#!/bin/sh
#
# Cxp Application Install Shell Script Version 1.04
# Create : 2000/06/28
# Author : Konta ( hatakeda@mbm.sphere.ne.jp)
# http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
#

PATH=$PATH:/usr/ucb:/usr/bin:/bin
export PATH
ECHO=echo
MAKEDIR=mkdir
COPY=cp
REMOVE=rm
CHMOD=chmod
CHOWN=chown
CHGRP=chgrp
CXP_BASEDIR=

#
# Check super user.
#
WHOAMI=`whoami`

if [ $WHOAMI != "root" ]; then
    $ECHO "Please root user (super user) !!"
    $ECHO "install.sh script is finished."
    exit 1
fi


BASEOPTIONPARAM=0

PARAM=$*

#
# Get Option.
#
for name in $PARAM; do
    case "$name" in
    -base)
	BASEOPTIONPARAM=1
        ;;
    *)
        if [ $BASEOPTIONPARAM = 1 ]
        then
		CXP_BASEDIR="$name"
        fi
	BASEOPTIONPARAM=0
        ;;
    esac
done

#
# cxplorer directory delete.
#
if [ -d $CXP_BASEDIR ]; then
    $REMOVE -r $CXP_BASEDIR
fi

#
# cxplorer directory makeking.
#
if [ ! -d $CXP_BASEDIR ]; then
    $MAKEDIR $CXP_BASEDIR
fi

if [ ! -d $CXP_BASEDIR/bin ]; then
    $MAKEDIR $CXP_BASEDIR/bin
fi

if [ ! -d $CXP_BASEDIR/doc ]; then
    $MAKEDIR $CXP_BASEDIR/doc
fi

if [ ! -d $CXP_BASEDIR/lib ]; then
    $MAKEDIR $CXP_BASEDIR/lib
fi

if [ ! -d $CXP_BASEDIR/lib/xpm ]; then
    $MAKEDIR $CXP_BASEDIR/lib/xpm
fi

if [ ! -d $CXP_BASEDIR/lib/base ]; then
    $MAKEDIR $CXP_BASEDIR/lib/base
fi

if [ ! -d $CXP_BASEDIR/panel ]; then
    $MAKEDIR $CXP_BASEDIR/panel
fi

if [ ! -d $CXP_BASEDIR/panel/xpm ]; then
    $MAKEDIR $CXP_BASEDIR/panel/xpm
fi

if [ ! -d $CXP_BASEDIR/style ]; then
    $MAKEDIR $CXP_BASEDIR/style
fi

if [ ! -d $CXP_BASEDIR/style/cxp ]; then
    $MAKEDIR $CXP_BASEDIR/style/cxp
    $MAKEDIR $CXP_BASEDIR/style/cxp/xpm
fi

if [ ! -d $CXP_BASEDIR/style/macos9 ]; then
    $MAKEDIR $CXP_BASEDIR/style/macos9
    $MAKEDIR $CXP_BASEDIR/style/macos9/xpm
fi

if [ ! -d $CXP_BASEDIR/style/macaqua ]; then
    $MAKEDIR $CXP_BASEDIR/style/macaqua
    $MAKEDIR $CXP_BASEDIR/style/macaqua/xpm
fi

if [ ! -d $CXP_BASEDIR/style/windows ]; then
    $MAKEDIR $CXP_BASEDIR/style/windows
    $MAKEDIR $CXP_BASEDIR/style/windows/xpm
fi

if [ ! -d $CXP_BASEDIR/style/kde ]; then
    $MAKEDIR $CXP_BASEDIR/style/kde
    $MAKEDIR $CXP_BASEDIR/style/kde/xpm
fi
if [ ! -d $CXP_BASEDIR/style/gnome ]; then
    $MAKEDIR $CXP_BASEDIR/style/gnome
    $MAKEDIR $CXP_BASEDIR/style/gnome/xpm
fi
if [ ! -d $CXP_BASEDIR/style/fukuro ]; then
    $MAKEDIR $CXP_BASEDIR/style/fukuro
    $MAKEDIR $CXP_BASEDIR/style/fukuro/xpm
fi

if [ ! -d $CXP_BASEDIR/contrib ]; then
    $MAKEDIR $CXP_BASEDIR/contrib
fi

$COPY cxplorer               $CXP_BASEDIR/bin/.
$COPY cxpmail                $CXP_BASEDIR/bin/.
$COPY cxpnote                $CXP_BASEDIR/bin/.
$COPY cxpapp                 $CXP_BASEDIR/bin/.
$COPY cxppanel               $CXP_BASEDIR/bin/.
$COPY cxpsysinfo             $CXP_BASEDIR/bin/.
$COPY cxpimage               $CXP_BASEDIR/bin/.
$COPY cxpbg                  $CXP_BASEDIR/bin/.
$COPY cxpaddr                $CXP_BASEDIR/bin/.
$COPY cxpcalen               $CXP_BASEDIR/bin/.
$COPY cxpcalc                $CXP_BASEDIR/bin/.
$COPY cxpbackup              $CXP_BASEDIR/bin/.
$COPY cxprestore             $CXP_BASEDIR/bin/.
$COPY cxpdevice              $CXP_BASEDIR/bin/.
$COPY cxpmessage             $CXP_BASEDIR/bin/.
$COPY cxpmanager             $CXP_BASEDIR/bin/.
$COPY cxpmanager_dev         $CXP_BASEDIR/bin/.
$COPY *.euc                  $CXP_BASEDIR/doc/.
$COPY -r lib                 $CXP_BASEDIR/.
$COPY -r panel               $CXP_BASEDIR/.
$COPY -r style               $CXP_BASEDIR/.
$COPY -r contrib             $CXP_BASEDIR/.

$CHOWN root $CXP_BASEDIR/bin/cxpmanager_dev
$CHGRP root $CXP_BASEDIR/bin/cxpmanager_dev
$CHMOD +s   $CXP_BASEDIR/bin/cxpmanager_dev

if [ -f /usr/bin/cxplorer ]; then
	$REMOVE /usr/bin/cxplorer
fi
if [ -f /usr/bin/cxpmail ]; then
	$REMOVE /usr/bin/cxpmail
fi
if [ -f /usr/bin/cxpnote ]; then
	$REMOVE /usr/bin/cxpnote
fi
if [ -f /usr/bin/cxpapp ]; then
	$REMOVE /usr/bin/cxpapp
fi
if [ -f /usr/bin/cxpaddr ]; then
	$REMOVE /usr/bin/cxpaddr
fi
if [ -f /usr/bin/cxppanel ]; then
	$REMOVE /usr/bin/cxppanel
fi
if [ -f /usr/bin/cxpsysinfo ]; then
	$REMOVE /usr/bin/cxpsysinfo
fi
if [ -f /usr/bin/cxpimage ]; then
	$REMOVE /usr/bin/cxpimage
fi
if [ -f /usr/bin/cxpbg ]; then
	$REMOVE /usr/bin/cxpbg
fi
if [ -f /usr/bin/cxpcalen ]; then
	$REMOVE /usr/bin/cxpcalen
fi
if [ -f /usr/bin/cxpcalc ]; then
	$REMOVE /usr/bin/cxpcalc
fi
if [ -f /usr/bin/cxpbackup ]; then
	$REMOVE /usr/bin/cxpbackup
fi
if [ -f /usr/bin/cxprestore ]; then
	$REMOVE /usr/bin/cxprestore
fi
if [ -f /usr/bin/cxpdevice ]; then
	$REMOVE /usr/bin/cxpdevice
fi
if [ -f /usr/bin/cxpmessage ]; then
	$REMOVE /usr/bin/cxpmessage
fi
if [ -f /usr/bin/cxpmanager ]; then
	$REMOVE /usr/bin/cxpmanager
fi
if [ -f /usr/bin/cxpmanager_dev ]; then
	$REMOVE /usr/bin/cxpmanager_dev
fi

ln -s $CXP_BASEDIR/bin/cxplorer   /usr/bin/cxplorer
ln -s $CXP_BASEDIR/bin/cxpmail    /usr/bin/cxpmail
ln -s $CXP_BASEDIR/bin/cxpnote    /usr/bin/cxpnote
ln -s $CXP_BASEDIR/bin/cxpapp     /usr/bin/cxpapp
ln -s $CXP_BASEDIR/bin/cxpaddr    /usr/bin/cxpaddr
ln -s $CXP_BASEDIR/bin/cxppanel   /usr/bin/cxppanel
ln -s $CXP_BASEDIR/bin/cxpsysinfo /usr/bin/cxpsysinfo
ln -s $CXP_BASEDIR/bin/cxpbg      /usr/bin/cxpbg
ln -s $CXP_BASEDIR/bin/cxpimage   /usr/bin/cxpimage
ln -s $CXP_BASEDIR/bin/cxpcalen   /usr/bin/cxpcalen
ln -s $CXP_BASEDIR/bin/cxpcalc    /usr/bin/cxpcalc
ln -s $CXP_BASEDIR/bin/cxpbackup  /usr/bin/cxpbackup
ln -s $CXP_BASEDIR/bin/cxprestore /usr/bin/cxprestore
ln -s $CXP_BASEDIR/bin/cxpdevice  /usr/bin/cxpdevice
ln -s $CXP_BASEDIR/bin/cxpmessage /usr/bin/cxpmessage
ln -s $CXP_BASEDIR/bin/cxpmanager /usr/bin/cxpmanager
ln -s $CXP_BASEDIR/bin/cxpmanager_dev /usr/bin/cxpmanager_dev

if [ -f /tmp/.cxpsock ]; then
	$REMOVE /tmp/.cxpsock
fi


PROCESS=`ps ax | grep cxpmanager | grep -v grep | grep -v vi | grep -v emacs | grep -v cxpnote | awk '{ print $1 }'`

echo "$PROCESS" | while read process; do
	if [ $process ]; then
		kill -9 $process
	fi
done

$ECHO "install succefull !! Conguraturation !!"
exit 0
