/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software; 
 * 
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#include "common_types.h"
#include <jpeglib.h>
#include <tiffio.h>
#include <png.h>

/*---- GIF ---------------------------------------*/
typedef guchar *GifColormap[3];
typedef struct gif_info_struct
{
    unsigned int width;
    unsigned int height;
    GifColormap colorMap;
    unsigned int BitPixel;
    unsigned int ColorReso;
    unsigned int Background;
    unsigned int AspectRatio;
} gif_info;

typedef struct
{
    gint interlace;
    gint loop;
    gint default_delay;
    gint default_dispose;
} GIFSaveVals;

typedef struct gif89_info_struct
{
    gint transparent;
    gint delayTime;
    gint inputFlag;
    gint disposal;
    gchar *comment;
} gif89_info;

#define CM_RED           0
#define CM_GREEN         1
#define CM_BLUE          2
#define MAX_COMMENT_SIZE 30
#define MAX_LWZ_BITS     12
#define INTERLACE          0x40
#define LOCALCOLORMAP      0x80
#define BitSet(byte, bit)  (((byte) & (bit)) == (bit))
#define ReadCheckOK(file,buffer,len) (fread(buffer, len, 1, file) != 0)
#define LM_to_uint(a,b)         (((b)<<8)|(a))

gboolean gif_get_header(gchar *filename, gif_info *screen);
gchar* gif_load(gchar *filename, GtkWidget *image_wid, int w, int h);

#define RANDOM_SEED 314159265
#define SCANLINE_INTERACT 1
#define SCANLINE_DISPLAY 2
#define DISPLAY_SPEED 20   

gint gifVersionCheck( gchar * );
gint ReadColorMap (FILE *, gint, GifColormap);
gint FreeColorMap (GifColormap);
gint DoExtension (FILE *, gint, gif89_info *);
gint GetDataBlock (FILE *, guchar *);
gint GetCode (FILE *, gint, gint);
gint LWZReadByte (FILE *, gint, gint);
gint32 ReadImageGIF (FILE *, gint, gint, GifColormap, gif89_info *,
        gint, gint, gint, guint, guint, guint, guint, GtkWidget *);


/*---- JPEG ---------------------------------------*/
typedef	struct	jpeg_decompress_struct	jpeg_info;
gboolean jpeg_get_header (gchar *filename, jpeg_info *info);
gboolean jpeg_load (gchar *filename, GtkWidget *image_wid, int w, int h);

#define SCANLINE_INTERACT 1
#define SCANLINE_DISPLAY 2

/*---- PNG ---------------------------------------*/
gboolean png_get_header (gchar *filename, png_info *info);
gboolean png_load (gchar *filename, GtkWidget *image_wid, int w, int h);

/*---- TIFF ---------------------------------------*/
typedef struct
{
    gint width;
    gint height;
    gint ncolors;
    gint alpha;
} tiff_info;

gboolean tiff_get_header (gchar *filename, tiff_info *info);
gboolean tiff_load (gchar *filename, GtkWidget *image_wid, int w, int h);

/*---- BMP ---------------------------------------*/
typedef struct bmp_info_struct
{
    gulong width;	/* 12 */
    gulong height;	/* 16 */
    guint planes;	/* 1A */
    guint bitCnt;	/* 1C */
    gulong compr;	/* 1E */
    gulong sizeIm;	/* 22 */
    gulong xPels;	/* 26 */
    gulong yPels;	/* 2A */
    gulong clrUsed;	/* 2E */
    gulong clrImp;	/* 32 */
			/* 36 */
} bmp_info;

gboolean bmp_get_header (gchar *filename, bmp_info *info);
gboolean bmp_load (gchar *filename, GtkWidget *image_wid, int w, int h);

#define ToL(buffer, off)  (buffer[(off)] | buffer[(off)+1]<<8 | buffer[(off)+2]<<16 | buffer[(off)+3]<<24)
#define ToS(buffer, off)  (buffer[(off)] | buffer[(off)+1]<<8);

gboolean BmpReadColorMap (FILE *fd, guchar buffer[256][3], gint number, gint size, gint *grey);
gboolean BmpReadImage (FILE *fd, gint len, gint height, guchar cmap[256][3], gint ncols,
                gint bpp, gint compression, gint spzeile, gint grey,
                GtkWidget *image_wid, int bmp_img_width, int bmp_img_height);


/*---- PSD ---------------------------------------*/
typedef struct
{
    gint width;
    gint height;
    gint ncolors;
    gint alpha;
} psd_info;

gboolean psd_get_header (gchar *filename, psd_info *info);
guchar *psd_load (gchar *filename, GtkWidget *image_wid, int w, int h);

#define MAX_CHANNELS 30

typedef enum
{
        PSD_GRAY_IMAGE,
        PSD_INDEXED_IMAGE,
        PSD_RGB_IMAGE,
        PSD_RGBA_IMAGE,
        PSD_BITMAP_IMAGE,
        PSD_UNKNOWN_IMAGE
} PsdImageType;

typedef struct
{
        glong top;
        glong left;
        glong bottom;
        glong right;

        gint num_channels;
        gint channel_id[MAX_CHANNELS];
        glong channel_len[MAX_CHANNELS];

        gboolean has_mask;
        glong mask_top;
        glong mask_left;
        glong mask_bottom;
        glong mask_right;
        glong mask_throw_alpha;

        LayerMode mode;
        gint opacity;
        gint clipping;
        gboolean protecttrans;
        gboolean visible;
        gboolean paintonmask;
        gint recordfiller;
        glong rangeslen;
} PsdLayer;
typedef struct
{
        PsdImageType type;
        gboolean cmyk;
        guchar caption[256];
        gint channels;
        glong rows;
        glong columns;
        gint mode;
        glong cmaplen;
        guchar cmap[768];
        gint bpp;

        glong reslen;
        glong misclen;
        PsdLayer *layers;
        gint numlayers;
        gint curlayer;
        gint absolute_alpha;
        gint num_aux_channels;
} PsdImage;

gboolean psd_get_short(FILE *fd, gint *val);
gboolean psd_get_long(FILE *fd, glong *val);
gboolean psd_get_string(FILE *fd, guchar *buf);

gboolean psd_load_image_resource (FILE *fd, PsdImage *image);
gboolean psd_load_id_data (FILE *fd, gint id, PsdImage *image);
gboolean psd_load_misc_data (FILE *fd, PsdImage *image, GtkPreview *preview, double nscale);
gboolean psd_load_layer_record (FILE *fd, PsdImage *image);
gboolean psd_load_layer_pixeldata(FILE *fd, PsdImage *image, GtkPreview *preview, double nscale);
gboolean psd_load_image_data (FILE *fd, PsdImage *image, GtkPreview *preview, double nscale);
gboolean psd_layer_has_alpha (PsdLayer* layer);
void     psd_put_pixel_element (PsdImage *image, guchar *line, gint x, gint off, gint ic);
LayerMode psd_modekey_to_lmode (guchar *modekey);

