/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software; 
 * 
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */
 
#ifndef __GTYPES_H__
#define __GTYPES_H__

#define THUMBNAIL_WIDTH 80
#define THUMBNAIL_HEIGHT 60
#define SLIDESHOW_DELAY 4000

#define min(a, b) (((a)<(b))?(a):(b))
#define max(a, b) (((a)>(b))?(a):(b))

#ifdef __cplusplus
        extern "C" {
#endif /* __cplusplus */

#include <time.h>
#include <gtk/gtk.h>

typedef enum
{
	XPM,
	GIF,
	JPG,
	BMP,
	ICO,
	PCX,
	TIF,
	PNG,
	PNM,
	PSD,
	XBM,
	XCF,
	UNKNOWN,
	MAX_IMAGE_TYPES
} ImageType;

typedef enum
{
	NORMAL_MODE       = 0,
	DISSOLVE_MODE     = 1,
	MULTIPLY_MODE     = 3,
	SCREEN_MODE       = 4,
	OVERLAY_MODE      = 5,
	DIFFERENCE_MODE   = 6,
	ADDITION_MODE     = 7,
	SUBTRACT_MODE     = 8,
	DARKEN_ONLY_MODE  = 9,
	LIGHTEN_ONLY_MODE = 10,
	HUE_MODE          = 11,
	SATURATION_MODE   = 12,
	COLOR_MODE        = 13,
	VALUE_MODE        = 14
} LayerMode;

typedef enum
{
	IMAGE_LIST_DETAILS	= 0,
	IMAGE_LIST_THUMBNAILS	= 1,
	IMAGE_LIST_SMALL_ICONS	= 2
} ImageListType;

typedef enum
{
	IMAGE_SORT_ASCEND_BY_NAME = 0,
	IMAGE_SORT_DESCEND_BY_NAME = 1,
	IMAGE_SORT_ASCEND_BY_SIZE = 2,
	IMAGE_SORT_DESCEND_BY_SIZE = 3,
	IMAGE_SORT_ASCEND_BY_PROPERTY = 4,
	IMAGE_SORT_DESCEND_BY_PROPERTY = 5,
	IMAGE_SORT_ASCEND_BY_DATE = 6,
	IMAGE_SORT_DESCEND_BY_DATE = 7,
} ImageSortType;

typedef struct _ImageCache ImageCache;
struct _ImageCache
{
	guchar *buffer;
	guint16 buffer_width;
	guint16 buffer_height;
};

typedef struct _ImageInfo ImageInfo;
struct _ImageInfo
{
	ImageType type;
	gint serial;
	gchar name[256];
	glong size;
	time_t time;
	gint width;
	gint height;
	gchar *desc;
	gboolean has_desc;
	GdkPixmap *type_pixmap;
	GdkBitmap *type_mask;

	glong ncolors;
	/*
	 * if TRUE, the ncolors field should be a REAL color numbers(xpm, gif)
	 * otherwise, the ncolors field is numbers of bits(i.e, 8 is 256-color)
	 */
	gboolean real_ncolors;
	
	/*
	 * Is there a alpha channel?
	 */
	gint alpha;
	
	/*
	 * bytes per pixel when loaded into memory
	 * NOT for all image format
	 */
	gint bpp;

	/*
	 * Is the image valid? we can know before or after loading it,
	 * and cache it.
	 */
	gboolean valid;

	/* whether the image has been loaded? */
	gboolean loaded;

	/* this field is for image cache in imagelist*/
	ImageCache cache;
};

#ifdef __cplusplus
        }
#endif /* __cplusplus */

#endif
