/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#include "cxplorer.h"

#define	MIN_YEAR_VALUE		1980
#define	MAX_YEAR_VALUE		2030

#define	MAX_CALEN_HOUR		24
#define	MAX_CALEN_DAY		31
#define	MAX_CALEN_MONTH		12

#define	MAX_TODOLIST_NUM	512	/* 512ޤ */
#define	MAX_VIEWDATA_NUM	128	/* 128ޤ */

typedef struct {
	int	mode ;		/* 顼⡼ */
				/* 0 : 顼ʤ */
				/* 1 : 顼ꤢ */
	int	year ;		/* 顼ǯ */
	int	month ;		/* 顼 */
	int	day ;		/* 顼 */
	int	hour ;		/* 顼 */
	int	min ;		/* 顼ʬ */
} AlarmInfo ;

typedef struct {
	int		month ;		/*  */
	int		day ;		/*  */
	int		hour ;		/*  */
	int		min ;		/* ʬ */
	int		level ;		/* ٥ */
	char		*title ;	/* ȥ */
	AlarmInfo	alarm ;		/* 顼 */
	int		length ;	/* ǡ */
	char		*data ;		/* ǡ */
} ScduInfo ;

typedef struct {
	int		kensu ;		/*  */
	ScduInfo	info[MAX_CALEN_HOUR] ;
} Day ;

typedef struct {
	Day		day[MAX_CALEN_DAY] ;
} Month ;

typedef struct {
	Month		month[MAX_CALEN_MONTH] ;
} Year ;

typedef struct {
	int		level ;		/* ٥ */
					/*  0 : ̾ */
					/*  1 :  */
					/*  2 : ۵ */
					/*  3 : ¾ */

	AlarmInfo	alarm ;		/* 顼 */
	char		*data ;		/* ToDoǡ */
} TodoItem ;

typedef struct {
	int		kensu ;		/* ǡ */
	TodoItem	item[MAX_TODOLIST_NUM] ;
} Todo ;

typedef struct {
	int		kind ;		/*  */
					/* 0 : Ŀ */
					/* 1 : Ż */
					/* 2 : ̣ */
					/* 3 :  */
					/* 4 : ¾ */

	char		*title ;	/* ɽȥ */
	int		kensu ;		/* ǡ */
} ViewDataItem ;

typedef struct {
	int		kensu ;
	ViewDataItem	view[MAX_VIEWDATA_NUM] ;
} ViewData ;

typedef struct {
	GtkWidget	*window;
	GtkWidget	*menubar;
	GtkWidget	*viewAddBtn;
	GtkWidget	*viewModBtn;
	GtkWidget	*viewDelBtn;
	GtkWidget	*viewList;
	GtkWidget	*todoAddBtn;   
	GtkWidget	*todoModBtn;   
	GtkWidget	*todoDelBtn;
	GtkWidget	*todoList;

	GtkWidget	*YmdDownBtn;
	GtkWidget	*viewYmdLabel;
	GtkWidget	*YmdUpBtn;
	GtkWidget	*calendar1;
	GtkWidget	*HanreiList;

	GtkWidget	*notebook1;
	GtkWidget	*dayLabel[50];
	GtkWidget	*dayList[50];
	GtkWidget	*timeList[50];
	GdkFont		*font;

	BASEINFO	base ;		/* ܾ */

	int		fontIndex ;	/* եȾ */
	FONTINFO	fontInfo ;

	int		s_year ;	/* ɽǯ */
	int		s_month ;	/* ɽ */
	int		s_day ;		/* ɽ */


	ViewData	view ;		/* ɽ */
	Year		data ;		/* 塼ǡ */
	Todo		todo ;		/* 뤳ȥꥹ */

	int		selectview ;	/* ɽ */
	int		selecttodo ;	/* ToDoֹ */
	int		selectday ;	/* ֹ */
	int		selecttime ;	/* ֹ */

			/* Υǡɽ */
	int		notCalenSelectNotDataView ;

			/* ɽ̵ */
	int		notDaySelection ;

			/* ɽ̵ */
	int		notTimeSelection ;

} CxpCalen ;
