/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifndef __CXP_HEAD__
#define __CXP_HEAD__

/*------------------------------------------------------------------*/
/* ɽ⡼                                                   */
/*------------------------------------------------------------------*/
#define	DIR_VIEW_NONE	0
#define	DIR_VIEW_OFF	1
#define	DIR_VIEW_ON	2

/*------------------------------------------------------------------*/
/* ǥ쥯ȥĹ                                               */
/*------------------------------------------------------------------*/
#define	MAX_DIR_LENGTH	1024

/*------------------------------------------------------------------*/
/* 祹ե                                           */
/*------------------------------------------------------------------*/
#define	MAX_STYLE_NUM	64

/*------------------------------------------------------------------*/
/* ϢŤե                                           */
/*------------------------------------------------------------------*/
#define	MAX_APPLI_NUM	1024

/*------------------------------------------------------------------*/
/* ѥͥ                                                 */
/*------------------------------------------------------------------*/
#define	MAX_PANEL_NUM	128
#define	MAX_PMENU_NUM	256

/*------------------------------------------------------------------*/
/* Ͽ᡼                                             */
/*------------------------------------------------------------------*/
#define	MAX_IMAGE_NUM	32768

/*------------------------------------------------------------------*/
/* ɽե                                               */
/*------------------------------------------------------------------*/
#define	MAX_FILE_NUM	8192

/*------------------------------------------------------------------*/
/* ɽǥ쥯ȥ                                           */
/*------------------------------------------------------------------*/
#define	MAX_DIR_NUM	8192

/*------------------------------------------------------------------*/
/* 祢ɥ쥹Ͽ                                             */
/*------------------------------------------------------------------*/
#define	MAX_ADDR_NUM	8192

/*------------------------------------------------------------------*/
/* եϿ                                               */
/*------------------------------------------------------------------*/
#define	MAX_FONT_NUM	32

/*------------------------------------------------------------------*/
/* 祢Ⱦ                                             */
/*------------------------------------------------------------------*/
#define	MAX_CONNECT_INFO	32

/*------------------------------------------------------------------*/
/* 祢ץꥱϿ                                       */
/*------------------------------------------------------------------*/
#define	MAX_APLICATION_NUM	256

/*------------------------------------------------------------------*/
/* Ͽե󥯥                                         */
/*------------------------------------------------------------------*/
#define	MAX_CFUNC_NUM		26
#define	MAX_FFUNC_NUM		12

/*------------------------------------------------------------------*/
/* ϿǥХ                                               */
/*------------------------------------------------------------------*/
#define MAX_DEVICE_NUM  32

/*------------------------------------------------------------------*/
/* ᡼                                                   */
/*------------------------------------------------------------------*/
#define	CXP_IMAGE_NONE	0
#define	CXP_IMAGE_JPEG	1	/* first support */
#define	CXP_IMAGE_GIF	2	/* first support */
#define	CXP_IMAGE_TIFF	3	/* first support */
#define	CXP_IMAGE_XPM	4	/* next support */
#define	CXP_IMAGE_XWD	5	/* next support */
#define	CXP_IMAGE_XBM	6	/* next support */
#define	CXP_IMAGE_PNG	7	/* first support */
#define	CXP_IMAGE_PSD	8	/* first support */
#define	CXP_IMAGE_BMP	9	/* first support */

/*------------------------------------------------------------------*/
/* ɽּ                                                     */
/*------------------------------------------------------------------*/
#define	VIEW_LIST	0
#define	VIEW_LISTFILE	1
#define	VIEW_SMALLICON	2
#define	VIEW_BIGICON	3

/*------------------------------------------------------------------*/
/* åȡڡȾ                                             */
/*------------------------------------------------------------------*/
#define	CUTBUFF_OFF	0
#define	CUTBUFF_ON	1
#define	CUTBUFF_FILENAME	"/tmp/.cxpcutbuff"

/*------------------------------------------------------------------*/
/* ƥɸǡ                                           */
/*------------------------------------------------------------------*/
#define	CXPSYSTEM_BASE	"_CXPBASE_/lib/base.cfg"
#define	CXPSYSTEM_STYLE	"_CXPBASE_/style"
#define	CXPSYSTEM_APPLI	"_CXPBASE_/lib/appli.cfg"
#define	CXPSYSTEM_FONT	"_CXPBASE_/lib/font.cfg"
#define	CXPSYSTEM_PANEL	"_CXPBASE_/panel/panel.cfg"
#define	CXPSYSTEM_PMENU	"_CXPBASE_/panel/cxpmenu.cfg"
#define	CXPSYSTEM_APPLICATION	"_CXPBASE_/lib/application.cfg"
#define	CXPSYSTEM_FUNCTION	"_CXPBASE_/lib/function.cfg"
#define	CXPSYSTEM_DEVICE	"_CXPBASE_/lib/device.cfg"

typedef struct {
        int             dotFlag ;       /* 0: view 1: none */
        int             execFlag ;      /* 0: view 1: none */
	int		styleIndex ;	/*  */
} CxplorerInfo ;

/*------------------------------------------------------------------*/
/* ץꥱ                                             */
/*------------------------------------------------------------------*/
typedef struct {
	char		*name ;
	char		*path ;
} APITEM ;
typedef struct {
	int		num ;		/* Ͽץꥱ */
	APITEM		item[MAX_APLICATION_NUM];
} APLICATION ;

/*------------------------------------------------------------------*/
/* եե                                         */
/*------------------------------------------------------------------*/
typedef struct {
	int		row ;		/* ɽңϣֹ */
        char            fname[1024] ;   /* ե̾ */
        char            kind ;          /*  */
	char		yobi[3];	/* ͽ */
        uid_t           uid ;           /* 桼ɣ */
        gid_t           gid ;           /* 롼ףɣ */
        time_t          time ;          /*  */
        time_t          ctime ;         /*  */
        time_t          atime ;         /*  */
        mode_t          mode ;          /* ⡼ */
        size_t          size ;          /*  */
        char            view ;          /* ɽե饰 */
        void            *next ;         /*  */
} FINFO ;

/*------------------------------------------------------------------*/
/* ǥ쥯ȥե                                     */
/*------------------------------------------------------------------*/
typedef struct {
        int             count ;         /* ե */
        FINFO           *finfo[MAX_FILE_NUM] ;  /* ե */
} DINFO ;

/*------------------------------------------------------------------*/
/* ե󥯥ե                                   */
/*------------------------------------------------------------------*/
typedef struct {
	uint		keycode ;	/*  */
	char		*execFunc ;	/* ¹ԥޥ */
} FUNCTABLE ;
typedef struct {
	int		maxCNum ;	/* Cntlե󥯥 */
	int		maxFNum ;	/* FNե󥯥   */
	FUNCTABLE	cTable[MAX_CFUNC_NUM] ;	/* Cntlơ֥ */
	FUNCTABLE	fTable[MAX_FFUNC_NUM] ;	/* FNơ֥ */
} FUNCTION ;

/*------------------------------------------------------------------*/
/* ǥХե                                         */
/*------------------------------------------------------------------*/
typedef struct {
	char		*type ;
        char            *name ;
        char            *path ;
	int		backupFlag ;	/* 1: Ѥʤ 0: Ѥ */
} DeviceItem ;

typedef struct {
        int             device_kensu;
        DeviceItem      device[MAX_DEVICE_NUM];
} DeviceInfo ;

/*------------------------------------------------------------------*/
/* ƥեե                                 */
/*------------------------------------------------------------------*/
typedef struct {
        DINFO           root ;          /* ե */
} ROOTINFO ;

typedef struct {
	char		*name ;		/* ̾ */
	char		*next ;		/* XPMե(nextͭ alarmͭ) */
	char		*none ;		/* XPMե(nextʤ alarm̵) */
} CalenItem ;

typedef struct {
	char		*cxplorer ;	/* إ */
	char		*cxpnote ;	/* إ */
	char		*cxpaddr ;	/* إ */
	char		*cxpcalen ;	/* إ */
	char		*cxpmail ;	/* إ */
	char		*cxpimage ;	/* إ */
	char		*cxpbackup ;	/* إ */
	char		*cxprestore ;	/* إ */
	char		*cxpdevice ;	/* إ */
	char		*topcmd[24] ;	/* Cxplorerѥġܥ */
	char		*note[10] ;	/* Cxpnoteѥġܥ */
	char		*mail[24] ;	/* CapMailѥġܥ */
	char		*mailt[10] ;	/* CapMail(text)ѥġܥ */
	char		*selecton;	/* CxpbackupON */
	char		*selectsub;	/* CxpbackupON(SUB) */
	char		*selectoff;	/* CxpbackupOFF */
	char		*devicefdd ;	/* CxpdeviceFDD */
	char		*devicetape ;	/* CxpdeviceTAPE */
	char		*devicecd ;	/* CxpdeviceCD */
	char		*deviceunknown ; /* Cxpdevice */
	CalenItem	kindmine ;	/* Cxpcalen :Ŀ */
	CalenItem	kindwork ;	/* Cxpcalen :Ż */
	CalenItem	kindtaste ;	/* Cxpcalen :̣ */
	CalenItem	kindplay ;	/* Cxpcalen : */
	CalenItem	kindother ;	/* Cxpcalen :¾ */
	CalenItem	kindcomm ;	/* Cxpcalen : */
	CalenItem	levelnormal ;	/* Cxpcalen ٥:̾ */
	CalenItem	leveljyuyou ;	/* Cxpcalen ٥: */
	CalenItem	levelkinkyu ;	/* Cxpcalen ٥:۵ */
	CalenItem	levelother ;	/* Cxpcalen ٥:¾ */
} BASEINFO ;

typedef struct {
	int		flag ;		/* 0:Բ 1:Ѳ */
	char		*name ;		/* ̾ */

	char		*treexpm1 ;	/* ̾ǥ쥯ȥ     ĥ꡼ */
	char		*treexpm2 ;	/* ̾ǥ쥯ȥ() ĥ꡼ */
	char		*treexpm3 ;	/* ̾ǥ쥯ȥ() ĥ꡼ */
	char		*filexpm ;	/* ̾ǥ쥯ȥ ե */
	char		*unknown ;	/* ̤Υե ե */
} STYLEINFO ;

typedef struct {
	char		*kakucho ;	/* ĥ */
	char		*info ;		/* ե̾ */
	char		*xpm_small ;	/* أУͥե */
	char		*command ;	/* ¹ԥץꥱ */
} APPLIINFO ;

typedef struct {
	char		row[MAX_FILE_NUM] ;	/* ROWֹ */
} SELECTINFO ;

typedef struct {
	int		flag ;		/* 0 :̵ 1 :ͭ */
        int             count ;		/* ե */
        FINFO           *finfo[MAX_FILE_NUM] ;	/* ե */
} CUTBUFFINFO ;

typedef struct {
	char		*title ;	/* ȥ̾ */
	char		*xpm ;		/* أУͥե */
	char		*command ;	/* ץꥱ */
	char		*hint ;		/* ҥȾ */
} PANELINFO ;

typedef struct {
	char		*menuname ;	/* ˥塼̾ */
	char		*command ;	/* ץꥱ */
} PMENUINFO ;

typedef struct {
	char		*title ;	/* ȥ̾ */
	char		*font_alpha ;	/* ʸե */
	char		*font_kanji ;	/* ե */
	char		*font_kana ;	/* ̾ե */
} FONTITEM ;

typedef struct {
	int		kensu ;		/* Ͽ */
	FONTITEM	font[MAX_FONT_NUM] ;
} FONTINFO ;

typedef struct {
	char		*hostname ;
	char		*portno ;
} CxpConnect ;

typedef struct {
	char		*login ;
	char		*passwd ;
	CxpConnect	pop3 ;
	CxpConnect	smtp ;
	CxpConnect	proxy ;
	int		proxyFlag ;

	int		sockPop3 ;
	int		sockSmtp ;
	int		sockProxy ;
} ConnectInfo ;

typedef struct {
        char            *name ;
        char            *email ;
	int		mailDelete ;	/* 0: Ф 1 : Фʤ */
	int		sameMail ;	/* 0: Ʊ᡼ 1: Ʊ᡼ϼʤ */
	int		ndayDelete ;	/* 0: NΥ᡼Ϻʤ 1: NΥ᡼ */
	int		nday ;		/* N */
} MyInfo ;


typedef struct {
        GtkWidget       *window ;
	GtkWidget	*vbox ;
	GtkWidget	*swin1 ;
	GtkWidget	*swin2 ;
	GtkWidget	*menubar ;
	GtkWidget	*filemenu, *fileitem ;
	GtkWidget	*editmenu, *edititem ;
	GtkWidget	*movemenu, *moveitem ;
	GtkWidget	*toolmenu, *toolitem ;
	GtkWidget	*viewmenu, *viewitem ;
	GtkWidget	*helpmenu, *helpitem ;
        GtkWidget       *clist1;
        GtkWidget       *clist2;
	GtkWidget	*topcmd[24] ;
	GtkWidget	*address ;

			/* ١ */
	BASEINFO	base ;

                        /* Cxplorer */
        CxplorerInfo    cinf ;

			/*  */
	int		styleIndex ;
	STYLEINFO	style[MAX_STYLE_NUM] ;

			/* ץꥱ */
	int		appli_kensu ;
	APPLIINFO	appli[MAX_APPLI_NUM] ;

			/* Ͽץꥱ */
	APLICATION	aplication ;

			/* Ͽե󥯥 */
	FUNCTION	function ;

			/* ǥ쥯ȥ */
	ROOTINFO	fsInfo ;

			/* ե */
	DINFO		fsView ;

			/*  */
	SELECTINFO	select ;

			/* åȡڡȾ */
	CUTBUFFINFO	cutbuff ;

			/* ɽǥ쥯ȥ̾ */
	char		pwdbuff[MAX_DIR_LENGTH] ;

			/* ưɣѿ */
	uid_t		uid ;
	gid_t		gid ;

			/* ɽѿ */
	int		viewMode ;	/*  */
	int		viewModeBack ;	/*  */

			/* ȼ */
	int		sortno ;

			/* Υॢѿ */
	int		clist1_selection ;
	int		clist1_timeout_start[MAX_DIR_NUM] ;
	int		clist2_timeout_start[MAX_FILE_NUM] ;

			/* ¾ѿ */
	int		totalCount ;
	int		currentViewFlag ;
	int		currentViewFlag2 ;
} CxpMgr;

typedef struct {
        GtkWidget       *window ;
	GtkWidget	*vbox ;
	GtkWidget	*menubar ;
	GtkWidget	*filemenu, *fileitem ;
	GtkWidget	*editmenu, *edititem ;
	GtkWidget	*viewmenu, *viewitem ;
	GtkWidget	*helpmenu, *helpitem ;
	GtkWidget	*topcmd[10] ;
	GtkWidget	*fontdlg ;
	GtkWidget	*fontswin ;
	GtkWidget	*fontlist ;
	GtkWidget	*text ;
	GdkFont		*font;

			/* ưɣѿ */
	pid_t		pid ;
	uid_t		uid ;
	gid_t		gid ;

			/* ١ */
	BASEINFO	base ;

			/*  */
	int		styleIndex ;
	STYLEINFO	style[MAX_STYLE_NUM] ;

			/* եȾ */
	int		fontIndex ;
	FONTINFO	fontInfo ;

			/*  */
	int		color ;

			/* ưץ */
	int		option ;

	char		pwdbuff[1024] ;
	char		filename[1024] ;

} CxpNote ;

typedef struct {
        GtkWidget       *window ;
	GtkWidget	*vbox ;
	GtkWidget	*hbox ;
	GtkWidget	*swin ;
        GtkWidget       *clist;

			/* ưɣѿ */
	uid_t		uid ;
	gid_t		gid ;

			/* Υॢѿ */
	int		clist_timeout_start ;
	int		clist_timeout_end ;

			/*  */
	int		selectrow ;

			/* ץꥱ */
	int		appli_kensu ;
	APPLIINFO	appli[MAX_APPLI_NUM] ;

			/* ¾ѿ */
	int		currentViewFlag ;
} CxpApp ;

typedef struct {
        GtkWidget       *window ;
	GtkWidget	*basebtn ;
	GtkWidget	*vbox ;
	GtkWidget	*hbox ;
	GtkWidget	*menubar ;
	GtkWidget	*toolbar ;
	GtkWidget	*swin ;

			/*  */
	int		xpos ;
	int		ypos ;
	int		maxwidth  ;
	int		maxheight ;
	int		minwidth  ;
	int		minheight ;

			/* ưɣѿ */
	uid_t		uid ;
	gid_t		gid ;

			/* ѥͥ */
	int		panel_kensu ;
	PANELINFO	panel[MAX_PANEL_NUM];

	int		pmenu_kensu ;
	PMENUINFO	pmenu[MAX_PMENU_NUM];

} CxpPnl ;

typedef struct {
	char *ver ;
	char *cpu[12] ;
	char *mem ;
	char *disk[32] ;
	char *cdrom[12] ;
	char *floppy[12] ;
	char *scsi[12] ;
	char *eth[12] ;
	char *ttys[12] ;
	char *pararel[12] ;
	int  count ;
	int  dcount ;
	int  ccount ;
	int  fcount ;
	int  scount ;
	int  ecount ;
	int  tcount ;
	int  pcount ;
} SysInfo ;

typedef struct {
        GtkWidget       *window ;
	GtkWidget	*vbox ;
	GtkWidget	*hbox ;
	GtkWidget	*swin ;
	GtkWidget	*clist ;

			/* ưɣѿ */
	uid_t		uid ;
	gid_t		gid ;

	SysInfo		info ;

} CxpSysinfo ;

typedef	struct {
	char		*name ;		/* ̾ */
	char		*kana ;		/* ɤ */
	char		*job ;		/* ̾/ع̾ */
	char		*jtel ;		/* Ϣֹ */
	char		*sex ;		/*  0: 1: */
	char		*birth ;	/* ǯ 19xx/xx/xx */
	char		*bload ;	/* շ 0:A 1:B 2:O 3:AB 4:? */
	char		*ybin ;		/* ͹ֹ */
	char		*addr ;		/* 𽻽 */
	char		*tel ;		/* ֹ */
	char		*fax ;		/* FAXֹ */
	char		*email ;	/* Żҥ᡼ */
	char		*website ;	/* ۡڡ */
	char		*comment ;	/*  */
} ADDRINFO ;

typedef	struct {
        GtkWidget       *window ;
	GtkWidget	*vbox ;
	GtkWidget	*menubar ;
	GtkWidget	*hbox ;
	GtkWidget	*swin ;
	GtkWidget	*clist ;

	GtkWidget	*item[32] ;

			/* ưɣѿ */
	uid_t		uid ;
	gid_t		gid ;

			/* ١ */
	BASEINFO	base ;

			/* Υॢѿ */
	int		clist_timeout_start[MAX_ADDR_NUM] ;
	int		clist_timeout_end[MAX_ADDR_NUM] ;

			/*  */
	int		selectrow ;

	int		copyFlag ;
	ADDRINFO	copyData ;

	int		currentViewFlag ;
	int		currentViewFlag2 ;

			/* ɥ쥹 */
	int		addr_kensu ;
	ADDRINFO	addr[MAX_ADDR_NUM] ;

} CxpAddr ;


static char *error_xpm[] = {
"16 16 7 1",
" 	c None",
".	c #FFFFFF",
"+	c #000000",
"@	c #FF0000",
"#	c #800000",
"$	c #C0C0C0",
"%	c #D2D2D2",
"                ",
"  +++++++++     ",
"  +......+++    ",
"  +......++++   ",
"  +......+++++  ",
"  +..........+  ",
"  +..........+  ",
"  +..........+  ",
"  +..........+  ",
"  +..........+  ",
"  +..........+  ",
"  +..........+  ",
"  +..........+  ",
"  +..........+  ",
"  ++++++++++++  ",
"                "};

extern char *nstrchr();
extern char *nstrrchr();


#endif


