/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

/* Cxplorer Infomation */
int getCxplorerInfo( info )
CxplorerInfo	*info ;
{
	FILE	*fp ;
	char	data[2048] ;
	char	filename[1024] ;
	char	*ptr ;

	sprintf( filename, "%s/.cxp/cxplorer.cfg", (char*)getenv("HOME") );

#ifdef	DEBUG
fprintf(stdout,"filename [%s]\n", filename );
#endif

	info->dotFlag = 1 ;
	info->execFlag = 1 ;
	info->styleIndex = 0 ;

	if ( access( filename, F_OK ) ){
		return(0);
	}

	if ( (fp = fopen( filename, "r" )) == NULL ) {
		fprintf(stdout,"Cxplorer Infomation file open error [%s]\n",
				filename );
		return(-1);
	}

	memset( data, 0x00, sizeof(data) );
	while( fgets( data, sizeof(data), fp) != 0)
	{
	    if (( data[0] == '#'  ) ||  ( data[0] == '\n' )
	    ||  ( data[0] == '\t' ) ||  ( data[0] == ' '  ))
		continue ;

	    if ( strncmp(data,"VIEW_DOTFILE=Yes", strlen("VIEW_DOTFILE=Yes"))==0)
		info->dotFlag = 1 ;
	    if ( strncmp(data,"VIEW_DOTFILE=No", strlen("VIEW_DOTFILE=No"))==0)
		info->dotFlag = 0 ;

	    if ( strncmp(data,"VIEW_EXECFILE=Yes", strlen("VIEW_EXECFILE=Yes"))==0)
		info->execFlag = 1 ;
	    if ( strncmp(data,"VIEW_EXECFILE=No", strlen("VIEW_EXECFILE=No"))==0)
		info->execFlag = 0 ;

	    if ( strncmp(data,"STYLE_NUMBER=", strlen("STYLE_NUMBER="))==0)
	    {
		if ( (ptr = strchr( data, '=' )) != (char *)NULL )
		{
		    info->styleIndex = atoi(ptr+1) ;
		}
            }
	}

	fclose( fp );

	return(0);
}

int setCxplorerInfo( info )
CxplorerInfo	*info ;
{
	FILE	*fp ;
	char	filename[1024] ;
	int	i ;

	sprintf( filename, "%s/.cxp", (char*)getenv("HOME") );
	if ( access( filename, F_OK ) ) {
	    /* ǥ쥯ȥ꤬ʤä */
	    mkdir ( filename, 0755 );
	}
	sprintf( filename, "%s/.cxp/cxplorer.cfg", (char*)getenv("HOME") );
	if ( (fp = fopen( filename, "w" )) == NULL )
		return(-1);

	fprintf( fp, "#\n" );
	fprintf( fp, "# Cxplorer Infomation config file version 1.00\n" );
	fprintf( fp, "# author: konta (hatakeda@mbm.sphere.ne.jp)\n" );
	fprintf( fp, "#\n" );
	fprintf( fp, "#\n" );
	fprintf( fp, "#\n" );
	fprintf( fp, "\n" );

	if ( info->dotFlag == 1 )  fprintf( fp, "VIEW_DOTFILE=Yes\n" );
	if ( info->dotFlag == 0 )  fprintf( fp, "VIEW_DOTFILE=No\n" );
	if ( info->execFlag == 1 ) fprintf( fp, "VIEW_EXECFILE=Yes\n" );
	if ( info->execFlag == 0 ) fprintf( fp, "VIEW_EXECFILE=No\n" );
	fprintf( fp, "STYLE_NUMBER=%d\n", info->styleIndex );

	fprintf( fp, "\n" );

	fclose(fp);

	return(0);
}
