/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

static uint	cListTable[MAX_CFUNC_NUM] = {
	GDK_a, GDK_b, GDK_c, GDK_d, GDK_e,
	GDK_f, GDK_g, GDK_h, GDK_i, GDK_j,
	GDK_k, GDK_l, GDK_m, GDK_n, GDK_o,
	GDK_p, GDK_q, GDK_r, GDK_s, GDK_t,
	GDK_u, GDK_v, GDK_w, GDK_x, GDK_y,
	GDK_z };

static uint	fListTable[MAX_FFUNC_NUM] = {
	GDK_F1, GDK_F2, GDK_F3, GDK_F4,
	GDK_F5, GDK_F6, GDK_F7, GDK_F8,
	GDK_F9, GDK_F10, GDK_F11, GDK_F12 };


/* Ͽե󥯥ɤ߹ */
int getFunctionInfo( info )
FUNCTION	*info ;
{
	FILE	*fp ;
	char	buff[1024] ;
	char	work[1024] ;
	char	work2[1024] ;
	char	filename[1024] ;
	char	*ptr, *ptr2 ;
	int	status ;

	info->maxCNum = 0 ;
	info->maxFNum = 0 ;

	sprintf( filename, "%s/.cxp/lib/function.cfg", (char*)getenv("HOME") );
	if ( access( filename, F_OK ) )
	{
		/* ե뤬¸ߤʤä饷ƥΥǡ */
		strcpy( filename, (char *)getPath(CXPSYSTEM_FUNCTION) );
	}

	if ( (fp = fopen( filename, "r" )) == NULL )
	{
		fprintf(stdout,"Entry Function file open error [%s]\n",
				filename );
		return(-1);
	}

	memset( buff, 0x00, sizeof(buff) );
	while( fgets( buff, sizeof(buff), fp) != 0)
	{
	    if (( buff[0] == '#'  ) ||  ( buff[0] == '\n' )
	    ||  ( buff[0] == '\t' ) ||  ( buff[0] == ' '  ))
		continue ;


	    memcpy( work, buff, sizeof(buff) );
	    ptr = nstrchr ( work, '"', 2 );
	    *ptr = 0x00 ;
	    ptr = nstrchr ( work, '"', 1 );

	    memcpy( work2, buff, sizeof(buff) );
            ptr2 = nstrchr ( work2, '"', 4 );
            *ptr2 = 0x00 ;
            ptr2 = nstrchr ( work2, '"', 3 );

	    status = -1 ;

	    if ( strncmp( ptr+1, "CNTL+", 5 ) == 0 )
	    {
		if ( strcmp( ptr+1, "CNTL+A" ) == 0 ) status = 0 ;
		if ( strcmp( ptr+1, "CNTL+B" ) == 0 ) status = 1 ;
		if ( strcmp( ptr+1, "CNTL+C" ) == 0 ) status = 2 ;
		if ( strcmp( ptr+1, "CNTL+D" ) == 0 ) status = 3 ;
		if ( strcmp( ptr+1, "CNTL+E" ) == 0 ) status = 4 ;
		if ( strcmp( ptr+1, "CNTL+F" ) == 0 ) status = 5 ;
		if ( strcmp( ptr+1, "CNTL+G" ) == 0 ) status = 6 ;
		if ( strcmp( ptr+1, "CNTL+H" ) == 0 ) status = 7 ;
		if ( strcmp( ptr+1, "CNTL+I" ) == 0 ) status = 8 ;
		if ( strcmp( ptr+1, "CNTL+J" ) == 0 ) status = 9 ;
		if ( strcmp( ptr+1, "CNTL+K" ) == 0 ) status = 10 ;
		if ( strcmp( ptr+1, "CNTL+L" ) == 0 ) status = 11 ;
		if ( strcmp( ptr+1, "CNTL+M" ) == 0 ) status = 12 ;
		if ( strcmp( ptr+1, "CNTL+N" ) == 0 ) status = 13 ;
		if ( strcmp( ptr+1, "CNTL+O" ) == 0 ) status = 14 ;
		if ( strcmp( ptr+1, "CNTL+P" ) == 0 ) status = 15 ;
		if ( strcmp( ptr+1, "CNTL+Q" ) == 0 ) status = 16 ;
		if ( strcmp( ptr+1, "CNTL+R" ) == 0 ) status = 17 ;
		if ( strcmp( ptr+1, "CNTL+S" ) == 0 ) status = 18 ;
		if ( strcmp( ptr+1, "CNTL+T" ) == 0 ) status = 19 ;
		if ( strcmp( ptr+1, "CNTL+U" ) == 0 ) status = 20 ;
		if ( strcmp( ptr+1, "CNTL+V" ) == 0 ) status = 21 ;
		if ( strcmp( ptr+1, "CNTL+W" ) == 0 ) status = 22 ;
		if ( strcmp( ptr+1, "CNTL+X" ) == 0 ) status = 23 ;
		if ( strcmp( ptr+1, "CNTL+Y" ) == 0 ) status = 24 ;
		if ( strcmp( ptr+1, "CNTL+Z" ) == 0 ) status = 25 ;

		if ( status >= 0 )
		{
		    info->cTable[status].keycode = cListTable[status] ;
		    info->cTable[status].execFunc = (char *)g_strdup(ptr2+1) ;
		}
	    }

	    if ( strncmp( ptr+1, "F", 1 ) == 0 )
	    {
		if ( strcmp( ptr+1, "F1" ) == 0 ) status = 0 ;
		if ( strcmp( ptr+1, "F2" ) == 0 ) status = 1 ;
		if ( strcmp( ptr+1, "F3" ) == 0 ) status = 2 ;
		if ( strcmp( ptr+1, "F4" ) == 0 ) status = 3 ;
		if ( strcmp( ptr+1, "F5" ) == 0 ) status = 4 ;
		if ( strcmp( ptr+1, "F6" ) == 0 ) status = 5 ;
		if ( strcmp( ptr+1, "F7" ) == 0 ) status = 6 ;
		if ( strcmp( ptr+1, "F8" ) == 0 ) status = 7 ;
		if ( strcmp( ptr+1, "F9" ) == 0 ) status = 8 ;
		if ( strcmp( ptr+1, "F10" ) == 0 ) status = 9 ;
		if ( strcmp( ptr+1, "F11" ) == 0 ) status = 10 ;
		if ( strcmp( ptr+1, "F12" ) == 0 ) status = 11 ;

		if ( status >= 0 )
		{
		    info->fTable[status].keycode = fListTable[status] ;
		    info->fTable[status].execFunc = (char *)g_strdup(ptr2+1) ;
		}
	    }


	}

	fclose( fp );

	info->maxCNum = MAX_CFUNC_NUM ;
	info->maxFNum = MAX_FFUNC_NUM ;

	return( 0 );
}

int setFunctionInfo( info )
FUNCTION	*info ;
{
	FILE	*fp ;
	char	filename[512] ;
	int	i ;

	sprintf( filename, "%s/.cxp", (char*)getenv("HOME") );
	if ( access( filename, F_OK ) )
	{
	    /* ǥ쥯ȥ꤬ʤä */
	    mkdir ( filename, 0755 );
	}
	sprintf( filename, "%s/.cxp/lib", (char*)getenv("HOME") );
	if ( access( filename, F_OK ) )
	{
	    /* ǥ쥯ȥ꤬ʤä */
	    mkdir ( filename, 0755 );
	}

	sprintf( filename, "%s/.cxp/lib/function.cfg", (char*)getenv("HOME") );
	if ( (fp = fopen( filename, "w" )) == NULL )
		return(-1);


	fprintf( fp, "#\n" );
	fprintf( fp, "# function.cfg "
		     "( cxplorer entry function info Version 1.00)\n" );
	fprintf( fp, "# author: konta (hatakeda@mbm.sphere.ne.jp)\n" );
	fprintf( fp, "#\n" );
	fprintf( fp, "#\n" );
	fprintf( fp, "\n" );

	fprintf( fp, "#\n" );
	fprintf( fp, "# [CNTL + XX] function table \n" );
	fprintf( fp, "#\n" );
	for(i=0;i<info->maxCNum;i++)
	{
	    switch( info->cTable[i].keycode )
	    {
	    case GDK_a : fprintf( fp, "\"CNTL+A\"," ); break ;
	    case GDK_b : fprintf( fp, "\"CNTL+B\"," ); break ;
	    case GDK_c : fprintf( fp, "\"CNTL+C\"," ); break ;
	    case GDK_d : fprintf( fp, "\"CNTL+D\"," ); break ;
	    case GDK_e : fprintf( fp, "\"CNTL+E\"," ); break ;
	    case GDK_f : fprintf( fp, "\"CNTL+F\"," ); break ;
	    case GDK_g : fprintf( fp, "\"CNTL+G\"," ); break ;
	    case GDK_h : fprintf( fp, "\"CNTL+H\"," ); break ;
	    case GDK_i : fprintf( fp, "\"CNTL+I\"," ); break ;
	    case GDK_j : fprintf( fp, "\"CNTL+J\"," ); break ;
	    case GDK_k : fprintf( fp, "\"CNTL+K\"," ); break ;
	    case GDK_l : fprintf( fp, "\"CNTL+L\"," ); break ;
	    case GDK_m : fprintf( fp, "\"CNTL+M\"," ); break ;
	    case GDK_n : fprintf( fp, "\"CNTL+N\"," ); break ;
	    case GDK_o : fprintf( fp, "\"CNTL+O\"," ); break ;
	    case GDK_p : fprintf( fp, "\"CNTL+P\"," ); break ;
	    case GDK_q : fprintf( fp, "\"CNTL+Q\"," ); break ;
	    case GDK_r : fprintf( fp, "\"CNTL+R\"," ); break ;
	    case GDK_s : fprintf( fp, "\"CNTL+S\"," ); break ;
	    case GDK_t : fprintf( fp, "\"CNTL+T\"," ); break ;
	    case GDK_u : fprintf( fp, "\"CNTL+U\"," ); break ;
	    case GDK_v : fprintf( fp, "\"CNTL+V\"," ); break ;
	    case GDK_w : fprintf( fp, "\"CNTL+W\"," ); break ;
	    case GDK_x : fprintf( fp, "\"CNTL+X\"," ); break ;
	    case GDK_y : fprintf( fp, "\"CNTL+Y\"," ); break ;
	    case GDK_z : fprintf( fp, "\"CNTL+Z\"," ); break ;
	    default :
		continue ;
	    }
	    if ( info->cTable[i].execFunc == (char *)NULL )
	    	fprintf( fp, "\"\"\n" );
	    else
		fprintf( fp, "\"%s\"\n", info->cTable[i].execFunc );
	}
	fprintf( fp, "\n" );
	fprintf( fp, "\n" );

	fprintf( fp, "#\n" );
	fprintf( fp, "# [FXX] function table \n" );
	fprintf( fp, "#\n" );
	for(i=0;i<info->maxFNum;i++)
	{
	    switch( info->fTable[i].keycode )
	    {
	    case GDK_F1 : fprintf( fp, "\"F1\"," ); break ;
	    case GDK_F2 : fprintf( fp, "\"F2\"," ); break ;
	    case GDK_F3 : fprintf( fp, "\"F3\"," ); break ;
	    case GDK_F4 : fprintf( fp, "\"F4\"," ); break ;
	    case GDK_F5 : fprintf( fp, "\"F5\"," ); break ;
	    case GDK_F6 : fprintf( fp, "\"F6\"," ); break ;
	    case GDK_F7 : fprintf( fp, "\"F7\"," ); break ;
	    case GDK_F8 : fprintf( fp, "\"F8\"," ); break ;
	    case GDK_F9 : fprintf( fp, "\"F9\"," ); break ;
	    case GDK_F10 : fprintf( fp, "\"F10\"," ); break ;
	    case GDK_F11 : fprintf( fp, "\"F11\"," ); break ;
	    case GDK_F12 : fprintf( fp, "\"F12\"," ); break ;
	    default :
		continue ;
	    }
	    if ( info->fTable[i].execFunc == (char *)NULL )
	    	fprintf( fp, "\"\"\n" );
	    else
		fprintf( fp, "\"%s\"\n", info->fTable[i].execFunc );
	}
	fprintf( fp, "\n" );

	fclose(fp);

	return(0);
}
