/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"

int getGeometryInfo( mode, xymode, whmode, x, y, w, h )
int mode ;
int *xymode, *whmode ;
int *x,*y,*w,*h;
{
    FILE    *fp ;
    char    data[1024] ;
    char    filename[1024] ;
    char    *px, *py, *pw, *ph ;

    *xymode = *whmode = 2 ; /* ư */
    *x = *y = *w = *y = -1 ;
    px = py = pw = ph = (char *)NULL ;

    switch( mode )
    {
	case CXPLORER_MODE :
		sprintf( filename, "%s/.cxp/size/cxplorer.size",
				(char*)getenv("HOME") );
		break ;
	case CXPNOTE_MODE :
		sprintf( filename, "%s/.cxp/size/cxpnote.size",
				(char*)getenv("HOME") );
		break ;
	case CXPMAIL_MODE :
		sprintf( filename, "%s/.cxp/size/cxpmail.size",
				(char*)getenv("HOME") );
		break ;
	case CXPCALEN_MODE :
		sprintf( filename, "%s/.cxp/size/cxpcalen.size",
				(char*)getenv("HOME") );
		break ;
	default :
		return(0);
		break ;
    }

    if ( access( filename, F_OK ) )
	return(0);

    if ( (fp = fopen( filename, "r" )) == NULL )
	return(-1);

    memset( data, 0x00, sizeof(data) );
    while( fgets( data, sizeof(data), fp) != 0)
    {
	if (( data[0] == '#'  ) ||  ( data[0] == '\n' )
	||  ( data[0] == '\t' ) ||  ( data[0] == ' '  ))
	    continue ;

	getNumberData( data,"XYMODE=", strlen("XYMODE="), xymode );
	getNumberData( data,"WHMODE=", strlen("WHMODE="), whmode );
	getNumberData( data,"X=", strlen("X="), x );
	getNumberData( data,"Y=", strlen("Y="), y );
	getNumberData( data,"W=", strlen("W="), w );
	getNumberData( data,"H=", strlen("H="), h );
    }
    fclose( fp );

    return(0);
}

int setGeometryInfo( mode, xymode, whmode, x, y, w, h )
int mode ;
int xymode, whmode ;
int x,y,w,h;
{
    FILE    *fp ;
    char    data[1024] ;
    char    filename[1024] ;

    sprintf( filename, "%s/.cxp", getenv("HOME") );
    if ( access( filename, F_OK ) )
    {
	/* ǥ쥯ȥ꤬ʤä */
	mkdir ( filename, 0755 );
    }
    sprintf( filename, "%s/.cxp/size", getenv("HOME") );
    if ( access( filename, F_OK ) )
    {
	/* ǥ쥯ȥ꤬ʤä */
	mkdir ( filename, 0755 );
    }

    switch( mode )
    {
	case CXPLORER_MODE :
		sprintf( filename, "%s/.cxp/size/cxplorer.size",
				(char*)getenv("HOME") );
		break ;
	case CXPNOTE_MODE :
		sprintf( filename, "%s/.cxp/size/cxpnote.size",
				(char*)getenv("HOME") );
		break ;
	case CXPMAIL_MODE :
		sprintf( filename, "%s/.cxp/size/cxpmail.size",
				(char*)getenv("HOME") );
		break ;
	case CXPCALEN_MODE :
		sprintf( filename, "%s/.cxp/size/cxpcalen.size",
				(char*)getenv("HOME") );
		break ;
	default :
		return(0);
		break ;
    }

    if ( (fp = fopen( filename, "w" )) == NULL )
	return(-1);

    fprintf( fp, "#\n" );
    fprintf( fp, "# window size setting .\n" );
    fprintf( fp, "# author: konta (hatakeda@mbm.sphere.ne.jp)\n" );
    fprintf( fp, "#\n" );
    fprintf( fp, "# XYMODE=mode   # ɽ֥⡼\n");
    fprintf( fp, "#        0 : ΰ\n");
    fprintf( fp, "#        1 : ΰ\n");
    fprintf( fp, "#        2 : ư\n");
    fprintf( fp, "# WHMODE=mode   # ɽ⡼\n");
    fprintf( fp, "#        0 : Υ\n");
    fprintf( fp, "#        1 : Υ\n");
    fprintf( fp, "#        2 : ư\n");
    fprintf( fp, "# X=size        # ɽXɸ\n");
    fprintf( fp, "# Y=size        # ɽYɸ\n");
    fprintf( fp, "# W=size        # ɥ\n");
    fprintf( fp, "# H=size        # ɥ⤵\n");
    fprintf( fp, "#\n" );
    fprintf( fp, "\n" );

    fprintf( fp, "XYMODE=%d\n", xymode );
    fprintf( fp, "WHMODE=%d\n", whmode );
    fprintf( fp, "X=%d\n", x );
    fprintf( fp, "Y=%d\n", y );
    fprintf( fp, "W=%d\n", w );
    fprintf( fp, "H=%d\n", h );
    fprintf( fp, "\n" );

    fclose( fp );

    return(0);
}
