/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

static char *_getAddr( no, buff, size )
int	no ;
char	*buff ;
int	size ;
{
	char	work[2048] ;
	char	*ptr ;

	memcpy( work, buff, size );
	ptr = nstrchr ( work, '"', no+1 );
	*ptr = 0x00 ;
	ptr = nstrchr ( work, '"', no );

	return( ptr+1 );
}

/* ɥ쥹ե뤫ɤ߹ */
int getAddressData( kensu, addr )
int		*kensu ;
ADDRINFO	*addr ;
{
	FILE	*fp ;
	char	data[2048] ;
	char	filename[512] ;

	(*kensu) = 0 ;

	sprintf( filename, "%s/.cxp/address.dat", getenv("HOME") );
	if ( access( filename, F_OK ) )
	{
		return(0);
	}

	if ( (fp = fopen( filename, "r" )) == NULL )
	{
		fprintf(stdout,"Address data file open error [%s]\n",
				filename );
		return(-1);
	}

	memset( data, 0x00, sizeof(data) );
	while( fgets( data, sizeof(data), fp) != 0)
	{
	    if (( data[0] == '#'  ) ||  ( data[0] == '\n' )
	    ||  ( data[0] == '\t' ) ||  ( data[0] == ' '  ))
		continue ;

	    addr[*kensu].name    = g_strdup(_getAddr(  1, data, sizeof(data)));
	    addr[*kensu].kana    = g_strdup(_getAddr(  3, data, sizeof(data)));
	    addr[*kensu].job     = g_strdup(_getAddr(  5, data, sizeof(data)));
	    addr[*kensu].jtel    = g_strdup(_getAddr(  7, data, sizeof(data)));
	    addr[*kensu].sex     = g_strdup(_getAddr(  9, data, sizeof(data)));
	    addr[*kensu].birth   = g_strdup(_getAddr( 11, data, sizeof(data)));
	    addr[*kensu].bload   = g_strdup(_getAddr( 13, data, sizeof(data)));
	    addr[*kensu].ybin    = g_strdup(_getAddr( 15, data, sizeof(data)));
	    addr[*kensu].addr    = g_strdup(_getAddr( 17, data, sizeof(data)));
	    addr[*kensu].tel     = g_strdup(_getAddr( 19, data, sizeof(data)));
	    addr[*kensu].fax     = g_strdup(_getAddr( 21, data, sizeof(data)));
	    addr[*kensu].email   = g_strdup(_getAddr( 23, data, sizeof(data)));
	    addr[*kensu].website = g_strdup(_getAddr( 25, data, sizeof(data)));
	    addr[*kensu].comment = g_strdup(_getAddr( 27, data, sizeof(data)));

	    (*kensu) ++ ;
	}

	fclose( fp );

	return( *kensu );
}

int setAddressData( kensu, addr )
int		*kensu ;
ADDRINFO	*addr ;
{
	FILE	*fp ;
	char	filename[512] ;
	int	i ;

	sprintf( filename, "%s/.cxp", getenv("HOME") );
	if ( access( filename, F_OK ) )
	{
	    /* ǥ쥯ȥ꤬ʤä */
	    mkdir ( filename, 0755 );
	}
	sprintf( filename, "%s/.cxp/address.dat", getenv("HOME") );
	if ( (fp = fopen( filename, "w" )) == NULL )
		return(-1);

	fprintf( fp, "#\n" );
	fprintf( fp, "# address.dat "
		     "( cxplorer address data file Version 1.00)\n" );
	fprintf( fp, "# author: konta (hatakeda@mbm.sphere.ne.jp)\n" );
	fprintf( fp, "#\n" );
	fprintf( fp, "# Usage : \".aaa\"%c \"bbb\"%c \"ddd.xpm\"%c \"eee\"\n",
                            0x2c, 0x2c, 0x2c );
	fprintf( fp, "# Usage : \"name\"%c\"kana\"%c\"job\"%c\"jtel\"%c"
			"\"sex\"%c\"birth\"%c\"bload\"%c\"ybin\"%c\"addr\"%c"
			"\"tel\"%c\"fax\"%c\"email\"%c\"website\"%c\"comment\"\n",
			0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c,
			0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c );
	fprintf( fp, "#\n" );
	fprintf( fp, "# name    : ̾\n");
	fprintf( fp, "# kana    : \n");
	fprintf( fp, "# job     : ̾ع̾\n");
	fprintf( fp, "# jtel    : Ϣ\n");
	fprintf( fp, "# sex     : \n");
	fprintf( fp, "# birth   : ǯ\n");
	fprintf( fp, "# bload   : շ\n");
	fprintf( fp, "# ybin    : ͹ֹ\n");
	fprintf( fp, "# addr    : \n");
	fprintf( fp, "# tel     : ֹ\n");
	fprintf( fp, "# fax     : ƣֹ\n");
	fprintf( fp, "# email   : Żҥ᡼\n");
	fprintf( fp, "# website : ۡڡ\n");
	fprintf( fp, "# comment : \n");
	fprintf( fp, "#\n" );
	fprintf( fp, "\n" );
	fprintf( fp, "#\n" );
	fprintf( fp, "# ɥ쥹ǡ\n");
	fprintf( fp, "#\n" );

	for(i=0;i<(*kensu);i++)
	{
		fprintf( fp,	"\"%s\"%c\"%s\"%c\"%s\"%c\"%s\"%c"
				"\"%s\"%c\"%s\"%c\"%s\"%c\"%s\"%c"
				"\"%s\"%c\"%s\"%c\"%s\"%c\"%s\"%c"
				"\"%s\"%c\"%s\"\n",
		addr[i].name,	0x2c, addr[i].kana,	0x2c,
		addr[i].job,	0x2c, addr[i].jtel,	0x2c,
		addr[i].sex,	0x2c, addr[i].birth,	0x2c,
		addr[i].bload,	0x2c, addr[i].ybin,	0x2c,
		addr[i].addr,	0x2c, addr[i].tel,	0x2c,
		addr[i].fax,	0x2c, addr[i].email,	0x2c,
		addr[i].website,0x2c, addr[i].comment );
	}

	fclose(fp);

	return(0);
}
