/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

/* ץꥱեɤ߹ */
int getApplicationConfig( appli_kensu, appli )
int	*appli_kensu ;
APPLIINFO	*appli ;
{
	FILE	*fp ;
	char	configbuff[1024] ;
	char	workbuff[1024] ;
	char	filename[1024] ;
	char	*ptr ;
	int	kensu ;
	int	n ;

	sprintf( filename, "%s/.cxp/lib/appli.cfg", (char*)getenv("HOME") );
	if ( access( filename, F_OK ) )
	{
		/* ե뤬¸ߤʤä饷ƥΥǡ */
		strcpy( filename, (char *)getPath(CXPSYSTEM_APPLI) );
	}

	if ( (fp = fopen( filename, "r" )) == NULL )
	{
		fprintf(stdout,"Application config file open error [%s]\n",
				filename );
		return(-1);
	}

	(*appli_kensu) = 0 ;
	memset( configbuff, 0x00, sizeof(configbuff) );
	while( fgets( configbuff, sizeof(configbuff), fp) != 0)
	{
	    if (( configbuff[0] == '#'  ) ||  ( configbuff[0] == '\n' )
	    ||  ( configbuff[0] == '\t' ) ||  ( configbuff[0] == ' '  ))
		continue ;

	    /* ĥҤμФ */
	    memcpy( workbuff, configbuff, sizeof(configbuff) );
	    ptr = nstrchr ( workbuff, '"', 2 );
	    *ptr = 0x00 ;
	    ptr = nstrchr ( workbuff, '"', 1 );
	    appli[*appli_kensu].kakucho = g_strdup( ptr+1 );

	    /* ե̾μФ */
	    memcpy( workbuff, configbuff, sizeof(configbuff) );
	    ptr = nstrchr ( workbuff, '"', 4 );
	    *ptr = 0x00 ;
	    ptr = nstrchr ( workbuff, '"', 3 );
	    appli[*appli_kensu].info = g_strdup( ptr+1 );

	    /* XPM̾եμФ */
	    memcpy( workbuff, configbuff, sizeof(configbuff) );
	    ptr = nstrchr ( workbuff, '"', 6 );
	    *ptr = 0x00 ;
	    ptr = nstrchr ( workbuff, '"', 5 );
	    appli[*appli_kensu].xpm_small = g_strdup( (char *)getPath(ptr+1) );

	    /* ưեμФ */
	    memcpy( workbuff, configbuff, sizeof(configbuff) );
	    ptr = nstrchr ( workbuff, '"', 8 );
	    *ptr = 0x00 ;
	    ptr = nstrchr ( workbuff, '"', 7 );
	    appli[*appli_kensu].command = g_strdup( (char *)getPath(ptr+1) );

	    (*appli_kensu) ++ ;
	}

	fclose( fp );

	return( *appli_kensu );
}

int setApplicationConfig( appli_kensu, appli )
int	*appli_kensu ;
APPLIINFO	*appli ;
{
	FILE	*fp ;
	char	filename[512] ;
	int	i ;

	sprintf( filename, "%s/.cxp", (char*)getenv("HOME") );
	if ( access( filename, F_OK ) )
	{
	    /* ǥ쥯ȥ꤬ʤä */
	    mkdir ( filename, 0755 );
	}
	sprintf( filename, "%s/.cxp/lib", (char*)getenv("HOME") );
	if ( access( filename, F_OK ) )
	{
	    /* ǥ쥯ȥ꤬ʤä */
	    mkdir ( filename, 0755 );
	}

	sprintf( filename, "%s/.cxp/lib/appli.cfg", (char*)getenv("HOME") );
	if ( (fp = fopen( filename, "w" )) == NULL )
		return(-1);

	fprintf( fp, "#\n" );
	fprintf( fp, "# appli.cfg "
		     "( cxplorer applicaion config file Version 1.00)\n" );
	fprintf( fp, "# author: konta (hatakeda@mbm.sphere.ne.jp)\n" );
	fprintf( fp, "#\n" );
	fprintf( fp, "# Usage : \".aaa\"%c \"bbb\"%c \"ddd.xpm\"%c \"eee\"\n",
                            0x2c, 0x2c, 0x2c );
	fprintf( fp, "#\n" );
	fprintf( fp, "# .aaa    : ĥ\n" );
	fprintf( fp, "# bbb     : ե̾\n" );
	fprintf( fp, "# ddd.xpm : XPMե\n" );
	fprintf( fp, "# eee     : ưץꥱʶͣϣˡ\n" );
	fprintf( fp, "#\n" );
	fprintf( fp, "\n" );
	fprintf( fp, "#\n" );
	fprintf( fp, "# ץꥱϢդ\n" );
	fprintf( fp, "#\n" );

	for(i=0;i<(*appli_kensu);i++)
	{
		fprintf( fp, "\"%s\"%c\"%s\"%c\"%s\"%c\"%s\"\n",
		appli[i].kakucho,	0x2c,
		appli[i].info,		0x2c,
		appli[i].xpm_small,	0x2c,
		appli[i].command );
	}

	fclose(fp);

	return(0);
}
