/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

/* ǥХɤ߹ */
int getDeviceConfig( device )
DeviceInfo *device ;
{
    FILE	*fp ;
    char	configbuff[1024] ;
    char	workbuff[1024] ;
    char	filename[1024] ;
    char	*ptr ;
    int		kensu ;
    int		n ;

    sprintf( filename, "%s/.cxp/lib/device.cfg", (char*)getenv("HOME") );
    if ( access( filename, F_OK ) )
    {
	/* ե뤬¸ߤʤä饷ƥΥǡ */
	strcpy( filename, (char *)getPath(CXPSYSTEM_DEVICE) );
    }

    if ( (fp = fopen( filename, "r" )) == NULL )
    {
	fprintf(stdout,"Device config file open error [%s]\n", filename );
	return(-1);
    }

    device->device_kensu = 0 ;

    memset( configbuff, 0x00, sizeof(configbuff) );
    while( fgets( configbuff, sizeof(configbuff), fp) != 0)
    {
	if (( configbuff[0] == '#'  ) ||  ( configbuff[0] == '\n' )
	||  ( configbuff[0] == '\t' ) ||  ( configbuff[0] == ' '  ))
	    continue ;

	/* Хååץץμ */
	memcpy( workbuff, configbuff, sizeof(configbuff) );
	ptr = nstrchr ( workbuff, '"', 8 );
	*ptr = 0x00 ;
	ptr = nstrchr ( workbuff, '"', 7 );
	if ( strcmp( ptr+1, "OFF" ) == 0 )
	    device->device[device->device_kensu].backupFlag = 1 ;
	else
	    device->device[device->device_kensu].backupFlag = 0 ;

	/* ǥХ̾μ */
	memcpy( workbuff, configbuff, sizeof(configbuff) );
	ptr = nstrchr ( workbuff, '"', 4 );
	*ptr = 0x00 ;
	ptr = nstrchr ( workbuff, '"', 3 );
	device->device[device->device_kensu].name = g_strdup( ptr+1 );

	/* ǥХѥμ */
	memcpy( workbuff, configbuff, sizeof(configbuff) );
	ptr = nstrchr ( workbuff, '"', 6 );
	*ptr = 0x00 ;
	ptr = nstrchr ( workbuff, '"', 5 );
	device->device[device->device_kensu].path = g_strdup( ptr+1 );

	/* ǥХפμ */
	memcpy( workbuff, configbuff, sizeof(configbuff) );
	ptr = nstrchr ( workbuff, '"', 2 );
	*ptr = 0x00 ;
	ptr = nstrchr ( workbuff, '"', 1 );
	device->device[device->device_kensu].type = g_strdup( ptr+1 );

	device->device_kensu ++;
    }

    fclose( fp );

    return(0);
}

/* ǥХ񤭹 */
int setDeviceConfig( device )
DeviceInfo *device ;
{
    FILE	*fp ;
    char	filename[1024] ;
    int		i ;

    sprintf( filename, "%s/.cxp", (char*)getenv("HOME") );
    if ( access( filename, F_OK ) )  
    {
	/* ǥ쥯ȥ꤬ʤä */
	mkdir ( filename, 0755 );
    }
    sprintf( filename, "%s/.cxp/lib", (char*)getenv("HOME") );
    if ( access( filename, F_OK ) )
    {
	/* ǥ쥯ȥ꤬ʤä */
	mkdir ( filename, 0755 );
    }

    sprintf( filename, "%s/.cxp/lib/device.cfg", (char*)getenv("HOME") );
    if ( (fp = fopen( filename, "w" )) == NULL )
    {
	fprintf(stdout,"Device config file open error [%s]\n", filename );
	return(-1);
    }

    fprintf( fp, "#\n" );
    fprintf( fp, "# device.cfg ( Cxp Device Config Version 1.00)\n" );
    fprintf( fp, "# author: konta (hatakeda@mbm.sphere.ne.jp)\n" );
    fprintf( fp, "#\n" );
    fprintf( fp, "# Usage : \"type\"%c \"devname\"%c\"device\"%c\"option\"\n",0x2c,0x2c,0x2c);
    fprintf( fp, "#\n" );
    fprintf( fp, "# type    : ǥ\n" );
    fprintf( fp, "# devname : ǥХ̾\n" );
    fprintf( fp, "# device  : ǥХե\n" );
    fprintf( fp, "# option  : ץ\n" );
    fprintf( fp, "#\n" );
    fprintf( fp, "\n" );

    for(i=0;i<device->device_kensu;i++)
    {
	fprintf( fp, "\"%s\"%c\"%s\"%c\"%s\"%c\"%s\"\n",
		device->device[i].type,
		0x2c,
		device->device[i].name,
		0x2c,
		device->device[i].path,
		0x2c,
		(device->device[i].backupFlag == 0 ? "ON" : "OFF") );
    }

    fclose( fp );

    return(0);
}
