/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpimage.h"

/* ƥΥ᡼ */
int getSystemImageInfo( kensu, image )
int		*kensu ;
IMAGEINFO	*image ;
{
	FILE	*fp ;
	char	configbuff[2048] ;
	char	workbuff[2048] ;
	char	filename[512] ;
	char	*ptr ;
	int	n ;

	(*kensu) = 0 ;

	sprintf( filename, "%s/.cxp/lib/cxpimage.cfg", (char*)getenv("HOME") );
	if ( access( filename, F_OK ) )
        {
		/* ե뤬¸ߤʤä飰֤ */
		return(0);
        }

	if ( (fp = fopen( filename, "r" )) == NULL )
	{
		fprintf(stdout,"System Image file open error [%s]\n",
				filename );
		return(-1);
	}

	memset( configbuff, 0x00, sizeof(configbuff) );
	while( fgets( configbuff, sizeof(configbuff), fp) != 0)
	{
		/* ե륿פμ */
		memcpy( workbuff, configbuff, sizeof(configbuff) );
		image[*kensu].type = CXP_IMAGE_NONE ;
		ptr = nstrrchr( workbuff, '.' );
		if ( ptr != NULL )
		{
			if ( strncmp( ptr+1, "gif", 3 ) == 0
			||   strncmp( ptr+1, "GIF", 3 ) == 0 )
			{
				image[*kensu].type = CXP_IMAGE_GIF ;
			}else
			if ( strncmp( ptr+1, "jpg", 3 ) == 0
			||   strncmp( ptr+1, "JPG", 3 ) == 0
			||   strncmp( ptr+1, "jpeg", 4 ) == 0
			||   strncmp( ptr+1, "JPEG", 4 ) == 0 )
			{
				image[*kensu].type = CXP_IMAGE_JPEG ;
			}
		}

		/* ե̾μ */
		image[*kensu].file = g_strdup( configbuff );

		(*kensu) ++ ;

		if ( (*kensu) >= MAX_IMAGE_NUM - 1 )
		{
			break ;
		}
	}

	fclose( fp );

	return( *kensu );
}
