/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

static int getStrNext();
static int getNumNext();

static char passwdChgNumData[10+1] = "9876543210" ;
static char passwdChgascData[26+1] = "zyxwvutsrqponmlkjihgfedcba" ;
static char passwdChgASCData[26+1] = "ZYXWVUTSRQPONMLKJIHGFEDCBA" ;

/* ͥåȥեξեɤ߹ */
int getNetConfig( kensu, net, my )
int		*kensu ;
ConnectInfo	*net ;
MyInfo		*my ;
{
    FILE *fp ;
    char cbuff[1024] ;
    char filename[1024] ;
    char *passwdPtr ;
    char passwdBuff[1024] ;
    int  i ;
    int  count ;

    count = 0 ;
    *kensu = 0 ;

    passwdPtr = (char *)NULL ;

    sprintf( filename, "%s/.cxp/net.cfg", getenv("HOME") );
    if ( access( filename, F_OK ) )
    {
	for(i=0;i<MAX_CONNECT_INFO;i++)
	{
	    net[i].login = (char *)NULL ;
	    net[i].passwd = (char *)NULL ;
	    net[i].pop3.hostname = (char *)NULL ;
	    net[i].pop3.portno = "110" ;
	    net[i].smtp.hostname = (char *)NULL ;
	    net[i].smtp.portno = "25" ;
	    net[i].proxy.hostname = (char *)NULL ;
	    net[i].proxy.portno = "8080" ;
	    net[i].proxyFlag = 0 ;
	}
	my->name = NULL ;
	my->email = NULL ;
	my->mailDelete = 0 ; /*  */
	my->sameMail = 0 ; /*  */
	my->ndayDelete = 0 ; /*  */
	my->nday       = 0 ;
	*kensu = 0 ;
	return(0);
    }

    if ( (fp = fopen( (char *)getPath(filename), "r" )) == NULL )
    {
	for(i=0;i<MAX_CONNECT_INFO;i++)
	{
	    net[i].login = (char *)NULL ;
	    net[i].passwd = (char *)NULL ;
	    net[i].pop3.hostname = (char *)NULL ;
	    net[i].pop3.portno = "110" ;
	    net[i].smtp.hostname = (char *)NULL ;
	    net[i].smtp.portno = "25" ;
	    net[i].proxy.hostname = (char *)NULL ;
	    net[i].proxy.portno = "8080" ;
	    net[i].proxyFlag = 0 ;
	}
	my->name = NULL ;
	my->email = NULL ;
	my->mailDelete = 0 ; /*  */
	my->sameMail = 0 ; /*  */
	my->ndayDelete = 0 ; /*  */
	my->nday       = 0 ;
	*kensu = 0 ;
	return(0);
    }

    memset( cbuff, 0x00, sizeof(cbuff) );
    while( fgets( cbuff, sizeof(cbuff), fp) != 0)
    {
	if (( cbuff[0] == '#'  ) ||  ( cbuff[0] == '\n' )
	||  ( cbuff[0] == '\t' ) ||  ( cbuff[0] == ' '  ))
		continue ;

	getStrNext( cbuff,"USERNAME=", strlen("USERNAME="), &my->name);
	getStrNext( cbuff,"EMAIL=", strlen("EMAIL="), &my->email);

	if ( strncmp( cbuff,"MAILDELETE=Yes", strlen("MAILDELETE=Yes"))==0)
		my->mailDelete = 0 ;
	if ( strncmp( cbuff,"MAILDELETE=No", strlen("MAILDELETE=No"))==0)
		my->mailDelete = 1 ;

	if ( strncmp( cbuff,"SAMEDELETE=Yes", strlen("SAMEDELETE=Yes"))==0)
		my->sameMail = 1 ;
	if ( strncmp( cbuff,"SAMEDELETE=No", strlen("SAMEDELETE=No"))==0)
		my->sameMail = 0 ;

	if ( strncmp( cbuff,"NDAYDELETE=Yes", strlen("NDAYDELETE=Yes"))==0)
		my->ndayDelete = 1 ;
	if ( strncmp( cbuff,"NDAYDELETE=No", strlen("NDAYDELETE=No"))==0)
		my->ndayDelete = 0 ;

	getNumNext( cbuff,"NDAY=", strlen("NDAY="), &my->nday);

	if ( strncmp( cbuff,"CONNECT_PROXY=Yes", strlen("CONNECT_PROXY=Yes"))==0)
		net[count].proxyFlag = 1 ;
	if ( strncmp( cbuff,"CONNECT_PROXY=No", strlen("CONNECT_PROXY=No"))==0)
		net[count].proxyFlag = 0 ;
	getStrNext( cbuff,"LOGIN=",strlen("LOGIN="),&net[count].login);
	getStrNext( cbuff,"PASSWD=", strlen("PASSWD="), &passwdPtr);
	if ( passwdPtr != (char *)0 )
	{
	   int length, k ;
	   sprintf( passwdBuff, "%s", passwdPtr );
	   length = strlen(passwdBuff);
	   for(i=0;i<length;i++)
	   {
		if ( passwdBuff[i] >= '0' && passwdBuff[i] <= '9' )
		{
		   k = (int)(passwdBuff[i]) - (int)'0' ;
		   passwdBuff[i] = passwdChgNumData[k] ;
		}else
		if ( passwdBuff[i] >= 'A' && passwdBuff[i] <= 'Z' )
		{
		   k = (int)(passwdBuff[i]) - (int)'A' ;
		   passwdBuff[i] = passwdChgASCData[k] ;
		}else
		if ( passwdBuff[i] >= 'a' && passwdBuff[i] <= 'z' )
		{
		   k = (int)(passwdBuff[i]) - (int)'a' ;
		   passwdBuff[i] = passwdChgascData[k] ;
		}
	   }
	   net[count].passwd = g_strdup(passwdBuff);
	}

	getStrNext( cbuff,"POP3_HOSTNAME=", strlen("POP3_HOSTNAME="),
				&net[count].pop3.hostname);
	getStrNext( cbuff,"POP3_PORTNO=", strlen("POP3_PORTNO="),
				&net[count].pop3.portno);
	getStrNext( cbuff,"SMTP_HOSTNAME=", strlen("SMTP_HOSTNAME="),
				&net[count].smtp.hostname);
	getStrNext( cbuff,"SMTP_PORTNO=", strlen("SMTP_PORTNO="),
				&net[count].smtp.portno);
	getStrNext( cbuff,"PROXY_HOSTNAME=", strlen("PROXY_HOSTNAME="),
				&net[count].proxy.hostname);
	getStrNext( cbuff,"PROXY_PORTNO=", strlen("PROXY_PORTNO="),
				&net[count].proxy.portno);

	if ( strmatch( "PROXY_PORTNO=*", cbuff ) == 0 )
	{
	    count ++;
	}
    }


    *kensu = count ;
    fclose( fp );

    return(0);
}

/* ͥåȥեξե񤭹 */
int setNetConfig( kensu, net, my )
int		*kensu ;
ConnectInfo	*net ;
MyInfo		*my ;
{
    FILE *fp ;
    char cbuff[1024] ;
    char filename[1024] ;
    char passwdBuff[1024] ;
    int  i ;

    sprintf( filename, "%s/.cxp", getenv("HOME") );
    if ( access( filename, F_OK ) )
    {
	/* ǥ쥯ȥ꤬ʤä */
	mkdir ( filename, 0755 );
    }

    sprintf( filename, "%s/.cxp/net.cfg", getenv("HOME") );
    if ( (fp = fopen( (char *)getPath(filename), "w" )) == NULL )
    {
	return(-1);
    }

    fprintf( fp, "#\n" );
    fprintf( fp, "# net.cfg (Cxp Network Config File Version 1.00) \n" );
    fprintf( fp, "# author: konta (hatakeda@mbm.sphere.ne.jp)\n" );
    fprintf( fp, "#\n" );
    fprintf( fp, "#\n" );
    fprintf( fp, "\n" ) ;

    fprintf( fp, "#\n" ) ;
    fprintf( fp, "# My Name Infomation.\n") ;
    fprintf( fp, "#\n" ) ;
    if ( my->name == NULL )
	fprintf( fp, "USERNAME=\"\"\n" );
    else
	fprintf( fp, "USERNAME=\"%s\"\n", my->name );

    if ( my->email == NULL )
	fprintf( fp, "EMAIL=\"\"\n" );
    else
	fprintf( fp, "EMAIL=\"%s\"\n", my->email );

    if ( my->mailDelete == 0 )
	fprintf( fp, "MAILDELETE=Yes\n" );
    else
	fprintf( fp, "MAILDELETE=No\n" );

    if ( my->sameMail == 0 )
	fprintf( fp, "SAMEDELETE=No\n" );
    else
	fprintf( fp, "SAMEDELETE=Yes\n" );

    if ( my->ndayDelete == 0 )
	fprintf( fp, "NDAYDELETE=No\n" );
    else
	fprintf( fp, "NDAYDELETE=Yes\n" );

    fprintf( fp, "NDAY=\"%d\"\n", my->nday );

    fprintf( fp, "\n" ) ;



    for(i=0;i<(*kensu);i++)
    {
	fprintf( fp, "\n" ) ;
	fprintf( fp, "\n" ) ;
	fprintf( fp, "\n" ) ;
	fprintf( fp, "#\n" ) ;
	fprintf( fp, "# login Infomation. No.%d\n", i+1 ) ;
	fprintf( fp, "#\n" ) ;

	if ( net[i].login == NULL )
	    fprintf( fp, "LOGIN=\"\"\n" );
	else
	    fprintf( fp, "LOGIN=\"%s\"\n", net[i].login );

	if ( net[i].passwd == NULL )
	    fprintf( fp, "PASSWD=\"\"\n" );
	else{
	    int length, k, m ;

	    sprintf( passwdBuff,"%s", net[i].passwd );
	    length = strlen(passwdBuff);
	    for(m=0;m<length;m++)
	    {
		if ( passwdBuff[m] >= '0' && passwdBuff[m] <= '9' )
		{
		    k = (int)(passwdBuff[m]) - (int)'0' ;
		    passwdBuff[m] = passwdChgNumData[k] ;
		}else
		if ( passwdBuff[m] >= 'A' && passwdBuff[m] <= 'Z' )
		{
		    k = (int)(passwdBuff[m]) - (int)'A' ;
		    passwdBuff[m] = passwdChgASCData[k] ;
		}else
		if ( passwdBuff[m] >= 'a' && passwdBuff[m] <= 'z' )
		{
		    k = (int)(passwdBuff[m]) - (int)'a' ;
		    passwdBuff[m] = passwdChgascData[k] ;
		}
	    }
	    fprintf( fp, "PASSWD=\"%s\"\n", passwdBuff );
	}

	if ( net[i].proxyFlag == 0 )
	    fprintf( fp, "CONNECT_PROXY=No\n" ) ;
	else
	    fprintf( fp, "CONNECT_PROXY=Yes\n" ) ;

	if (net[i].pop3.hostname == NULL)
	    fprintf( fp, "POP3_HOSTNAME=\"\"\n" );
	else
	    fprintf( fp, "POP3_HOSTNAME=\"%s\"\n", net[i].pop3.hostname );

	if (net[i].pop3.portno == NULL)
	    fprintf( fp, "POP3_PORTNO=\"\"\n" );
	else
	    fprintf( fp, "POP3_PORTNO=\"%s\"\n", net[i].pop3.portno );

	if (net[i].smtp.hostname == NULL)
	    fprintf( fp, "SMTP_HOSTNAME=\"\"\n" );
	else
	    fprintf( fp, "SMTP_HOSTNAME=\"%s\"\n", net[i].smtp.hostname );

	if (net[i].smtp.portno == NULL)
	    fprintf( fp, "SMTP_PORTNO=\"\"\n" );
	else
	    fprintf( fp, "SMTP_PORTNO=\"%s\"\n", net[i].smtp.portno );

	if (net[i].proxy.hostname == NULL)
	    fprintf( fp, "PROXY_HOSTNAME=\"\"\n" );
	else
	    fprintf( fp, "PROXY_HOSTNAME=\"%s\"\n", net[i].proxy.hostname );

	if (net[i].proxy.portno == NULL)
	    fprintf( fp, "PROXY_PORTNO=\"\"\n" );
	else
	    fprintf( fp, "PROXY_PORTNO=\"%s\"\n", net[i].proxy.portno );

    }
    fprintf( fp, "\n" );

    fclose( fp );

    chmod( filename, 0700 );

    return(0);
}

static int getStrNext( char *buff, char *data, int size, char **set )
{
    char workbuff[1024] ;
    char *ptr ;

    if ( !strncmp( buff, data, size ) )
    {
	memset( workbuff, 0x00, sizeof(workbuff) );
	strncpy( workbuff, buff, strlen(buff) );
	ptr = nstrchr ( workbuff, '"', 2 );
	if ( ptr != (char *)NULL )
	    *ptr = 0x00 ;
	ptr = nstrchr ( workbuff, '"', 1 );
	(*set) = (char *)g_strdup( (char *)getPath(ptr+1) );
    }
}

static int getNumNext( char *buff, char *data, int size, int *set )
{
    char workbuff[1024] ;
    char *ptr ;

    if ( !strncmp( buff, data, size ) )
    {
	memset( workbuff, 0x00, sizeof(workbuff) );
	strncpy( workbuff, buff, strlen(buff) );
	ptr = nstrchr ( workbuff, '"', 2 );
	if ( ptr != (char *)NULL )
	    *ptr = 0x00 ;
	ptr = nstrchr ( workbuff, '"', 1 );
	(*set) = atoi( ptr+1 );
    }
}
