/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

static char *cxpbasepath ;

int CxpBasePathInit()
{
    FILE *fp ;
    char cbuff[512] ;
    char *ptr ;

    cxpbasepath = strdup("/usr/local/cxplorer");

    if ( access( CXP_BASE_PATHINFO, F_OK ) )
    {
	/* ե뤬¸ߤʤϤΤޤȴ */
	return(0);
    }

    if ( (fp = fopen(CXP_BASE_PATHINFO,"r")) == (FILE *)NULL )
    {
	/* ե륪ץ󥨥顼ϤΤޤȴ */
	return(0);
    }

    while( fgets( cbuff, sizeof(cbuff), fp) != 0)
    {
	if (( cbuff[0] == '#'  ) ||  ( cbuff[0] == '\n' )
	||  ( cbuff[0] == '\t' ) ||  ( cbuff[0] == ' '  ))
		continue ;

	if ((ptr = (char *)strchr( cbuff, '\n' )) != (char *)NULL )
	    *ptr = 0x00 ;

	if ( strlen(cbuff) <= 0 )
	    continue ;

	if ( !access( cbuff, F_OK ) )
	{
	    /* ¸ߤǥ쥯ȥξΤ */
	    cxpbasepath = strdup( cbuff );
	    break ;
	}
    }

    fclose(fp);

    return(0);
}

char *getPath( path )
char	*path ;
{
	static char buff[1024] ;
	char	work[1024] ;
	char	*ptr ;

	strcpy( work, path );
	if ( !strmatch( (char *)"_CXPBASE_*", work ) )
	{
	    sprintf( buff, "%s/%s", cxpbasepath, &work[10] );
	}else{
	    strcpy( buff, work );
	}

	return( (char *)&buff[0] );
}
