/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpcalen.h"

static int sortScheduleData();

/* ꤵ줿ǯ֤ */
int getMonthDay( int year, int month )
{
	int	mm1[12] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
	int	mm2[12] = { 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
	int	day ;

	if ( ((year%4) == 0 && (year%100) != 0 ) || ((year%400) == 0 ))
        {
	    /* ǯǤ */
	    day = mm2[month - 1] ;
	}else{
	    /* ǯǤʤ */
	    day = mm1[month - 1] ;
	}

	return(day);
}

/* ꤵ줿ǯγ֤ */
int getStartMonthPosition( int year, int month )
{
	struct tm stim ;
	struct tm *ltim ;
	time_t	tim ;
	int	position ;

	position = 0 ;

	/* ꤵ줿ǯΣֹ */
	/* 0 :  */
	/* 1 :  */
	/* 2 :  */
	/* 3 :  */
	/* 4 :  */
	/* 5 :  */
	/* 6 :  */

	stim.tm_year = year - 1900 ;
	stim.tm_mon  = month - 1 ;
	stim.tm_mday = 1 ;
	stim.tm_hour = 0 ;
	stim.tm_min  = 0 ;
	stim.tm_sec  = 0 ;

	/*  */
	tim = mktime(&stim);
	ltim = localtime(&tim);

	return( ltim->tm_wday );
}

/* ToDoΣƥ */
static int getTodoItem( char *buff, int *level, char **naiyo, AlarmInfo *alarmdata )
{
	char		work[2048];
	char		*ptr ;

	strcpy( work, buff );
	if ( (ptr = (char *)strrchr( work,'\n' )) != (char *)NULL )
		*ptr = 0x00 ;

	/* ʬμ */
	if ( (ptr = (char *)strrchr( work, ':' )) == (char *)NULL )
		return(1);
	alarmdata->min = atoi(ptr+1);
	*ptr = 0x00 ;

	/* μ */
	if ( (ptr = (char *)strrchr( work, '\t' )) == (char *)NULL )
		return(1);
	alarmdata->hour = atoi(ptr+1);
	*ptr = 0x00 ;

	/* μ */
	if ( (ptr = (char *)strrchr( work, '/' )) == (char *)NULL )
		return(1);
	alarmdata->day = atoi(ptr+1);
	*ptr = 0x00 ;

	/* μ */
	if ( (ptr = (char *)strrchr( work, '/' )) == (char *)NULL )
		return(1);
	alarmdata->month = atoi(ptr+1);
	*ptr = 0x00 ;

	/* ǯμ */
	if ( (ptr = (char *)strrchr( work, '\t' )) == (char *)NULL )
		return(1);
	alarmdata->year = atoi(ptr+1);
	*ptr = 0x00 ;

	/* 顼μ */
	if ( (ptr = (char *)strrchr( work, '\t' )) == (char *)NULL )
		return(1);
	if ( strcmp(ptr+1, "OFF" ) == 0 )
		alarmdata->mode = 0 ;
	else if ( strcmp(ptr+1, "ON=ALLYEAR" ) == 0 )
		alarmdata->mode = 1 ;
	else if ( strcmp(ptr+1, "ON=ALLMONTH" ) == 0 )
		alarmdata->mode = 2 ;
	else if ( strcmp(ptr+1, "ON=ALLDAY" ) == 0 )
		alarmdata->mode = 3 ;
	else if ( strcmp(ptr+1, "ON=ALLHOUR" ) == 0 )
		alarmdata->mode = 4 ;
	else if ( strcmp(ptr+1, "ON=ALLMIN" ) == 0 )
		alarmdata->mode = 5 ;
	else if ( strcmp(ptr+1, "ON=DATETIME" ) == 0 )
		alarmdata->mode = 6 ;
	else
		return(1);
	*ptr = 0x00 ;

	/* Ƥμ */
	if ( (ptr = (char *)strrchr( work, '\t' )) == (char *)NULL )
		return(1);
	*naiyo = strdup(ptr+1);
	*ptr = 0x00 ;

	/* ٥μ */
	if ( strlen(work) <= 0 )
		return(1);
	*level = atoi(work);

	return(0);
}

/* 塼Σ */
static int getScdItem( char *buff, ScduInfo *sinfo )
{
	char		work[2048];
	char		*ptr ;

	strcpy( work, buff );
	if ( (ptr = (char *)strrchr( work,'\n' )) != (char *)NULL )
		*ptr = 0x00 ;

	/* ʬμ */
	if ( (ptr = (char *)strrchr( work, ':' )) == (char *)NULL )
		return(1);
	sinfo->alarm.min = atoi(ptr+1);
	*ptr = 0x00 ;

	/* μ */
	if ( (ptr = (char *)strrchr( work, '\t' )) == (char *)NULL )
		return(1);
	sinfo->alarm.hour = atoi(ptr+1);
	*ptr = 0x00 ;

	/* μ */
	if ( (ptr = (char *)strrchr( work, '/' )) == (char *)NULL )
		return(1);
	sinfo->alarm.day = atoi(ptr+1);
	*ptr = 0x00 ;

	/* μ */
	if ( (ptr = (char *)strrchr( work, '/' )) == (char *)NULL )
		return(1);
	sinfo->alarm.month = atoi(ptr+1);
	*ptr = 0x00 ;

	/* ǯμ */
	if ( (ptr = (char *)strrchr( work, '\t' )) == (char *)NULL )
		return(1);
	sinfo->alarm.year = atoi(ptr+1);
	*ptr = 0x00 ;

	/* 顼μ */
	if ( (ptr = (char *)strrchr( work, '\t' )) == (char *)NULL )
		return(1);
	if ( strcmp(ptr+1, "OFF" ) == 0 )
		sinfo->alarm.mode = 0 ;
	else if ( strcmp(ptr+1, "ON" ) == 0 )
		sinfo->alarm.mode = 1 ;
	else
		return(1);

#if 0
	else if ( strcmp(ptr+1, "ON=ALLYEAR" ) == 0 )
		sinfo->alarm.mode = 1 ;
	else if ( strcmp(ptr+1, "ON=ALLMONTH" ) == 0 )
		sinfo->alarm.mode = 2 ;
	else if ( strcmp(ptr+1, "ON=ALLDAY" ) == 0 )
		sinfo->alarm.mode = 3 ;
	else if ( strcmp(ptr+1, "ON=ALLHOUR" ) == 0 )
		sinfo->alarm.mode = 4 ;
	else if ( strcmp(ptr+1, "ON=ALLMIN" ) == 0 )
		sinfo->alarm.mode = 5 ;
	else if ( strcmp(ptr+1, "ON=DATETIME" ) == 0 )
		sinfo->alarm.mode = 6 ;
	else
		return(1);
#endif

	*ptr = 0x00 ;

	/* μ */
	if ( (ptr = (char *)strrchr( work, '\t' )) == (char *)NULL )
		return(1);
	sinfo->length = atoi(ptr+1);
	*ptr = 0x00 ;

	/* ȥμ */
	if ( (ptr = (char *)strrchr( work, '\t' )) == (char *)NULL )
		return(1);
	sinfo->title = strdup(ptr+1);
	*ptr = 0x00 ;

	/* ٥μ */
	if ( (ptr = (char *)strrchr( work, '\t' )) == (char *)NULL )
		return(1);
	sinfo->level = atoi(ptr+1);
	*ptr = 0x00 ;

	/* ʬμ */
	if ( (ptr = (char *)strrchr( work, ':' )) == (char *)NULL )
		return(1);
	sinfo->min = atoi(ptr+1);
	*ptr = 0x00 ;

	/* μ */
	if ( (ptr = (char *)strrchr( work, '\t' )) == (char *)NULL )
		return(1);
	sinfo->hour = atoi(ptr+1);
	*ptr = 0x00 ;

	/* μ */
	if ( (ptr = (char *)strrchr( work, '/' )) == (char *)NULL )
		return(1);
	sinfo->day = atoi(ptr+1);
	*ptr = 0x00 ;

	/* μ */
	if ( strlen(work) <= 0 )
		return(1);
	sinfo->month = atoi(work);

	return(0);
}

/* ToDo */
int getCalenDataTodo( Todo *todo )
{
	AlarmInfo	alarmdata ;
	FILE		*fp ;
	char		buff[2048] ;
	char		filename[1024] ;
	char		*naiyo ;
	int		status ;
	int		kensu ;
	int		level ;

	memset( todo, 0x00, sizeof(Todo) );

	sprintf( filename, "%s/.cxp/todo/todo.dat", (char*)getenv("HOME") );
	if ( access( filename, F_OK ) )
	{
		return(1);
	}

	if ((fp = fopen( filename, "r" )) == NULL )
	{
		return(1);
	}

	kensu = 0 ;
	while( fgets( buff, sizeof(buff), fp ) != 0 )
	{
	    if (( buff[0] == '#'  ) || ( buff[0] == '\n' )
	    ||  ( buff[0] == '\t' ) || ( buff[0] == ' '  ))
		continue ;

	    status = getTodoItem( buff, &level, &naiyo, &alarmdata );
	    if ( status == 0 )
	    {
		todo->item[kensu].level       = level ;
		todo->item[kensu].alarm.mode  = alarmdata.mode ;
		todo->item[kensu].alarm.year  = alarmdata.year ;
		todo->item[kensu].alarm.month = alarmdata.month ;
		todo->item[kensu].alarm.day   = alarmdata.day ;
		todo->item[kensu].alarm.hour  = alarmdata.hour ;
		todo->item[kensu].alarm.min   = alarmdata.min ;
		todo->item[kensu].data        = strdup(naiyo);
		kensu ++;
	    }
	}

	todo->kensu = kensu ;

	fclose(fp);

	return(0);
}

/* ToDo¸ */
int setCalenDataTodo( Todo *todo )
{
	FILE	*fp ;
	char	buff[2048];
	char	filename[1024] ;
	int	i ;

	sprintf( filename, "%s/.cxp", (char*)getenv("HOME") );
	if ( access( filename, F_OK ) )
		mkdir ( filename, 0755 );

	sprintf( filename, "%s/.cxp/todo", (char*)getenv("HOME") );
	if ( access( filename, F_OK ) )
		mkdir ( filename, 0755 );

	sprintf( filename, "%s/.cxp/todo/todo.dat", (char*)getenv("HOME"));

	if ( (fp = fopen( filename, "w" )) == NULL )
	{
		return(1);
	}

	fprintf(fp, "#\n");
	fprintf(fp, "# todo.dat (Cxp Calen Todo Data)\n");
	fprintf(fp, "# author konta (hatakeda@mbm.sphere.ne.jp)\n");
	fprintf(fp, "#\n");
	fprintf(fp, "\n");

	for(i=0;i<todo->kensu;i++)
	{
		fprintf(fp, "%d\t", todo->item[i].level );
		fprintf(fp, "%s\t", todo->item[i].data );
		switch(todo->item[i].alarm.mode)
		{
		    default :
		    case 0 : fprintf(fp, "%s\t", "OFF"         ); break ;
		    case 1 : fprintf(fp, "%s\t", "ON"          ); break ;
#if 0
		    case 1 : fprintf(fp, "%s\t", "ON=ALLYEAR"  ); break ;
		    case 2 : fprintf(fp, "%s\t", "ON=ALLMONTH" ); break ;
		    case 3 : fprintf(fp, "%s\t", "ON=ALLDAY"   ); break ;
		    case 4 : fprintf(fp, "%s\t", "ON=ALLHOUR"  ); break ;
		    case 5 : fprintf(fp, "%s\t", "ON=ALLMIN"   ); break ;
		    case 6 : fprintf(fp, "%s\t", "ON=DATETIME" ); break ;
#endif
		}
		fprintf(fp, "%04d/",  todo->item[i].alarm.year );
		fprintf(fp, "%02d/",  todo->item[i].alarm.month );
		fprintf(fp, "%02d\t", todo->item[i].alarm.day );
		fprintf(fp, "%02d:",  todo->item[i].alarm.hour );
		fprintf(fp, "%02d\n", todo->item[i].alarm.min );
	}

	fclose(fp);

	return(0);
}

/* ɽ̤ */
int getCalenDataView( ViewData *view )
{
	FILE		*fp ;
	char		buff[2048] ;
	char		work[2048] ;
	char		filename[1024] ;
	char		*ptr ;
	char		*name ;
	int		kensu ;
	int		kind ;

	memset( view, 0x00, sizeof(ViewData) );

	sprintf( filename, "%s/.cxp/schedule/view.dat", (char*)getenv("HOME") );
	if ( access( filename, F_OK ) )
		return(1);

	kensu = 0 ;

	/*--- MINE ǡμ ---*/
	if ((fp = fopen( filename, "r" )) == NULL )
		return(1);
	while( fgets( buff, sizeof(buff), fp ) != 0 )
	{
	    if (( buff[0] == '#'  ) || ( buff[0] == '\n' )
	    ||  ( buff[0] == '\t' ) || ( buff[0] == ' '  ))
		continue ;

	    strcpy( work, buff );
	    if ((ptr = (char *)strrchr(work, '\n')) != (char *)NULL )
		*ptr = 0x00 ;

	    if ((ptr = (char *)strrchr(work, '\t')) == (char *)NULL )
		continue ;

	    name = strdup(ptr+1);
	    *ptr = 0x00 ;

	    if ( strcmp(work,"MINE") == 0 )
	    {
		kind = 0 ;
		view->view[kensu].kind = kind ;
		view->view[kensu].title = strdup(name);
		view->view[kensu].kensu = 0 ;
		kensu ++;
	    }
	}
	fclose(fp);

	/*--- WORK ǡμ ---*/
	if ((fp = fopen( filename, "r" )) == NULL )
		return(1);
	while( fgets( buff, sizeof(buff), fp ) != 0 )
	{
	    if (( buff[0] == '#'  ) || ( buff[0] == '\n' )
	    ||  ( buff[0] == '\t' ) || ( buff[0] == ' '  ))
		continue ;

	    strcpy( work, buff );
	    if ((ptr = (char *)strrchr(work, '\n')) != (char *)NULL )
		*ptr = 0x00 ;

	    if ((ptr = (char *)strrchr(work, '\t')) == (char *)NULL )
		continue ;

	    name = strdup(ptr+1);
	    *ptr = 0x00 ;

	    if ( strcmp(work,"WORK") == 0 )
	    {
		kind = 1 ;
		view->view[kensu].kind = kind ;
		view->view[kensu].title = strdup(name);
		view->view[kensu].kensu = 0 ;
		kensu ++;
	    }
	}
	fclose(fp);

	/*--- TASTE ǡμ ---*/
	if ((fp = fopen( filename, "r" )) == NULL )
		return(1);
	while( fgets( buff, sizeof(buff), fp ) != 0 )
	{
	    if (( buff[0] == '#'  ) || ( buff[0] == '\n' )
	    ||  ( buff[0] == '\t' ) || ( buff[0] == ' '  ))
		continue ;

	    strcpy( work, buff );
	    if ((ptr = (char *)strrchr(work, '\n')) != (char *)NULL )
		*ptr = 0x00 ;

	    if ((ptr = (char *)strrchr(work, '\t')) == (char *)NULL )
		continue ;

	    name = strdup(ptr+1);
	    *ptr = 0x00 ;

	    if ( strcmp(work,"TASTE") == 0 )
	    {
		kind = 2 ;
		view->view[kensu].kind = kind ;
		view->view[kensu].title = strdup(name);
		view->view[kensu].kensu = 0 ;
		kensu ++;
	    }
	}
	fclose(fp);

	/*--- PLAY ǡμ ---*/
	if ((fp = fopen( filename, "r" )) == NULL )
		return(1);
	while( fgets( buff, sizeof(buff), fp ) != 0 )
	{
	    if (( buff[0] == '#'  ) || ( buff[0] == '\n' )
	    ||  ( buff[0] == '\t' ) || ( buff[0] == ' '  ))
		continue ;

	    strcpy( work, buff );
	    if ((ptr = (char *)strrchr(work, '\n')) != (char *)NULL )
		*ptr = 0x00 ;

	    if ((ptr = (char *)strrchr(work, '\t')) == (char *)NULL )
		continue ;

	    name = strdup(ptr+1);
	    *ptr = 0x00 ;

	    if ( strcmp(work,"PLAY") == 0 )
	    {
		kind = 3 ;
		view->view[kensu].kind = kind ;
		view->view[kensu].title = strdup(name);
		view->view[kensu].kensu = 0 ;
		kensu ++;
	    }
	}
	fclose(fp);

	/*--- OTHER ǡμ ---*/
	if ((fp = fopen( filename, "r" )) == NULL )
		return(1);
	while( fgets( buff, sizeof(buff), fp ) != 0 )
	{
	    if (( buff[0] == '#'  ) || ( buff[0] == '\n' )
	    ||  ( buff[0] == '\t' ) || ( buff[0] == ' '  ))
		continue ;

	    strcpy( work, buff );
	    if ((ptr = (char *)strrchr(work, '\n')) != (char *)NULL )
		*ptr = 0x00 ;

	    if ((ptr = (char *)strrchr(work, '\t')) == (char *)NULL )
		continue ;

	    name = strdup(ptr+1);
	    *ptr = 0x00 ;

	    if ( strcmp(work,"OTHER") == 0 )
	    {
		kind = 4 ;
		view->view[kensu].kind = kind ;
		view->view[kensu].title = strdup(name);
		view->view[kensu].kensu = 0 ;
		kensu ++;
	    }
	}
	fclose(fp);

	view->kensu = kensu ;

	return(0);
}

/* ɽ̤¸ */
int setCalenDataView( ViewData *view )
{
	FILE	*fp ;
	char	buff[2048];
	char	filename[1024] ;
	int	i ;

	sprintf( filename, "%s/.cxp", (char*)getenv("HOME") );
	if ( access( filename, F_OK ) )
		mkdir ( filename, 0755 );

	sprintf( filename, "%s/.cxp/schedule", (char*)getenv("HOME") );
	if ( access( filename, F_OK ) )
		mkdir ( filename, 0755 );

	sprintf( filename, "%s/.cxp/schedule/view.dat", (char*)getenv("HOME") );

	if ( (fp = fopen( filename, "w" )) == NULL )
	{
		return(1);
	}

	fprintf(fp, "#\n");
	fprintf(fp, "# view.dat (Cxp Calen Schedule Info Data)\n");
	fprintf(fp, "# author konta (hatakeda@mbm.sphere.ne.jp)\n");
	fprintf(fp, "#\n");
	fprintf(fp, "\n");

	for(i=0;i<view->kensu;i++)
	{
		switch(view->view[i].kind)
		{
		default :
		case 0 : fprintf(fp, "%s\t", "MINE"  ); break ;
		case 1 : fprintf(fp, "%s\t", "WORK"  ); break ;
		case 2 : fprintf(fp, "%s\t", "TASTE" ); break ;
		case 3 : fprintf(fp, "%s\t", "PLAY"  ); break ;
		case 4 : fprintf(fp, "%s\t", "OTHER" ); break ;
		}
		fprintf(fp, "%s\n", view->view[i].title );
	}

	fclose(fp);

}

/* 塼 */
int getCalenDataSchedule( int year, ViewDataItem *viewi, Year *scd )
{
	FILE		*fp ;
	char		kindbuff[256];
	char		buff[2048] ;
	char		filename[1024] ;
	int		kensu ;
	int		kind ;
	ScduInfo	sinfo ;
	int		m,d,k,l;
	int		status ;

	memset( scd, 0x00, sizeof(Year) );

	switch( viewi->kind )
	{
		default :
		case 0 :
			sprintf( kindbuff, "mine" );
			break ;
		case 1 :
			sprintf( kindbuff, "work" );
			break ;
		case 2 :
			sprintf( kindbuff, "taste" );
			break ;
		case 3 :
			sprintf( kindbuff, "play" );
			break ;
		case 4 :
			sprintf( kindbuff, "other" );
			break ;
	}

	sprintf( filename, "%s/.cxp/schedule/%s/%s/%04d.dat",
			(char*)getenv("HOME"),
			kindbuff,
			viewi->title,
			year );
	if ( access( filename, F_OK ) )
	{
#ifdef	DEBUG9
fprintf(stdout,"ե뤬¸ߤʤ [%s]\n", filename );
#endif
		return(1);
	}

	if ((fp = fopen( filename, "r" )) == NULL )
	{
#ifdef	DEBUG9
fprintf(stdout,"ե򥪡ץǤʤ [%s]\n", filename );
#endif
		return(1);
	}

	kensu = 0 ;
	while( fgets( buff, sizeof(buff), fp ) != 0 )
	{
	    if (( buff[0] == '#'  ) || ( buff[0] == '\n' )
	    ||  ( buff[0] == '\t' ) || ( buff[0] == ' '  ))
		continue ;

	    if ( strmatch( "*/*:*/*/*:*", buff ) == 0 )
	    {
#ifdef	DEBUG9
fprintf(stdout,"DATA |%s", buff );
#endif
		memset( &sinfo, 0x00, sizeof(ScduInfo));
		status = getScdItem( buff, &sinfo );

#ifdef	DEBUG9
fprintf(stdout,"status => %d\n", status );
#endif
		if ( status == 0 )
		{
			kensu++;

			m = sinfo.month - 1;
			d = sinfo.day   - 1;
			k = scd->month[m].day[d].kensu ;
			scd->month[m].day[d].info[k].month  = sinfo.month ;
			scd->month[m].day[d].info[k].day    = sinfo.day ;
			scd->month[m].day[d].info[k].hour   = sinfo.hour ;
			scd->month[m].day[d].info[k].min    = sinfo.min ;
			scd->month[m].day[d].info[k].level  = sinfo.level ;
			scd->month[m].day[d].info[k].length = sinfo.length ;
			scd->month[m].day[d].info[k].title  = strdup(sinfo.title);
			memcpy(&scd->month[m].day[d].info[k].alarm,
						&sinfo.alarm,sizeof(AlarmInfo));
			scd->month[m].day[d].info[k].data = malloc(sinfo.length + 1);
			if ( scd->month[m].day[d].info[k].data == (char *)NULL )
			{
				scd->month[m].day[d].kensu ++;
				continue ;
			}

			memset(scd->month[m].day[d].info[k].data,0x00,sinfo.length+1);
			fread( scd->month[m].day[d].info[k].data, sinfo.length,1,fp);
			scd->month[m].day[d].kensu ++;
			continue ;
		}
	    }
#ifdef	DEBUG9
	    else{
fprintf(stdout,"error buff |%s", buff );
	    }
#endif
	}

	viewi->kensu = kensu ;

	fclose(fp);

	/* ɤ߹ǡƷ,ǻ,ʬǥȤ */
	sortScheduleData( scd );

	return(0);
}

/* 塼¸ */
int setCalenDataSchedule( int year, ViewDataItem *viewi, Year *scd )
{
	FILE	*fp ;
	char	kindbuff[256];
	char	buff[2048];
	char	filename[1024] ;
	int	m,d,i,k ;

	switch( viewi->kind )
	{
		default :
		case 0 :
			sprintf( kindbuff, "mine" );
			break ;
		case 1 :
			sprintf( kindbuff, "work" );
			break ;
		case 2 :
			sprintf( kindbuff, "taste" );
			break ;
		case 3 :
			sprintf( kindbuff, "play" );
			break ;
		case 4 :
			sprintf( kindbuff, "other" );
			break ;
	}

	sprintf( filename, "%s/.cxp", (char*)getenv("HOME") );
	if ( access( filename, F_OK ) )
		mkdir ( filename, 0755 );

	sprintf( filename, "%s/.cxp/schedule", (char*)getenv("HOME") );
	if ( access( filename, F_OK ) )
		mkdir ( filename, 0755 );

	sprintf( filename, "%s/.cxp/schedule/%s",
			(char*)getenv("HOME"),
			kindbuff );
	if ( access( filename, F_OK ) )
		mkdir ( filename, 0755 );

	sprintf( filename, "%s/.cxp/schedule/%s/%s",
			(char*)getenv("HOME"),
			kindbuff,
			viewi->title );
	if ( access( filename, F_OK ) )
		mkdir ( filename, 0755 );

	sprintf( filename, "%s/.cxp/schedule/%s/%s/%04d.dat",
			(char*)getenv("HOME"),
			kindbuff,
			viewi->title,
			year );

#ifdef	DEBUG9
fprintf(stdout,"setCalenDataSchedule year -> %d\n",year );
fprintf(stdout,"setCalenDataSchedule kindbuff -> [%s]\n",kindbuff );
fprintf(stdout,"setCalenDataSchedule viewi->title -> [%s]\n",viewi->title );
fprintf(stdout,"setCalenDataSchedule filename -> [%s]\n",filename );
#endif

	if ( (fp = fopen( filename, "w" )) == NULL )
	{
		return(1);
	}

	fprintf(fp, "#\n");
	fprintf(fp, "# %s/%02d.dat (Cxp Calen Schedule Data)\n", viewi->title, year);
	fprintf(fp, "# author konta (hatakeda@mbm.sphere.ne.jp)\n");
	fprintf(fp, "#\n");
	fprintf(fp, "\n");

	/* ¸˥Ȥ */
	sortScheduleData( scd );

	for(m=0;m<MAX_CALEN_MONTH;m++)
	for(d=0;d<MAX_CALEN_DAY;d++)
	{
	    for(i=0;i<scd->month[m].day[d].kensu;i++)
	    {
		fprintf(fp,"%02d/",  scd->month[m].day[d].info[i].month );
		fprintf(fp,"%02d\t", scd->month[m].day[d].info[i].day );
		fprintf(fp,"%02d:",  scd->month[m].day[d].info[i].hour );
		fprintf(fp,"%02d\t", scd->month[m].day[d].info[i].min );
		fprintf(fp,"%d\t",   scd->month[m].day[d].info[i].level );
		fprintf(fp,"%s\t",   scd->month[m].day[d].info[i].title );
		fprintf(fp,"%d\t",   scd->month[m].day[d].info[i].length );
		switch( scd->month[m].day[d].info[i].alarm.mode )
		{
		default :
		case 0 : fprintf(fp,"%s\t", "OFF" ); break ;
		case 1 : fprintf(fp,"%s\t", "ON" ); break ;
		}
		fprintf(fp,"%04d/",  scd->month[m].day[d].info[i].alarm.year );
		fprintf(fp,"%02d/",  scd->month[m].day[d].info[i].alarm.month );
		fprintf(fp,"%02d\t", scd->month[m].day[d].info[i].alarm.day );
		fprintf(fp,"%02d:",  scd->month[m].day[d].info[i].alarm.hour );
		fprintf(fp,"%02d\n", scd->month[m].day[d].info[i].alarm.min );
		if (( scd->month[m].day[d].info[i].length > 0 )
		&&  ( scd->month[m].day[d].info[i].data != (char *)NULL ))
			fprintf(fp,"%s\n",   scd->month[m].day[d].info[i].data );
	    }
	}


	fclose(fp);

	return(0);
}

static void quicksort_scd ( Day *dat, int first, int last )
{
	int	i, j ;
	ScduInfo x, t ;

	memcpy( &x, &dat->info[(first + last)/2], sizeof(ScduInfo) );

	i = first ;
	j = last ;
	for(;;)
	{
	    while( (dat->info[i].hour * 60 + dat->info[i].min) < (x.hour * 60 + x.min) ) i++;
	    while( (x.hour * 60 + x.min) < (dat->info[j].hour * 60 + dat->info[j].min) ) j--;
	    if ( i >= j ) break ;
	    memcpy( &t, &dat->info[i], sizeof(ScduInfo) );
	    memcpy( &dat->info[i], &dat->info[j], sizeof(ScduInfo) );
	    memcpy( &dat->info[j], &t, sizeof(ScduInfo) );
            i++;
            j--;
        }

        if ( first < i - 1 ) quicksort_scd( dat, first, i - 1 );
        if ( j + 1 < last  ) quicksort_scd( dat, j + 1, last );
}

static int sortScheduleData( Year *scd )
{
    int m, d ;

    for(m=0;m<MAX_CALEN_MONTH;m++)
    {
	for(d=0;d<MAX_CALEN_DAY;d++)
	{
	    if ( scd->month[m].day[d].kensu > 1 )
	    {
		quicksort_scd( &scd->month[m].day[d], 0, scd->month[m].day[d].kensu -1 );
	    }
	}
    }
}
