/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

static int _getSystemInfomation( SysInfo *, char *fname ) ;

/* ƥ */
int getSystemInfomation( info )
SysInfo	*info ;
{
    system("dmesg > /tmp/.cxpdmesg");
    _getSystemInfomation( info, "/tmp/.cxpdmesg" ) ;
    remove("/tmp/.cxpdmesg");

    if ( strcmp( info->ver, "Unknown" ) == 0 )
    {
        _getSystemInfomation( info, "/var/log/dmesg" ) ;
    }
}

static int _getSystemInfomation( info, fname )
SysInfo	*info ;
char	*fname ;
{
    FILE *fp ;
    char buff[1024] ;
    char *ptr, *ptr2 ;
    int  i ;

    if ( (fp = fopen( fname, "r" )) == NULL )
        exit(0);

    info->ver = (char *)g_strdup("Unknown");
    info->mem = (char *)g_strdup("Unknown");
    info->count  = 0 ;
    info->dcount = 0 ;
    info->ccount = 0 ;
    info->fcount = 0 ;
    info->scount = 0 ;
    info->ecount = 0 ;
    info->tcount = 0 ;
    info->pcount = 0 ;

    while( fgets( buff, sizeof(buff), fp) != 0)
    {
	if ( strmatch("Linux version *", buff ) == 0 )
	{
	    ptr  = nstrchr( buff, ' ',2 ) ;
	    ptr2 = nstrchr( ptr+1, ' ',1 ) ;
	    *ptr2 = 0x00 ;

	    info->ver = (char *)strdup( buff ) ;
	}
	if ( strmatch("CPU: *", buff ) == 0 )
	{
	    ptr = (char *)strchr( buff, ' ' ) ;
	    info->cpu[info->count] = (char *)strdup( ptr+1 ) ;
	    info->count++;
	}
	if ( strmatch("Memory: *", buff ) == 0 )
	{
	    ptr = (char *)strchr( buff, '/' ) ;
	    ptr2 = (char *)strchr(ptr,' ');
	    *ptr2 = 0x00 ;
	    info->mem = (char *)strdup( ptr+1 ) ;
	}
	if ( strmatch("*: *DISK drive*", buff ) == 0 )
	{
	    info->disk[info->dcount] = (char *)strdup( buff ) ;
	    info->dcount ++;
	}
	if ( strmatch("*: *CDROM drive*", buff ) == 0 )
	{
	    info->cdrom[info->ccount] = (char *)strdup( buff ) ;
	    info->ccount ++;
	}
	if ( strmatch("Floppy *:*", buff ) == 0 )
	{
	    info->floppy[info->fcount] = (char *)strdup( buff ) ;
	    info->fcount ++;
	}
	if ( strmatch("(scsi*)*<*>*found*", buff ) == 0 )
	{
	    ptr  = (char *)strchr( buff, '<' ) ;
	    ptr2 = (char *)strchr( buff, '>' ) ;
	    *ptr2 = ' ';
	    info->scsi[info->scount] = (char *)strdup( ptr+1 ) ;
	    info->scount ++;
	}
	if ( strmatch("eth*", buff ) == 0 )
	{
	    info->eth[info->ecount] = (char *)strdup( buff ) ;
	    info->ecount ++;
	}
	if ( strmatch("tty*", buff ) == 0 )
	{
	    info->ttys[info->tcount] = (char *)strdup( buff ) ;
	    info->tcount ++;
	}
	if ( strmatch("lp?:*", buff ) == 0 )
	{
	    info->pararel[info->pcount] = (char *)strdup( buff ) ;
	    info->pcount ++;
	}
    }

    fclose( fp );

    convchar( info->ver, '\n', 0x00 ) ;
    for(i=0;i<info->count;i++)
        convchar( info->cpu[i], '\n', 0x00 ) ;
    convchar( info->mem, '\n', 0x00 ) ;
    for(i=0;i<info->dcount;i++)
    	convchar( info->disk[i], '\n', 0x00 ) ;
    for(i=0;i<info->ccount;i++)
    	convchar( info->cdrom[i], '\n', 0x00 ) ;
    for(i=0;i<info->fcount;i++)
    	convchar( info->floppy[i], '\n', 0x00 ) ;
    for(i=0;i<info->scount;i++)
    	convchar( info->scsi[i], '\n', 0x00 ) ;
    for(i=0;i<info->ecount;i++)
    	convchar( info->eth[i], '\n', 0x00 ) ;
    for(i=0;i<info->tcount;i++)
    	convchar( info->ttys[i], '\n', 0x00 ) ;
    for(i=0;i<info->pcount;i++)
    	convchar( info->pararel[i], '\n', 0x00 ) ;

   return(0);
}
