/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"

int common_copy( char *src, char *dst )
{
    FILE *fpi ;
    FILE *fpo ;
    char buff[1024] ;
    int ss, recvsize ;

#ifdef DEBUG
fprintf(stdout,"filecopy src [%s]\n", src );
fprintf(stdout,"filecopy dst [%s]\n", dst );
#endif

    if ( (fpi = fopen( src, "rb" )) == NULL ) {
#ifdef DEBUG
fprintf(stdout,"filecopy src open error\n" );
#endif
	return(-1);
    }
    if ( (fpo = fopen( dst, "wb" )) == NULL ) {
#ifdef DEBUG
fprintf(stdout,"filecopy dst open error\n" );
#endif
	fclose(fpi);
	return(-1);
    }

    recvsize = 0 ;
    while( 1 )
    {
	ss = fread( &buff, 1, sizeof(buff), fpi );
	if ( ss <= 0 )
	    break ;

	recvsize += ss ;
	fwrite( buff, ss, 1, fpo );
    }

#ifdef DEBUG
fprintf(stdout,"filecopy finish!! size (%d)\n", recvsize );
#endif

    fclose(fpi);
    fclose(fpo);
    return(0);
}
