/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"

static GtkWidget *sizeWindow;
static GtkWidget *sizeRadioBtn1;
static GtkWidget *sizeRadioBtn2;
static GtkWidget *sizeRadioBtn3;
static GtkWidget *widthEntry;
static GtkWidget *heightEntry;
static GtkWidget *viewRadioBtn1;
static GtkWidget *viewRadioBtn2;
static GtkWidget *viewRadioBtn3;
static GtkWidget *XEntry;
static GtkWidget *YEntry;
static GtkWidget *setBtn;
static GtkWidget *canBtn;
static int       saveMode ;

static int saveWinSizeRadioFunc( GtkWidget *widget, GtkWidget *radioBtn )
{
	;
}

static int saveWinViewRadioFunc( GtkWidget *widget, GtkWidget *radioBtn )
{
	;
}

static int saveWinSetFunc( GtkWidget *widget, GtkWidget *win )
{
    int xymode, whmode ;
    int x,y,w,h ;
    char *widthPtr, *heightPtr ;
    char *xPtr, *yPtr ;

    getGeometryInfo( saveMode, &xymode, &whmode, &x, &y, &w, &h );

    if ( GTK_TOGGLE_BUTTON(sizeRadioBtn1)->active )
	whmode = 0 ;
    else
    if ( GTK_TOGGLE_BUTTON(sizeRadioBtn2)->active )
	whmode = 1 ;
    else
    if ( GTK_TOGGLE_BUTTON(sizeRadioBtn3)->active )
	whmode = 2 ;

    if ( GTK_TOGGLE_BUTTON(viewRadioBtn1)->active )
	xymode = 0 ;
    else
    if ( GTK_TOGGLE_BUTTON(viewRadioBtn2)->active )
	xymode = 1 ;
    else
    if ( GTK_TOGGLE_BUTTON(viewRadioBtn3)->active )
	xymode = 2 ;


    /* XY֤WH */
    widthPtr = gtk_entry_get_text(GTK_ENTRY(widthEntry));
    heightPtr = gtk_entry_get_text(GTK_ENTRY(heightEntry));
    xPtr = gtk_entry_get_text(GTK_ENTRY(XEntry));
    yPtr = gtk_entry_get_text(GTK_ENTRY(YEntry));

    if ( whmode == 1 )
    {
	if ((widthPtr  == (char *)NULL || strlen(widthPtr) <= 0 )
	||  (heightPtr == (char *)NULL || strlen(heightPtr) <= 0 ))
	{
	    create_messageWin( 
			sizeWindow,
			"ꥵξˤϥϤƲ" );
	    return(0);
	}

	w = atoi(widthPtr);
	h = atoi(heightPtr);
    }

    if ( xymode == 1 )
    {
	if ((xPtr == (char *)NULL || strlen(xPtr) <= 0 )
	||  (yPtr == (char *)NULL || strlen(yPtr) <= 0 ))
	{
	    create_messageWin( 
			sizeWindow,
			"֤ξˤϰ֤ϤƲ");
	    return(0);
	}

	x = atoi(xPtr);
	y = atoi(yPtr);
    }

    setGeometryInfo( saveMode, xymode, whmode, x, y, w, h );

    gtk_widget_destroy(win);
}

static int saveWinCanFunc( GtkWidget *widget, GtkWidget *win )
{
    gtk_widget_destroy(win);
}

int create_sizeSettingWindow ( int mode )
{
  GtkWidget *vbox1;
  GtkWidget *hbox1;
  GtkWidget *label1;
  GSList *hbox1_group = NULL;
  GtkWidget *hbox2;
  GtkWidget *label2;
  GtkWidget *label3;
  GtkWidget *hbox3;
  GtkWidget *label4;
  GtkWidget *label5;
  GtkWidget *hbox4;
  GtkWidget *label6;
  GSList *hbox4_group = NULL;
  GtkWidget *hbox5;
  GtkWidget *label7;
  GtkWidget *label9;
  GtkWidget *hbox6;
  GtkWidget *label8;
  GtkWidget *label10;
  GtkWidget *hbox7;
  GtkWidget *hseparator1;
  GtkWidget *hbox8;
  int       x,y,w,h;
  int       sx,sy,sw,sh;
  int       xymode, whmode ;
  char      widthString[32] ;
  char      heightString[32] ;
  char      xString[32] ;
  char      yString[32] ;


  w = gdk_screen_width();
  h = gdk_screen_height();
  x = w * 0.5;
  y = h * 0.5;

  /* ¸̤ */
  saveMode = mode ;

  sizeWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (sizeWindow), "sizeWindow", sizeWindow);
  gtk_widget_set_usize (sizeWindow, 400, 260);
  gtk_window_set_title (GTK_WINDOW (sizeWindow), "ܥ");
  gtk_widget_set_uposition(sizeWindow, (x - 400*0.5), (y - 260*0.5) );
  gtk_widget_show (sizeWindow);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (sizeWindow), vbox1);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 10);

  label1 = gtk_label_new ("ܥ");
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE, FALSE, 10);

  sizeRadioBtn1 = gtk_radio_button_new_with_label (hbox1_group, "Υ");
  hbox1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (sizeRadioBtn1));
  gtk_widget_ref (sizeRadioBtn1);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "sizeRadioBtn1", sizeRadioBtn1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sizeRadioBtn1);
  gtk_box_pack_start (GTK_BOX (hbox1), sizeRadioBtn1, FALSE, FALSE, 2);

  sizeRadioBtn2 = gtk_radio_button_new_with_label (hbox1_group, "ꥵ");
  hbox1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (sizeRadioBtn2));
  gtk_widget_ref (sizeRadioBtn2);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "sizeRadioBtn2", sizeRadioBtn2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sizeRadioBtn2);
  gtk_box_pack_start (GTK_BOX (hbox1), sizeRadioBtn2, FALSE, FALSE, 2);

  sizeRadioBtn3 = gtk_radio_button_new_with_label (hbox1_group, "⤷ʤ");
  hbox1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (sizeRadioBtn3));
  gtk_widget_ref (sizeRadioBtn3);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "sizeRadioBtn3", sizeRadioBtn3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sizeRadioBtn3);
  gtk_box_pack_start (GTK_BOX (hbox1), sizeRadioBtn3, FALSE, FALSE, 2);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, TRUE, 5);

  label2 = gtk_label_new ("");
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (hbox2), label2, FALSE, FALSE, 10);

  label3 = gtk_label_new ("Υϡ");
  gtk_widget_ref (label3);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "label3", label3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (hbox2), label3, FALSE, FALSE, 10);

  widthEntry = gtk_entry_new ();
  gtk_widget_ref (widthEntry);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "widthEntry", widthEntry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (widthEntry);
  gtk_box_pack_start (GTK_BOX (hbox2), widthEntry, TRUE, TRUE, 10);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox3);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "hbox3", hbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, TRUE, 5);

  label4 = gtk_label_new ("");
  gtk_widget_ref (label4);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "label4", label4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label4);
  gtk_box_pack_start (GTK_BOX (hbox3), label4, FALSE, FALSE, 10);

  label5 = gtk_label_new ("Υϡ");
  gtk_widget_ref (label5);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "label5", label5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label5);
  gtk_box_pack_start (GTK_BOX (hbox3), label5, FALSE, FALSE, 10);

  heightEntry = gtk_entry_new ();
  gtk_widget_ref (heightEntry);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "heightEntry", heightEntry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (heightEntry);
  gtk_box_pack_start (GTK_BOX (hbox3), heightEntry, TRUE, TRUE, 10);

  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox4);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "hbox4", hbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox4, FALSE, TRUE, 10);

  label6 = gtk_label_new ("ɽ֡");
  gtk_widget_ref (label6);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "label6", label6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label6);
  gtk_box_pack_start (GTK_BOX (hbox4), label6, FALSE, FALSE, 10);

  viewRadioBtn1 = gtk_radio_button_new_with_label (hbox4_group, "ΰ");
  hbox4_group = gtk_radio_button_group (GTK_RADIO_BUTTON (viewRadioBtn1));
  gtk_widget_ref (viewRadioBtn1);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "viewRadioBtn1", viewRadioBtn1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (viewRadioBtn1);
  gtk_box_pack_start (GTK_BOX (hbox4), viewRadioBtn1, FALSE, FALSE, 2);

  viewRadioBtn2 = gtk_radio_button_new_with_label (hbox4_group, "");
  hbox4_group = gtk_radio_button_group (GTK_RADIO_BUTTON (viewRadioBtn2));
  gtk_widget_ref (viewRadioBtn2);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "viewRadioBtn2", viewRadioBtn2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (viewRadioBtn2);
  gtk_box_pack_start (GTK_BOX (hbox4), viewRadioBtn2, FALSE, FALSE, 2);

  viewRadioBtn3 = gtk_radio_button_new_with_label (hbox4_group, "⤷ʤ");
  hbox4_group = gtk_radio_button_group (GTK_RADIO_BUTTON (viewRadioBtn3));
  gtk_widget_ref (viewRadioBtn3);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "viewRadioBtn3", viewRadioBtn3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (viewRadioBtn3);
  gtk_box_pack_start (GTK_BOX (hbox4), viewRadioBtn3, FALSE, FALSE, 2);

  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox5);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "hbox5", hbox5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox5, FALSE, TRUE, 5);

  label7 = gtk_label_new ("");
  gtk_widget_ref (label7);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "label7", label7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label7);
  gtk_box_pack_start (GTK_BOX (hbox5), label7, FALSE, FALSE, 10);

  label9 = gtk_label_new ("غɸΰ֤ϡ");
  gtk_widget_ref (label9);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "label9", label9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label9);
  gtk_box_pack_start (GTK_BOX (hbox5), label9, FALSE, FALSE, 10);

  XEntry = gtk_entry_new ();
  gtk_widget_ref (XEntry);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "XEntry", XEntry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (XEntry);
  gtk_box_pack_start (GTK_BOX (hbox5), XEntry, TRUE, TRUE, 10);

  hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox6);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "hbox6", hbox6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox6);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox6, FALSE, TRUE, 5);

  label8 = gtk_label_new ("");
  gtk_widget_ref (label8);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "label8", label8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label8);
  gtk_box_pack_start (GTK_BOX (hbox6), label8, FALSE, FALSE, 10);

  label10 = gtk_label_new ("ٺɸΰ֤ϡ");
  gtk_widget_ref (label10);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "label10", label10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label10);
  gtk_box_pack_start (GTK_BOX (hbox6), label10, FALSE, FALSE, 10);

  YEntry = gtk_entry_new ();
  gtk_widget_ref (YEntry);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "YEntry", YEntry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (YEntry);
  gtk_box_pack_start (GTK_BOX (hbox6), YEntry, TRUE, TRUE, 10);

  hbox7 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox7);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "hbox7", hbox7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox7);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox7, FALSE, TRUE, 3);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator1);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "hseparator1", hseparator1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (hbox7), hseparator1, TRUE, TRUE, 0);

  hbox8 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox8);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "hbox8", hbox8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox8);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox8, FALSE, TRUE, 5);

  setBtn = gtk_button_new_with_label ("  ");
  gtk_widget_ref (setBtn);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "setBtn", setBtn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (setBtn);
  gtk_box_pack_start (GTK_BOX (hbox8), setBtn, FALSE, FALSE, 0);

  canBtn = gtk_button_new_with_label ("  ");
  gtk_widget_ref (canBtn);
  gtk_object_set_data_full (GTK_OBJECT (sizeWindow), "canBtn", canBtn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (canBtn);
  gtk_box_pack_start (GTK_BOX (hbox8), canBtn, FALSE, FALSE, 0);


  /* ߤξ */
  getGeometryInfo( saveMode, &xymode, &whmode, &sx, &sy, &sw, &sh );

  switch( whmode )
  {
    default :
    case 0 :
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sizeRadioBtn1), TRUE);
	break ;
    case 1 :
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sizeRadioBtn2), TRUE);
	break ;
    case 2 :
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sizeRadioBtn3), TRUE);
	break ;
  }

  switch( xymode )
  {
    default :
    case 0 :
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (viewRadioBtn1), TRUE);
	break ;
    case 1 :
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (viewRadioBtn2), TRUE);
	break ;
    case 2 :
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (viewRadioBtn3), TRUE);
	break ;
  }

  sprintf( widthString,  "%d", sw );
  sprintf( heightString, "%d", sh );
  sprintf( xString,      "%d", sx );
  sprintf( yString,      "%d", sy );

  gtk_entry_set_text (GTK_ENTRY (widthEntry),  widthString );
  gtk_entry_set_text (GTK_ENTRY (heightEntry), heightString );
  gtk_entry_set_text (GTK_ENTRY (XEntry),      xString );
  gtk_entry_set_text (GTK_ENTRY (YEntry),      yString );


#if 0
  /* ɽХå */
  gtk_signal_connect (GTK_OBJECT (sizeRadioBtn1), "activate",
	(GtkSignalFunc)saveWinSizeRadioFunc, sizeRadioBtn1 );
  gtk_signal_connect (GTK_OBJECT (sizeRadioBtn2), "activate",
	(GtkSignalFunc)saveWinSizeRadioFunc, sizeRadioBtn2 );
  gtk_signal_connect (GTK_OBJECT (sizeRadioBtn3), "activate",
	(GtkSignalFunc)saveWinSizeRadioFunc, sizeRadioBtn3 );

  /* ɽ֥Хå */
  gtk_signal_connect (GTK_OBJECT (viewRadioBtn1), "activate",
	(GtkSignalFunc)saveWinViewRadioFunc, sizeRadioBtn1 );
  gtk_signal_connect (GTK_OBJECT (viewRadioBtn2), "activate",
	(GtkSignalFunc)saveWinViewRadioFunc, sizeRadioBtn2 );
  gtk_signal_connect (GTK_OBJECT (viewRadioBtn3), "activate",
	(GtkSignalFunc)saveWinViewRadioFunc, sizeRadioBtn3 );
#endif

  /* ꥳХå */
  gtk_signal_connect (GTK_OBJECT (setBtn), "clicked",
	(GtkSignalFunc) saveWinSetFunc, sizeWindow );

  /* åХå */
  gtk_signal_connect (GTK_OBJECT (canBtn), "clicked",
	(GtkSignalFunc) saveWinCanFunc, sizeWindow );

}
