/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"

int	strmatch ( p1, p2 )
char	*p1;
char	*p2;
{
	int	status;

	for(;;)
	{
	    if (*p1 == '*')			/* 磻(*)ʸ        */
	    {					/* Yes,磻(*)ʸ      */
		for(p1++; (*p1)=='*'; p1++);	/*   Ϣ³磻(*)̵  */
		status = 1;			/*   ơϰ۾   */
		for(				/*   ʸʤʤޤ     */
		    ; (*p2)!=0x00; p2++)
		{				/*                          */
		    status = strmatch( p1,p2 );	/*     ʸʹߤå */
		    if (!status)		/*     ơʤ */
			return(0);		/*       ơ֤   */
		}				/*                          */
		if ((*p1) == 0x00)		/*   åʸʤ */
		    status = 0;			/*     ơ     */
		return(status);			/*   ơ֤       */
	    }else				/* No,磻(*)ʸǤʤ */
	    if ((*p1 == '?')||(*p1 == *p2))	/* ʸϰפ뤫       */
	    {					/* Yes,פ             */
		p1++;				/*   ʸå         */
		p2++;				/*   ʸå         */
	    }else				/* No,פʤ            */
		return(1);			/*    ơ۾֤  */

	    if ((*p1 == 0x00) && (*p2 == 0x00))	/* ʸʤ   */
		return(0);			/*   ơ֤   */
	}
}

int	convchar( p1, s1, s2 )
char	*p1;
char	s1;
char	s2;
{
	int	status;

	status = 0;				/* ơ̵ִ */
	for( ; *(p1) != 0x00; p1++ )		/* ʸ󤬤ʤʤޤ     */
	{					/*                          */
	    if (*p1 == s1)			/*   ʸϰפ뤫     */
	    {					/*   Yes,פ           */
		*p1 = s2;			/*     ʸִ   */
		status = 1;			/*     ơִͭ */
	    }					/*                          */
	}					/*                          */
	return(status);				/* ơ֤         */
}

int	spaceclear( p1 )
char	*p1;
{
	int	status;
	char	*p;

	status = 0;				/* ơѴ̵ */
	p = p1;					/* ʸƬݥ󥿤ʣ */

	for(;*(p+1) != 0x00; p++)		/* ʸ󤬤ʤʤޤ     */
	{					/*                          */
	    if (memcmp(p,"  ",2) == 0)		/*   Ϣ³ڡͭꡩ   */
	    {					/*   Yes,ͭ               */
		char	*_p;			/*                          */
		for(_p=p;*(_p)!=0x00;_p++)	/*     ʸʤʤޤ   */
		    *(_p) = *(_p+1);		/*       ʸذư   */
		if (memcmp(p,"  ",2) == 0)	/*     ʸϢ³ڡ */
		    p--;			/*       ʸذư       */
		status = 1;			/*     ơѴͭ */
	    }					/*                          */
	}					/*                          */
	if (*(p-1)==' ')			/* ʸκǸϥڡ */
	{					/* Yes,Ǹϥڡ       */
	    *(p-1) = 0x00;			/*   Σգ̣̤         */
	}					/*                          */
	p = p1;					/* ʸƬݥ󥿤ʣ */
	if (*(p)==' ')				/* ʸγϤϥڡ */
	{					/* Yes,Ϥϥڡ       */
	    for(;*(p)!=0x00;p++)		/*   ʸʤʤޤ     */
		*(p) = *(p+1);			/*     ʸذư     */
	}					/*                          */
	return(status);				/* ơ֤         */
}

char	*nstrchr( p1,s1,n1 )
char	*p1;
char	s1;
int	n1;
{
	int	i;

	for(i=1; *(p1) != 0x00; p1++ )		/* ʸ󤬤ʤʤޤ     */
	{					/*                          */
	    if (*p1 == s1)			/*   ʸϰפ뤫     */
	    {					/*   Yes,פ           */
		if (n1 == i)			/*	꤫        */
		    return( (char *)p1 );	/*        ɥ쥹֤    */
		else				/*      Ǥʤ      */
		    i++;			/*        ꥻå  */
	    }					/*                          */
	}					/*                          */
	return( (char *)0 );			/* Σգ̣̥ɥ쥹֤   */
}

char	*nstrrchr( p1,s1,n1 )
char	*p1;
char	s1;
int	n1;
{
	int	i;
	char	*_p;

	_p = (char *)p1;			/* Ƭɥ쥹ʣ       */
	p1+=strlen(p1);				/* ǽɥ쥹ذư       */

	for(i=1; p1 != _p; p1-- )		/* ʸ󤬤ʤʤޤ     */
	{					/*                          */
	    if (*p1 == s1)			/*   ʸϰפ뤫     */
	    {					/*   Yes,פ           */
		if (n1 == i)			/*	꤫        */
		    return( (char *)p1 );	/*        ɥ쥹֤    */
		else				/*      Ǥʤ      */
		    i++;			/*        ꥻå  */
	    }					/*                          */
	}					/*                          */
	return( (char *)0 );			/* Σգ̣̥ɥ쥹֤   */
}

char	*nstrpbrk( p1,p2,n1 )
char	*p1;
char	*p2;
int	*n1;
{
	int	i,j;


	for(i=1,j=1; *(p1) != 0x00; i++,j++ )	/* ʸ󤬤ʤʤޤ     */
	{					/*                          */
	    if (strlen(p2)<=j)			/*   ʸϽλ       */
	    {					/*                          */
		*n1 = i-j+1;			/*     פս   */
		return( (char *)(p1+i-j) );	/*     ɥ쥹֤       */
	    }					/*                          */
	    if (*(p1+i-1) != *(p2+j-1))		/*   ʸϰפʤ     */
		j = 0;				/*     󥿤     */
	}					/*                          */

	*n1 = 0;				/* ʤϣ       */
	return( (char *)0 );			/* Σգ̣̥ɥ쥹֤   */
}

int getStringData( char *buff, char *data, int size, char **set )
{
    char workbuff[1024] ;
    char *ptr ;

    if ( !strncmp( buff, data, size ) )
    {
        memset( workbuff, 0x00, sizeof(workbuff) );
        strncpy( workbuff, buff, strlen(buff) );
        ptr = strrchr ( workbuff, '\n' );
	if ( ptr != NULL )
	    *ptr = 0 ;
        ptr = &workbuff[size];
        (*set) = (char *)strdup( ptr );
    }
}
int getNumberData( char *buff, char *data, int size, int *set )
{
    char workbuff[1024] ;
    char *ptr ;

    if ( !strncmp( buff, data, size ) )
    {
        memset( workbuff, 0x00, sizeof(workbuff) );
        strncpy( workbuff, buff, strlen(buff) );
        ptr = strrchr ( workbuff, '\n' );
	if ( ptr != NULL )
	    *ptr = 0 ;
        ptr = &workbuff[size];
        (*set) = (int)atoi( ptr );
    }
}

int fgets_binary( char *buffer, int size, FILE *fp )
{
    char cc ;
    int  ss ;
    int  nn ;

    nn = 0 ;
    while(1)
    {
	ss = fread( &cc, sizeof(cc), 1, fp );
	if ( ss <= 0 )
	   break ;

	buffer[nn] = cc ;
	nn++;

	if (( cc == '\n' ) || ( cc == '\0' ) || ( nn >= size ))
	    break ;
    }

    if ( nn > 0 )
	return( nn );
    else
	return( 0 );
}

int fputs_binary( char *buffer, int size, FILE *fp )
{
    char *cc ;
    int  ss, sendsize ;

    sendsize ;
    cc = buffer ;
    while(1)
    {
	ss = fwrite( cc, sizeof(char), 1, fp );
	if (( *cc == '\n' ) || ( *cc == '\0' ))
	    break ;
	if ( sendsize + ss >= size )
	    break ;

	sendsize += ss ;

	cc++;
    }
}

int tabclear( char *src, int size, char *dst )
{
    int i, k ;

    k = 0 ;
    for(i=0;i<size;i++)
    {
	if ( *(src+i) != '\t' )
	{
	    *(dst+k) = *(src+i) ;
	    k++;
	}
    }
    *(dst+k) = (char)NULL ;

    return(k);
}

/*
 * "aaa;bbb;ccc;ddd"  -> 3
 * "aaa;bbb;ccc"      -> 2
 * "aaa;bbb"          -> 1
 * "aaa"              -> 0
 *
 */
int checkLimitCode ( char *src, int size, char code )
{
    int limit ;
    int i ;

    limit = 0 ;
    for(i=0;i<size;i++)
    {
	if ( *(src+i) == (char)code )
	    limit ++;
    }

    return(limit);
}

/*
 * "aaa;bbb;ccc;ddd", ';', 0  -> "aaa"
 * "aaa;bbb;ccc;ddd", ';', 1  -> "bbb"
 * "aaa;bbb;ccc;ddd", ';', 2  -> "ccc"
 * "aaa;bbb;ccc;ddd", ';', 3  -> "ddd"
 *
 * "aaa"            , ';', 0  -> "aaa"
 *
 */
int getLimitData ( char *src, int size, char code, int number, char *dst )
{
    int limit ;
    char buff[1024] ;
    char *ptr ;
    int i, k, special ;

    k = 0 ;
    special = 0 ;

    if ( number == 0 )
    {
	for(i=0;i<size;i++)
	{
	    if(( *(src+i) == (char)'\r' )
	    || ( *(src+i) == (char)'\n' )
	    || ( *(src+i) == (char)'\t' )
	    || ( *(src+i) == (char)'\0' ))
		break ;
	    if ( *(src+i) == (char)code )
		break ;

	    dst[k] = *(src+i);
	    k++;
	}
    }else{
	limit = 0 ;
	for(i=0;i<size;i++)
	{
	    if ( *(src+i) == (char)code )
	    {
		limit ++;
		if ( limit == number )
		    special = 1 ;
	    }else{
		if(( *(src+i) == (char)'\r' )
		|| ( *(src+i) == (char)'\n' )
		|| ( *(src+i) == (char)'\t' )
		|| ( *(src+i) == (char)'\0' ))
		    break ;

		if ( limit == (number+1) )
		    break ;

		if ( special == 1 )
		{
		    dst[k] = *(src+i);
		    k++;
		}
	    }
	}
    }

    return(0);
}
