/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

/*
 * Cxppanel Version Header
 *
 * version  date        log
 *  1.0.0   1999/09/28  first released.
 *  1.1.0   1999/11/11  button 3 click sub menu add.
 *                      double exec bug fix.
 *  1.1.1   2000/04/17  main exit code is ZERO add.
 *  1.1.2   2000/05/16  list style change.
 *  1.1.3   2000/06/21  dialog modal set .
 *  1.1.4   2000/08/01  cxpmanager start add.
 *  1.1.5   2000/08/01  model delete.
 *
 */

static char *Version   = "С 1.1.5 2000/09/07" ;
static char *Website   = "http://www1.sphere.ne.jp/hatakeda" ;
static char *Email     = "Ϣ衧 hatakeda@mbm.sphere.ne.jp" ;
static char *Copyright = "Copyright 1998-2000 Konta" ;
static char *Kakunin   = "Ĥ" ;

extern	CxpAddr    *cxpaddr;

void cxpaddrfilefunc_save()
{
    int status ;

    status = setAddressData( &(cxpaddr->addr_kensu), &(cxpaddr->addr) );

}
void cxpaddrfilefunc_add()
{
    cxpaddr_dialog (
		"ɥ쥹ɲ",
		"ɲá",
		"Ĥ롡",
		-1 );

}
void cxpaddrfilefunc_mod()
{
    if ( cxpaddr->selectrow >= 0 )
    {
	cxpaddr_dialog (
		"ɥ쥹ѹ",
		"ѹ",
		"Ĥ롡",
		cxpaddr->selectrow );
    }
}
void cxpaddrfilefunc_del()
{
    int i, k ;
    if ( cxpaddr->selectrow >= 0 )
    {
	for(i=cxpaddr->selectrow;i<cxpaddr->addr_kensu - 1;i++)
	{
	    cxpaddr->addr[i].name  = g_strdup( cxpaddr->addr[i+1].name );
	    cxpaddr->addr[i].kana  = g_strdup( cxpaddr->addr[i+1].kana );
	    cxpaddr->addr[i].job   = g_strdup( cxpaddr->addr[i+1].job );
	    cxpaddr->addr[i].jtel  = g_strdup( cxpaddr->addr[i+1].jtel );
	    cxpaddr->addr[i].sex   = g_strdup( cxpaddr->addr[i+1].sex );
	    cxpaddr->addr[i].birth = g_strdup( cxpaddr->addr[i+1].birth );
	    cxpaddr->addr[i].bload = g_strdup( cxpaddr->addr[i+1].bload );
	    cxpaddr->addr[i].ybin  = g_strdup( cxpaddr->addr[i+1].ybin );
	    cxpaddr->addr[i].addr  = g_strdup( cxpaddr->addr[i+1].addr );
	    cxpaddr->addr[i].tel   = g_strdup( cxpaddr->addr[i+1].tel );
	    cxpaddr->addr[i].fax   = g_strdup( cxpaddr->addr[i+1].fax );
	    cxpaddr->addr[i].email = g_strdup( cxpaddr->addr[i+1].email );
	    cxpaddr->addr[i].website = g_strdup( cxpaddr->addr[i+1].website );
	    cxpaddr->addr[i].comment = g_strdup( cxpaddr->addr[i+1].comment );
	}
	if ( cxpaddr->addr_kensu > 0 )
		cxpaddr->addr_kensu -- ;

	cxpaddr->addr[i].name  = g_strdup( "" );
	cxpaddr->addr[i].kana  = g_strdup( "" );
	cxpaddr->addr[i].job   = g_strdup( "" );
	cxpaddr->addr[i].jtel  = g_strdup( "" );
	cxpaddr->addr[i].sex   = g_strdup( "" );
	cxpaddr->addr[i].birth = g_strdup( "" );
	cxpaddr->addr[i].bload = g_strdup( "" );
	cxpaddr->addr[i].ybin  = g_strdup( "" );
	cxpaddr->addr[i].addr  = g_strdup( "" );
	cxpaddr->addr[i].tel   = g_strdup( "" );
	cxpaddr->addr[i].fax   = g_strdup( "" );
	cxpaddr->addr[i].email = g_strdup( "" );
	cxpaddr->addr[i].website = g_strdup( "" );
	cxpaddr->addr[i].comment = g_strdup( "" );

	cxpaddr->currentViewFlag = 1 ;
	cxpaddr_dataview();

    }
}
void cxpaddrfilefunc_close()
{
	gtk_main_quit();
}
void cxpaddreditfunc_copy()
{
    if ( cxpaddr->selectrow >= 0 )
    {
	cxpaddr->copyFlag = 1 ;
	cxpaddr->copyData.name  = g_strdup( cxpaddr->addr[cxpaddr->selectrow].name );
	cxpaddr->copyData.kana  = g_strdup( cxpaddr->addr[cxpaddr->selectrow].kana );
	cxpaddr->copyData.job   = g_strdup( cxpaddr->addr[cxpaddr->selectrow].job );
	cxpaddr->copyData.jtel  = g_strdup( cxpaddr->addr[cxpaddr->selectrow].jtel );
	cxpaddr->copyData.sex   = g_strdup( cxpaddr->addr[cxpaddr->selectrow].sex );
	cxpaddr->copyData.birth = g_strdup( cxpaddr->addr[cxpaddr->selectrow].birth );
	cxpaddr->copyData.bload = g_strdup( cxpaddr->addr[cxpaddr->selectrow].bload );
	cxpaddr->copyData.ybin  = g_strdup( cxpaddr->addr[cxpaddr->selectrow].ybin );
	cxpaddr->copyData.addr  = g_strdup( cxpaddr->addr[cxpaddr->selectrow].addr );
	cxpaddr->copyData.tel   = g_strdup( cxpaddr->addr[cxpaddr->selectrow].tel );
	cxpaddr->copyData.fax   = g_strdup( cxpaddr->addr[cxpaddr->selectrow].fax );
	cxpaddr->copyData.email = g_strdup( cxpaddr->addr[cxpaddr->selectrow].email );
	cxpaddr->copyData.website = g_strdup( cxpaddr->addr[cxpaddr->selectrow].website );
	cxpaddr->copyData.comment = g_strdup( cxpaddr->addr[cxpaddr->selectrow].comment );
    }else{
	cxpaddr->copyFlag = 0 ;
	cxpaddr->copyData.name  = g_strdup( "" );
	cxpaddr->copyData.kana  = g_strdup( "" );
	cxpaddr->copyData.job   = g_strdup( "" );
	cxpaddr->copyData.jtel  = g_strdup( "" );
	cxpaddr->copyData.sex   = g_strdup( "" );
	cxpaddr->copyData.birth = g_strdup( "" );
	cxpaddr->copyData.bload = g_strdup( "" );
	cxpaddr->copyData.ybin  = g_strdup( "" );
	cxpaddr->copyData.addr  = g_strdup( "" );
	cxpaddr->copyData.tel   = g_strdup( "" );
	cxpaddr->copyData.fax   = g_strdup( "" );
	cxpaddr->copyData.email = g_strdup( "" );
	cxpaddr->copyData.website = g_strdup( "" );
	cxpaddr->copyData.comment = g_strdup( "" );
    }
}
void cxpaddreditfunc_paste()
{
    char *setname[32] ;

    if ( cxpaddr->copyFlag == 1 )
    {
	cxpaddr->addr[cxpaddr->selectrow].name  = g_strdup( cxpaddr->copyData.name );
	cxpaddr->addr[cxpaddr->selectrow].kana  = g_strdup( cxpaddr->copyData.kana );
	cxpaddr->addr[cxpaddr->selectrow].job   = g_strdup( cxpaddr->copyData.job );
	cxpaddr->addr[cxpaddr->selectrow].jtel  = g_strdup( cxpaddr->copyData.jtel );
	cxpaddr->addr[cxpaddr->selectrow].sex   = g_strdup( cxpaddr->copyData.sex );
	cxpaddr->addr[cxpaddr->selectrow].birth = g_strdup( cxpaddr->copyData.birth );
	cxpaddr->addr[cxpaddr->selectrow].bload = g_strdup( cxpaddr->copyData.bload );
	cxpaddr->addr[cxpaddr->selectrow].ybin  = g_strdup( cxpaddr->copyData.ybin );
	cxpaddr->addr[cxpaddr->selectrow].addr  = g_strdup( cxpaddr->copyData.addr );
	cxpaddr->addr[cxpaddr->selectrow].tel   = g_strdup( cxpaddr->copyData.tel );
	cxpaddr->addr[cxpaddr->selectrow].fax   = g_strdup( cxpaddr->copyData.fax );
	cxpaddr->addr[cxpaddr->selectrow].email = g_strdup( cxpaddr->copyData.email );
	cxpaddr->addr[cxpaddr->selectrow].website = g_strdup( cxpaddr->copyData.website );
	cxpaddr->addr[cxpaddr->selectrow].comment = g_strdup( cxpaddr->copyData.comment );

	setname[0] = g_strdup( cxpaddr->addr[cxpaddr->selectrow].name );
	setname[1] = g_strdup( cxpaddr->addr[cxpaddr->selectrow].sex  );
	setname[2] = g_strdup( cxpaddr->addr[cxpaddr->selectrow].job  );
	setname[3] = g_strdup( cxpaddr->addr[cxpaddr->selectrow].jtel );
	setname[4] = g_strdup( cxpaddr->addr[cxpaddr->selectrow].email );
	gtk_clist_append( GTK_CLIST(cxpaddr->clist), setname );

	cxpaddr->selectrow ++;
    }
}


static void helpdialog_destroy(GtkWidget *widget, gpointer data)
{
  /* ɥϥɤ */
  gtk_grab_remove ( widget );
  gtk_widget_hide( widget );
}

void cxpaddrhelpfunc_about()
{
  GtkWidget *dialog ;
  GtkWidget *label[5] ;
  GtkWidget *button ;
  GtkWidget *pixmapwid;
  GdkPixmap *pixmap ;
  GdkBitmap *mask;
  GtkStyle  *style;
  int x,y,w,h ;

  gdk_window_get_origin(cxpaddr->window->window, &x, &y);
  gdk_window_get_size  (cxpaddr->window->window, &w, &h);

  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), "CxpaddrˤĤ");
  gtk_widget_set_usize(dialog, 300, 210);
  gtk_widget_set_uposition(dialog, (x+(w/2)) - (300/2), (y+(h/2)) - (210/2));
  gtk_grab_add (dialog);
  gtk_widget_show (dialog);

  label[4] = gtk_label_new( Copyright   );
  gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		label[4], FALSE, TRUE, 5);
  gtk_widget_show (label[4]);

  label[3] = gtk_label_new( Email   );
  gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		label[3], FALSE, TRUE, 5);
  gtk_widget_show (label[3]);

  label[2] = gtk_label_new( Website   );
  gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		label[2], FALSE, TRUE, 5);
  gtk_widget_show (label[2]);

  label[1] = gtk_label_new( Version );
  gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		label[1], FALSE, TRUE, 5);
  gtk_widget_show (label[1]);

  style = gtk_widget_get_style( cxpaddr->window );
  pixmap = gdk_pixmap_create_from_xpm(
                cxpaddr->window->window,
                &mask, &style->bg[GTK_STATE_NORMAL],
                cxpaddr->base.cxpaddr );
  pixmapwid = gtk_pixmap_new (pixmap, mask);
  gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		pixmapwid, TRUE, TRUE, 0);
  gtk_widget_show (pixmapwid);


  button = gtk_button_new_with_label (Kakunin);
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			(GtkSignalFunc) helpdialog_destroy,
			GTK_OBJECT (dialog));

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button, FALSE, TRUE, 0);
  gtk_widget_show (button);

}
