/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern CxpAddr    *cxpaddr;

static char *clist_title[5] =
{
	"̾",
	"Żҥ᡼",
	"̾",
	"",
	"Ϣ"
};

#define	SUBMENU_ADD	"ɲ"
#define	SUBMENU_MOD	"ѹ"
#define	SUBMENU_DEL	""
#define	SUBMENU_COPY	"ԡ"
#define	SUBMENU_PASTE	"Žդ"

static void submenu_response (gchar *string)
{
    if ( strcmp( string, SUBMENU_ADD ) == 0 ) {
	cxpaddrfilefunc_add();
    }else if ( strcmp( string, SUBMENU_MOD ) == 0 ) {
	cxpaddrfilefunc_mod();
    }else if ( strcmp( string, SUBMENU_DEL ) == 0 ) {
	cxpaddrfilefunc_del();
    }else if ( strcmp( string, SUBMENU_COPY ) == 0 ) {
	cxpaddreditfunc_copy();
    }else if ( strcmp( string, SUBMENU_PASTE ) == 0 ) {
	cxpaddreditfunc_paste();
    }
}

static gint clist_timeout_startfunc( gpointer data )
{
	int	timedata ;

	timedata = (int)*((int *)data) ;
	gtk_timeout_remove( timedata );
	timedata = 0 ;
	return(0);
}
static gint clist_timeout_endfunc( gpointer data )
{
	int	timedata ;

	timedata = (int)*((int *)data) ;
	gtk_timeout_remove( timedata );
	timedata = 0 ;
	return(0);
}

static void clist_unselection( clist, row, column, event, data )
GtkWidget      *clist ;
gint            row ;
gint            column ;
GdkEventButton *event ;
gpointer        data ;
{
	/* 򥯥ꥢ */
	cxpaddr->selectrow = 0 ;
}

static void clist_selection( clist, row, column, event, data )
GtkWidget      *clist ;
gint            row ;
gint            column ;
GdkEventButton *event ;
gpointer        data ;
{

	/* ˥å */
	if ( cxpaddr->selectrow != row )
	{
		cxpaddr->selectrow = row ;
		return ;
	}

	if ( cxpaddr->currentViewFlag2 )
	{
		cxpaddr->currentViewFlag2 = 0 ;
		return ;
	}


	if ( row < 0 )
		return ;

	/* ॢȤ */
	if ( cxpaddr->clist_timeout_start[row] == 0 )
	{
		cxpaddr->clist_timeout_start[row] = gtk_timeout_add( 200,
			clist_timeout_startfunc,
			&cxpaddr->clist_timeout_start[row] );

		return ;
	}

	if ( cxpaddr->currentViewFlag )
	{
		cxpaddr->currentViewFlag = 0 ;
		return ;
	}

	/* ֥륯å򤵤줿ˤѹɽ */
	cxpaddr_dialog (
		"ɥ쥹ѹ",
		"ѹ",
		"Ĥ롡",
		cxpaddr->selectrow );

	cxpaddr->currentViewFlag2 = 1 ;

	return;
}

static gint clist_buttonpress (GtkWidget *widget, GdkEvent *event)
{
    GdkEventButton  *bevent = (GdkEventButton *) event;
    GdkEventKey     *kevent = (GdkEventKey *) event;
    GtkWidget       *lmenubar ;
    GtkWidget       *lmenu ;
    GtkWidget       *lmenuitem ;
    int		row, column ;
    int		menuFlag ;

    menuFlag = 0 ;

    if (event->type == GDK_BUTTON_PRESS){
	if ( bevent->button != 3 ) {
	    /* ܥξ */
	    if (  bevent->button == 1 )
	    {
		gtk_clist_get_selection_info(
			GTK_CLIST(cxpaddr->clist),
			bevent->x, bevent->y,
			&row, &column );

		if ( row >= 0 && row < cxpaddr->addr_kensu )
		{
		    cxpaddr->currentViewFlag = 1 ;
		    gtk_clist_select_row(
				GTK_CLIST(cxpaddr->clist), row, 0 );
		}
		return FALSE;
	    }

	    /* ٥Ȥ̲ᤵ */
	    return FALSE ;
	}

	gtk_clist_get_selection_info(
		GTK_CLIST(cxpaddr->clist),
		bevent->x, bevent->y,
		&row, &column );

	if ( row >= 0 && row < cxpaddr->addr_kensu )
		menuFlag = 1 ;

	/* ˥塼 */
	lmenu = gtk_menu_new();

	lmenuitem = gtk_menu_item_new_with_label(SUBMENU_ADD);
	gtk_menu_append(GTK_MENU (lmenu), lmenuitem);
	gtk_signal_connect_object(GTK_OBJECT(lmenuitem), "activate",
			GTK_SIGNAL_FUNC(submenu_response),
			(gpointer)g_strdup(SUBMENU_ADD));
	gtk_widget_show(lmenuitem);

	if ( menuFlag )
	{
		lmenuitem = gtk_menu_item_new_with_label(SUBMENU_MOD);
		gtk_menu_append(GTK_MENU (lmenu), lmenuitem);
		gtk_signal_connect_object(GTK_OBJECT(lmenuitem), "activate",
			GTK_SIGNAL_FUNC(submenu_response),
			(gpointer)g_strdup(SUBMENU_MOD));
		gtk_widget_show(lmenuitem);

		lmenuitem = gtk_menu_item_new_with_label(SUBMENU_DEL);
		gtk_menu_append(GTK_MENU (lmenu), lmenuitem);
		gtk_signal_connect_object(GTK_OBJECT(lmenuitem), "activate",
			GTK_SIGNAL_FUNC(submenu_response),
			(gpointer)g_strdup(SUBMENU_DEL));
		gtk_widget_show(lmenuitem);

		lmenuitem = gtk_menu_item_new_with_label(SUBMENU_COPY);
		gtk_menu_append(GTK_MENU (lmenu), lmenuitem);
		gtk_signal_connect_object(GTK_OBJECT(lmenuitem), "activate",
			GTK_SIGNAL_FUNC(submenu_response),
			(gpointer)g_strdup(SUBMENU_COPY));
		gtk_widget_show(lmenuitem);
	}

	lmenuitem = gtk_menu_item_new_with_label(SUBMENU_PASTE);
	gtk_menu_append(GTK_MENU (lmenu), lmenuitem);
	gtk_signal_connect_object(GTK_OBJECT(lmenuitem), "activate",
			GTK_SIGNAL_FUNC(submenu_response),
			(gpointer)g_strdup(SUBMENU_PASTE));
	gtk_widget_show(lmenuitem);

	/* ˥塼ݥåץå */
	gtk_menu_popup (GTK_MENU(lmenu), NULL, NULL, NULL, NULL,
			bevent->button, bevent->time);

	return TRUE ;

    }
    /* ٥Ȥ̲ᤵ */
    return FALSE;
}

void cxpaddr_list_init()
{
  GtkWidget	*hbox ;

  hbox = gtk_hbox_new( FALSE, 1);
  gtk_box_pack_start(GTK_BOX(cxpaddr->vbox), hbox, TRUE, TRUE, 5);
  gtk_widget_show(hbox);

  /* Clist Τ뤿Υɥɥ */
  cxpaddr->swin = gtk_scrolled_window_new(NULL, NULL);

  /* ʿӿľΥСɽ褦 */
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(cxpaddr->swin), 
	 	GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  gtk_box_pack_start(GTK_BOX(hbox), cxpaddr->swin, TRUE, TRUE, 5);
  gtk_widget_show(cxpaddr->swin);


  cxpaddr->clist = gtk_clist_new_with_titles( 5, clist_title );

  gtk_widget_set_usize(cxpaddr->clist, 550, -1);
  gtk_clist_set_selection_mode(GTK_CLIST(cxpaddr->clist),
				GTK_SELECTION_BROWSE);

  gtk_signal_connect(GTK_OBJECT(cxpaddr->clist),
		"select_row", GTK_SIGNAL_FUNC(clist_selection), NULL);

  gtk_signal_connect(GTK_OBJECT(cxpaddr->clist),
		"unselect_row", GTK_SIGNAL_FUNC(clist_unselection), NULL);

  gtk_signal_connect_object(GTK_OBJECT(cxpaddr->clist),
		"event", GTK_SIGNAL_FUNC(clist_buttonpress), NULL);

  /* ȥܥȤʤ褦ˤ롣*/
  gtk_clist_column_titles_passive( GTK_CLIST(cxpaddr->clist));

  gtk_clist_set_column_width(GTK_CLIST(cxpaddr->clist), 0, 150);
  gtk_clist_set_column_width(GTK_CLIST(cxpaddr->clist), 1, 100);
  gtk_clist_set_column_width(GTK_CLIST(cxpaddr->clist), 2, 150);
  gtk_clist_set_column_width(GTK_CLIST(cxpaddr->clist), 3,  50);
  gtk_clist_set_column_width(GTK_CLIST(cxpaddr->clist), 4, 100);

  gtk_container_add(GTK_CONTAINER(cxpaddr->swin), cxpaddr->clist);
  gtk_widget_show(cxpaddr->clist);


}
