/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern	CxpAddr    *cxpaddr;

static void filemenu_response () ;
static void editmenu_response () ;
static void helpmenu_response () ;

#define	FILEIACT_SAVE		0x0101
#define	FILEIACT_ADD		0x0102
#define	FILEIACT_MOD		0x0103
#define	FILEIACT_DEL		0x0104
#define	FILEIACT_CLOSE		0x0105
#define	EDITIACT_COPY		0x0201
#define	EDITIACT_PASTE		0x0202
#define	HELPIACT_ABOUT		0x0901

#define	FILEMENU_BASE		"/ե"
#define	FILEMENU_SAVE		"/ե/¸"
#define	FILEMENU_SEP1		"/ե/sep1"
#define	FILEMENU_ADD		"/ե/ɲ"
#define	FILEMENU_MOD		"/ե/ѹ"
#define	FILEMENU_DEL		"/ե/"
#define	FILEMENU_SEP2		"/ե/sep2"
#define	FILEMENU_CLOSE		"/ե/Ĥ"

#define	EDITMENU_BASE		"/Խ"
#define	EDITMENU_COPY		"/Խ/ԡ"
#define	EDITMENU_PASTE		"/Խ/Žդ"

#define	HELPMENU_BASE		"/إ"
#define	HELPMENU_ABOUT		"/إ/CxpaddrˤĤ"


static GtkItemFactoryEntry menu_items[] = {
 { FILEMENU_BASE,    NULL, NULL,   0, "<Branch>" },
 { FILEMENU_SAVE,    "<control>S", filemenu_response,  FILEIACT_SAVE,   NULL },
 { FILEMENU_SEP1,    NULL, NULL,   0, "<Separator>" },
 { FILEMENU_ADD,     "<control>A", filemenu_response,  FILEIACT_ADD,    NULL },
 { FILEMENU_MOD,     "<control>M", filemenu_response,  FILEIACT_MOD,    NULL },
 { FILEMENU_DEL,     "<control>D", filemenu_response,  FILEIACT_DEL,    NULL },
 { FILEMENU_SEP2,    NULL, NULL,   0, "<Separator>" },
 { FILEMENU_CLOSE,   "<control>Q", filemenu_response,  FILEIACT_CLOSE,  NULL },
 { EDITMENU_BASE,    NULL, NULL,   0, "<Branch>" },
 { EDITMENU_COPY,    "<control>C", editmenu_response,  EDITIACT_COPY,   NULL },
 { EDITMENU_PASTE,   "<control>V", editmenu_response,  EDITIACT_PASTE,  NULL },
 { HELPMENU_BASE,    NULL, NULL,   0, "<LastBranch>" },
 { HELPMENU_ABOUT,   NULL,         helpmenu_response,  HELPIACT_ABOUT,  NULL },
};


static void filemenu_response (GtkWidget *w, gpointer data)
{
	switch( (int)data )
	{
	case FILEIACT_SAVE :
		cxpaddrfilefunc_save();
		break ;
	case FILEIACT_ADD :
		cxpaddrfilefunc_add();
		break ;
	case FILEIACT_MOD :
		cxpaddrfilefunc_mod();
		break ;
	case FILEIACT_DEL :
		cxpaddrfilefunc_del();
		break ;
	case FILEIACT_CLOSE :
		cxpaddrfilefunc_close();
		break ;
	}
}

static void editmenu_response (GtkWidget *w, gpointer data)
{
	switch( (int)data )
	{
	case EDITIACT_COPY :
		cxpaddreditfunc_copy();
		break ;
	case EDITIACT_PASTE :
		cxpaddreditfunc_paste();
		break ;
	}
}

static void helpmenu_response (GtkWidget *w, gpointer data)
{
	switch( (int)data )
	{
	case HELPIACT_ABOUT :
		cxpaddrhelpfunc_about();
		break;
	}
}


void cxpaddr_menu_init()
{
  GtkWidget	*handle_box ;
  GtkWidget	*subitem ;
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;
  int		nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);

  handle_box = gtk_handle_box_new ();
  gtk_box_pack_start (GTK_BOX(cxpaddr->vbox), handle_box, FALSE, FALSE, 0 );
  gtk_widget_show (handle_box);

  accel_group = gtk_accel_group_new();

  item_factory = gtk_item_factory_new(
		GTK_TYPE_MENU_BAR, "<main>", accel_group);

  gtk_item_factory_create_items(item_factory, nmenu_items, menu_items, NULL);

  gtk_accel_group_attach (accel_group, GTK_OBJECT (cxpaddr->window));

  cxpaddr->menubar = gtk_item_factory_get_widget(item_factory, "<main>");
  gtk_container_add ( GTK_CONTAINER ( handle_box ) , cxpaddr->menubar );
  gtk_widget_show(cxpaddr->menubar);

}
