/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern	CxpApp    *cxpapp;

static GtkWidget *filew ;
static GtkWidget *textwid_kakucho ;
static GtkWidget *textwid_info ;
static GtkWidget *textwid_xpm ;
static GtkWidget *textwid_app ;
extern void cxpapp_message ();

void adddata_func(GtkWidget *widget, gpointer data)
{
	char	*text[6] ;
	int	i ;
	int	status ;

	text[0] = gtk_entry_get_text(GTK_ENTRY(textwid_kakucho));
	text[1] = gtk_entry_get_text(GTK_ENTRY(textwid_info));
	text[2] = gtk_entry_get_text(GTK_ENTRY(textwid_xpm));
	text[3] = gtk_entry_get_text(GTK_ENTRY(textwid_app));

#if 0
fprintf(stdout,"step 1 ...\n");
fprintf(stdout,"text[0] -> [%s]\n", text[0] );
fprintf(stdout,"text[1] -> [%s]\n", text[1] );
fprintf(stdout,"text[2] -> [%s]\n", text[2] );
fprintf(stdout,"text[3] -> [%s]\n", text[3] );
fflush(stdout);
#endif

	if ( text[0] == NULL || strlen(text[0]) <= 0 )
	{
	    cxpapp_message (
		"ɲå顼","Ĥ",
		"ĥҤϤƤޤ","" );
	}else
	if ( text[1] == NULL || strlen(text[1]) <= 0 )
	{
	    cxpapp_message (
		"ɲå顼","Ĥ",
		"եϤƤޤ","");
	}else
	if ( text[2] == NULL || strlen(text[2]) <= 0 )
	{
	    cxpapp_message (
		"ɲå顼","Ĥ",
		"XPMե뤬ꤵƤޤ","");
	}else{

	    /* ϿƤȽʣå */
	    status = 0 ;
	    for(i=0;i<cxpapp->appli_kensu;i++)
	    {
		if ( strcmp(cxpapp->appli[i].kakucho, text[0]) == 0 )
		{
		    status = 1 ;
		    break ;
		}
	    }
	    if ( status == 1 )
	    {
		cxpapp_message (
			"ɲå顼","Ĥ",
			"ƱĥҾϿƤޤ",
			text[0] );
	    }else{


		/* ꥹȤɲä */
		cxpapp->appli[cxpapp->appli_kensu].kakucho = g_strdup(text[0]);
		cxpapp->appli[cxpapp->appli_kensu].info    = g_strdup(text[1]);
		cxpapp->appli[cxpapp->appli_kensu].xpm_small=g_strdup(text[2]);
		if ( text[3] != NULL && strlen(text[3]) > 0 )
		cxpapp->appli[cxpapp->appli_kensu].command = g_strdup(text[3]);
		cxpapp->appli_kensu ++;

		cxpapp_view();

		/* ɥϥɤ */
		gtk_widget_hide( widget );
	    }
	}
}

void moddata_func(GtkWidget *widget, gpointer data)
{
	char	*text[4] ;
	int	i ;
	int	status ;

	text[0] = gtk_entry_get_text(GTK_ENTRY(textwid_kakucho));
	text[1] = gtk_entry_get_text(GTK_ENTRY(textwid_info));
	text[2] = gtk_entry_get_text(GTK_ENTRY(textwid_xpm));
	text[3] = gtk_entry_get_text(GTK_ENTRY(textwid_app));

	if ( text[0] == NULL || strlen(text[0]) <= 0 )
	{
	    cxpapp_message (
		"ѹ顼","Ĥ",
		"ĥҤϤƤޤ","" );
	}else
	if ( text[1] == NULL || strlen(text[1]) <= 0 )
	{
	    cxpapp_message (
		"ѹ顼","Ĥ",
		"եϤƤޤ","");
	}else
	if ( text[2] == NULL || strlen(text[2]) <= 0 )
	{
	    cxpapp_message (
		"ѹ顼","Ĥ",
		"XPMե뤬ꤵƤޤ","");
	}else{

	    /* ϿƤȽʣå */
	    status = 0 ;
	    for(i=0;i<cxpapp->appli_kensu;i++)
	    {
		if ( strcmp(cxpapp->appli[i].kakucho, text[0]) == 0
		&&   cxpapp->selectrow != i )
		{
		    status = 1 ;
		    break ;
		}
	    }

	    if ( status == 1 )
	    {
		cxpapp_message (
			"ѹ顼","Ĥ",
			"ƱĥҾϿƤޤ",
			text[0] );
	    }else{

		/* ꥹȤɲä */
		cxpapp->appli[cxpapp->selectrow].kakucho = g_strdup(text[0]);
		cxpapp->appli[cxpapp->selectrow].info    = g_strdup(text[1]);
		cxpapp->appli[cxpapp->selectrow].xpm_small=g_strdup(text[2]);
		if ( text[3] != NULL && strlen(text[3]) > 0 )
		cxpapp->appli[cxpapp->selectrow].command = g_strdup(text[3]);
		else
		cxpapp->appli[cxpapp->selectrow].command = NULL ;

		cxpapp_view();

		/* ɥϥɤ */
		gtk_widget_hide( widget );
	    }
	}
}

void deldata_func(GtkWidget *widget, gpointer data)
{
	char	*text[4] ;
	int	i ;
	int	status ;


	status = 0 ;
	for(i=cxpapp->selectrow;i<cxpapp->appli_kensu;i++)
	{
		cxpapp->appli[i].kakucho   = NULL ;
		cxpapp->appli[i].info      = NULL ;
		cxpapp->appli[i].xpm_small = NULL ;
		cxpapp->appli[i].command   = NULL ;

		cxpapp->appli[i].kakucho   = 
			g_strdup(cxpapp->appli[i+1].kakucho);
		cxpapp->appli[i].info      = 
			g_strdup(cxpapp->appli[i+1].info);
		cxpapp->appli[i].xpm_small = 
			g_strdup(cxpapp->appli[i+1].xpm_small);
		cxpapp->appli[i].command   = 
			g_strdup(cxpapp->appli[i+1].command);
	}
	cxpapp->appli_kensu--;

	cxpapp_view();

	/* ɥϥɤ */
	gtk_widget_hide( widget );
}

void cancel_function(GtkWidget *widget, gpointer data)
{
	/* ɥϥɤ */
	gtk_widget_hide( widget );
}

/* åɽ */
void cxpapp_message ( title, can, list1, list2 )
char	*title ;
char	*can ;
char	*list1 ;
char	*list2 ;
{
  GtkWidget *dialog ;
  GtkWidget *label[5] ;
  GtkWidget *button1 ;
  GtkWidget *button2 ;
  int x,y,w,h ;

  gdk_window_get_origin(cxpapp->window->window, &x, &y);
  gdk_window_get_size  (cxpapp->window->window, &w, &h);

  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), title );

  gtk_widget_set_usize(dialog, 300, 140);
  gtk_widget_set_uposition(dialog, (x+(w/2)) - (300/2), (y+(h/2)) - (100/2));
#if 0
  gtk_grab_add (dialog);
#endif
  gtk_widget_show (dialog);


  if ( strlen(list2) > 0 )
  {
	label[0] = gtk_label_new( list1 );
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		label[0], TRUE, TRUE, 10);
	gtk_widget_show (label[0]);

  	label[1] = gtk_label_new( list2   );
  	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		label[1], TRUE, TRUE, 0);
  	gtk_widget_show (label[1]);

  }else{

	label[0] = gtk_label_new( list1 );
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		label[0], TRUE, TRUE, 20);
	gtk_widget_show (label[0]);
  }

  button2 = gtk_button_new_with_label (can);
  gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			(GtkSignalFunc) cancel_function,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button2, FALSE, TRUE, 20);
  gtk_widget_show (button2);

}

static int cxpapp_setxpm(GtkWidget *widget, GtkFileSelection *fs)
{
    char workbuff[1024] ;

#if 0
    sprintf( workbuff, "cxpnote %s",
        gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)) );
#endif
    gtk_entry_set_text( GTK_ENTRY(textwid_xpm),
	gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs) ) );

    gtk_widget_hide(filew);

    return(0) ;
}

static int cxpapp_setapp(GtkWidget *widget, GtkFileSelection *fs)
{
    char workbuff[1024] ;

#if 0
    sprintf( workbuff, "cxpnote %s",
        gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)) );
#endif
    gtk_entry_set_text( GTK_ENTRY(textwid_app),
	gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs) ) );

    gtk_widget_hide(filew);

    return(0) ;
}

void cxpapp_xpmopenfunc()
{

    filew = gtk_file_selection_new ("ե");

    gtk_signal_connect (
                GTK_OBJECT (filew), "destroy",
                (GtkSignalFunc)gtk_widget_destroy,
                GTK_OBJECT(filew));
    gtk_signal_connect (
                GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
                "clicked", (GtkSignalFunc)cxpapp_setxpm, filew );
    gtk_signal_connect_object (
                GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button),
                "clicked", (GtkSignalFunc)gtk_widget_destroy,
                GTK_OBJECT (filew));

    gtk_widget_show(filew);
}

void cxpapp_appopenfunc()
{

    filew = gtk_file_selection_new ("ץꥱ") ;

    gtk_signal_connect (
                GTK_OBJECT (filew), "destroy",
                (GtkSignalFunc)gtk_widget_destroy,
                GTK_OBJECT(filew));
    gtk_signal_connect (
                GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
                "clicked", (GtkSignalFunc)cxpapp_setapp, filew );
    gtk_signal_connect_object (
                GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button),
                "clicked", (GtkSignalFunc)gtk_widget_destroy,
                GTK_OBJECT (filew));

    gtk_widget_show(filew);
}


/* ɲå */
void dialog_adddata ()
{
  GtkWidget *dialog ;
  GtkWidget *hbox[5] ;
  GtkWidget *label[5] ;
  GtkWidget *select[2] ;
  GtkWidget *button1 ;
  GtkWidget *button2 ;
  int x,y,w,h ;

  gdk_window_get_origin(cxpapp->window->window, &x, &y);
  gdk_window_get_size  (cxpapp->window->window, &w, &h);

  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), "ɲ" );

  gtk_widget_set_usize(dialog, 480, 200);
  gtk_widget_set_uposition(dialog, (x+(w/2)) - (480/2), (y+(h/2)) - (200/2));
  gtk_widget_show (dialog);


  hbox[0] = gtk_hbox_new(FALSE, 2);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox),hbox[0],TRUE,TRUE,10);
  gtk_widget_show(hbox[0]);

  label[0] = gtk_label_new( "ĥҡ" );
  gtk_box_pack_start (GTK_BOX (hbox[0]), label[0], FALSE, FALSE, 10);
  gtk_widget_show (label[0]);

  textwid_kakucho = gtk_entry_new_with_max_length( 256 );
  gtk_box_pack_start (GTK_BOX (hbox[0]), textwid_kakucho, TRUE, TRUE, 10);
  gtk_widget_show (textwid_kakucho);


  hbox[1] = gtk_hbox_new(FALSE, 2);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox),hbox[1],TRUE,TRUE,10);
  gtk_widget_show(hbox[1]);

  label[1] = gtk_label_new( "̾" );
  gtk_box_pack_start (GTK_BOX (hbox[1]), label[1], FALSE, FALSE, 10);
  gtk_widget_show (label[1]);

  textwid_info = gtk_entry_new_with_max_length( 256 );
  gtk_box_pack_start (GTK_BOX (hbox[1]), textwid_info, TRUE, TRUE, 10);
  gtk_widget_show (textwid_info);


  hbox[2] = gtk_hbox_new(FALSE, 2);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox),hbox[2],TRUE,TRUE,10);
  gtk_widget_show(hbox[2]);

  label[2] = gtk_label_new( "ե" );
  gtk_box_pack_start (GTK_BOX (hbox[2]), label[2], FALSE, FALSE, 10);
  gtk_widget_show (label[2]);

  textwid_xpm = gtk_entry_new_with_max_length( 512 );
  gtk_box_pack_start (GTK_BOX (hbox[2]), textwid_xpm, TRUE, TRUE, 10);
  gtk_widget_show (textwid_xpm);

  select[0] = gtk_button_new_with_label ("ե");
  gtk_signal_connect_object (GTK_OBJECT (select[0]), "clicked",
	(GtkSignalFunc)cxpapp_xpmopenfunc, GTK_OBJECT (dialog));
  gtk_box_pack_end (GTK_BOX (hbox[2]), select[0], FALSE, FALSE, 5);
  gtk_widget_show (select[0]);


  hbox[3] = gtk_hbox_new(FALSE, 2);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox),hbox[3],TRUE,TRUE,10);
  gtk_widget_show(hbox[3]);

  label[3] = gtk_label_new( "ץꥱ" );
  gtk_box_pack_start (GTK_BOX (hbox[3]), label[3], FALSE, FALSE, 10);
  gtk_widget_show (label[3]);

  textwid_app = gtk_entry_new_with_max_length( 512 );
  gtk_box_pack_start (GTK_BOX (hbox[3]), textwid_app, TRUE, TRUE, 10);
  gtk_widget_show (textwid_app);

  select[1] = gtk_button_new_with_label ("ե");
  gtk_signal_connect_object (GTK_OBJECT (select[1]), "clicked",
	(GtkSignalFunc)cxpapp_appopenfunc, GTK_OBJECT (dialog));
  gtk_box_pack_end (GTK_BOX (hbox[3]), select[1], FALSE, FALSE, 5);
  gtk_widget_show (select[1]);


  button1 = gtk_button_new_with_label ("ɲ");
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
			(GtkSignalFunc) adddata_func,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button1, FALSE, TRUE, 20);
  gtk_widget_show (button1);

  button2 = gtk_button_new_with_label ("Ĥ");
  gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			(GtkSignalFunc) cancel_function,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button2, FALSE, TRUE, 20);
  gtk_widget_show (button2);
}

/* ѹ */
void dialog_moddata ()
{
  GtkWidget *dialog ;
  GtkWidget *hbox[5] ;
  GtkWidget *label[5] ;
  GtkWidget *select[2] ;
  GtkWidget *button1 ;
  GtkWidget *button2 ;
  int x,y,w,h ;

  /* 򤵤Ƥʤϥå */
  if ( cxpapp->selectrow < 0 )
  {
	cxpapp_message (
		"ѹ顼","Ĥ",
		"ѹǡ򤵤Ƥޤ","" );
	return ;
  }

  gdk_window_get_origin(cxpapp->window->window, &x, &y);
  gdk_window_get_size  (cxpapp->window->window, &w, &h);

  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), "ѹ" );

  gtk_widget_set_usize(dialog, 480, 200);
  gtk_widget_set_uposition(dialog, (x+(w/2)) - (480/2), (y+(h/2)) - (200/2));
  gtk_widget_show (dialog);


  hbox[0] = gtk_hbox_new(FALSE, 2);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox),hbox[0],TRUE,TRUE,10);
  gtk_widget_show(hbox[0]);

  label[0] = gtk_label_new( "ĥҡ" );
  gtk_box_pack_start (GTK_BOX (hbox[0]), label[0], FALSE, FALSE, 10);
  gtk_widget_show (label[0]);

  textwid_kakucho = gtk_entry_new_with_max_length( 256 );
  gtk_box_pack_start (GTK_BOX (hbox[0]), textwid_kakucho, TRUE, TRUE, 10);
  gtk_widget_show (textwid_kakucho);


  hbox[1] = gtk_hbox_new(FALSE, 2);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox),hbox[1],TRUE,TRUE,10);
  gtk_widget_show(hbox[1]);

  label[1] = gtk_label_new( "̾" );
  gtk_box_pack_start (GTK_BOX (hbox[1]), label[1], FALSE, FALSE, 10);
  gtk_widget_show (label[1]);

  textwid_info = gtk_entry_new_with_max_length( 256 );
  gtk_box_pack_start (GTK_BOX (hbox[1]), textwid_info, TRUE, TRUE, 10);
  gtk_widget_show (textwid_info);


  hbox[2] = gtk_hbox_new(FALSE, 2);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox),hbox[2],TRUE,TRUE,10);
  gtk_widget_show(hbox[2]);

  label[2] = gtk_label_new( "ե" );
  gtk_box_pack_start (GTK_BOX (hbox[2]), label[2], FALSE, FALSE, 10);
  gtk_widget_show (label[2]);

  textwid_xpm = gtk_entry_new_with_max_length( 512 );
  gtk_box_pack_start (GTK_BOX (hbox[2]), textwid_xpm, TRUE, TRUE, 10);
  gtk_widget_show (textwid_xpm);

  select[0] = gtk_button_new_with_label ("ե");
  gtk_signal_connect_object (GTK_OBJECT (select[0]), "clicked",
	(GtkSignalFunc)cxpapp_xpmopenfunc, GTK_OBJECT (dialog));
  gtk_box_pack_end (GTK_BOX (hbox[2]), select[0], FALSE, FALSE, 5);
  gtk_widget_show (select[0]);


  hbox[3] = gtk_hbox_new(FALSE, 2);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox),hbox[3],TRUE,TRUE,10);
  gtk_widget_show(hbox[3]);

  label[3] = gtk_label_new( "ץꥱ" );
  gtk_box_pack_start (GTK_BOX (hbox[3]), label[3], FALSE, FALSE, 10);
  gtk_widget_show (label[3]);

  textwid_app = gtk_entry_new_with_max_length( 512 );
  gtk_box_pack_start (GTK_BOX (hbox[3]), textwid_app, TRUE, TRUE, 10);
  gtk_widget_show (textwid_app);

  select[1] = gtk_button_new_with_label ("ե");
  gtk_signal_connect_object (GTK_OBJECT (select[1]), "clicked",
	(GtkSignalFunc)cxpapp_appopenfunc, GTK_OBJECT (dialog));
  gtk_box_pack_end (GTK_BOX (hbox[3]), select[1], FALSE, FALSE, 5);
  gtk_widget_show (select[1]);

  gtk_entry_set_text( GTK_ENTRY(textwid_kakucho),
			cxpapp->appli[cxpapp->selectrow].kakucho );
  gtk_entry_set_text( GTK_ENTRY(textwid_info),
			cxpapp->appli[cxpapp->selectrow].info );
  if ( strlen(cxpapp->appli[cxpapp->selectrow].xpm_small) > 0 )
  gtk_entry_set_text( GTK_ENTRY(textwid_xpm),
			cxpapp->appli[cxpapp->selectrow].xpm_small );
  else
  gtk_entry_set_text( GTK_ENTRY(textwid_xpm), "" );
  if ( strlen(cxpapp->appli[cxpapp->selectrow].command) > 0 )
  gtk_entry_set_text( GTK_ENTRY(textwid_app),
			cxpapp->appli[cxpapp->selectrow].command );
  else
  gtk_entry_set_text( GTK_ENTRY(textwid_app),"");

  button1 = gtk_button_new_with_label ("ѹ" );
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
			(GtkSignalFunc) moddata_func,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button1, FALSE, TRUE, 20);
  gtk_widget_show (button1);

  button2 = gtk_button_new_with_label ("Ĥ");
  gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			(GtkSignalFunc) cancel_function,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button2, FALSE, TRUE, 20);
  gtk_widget_show (button2);
}

/*  */
void dialog_deldata ()
{
  GtkWidget *dialog ;
  GtkWidget *hbox[5] ;
  GtkWidget *label[5] ;
  GtkWidget *select[2] ;
  GtkWidget *button1 ;
  GtkWidget *button2 ;
  int x,y,w,h ;

  /* 򤵤Ƥʤϥå */
  if ( cxpapp->selectrow < 0 )
  {
	cxpapp_message (
		"顼","Ĥ",
		"ǡ򤵤Ƥޤ","" );
	return ;
  }

  gdk_window_get_origin(cxpapp->window->window, &x, &y);
  gdk_window_get_size  (cxpapp->window->window, &w, &h);

  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), "" );

  gtk_widget_set_usize(dialog, 480, 200);
  gtk_widget_set_uposition(dialog, (x+(w/2)) - (480/2), (y+(h/2)) - (200/2));
  gtk_widget_show (dialog);


  hbox[0] = gtk_hbox_new(FALSE, 2);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox),hbox[0],TRUE,TRUE,10);
  gtk_widget_show(hbox[0]);

  label[0] = gtk_label_new( "ĥҡ" );
  gtk_box_pack_start (GTK_BOX (hbox[0]), label[0], FALSE, FALSE, 10);
  gtk_widget_show (label[0]);

  textwid_kakucho = gtk_entry_new_with_max_length( 256 );
  gtk_box_pack_start (GTK_BOX (hbox[0]), textwid_kakucho, TRUE, TRUE, 10);
  gtk_widget_show (textwid_kakucho);


  hbox[1] = gtk_hbox_new(FALSE, 2);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox),hbox[1],TRUE,TRUE,10);
  gtk_widget_show(hbox[1]);

  label[1] = gtk_label_new( "̾" );
  gtk_box_pack_start (GTK_BOX (hbox[1]), label[1], FALSE, FALSE, 10);
  gtk_widget_show (label[1]);

  textwid_info = gtk_entry_new_with_max_length( 256 );
  gtk_box_pack_start (GTK_BOX (hbox[1]), textwid_info, TRUE, TRUE, 10);
  gtk_widget_show (textwid_info);


  hbox[2] = gtk_hbox_new(FALSE, 2);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox),hbox[2],TRUE,TRUE,10);
  gtk_widget_show(hbox[2]);

  label[2] = gtk_label_new( "ե" );
  gtk_box_pack_start (GTK_BOX (hbox[2]), label[2], FALSE, FALSE, 10);
  gtk_widget_show (label[2]);

  textwid_xpm = gtk_entry_new_with_max_length( 512 );
  gtk_box_pack_start (GTK_BOX (hbox[2]), textwid_xpm, TRUE, TRUE, 10);
  gtk_widget_show (textwid_xpm);


  hbox[3] = gtk_hbox_new(FALSE, 2);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox),hbox[3],TRUE,TRUE,10);
  gtk_widget_show(hbox[3]);

  label[3] = gtk_label_new( "ץꥱ" );
  gtk_box_pack_start (GTK_BOX (hbox[3]), label[3], FALSE, FALSE, 10);
  gtk_widget_show (label[3]);

  textwid_app = gtk_entry_new_with_max_length( 512 );
  gtk_box_pack_start (GTK_BOX (hbox[3]), textwid_app, TRUE, TRUE, 10);
  gtk_widget_show (textwid_app);

  gtk_entry_set_text( GTK_ENTRY(textwid_kakucho),
			cxpapp->appli[cxpapp->selectrow].kakucho );
  gtk_entry_set_text( GTK_ENTRY(textwid_info),
			cxpapp->appli[cxpapp->selectrow].info );
  gtk_entry_set_text( GTK_ENTRY(textwid_xpm),
			cxpapp->appli[cxpapp->selectrow].xpm_small );
  gtk_entry_set_text( GTK_ENTRY(textwid_app),
			cxpapp->appli[cxpapp->selectrow].command );

  gtk_entry_set_editable( GTK_ENTRY(textwid_kakucho),FALSE );
  gtk_entry_set_editable( GTK_ENTRY(textwid_info),   FALSE );
  gtk_entry_set_editable( GTK_ENTRY(textwid_xpm),    FALSE );
  gtk_entry_set_editable( GTK_ENTRY(textwid_app),    FALSE );

  button1 = gtk_button_new_with_label ("");
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
			(GtkSignalFunc) deldata_func,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button1, FALSE, TRUE, 20);
  gtk_widget_show (button1);

  button2 = gtk_button_new_with_label ("Ĥ");
  gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			(GtkSignalFunc) cancel_function,
			GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button2, FALSE, TRUE, 20);
  gtk_widget_show (button2);
}
