/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern CxpApp    *cxpapp;
extern void cxpapp_message ();

char *clist_title[4] =
{
	"ĥ",
	"̾",
	"XPMե̾",
	"ץꥱ"
};

#define	ADDNAME		"ɲ"
#define	DELNAME		""
#define	MODNAME		"ѹ"
#define	SAVENAME	"¸"
#define	CANNAME		"Ĥ"

gint clist_timeout_startfunc( data )
gpointer data ;
{
	gtk_timeout_remove( cxpapp->clist_timeout_start );
	cxpapp->clist_timeout_start = 0 ;
	return(0);
}
gint clist_timeout_endfunc( data )
gpointer data ;
{
	gtk_timeout_remove( cxpapp->clist_timeout_end );
	cxpapp->clist_timeout_end = 0 ;
	return(0);
}

void clist_unselection( clist, row, column, event, data )
GtkWidget      *clist ;
gint            row ;
gint            column ;
GdkEventButton *event ;
gpointer        data ;
{
	/* 򥯥ꥢ */
	cxpapp->selectrow = -1 ;
}

void clist_selection( clist, row, column, event, data )
GtkWidget      *clist ;
gint            row ;
gint            column ;
GdkEventButton *event ;
gpointer        data ;
{
	int		i ;

	/* ˥å */
	cxpapp->selectrow = row ;

	if ( cxpapp->currentViewFlag == 1 )
		return ;

	if ( row < 0 )
		return ;

	/* ॢȤ */
	if ( cxpapp->clist_timeout_start == 0 )
	{
		cxpapp->clist_timeout_start = gtk_timeout_add( 50,
			clist_timeout_startfunc, NULL);

		if ( cxpapp->clist_timeout_end != 0 )
		{
		    gtk_timeout_remove( cxpapp->clist_timeout_end );
		}
		cxpapp->clist_timeout_end = gtk_timeout_add( 200,
			clist_timeout_endfunc, NULL);

		return ;
	}

	dialog_moddata();

	return;
}

static void addfunc(GtkWidget *widget, gpointer data)
{
	dialog_adddata();
}
static void modfunc(GtkWidget *widget, gpointer data)
{
	dialog_moddata();
}
static void delfunc(GtkWidget *widget, gpointer data)
{
	dialog_deldata();
}
static void savefunc(GtkWidget *widget, gpointer data)
{
	int	status ;
	int	i ;

	/* XPMեå */
	status = 0 ;
	for(i=0;i<cxpapp->appli_kensu;i++)
	{
		if ( access( cxpapp->appli[i].xpm_small, F_OK )!=0)
		{
			status = 1 ;
			break ;
		}
	}
	if ( status != 0 )
	{
		/* å顼 */
		cxpapp_message (
			"¸顼","Ĥ",
			"XPMե뤬¸ߤޤ",
			cxpapp->appli[i].xpm_small );
		return ;
	}

	status = setApplicationConfig(
			&(cxpapp->appli_kensu), &(cxpapp->appli) );
	if ( status != 0 )
	{
		/* ¸˼ */
		cxpapp_message (
			"¸顼","Ĥ",
			"¸˼Ԥޤ","");
	}else{
		/* ¸λ */
		cxpapp_message (
			"¸","Ĥ",
			"¸˽λޤ",
			"ƥեȥƵưɬפޤ");
	}
}
static void canfunc(GtkWidget *widget, gpointer data)
{
	gtk_main_quit();
}


void cxpapp_list_init()
{
  GtkWidget	*hbox ;
  GtkWidget	*addbtn ;
  GtkWidget	*delbtn ;
  GtkWidget	*modbtn ;
  GtkWidget	*savebtn ;
  GtkWidget	*canbtn ;
  GtkWidget	*label ;


  hbox = gtk_hbox_new(FALSE, 2);
  gtk_box_pack_end (GTK_BOX(cxpapp->vbox), hbox, FALSE, FALSE, 10);
  gtk_widget_show(hbox);


  addbtn = gtk_button_new_with_label ( ADDNAME );
  gtk_signal_connect_object (GTK_OBJECT (addbtn), "clicked",
                        (GtkSignalFunc) addfunc, NULL );
  gtk_box_pack_start (GTK_BOX (hbox), addbtn, TRUE, TRUE,  5);
  gtk_widget_show (addbtn);

  modbtn = gtk_button_new_with_label ( MODNAME );
  gtk_signal_connect_object (GTK_OBJECT (modbtn), "clicked",
                        (GtkSignalFunc) modfunc, NULL );
  gtk_box_pack_start (GTK_BOX (hbox), modbtn, TRUE, TRUE,  5);
  gtk_widget_show (modbtn);

  delbtn = gtk_button_new_with_label ( DELNAME );
  gtk_signal_connect_object (GTK_OBJECT (delbtn), "clicked",
                        (GtkSignalFunc) delfunc, NULL );
  gtk_box_pack_start (GTK_BOX (hbox), delbtn, TRUE, TRUE,  5);
  gtk_widget_show (delbtn);

  savebtn = gtk_button_new_with_label ( SAVENAME );
  gtk_signal_connect_object (GTK_OBJECT (savebtn), "clicked",
                        (GtkSignalFunc) savefunc, NULL );
  gtk_box_pack_start (GTK_BOX (hbox), savebtn, TRUE, TRUE,  5);
  gtk_widget_show (savebtn);

  canbtn = gtk_button_new_with_label ( CANNAME );
  gtk_signal_connect_object (GTK_OBJECT (canbtn), "clicked",
                        (GtkSignalFunc) canfunc, NULL );
  gtk_box_pack_start (GTK_BOX (hbox), canbtn, TRUE, TRUE,  5);
  gtk_widget_show (canbtn);


  /* Clist Τ뤿Υɥɥ */
  cxpapp->swin = gtk_scrolled_window_new(NULL, NULL);

  /* ʿӿľΥСɽ褦 */
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(cxpapp->swin), 
	 	GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

#if 0
  gtk_box_pack_end (GTK_BOX(cxpapp->vbox), cxpapp->swin, TRUE, TRUE, 0 );
#else
  label = gtk_label_new( "ץꥱϢդޥ͡" );
  gtk_box_pack_start (GTK_BOX(cxpapp->vbox), label, FALSE, FALSE, 5 );
  gtk_widget_show(label);
  cxpapp->hbox = gtk_hbox_new( FALSE,0 );
  gtk_box_pack_end (GTK_BOX(cxpapp->vbox), cxpapp->hbox, TRUE, TRUE, 5 );
  gtk_widget_show(cxpapp->hbox);
  gtk_box_pack_end (GTK_BOX(cxpapp->hbox), cxpapp->swin, TRUE, TRUE, 10 );
  gtk_widget_show(cxpapp->swin);
#endif
  gtk_widget_show(cxpapp->swin);

  cxpapp->clist = gtk_clist_new_with_titles( 4, clist_title );

  gtk_widget_set_usize(cxpapp->clist, 440, -1);
  gtk_clist_set_selection_mode(GTK_CLIST(cxpapp->clist),GTK_SELECTION_BROWSE);

  gtk_signal_connect(GTK_OBJECT(cxpapp->clist),
		"select_row", GTK_SIGNAL_FUNC(clist_selection), NULL);

  gtk_signal_connect(GTK_OBJECT(cxpapp->clist),
		"unselect_row", GTK_SIGNAL_FUNC(clist_unselection), NULL);

  /* ȥܥȤʤ褦ˤ롣*/
  gtk_clist_column_titles_passive( GTK_CLIST(cxpapp->clist));

  gtk_clist_set_column_width(GTK_CLIST(cxpapp->clist), 0, 100);
  gtk_clist_set_column_width(GTK_CLIST(cxpapp->clist), 1, 100);
  gtk_clist_set_column_width(GTK_CLIST(cxpapp->clist), 2, 140);
  gtk_clist_set_column_width(GTK_CLIST(cxpapp->clist), 3, 120);

  gtk_container_add(GTK_CONTAINER(cxpapp->swin), cxpapp->clist);
  gtk_widget_show(cxpapp->clist);

}
