/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpbackup.h"

extern CxpBackup *cxpbackup;

static void filemenu_response ();
static void helpmenu_response ();

extern int dirListEventFunc ();
extern int dirListSelectionFunc ();
extern int dirListUnSelectionFunc ();
extern int dirListSelectBtnFunc ();
extern int dirListUnSelectBtnFunc ();
extern int dirListAllClearBtnFunc ();
extern int dirListAllSelectBtnFunc ();
extern int cxprestorehelpfunc_help ();
extern int keisanBtnFunc ();
extern int startBtnFunc ();
extern void compressRadioFunc ();
extern void deviceRadioFunc ();

#define FILEIACT_CLOSE          0x0101
#define HELPIACT_HELP           0x0901

#define FILEMENU_BASE           "/ե"
#define FILEMENU_CLOSE          "/ե/λ"
#define HELPMENU_BASE           "/إ"
#define HELPMENU_HELP           "/إ/CxpbackupˤĤ"

static GtkItemFactoryEntry menu_items[] = {
	{FILEMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{FILEMENU_CLOSE, "<control>Q", filemenu_response, FILEIACT_CLOSE,
	 NULL},
	{HELPMENU_BASE, NULL, NULL, 0, "<LastBranch>"},
	{HELPMENU_HELP, NULL, helpmenu_response, HELPIACT_HELP, NULL},
};

static char *backuptitle[1] = { "ǥ쥯ȥ"
};


static int cxpbackupfunc_close ()
{
	gtk_main_quit ();
}

static int cxpbackupTimer (gpointer data)
{

#ifdef	cxpbackup_step2
	if (cxpbackup->saveMode > 0)
	{
		showWindowAppend ();
	}
#endif
}

static void filemenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case FILEIACT_CLOSE:
		cxpbackupfunc_close ();
		break;
	}
}
static void helpmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case HELPIACT_HELP:
		cxpbackuphelpfunc_help ();
		break;
	}
}

cxpbackup_start ()
{
	GtkWidget *vbox1;
	GtkWidget *hbox1;
	GtkWidget *vbox2;
	GtkWidget *label1;
	GtkWidget *vbox3;
	GtkWidget *label2;
	GtkWidget *vbox4;
	GtkWidget *hbox2;
	GtkWidget *label5;
	GtkWidget *hbox3;
	GtkWidget *label6;
	GtkWidget *label7;
	GtkWidget *hbox4;
	GtkWidget *label8;
	GtkWidget *hbox5;
	GtkWidget *label9;
	GtkWidget *hbox7;
	GSList *hbox7_group = NULL;
	GtkWidget *hbox6;
	GtkWidget *label10;
	GtkWidget *compressMenu_menu;
	GtkWidget *glade_menuitem;
	GtkWidget *hbox8;
	GtkWidget *label13;
	GtkWidget *hbox9;
	GSList *hbox9_group = NULL;
	GtkWidget *label12;
	GtkWidget *label14;
	GtkWidget *hbox10;
	GtkWidget *label15;
	GtkWidget *deviceMenu_menu;
	GtkWidget *label16;
	GtkWidget *hbox11;
	GtkWidget *label3;
	GtkWidget *hbox12;
	GtkWidget *swin;
	GSList *compressGroup;
	GSList *deviceGroup;
	GtkItemFactory *item_factory;
	GtkAccelGroup *accel_group;
	int nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);
	int totalcount;
	int i;


	/* ǥ쥯ȥ */
	cxpbackup->root.count = 1;
	cxpbackup->root.bfinfo[0] = (BFINFO *) malloc (sizeof (BFINFO));
	memset (cxpbackup->root.bfinfo[0], 0x00, sizeof (BFINFO));
	cxpbackup->root.bfinfo[0]->view = DIR_VIEW_ON;
	getDirectoryInfo ("/", &(cxpbackup->root));


	cxpbackup->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (cxpbackup->window), "window",
			     cxpbackup->window);
	gtk_window_set_title (GTK_WINDOW (cxpbackup->window), "Cxpbackup");
	gtk_widget_set_usize (cxpbackup->window, 100, 100);
	gtk_window_set_default_size (GTK_WINDOW (cxpbackup->window), 540,
				     400);
	gtk_signal_connect (GTK_OBJECT (cxpbackup->window), "destroy",
			    GTK_SIGNAL_FUNC (cxpbackupfunc_close), NULL);
	gtk_timeout_add (500, (GtkFunction) cxpbackupTimer,
			 cxpbackup->window);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "vbox1",
				  vbox1, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (cxpbackup->window), vbox1);

	accel_group = gtk_accel_group_new ();

	item_factory =
		gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",
				      accel_group);

	gtk_item_factory_create_items (item_factory, nmenu_items, menu_items,
				       NULL);

	gtk_accel_group_attach (accel_group, GTK_OBJECT (cxpbackup->window));

	cxpbackup->menubar =
		gtk_item_factory_get_widget (item_factory, "<main>");
	gtk_box_pack_start (GTK_BOX (vbox1), cxpbackup->menubar, FALSE, FALSE,
			    0);
	gtk_widget_show (cxpbackup->menubar);

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "hbox1",
				  hbox1, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "vbox2",
				  vbox2, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (hbox1), vbox2, TRUE, TRUE, 5);

	label1 = gtk_label_new ("оݥե");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "label1",
				  label1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (vbox2), label1, FALSE, FALSE, 5);

	swin = gtk_scrolled_window_new (NULL, NULL);

	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_widget_show (swin);

	cxpbackup->dirList = gtk_clist_new_with_titles (1, backuptitle);
	gtk_widget_set_usize (cxpbackup->dirList, 200, 150);
	gtk_clist_set_selection_mode (GTK_CLIST (cxpbackup->dirList),
				      GTK_SELECTION_BROWSE);
	gtk_widget_set_usize (cxpbackup->dirList, 330, -2);

	/* ꥹȥХå */
	gtk_signal_connect (GTK_OBJECT (cxpbackup->dirList), "event",
			    GTK_SIGNAL_FUNC (dirListEventFunc), NULL);
	gtk_signal_connect (GTK_OBJECT (cxpbackup->dirList), "select_row",
			    GTK_SIGNAL_FUNC (dirListSelectionFunc), NULL);
	gtk_signal_connect (GTK_OBJECT (cxpbackup->dirList), "unselect_row",
			    GTK_SIGNAL_FUNC (dirListUnSelectionFunc), NULL);

	gtk_clist_column_title_passive (GTK_CLIST (cxpbackup->dirList), 0);

	gtk_container_add (GTK_CONTAINER (swin), cxpbackup->dirList);
	gtk_widget_show (cxpbackup->dirList);

	gtk_box_pack_start (GTK_BOX (vbox2), swin, TRUE, TRUE, 0);

	hbox12 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox12);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "hbox12",
				  hbox12,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox12);
	gtk_box_pack_start (GTK_BOX (vbox2), hbox12, FALSE, TRUE, 5);

	cxpbackup->selectBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (cxpbackup->selectBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "selectBtn",
				  cxpbackup->selectBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpbackup->selectBtn);
	gtk_box_pack_start (GTK_BOX (hbox12), cxpbackup->selectBtn, FALSE,
			    FALSE, 1);

	cxpbackup->unselectBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (cxpbackup->unselectBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window),
				  "unselectBtn", cxpbackup->unselectBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpbackup->unselectBtn);
	gtk_box_pack_start (GTK_BOX (hbox12), cxpbackup->unselectBtn, FALSE,
			    FALSE, 1);

	cxpbackup->allSelectBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (cxpbackup->allSelectBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window),
				  "allSelectBtn", cxpbackup->allSelectBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpbackup->allSelectBtn);
	gtk_box_pack_start (GTK_BOX (hbox12), cxpbackup->allSelectBtn, FALSE,
			    FALSE, 1);

	cxpbackup->allClearBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (cxpbackup->allClearBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window),
				  "allClearBtn", cxpbackup->allClearBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpbackup->allClearBtn);
	gtk_box_pack_start (GTK_BOX (hbox12), cxpbackup->allClearBtn, FALSE,
			    FALSE, 1);

	vbox3 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox3);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "vbox3",
				  vbox3, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox3);
	gtk_box_pack_start (GTK_BOX (hbox1), vbox3, TRUE, TRUE, 0);

	label2 = gtk_label_new ("    ");
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "label2",
				  label2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (vbox3), label2, FALSE, FALSE, 5);

	vbox4 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox4);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "vbox4",
				  vbox4, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox4);
	gtk_box_pack_start (GTK_BOX (vbox3), vbox4, TRUE, TRUE, 0);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "hbox2",
				  hbox2, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox4), hbox2, FALSE, TRUE, 0);

	label5 = gtk_label_new ("ǡ");
	gtk_widget_ref (label5);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "label5",
				  label5,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label5);
	gtk_box_pack_start (GTK_BOX (hbox2), label5, FALSE, FALSE, 0);

	hbox3 = gtk_hbox_new (TRUE, 5);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "hbox3",
				  hbox3, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox4), hbox3, FALSE, TRUE, 0);

	cxpbackup->keisanBtn = gtk_button_new_with_label (" ̷׻ ");
	gtk_widget_ref (cxpbackup->keisanBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "keisanBtn",
				  cxpbackup->keisanBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpbackup->keisanBtn);
	gtk_box_pack_start (GTK_BOX (hbox3), cxpbackup->keisanBtn, FALSE,
			    FALSE, 0);

	cxpbackup->sizeEntry = gtk_entry_new_with_max_length (20);
	gtk_widget_ref (cxpbackup->sizeEntry);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "sizeEntry",
				  cxpbackup->sizeEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_entry_set_editable (GTK_ENTRY (cxpbackup->sizeEntry), FALSE);

	gtk_entry_set_text (GTK_ENTRY (cxpbackup->sizeEntry), "0 Mbyte");

	gtk_widget_show (cxpbackup->sizeEntry);
	gtk_box_pack_start (GTK_BOX (hbox3), cxpbackup->sizeEntry, FALSE,
			    TRUE, 5);

	label7 = gtk_label_new ("    ");
	gtk_widget_ref (label7);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "label7",
				  label7,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label7);
	gtk_box_pack_start (GTK_BOX (vbox4), label7, TRUE, FALSE, 0);

	hbox4 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox4);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "hbox4",
				  hbox4, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox4);
	gtk_box_pack_start (GTK_BOX (vbox4), hbox4, FALSE, FALSE, 0);

	label8 = gtk_label_new ("ץ");
	gtk_widget_ref (label8);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "label8",
				  label8,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label8);
	gtk_box_pack_start (GTK_BOX (hbox4), label8, FALSE, FALSE, 0);

	hbox5 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox5);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "hbox5",
				  hbox5, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox5);
	gtk_box_pack_start (GTK_BOX (vbox4), hbox5, FALSE, TRUE, 0);

	label9 = gtk_label_new ("          ̵ǽ     ");
	gtk_widget_ref (label9);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "label9",
				  label9,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label9);
	gtk_box_pack_start (GTK_BOX (hbox5), label9, FALSE, FALSE, 0);

	hbox7 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox7);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "hbox7",
				  hbox7, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox7);
	gtk_box_pack_start (GTK_BOX (hbox5), hbox7, TRUE, TRUE, 0);

	cxpbackup->compRadioBtn1 =
		gtk_radio_button_new_with_label (hbox7_group, "");
	hbox7_group =
		gtk_radio_button_group (GTK_RADIO_BUTTON
					(cxpbackup->compRadioBtn1));
	gtk_widget_ref (cxpbackup->compRadioBtn1);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window),
				  "compRadioBtn1", cxpbackup->compRadioBtn1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpbackup->compRadioBtn1);
	gtk_box_pack_start (GTK_BOX (hbox7), cxpbackup->compRadioBtn1, FALSE,
			    FALSE, 0);

	cxpbackup->compRadioBtn2 =
		gtk_radio_button_new_with_label (hbox7_group, "ʤ");
	hbox7_group =
		gtk_radio_button_group (GTK_RADIO_BUTTON
					(cxpbackup->compRadioBtn2));
	gtk_widget_ref (cxpbackup->compRadioBtn2);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window),
				  "compRadioBtn2", cxpbackup->compRadioBtn2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpbackup->compRadioBtn2);
	gtk_box_pack_start (GTK_BOX (hbox7), cxpbackup->compRadioBtn2, FALSE,
			    FALSE, 0);

	hbox6 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox6);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "hbox6",
				  hbox6, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox6);
	gtk_box_pack_start (GTK_BOX (vbox4), hbox6, FALSE, TRUE, 0);

	label10 = gtk_label_new ("   ");
	gtk_widget_ref (label10);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "label10",
				  label10,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label10);
	gtk_box_pack_start (GTK_BOX (hbox6), label10, FALSE, FALSE, 0);

	cxpbackup->compressMenu = gtk_option_menu_new ();
	compressMenu_menu = gtk_menu_new ();

	compressGroup = NULL;
	/* compress menu */
	glade_menuitem =
		gtk_radio_menu_item_new_with_label (compressGroup, "gzip");
	gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
			    (GtkSignalFunc) compressRadioFunc,
			    (gpointer) NULL);
	compressGroup =
		gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM
					   (glade_menuitem));
	gtk_menu_append (GTK_MENU (compressMenu_menu), glade_menuitem);
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (glade_menuitem),
					TRUE);
	gtk_widget_show (glade_menuitem);

	/* compress menu */
	glade_menuitem =
		gtk_radio_menu_item_new_with_label (compressGroup,
						    "compress");
	gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
			    (GtkSignalFunc) compressRadioFunc,
			    (gpointer) NULL);
	compressGroup =
		gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM
					   (glade_menuitem));
	gtk_menu_append (GTK_MENU (compressMenu_menu), glade_menuitem);
	gtk_widget_show (glade_menuitem);

	gtk_option_menu_set_menu (GTK_OPTION_MENU (cxpbackup->compressMenu),
				  compressMenu_menu);
	gtk_widget_show (compressMenu_menu);
	gtk_widget_show (cxpbackup->compressMenu);
	gtk_box_pack_start (GTK_BOX (hbox6), cxpbackup->compressMenu, FALSE,
			    FALSE, 0);


#ifdef	cxpbackup_step2
	hbox8 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox8);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "hbox8",
				  hbox8, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox8);
	gtk_box_pack_start (GTK_BOX (vbox4), hbox8, FALSE, FALSE, 0);

	label13 = gtk_label_new ("          ɽ     ");
	gtk_widget_ref (label13);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "label13",
				  label13,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label13);
	gtk_box_pack_start (GTK_BOX (hbox8), label13, FALSE, FALSE, 0);

	hbox9 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox9);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "hbox9",
				  hbox9, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox9);
	gtk_box_pack_start (GTK_BOX (hbox8), hbox9, TRUE, TRUE, 0);

	cxpbackup->viewRadioBtn1 =
		gtk_radio_button_new_with_label (hbox9_group, "");
	hbox9_group =
		gtk_radio_button_group (GTK_RADIO_BUTTON
					(cxpbackup->viewRadioBtn1));
	gtk_widget_ref (cxpbackup->viewRadioBtn1);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window),
				  "viewRadioBtn1", cxpbackup->viewRadioBtn1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpbackup->viewRadioBtn1);
	gtk_box_pack_start (GTK_BOX (hbox9), cxpbackup->viewRadioBtn1, FALSE,
			    FALSE, 0);

	cxpbackup->viewRadioBtn2 =
		gtk_radio_button_new_with_label (hbox9_group, "ʤ");
	hbox9_group =
		gtk_radio_button_group (GTK_RADIO_BUTTON
					(cxpbackup->viewRadioBtn2));
	gtk_widget_ref (cxpbackup->viewRadioBtn2);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window),
				  "viewRadioBtn2", cxpbackup->viewRadioBtn2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpbackup->viewRadioBtn2);
	gtk_box_pack_start (GTK_BOX (hbox9), cxpbackup->viewRadioBtn2, FALSE,
			    FALSE, 0);
#endif


	label12 = gtk_label_new ("    ");
	gtk_widget_ref (label12);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "label12",
				  label12,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label12);
	gtk_box_pack_start (GTK_BOX (vbox4), label12, TRUE, FALSE, 0);

	label14 = gtk_label_new ("   ");
	gtk_widget_ref (label14);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "label14",
				  label14,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label14);
	gtk_box_pack_start (GTK_BOX (vbox4), label14, TRUE, FALSE, 0);

	hbox10 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox10);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "hbox10",
				  hbox10,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox10);
	gtk_box_pack_start (GTK_BOX (vbox4), hbox10, FALSE, TRUE, 0);

	label15 = gtk_label_new ("   ");
	gtk_widget_ref (label15);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "label15",
				  label15,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label15);
	gtk_box_pack_start (GTK_BOX (hbox10), label15, FALSE, FALSE, 0);


	cxpbackup->deviceMenu = gtk_option_menu_new ();
	deviceMenu_menu = gtk_menu_new ();

	deviceGroup = NULL;
	for (i = 0; i < cxpbackup->devinf.device_kensu; i++)
	{
		if (cxpbackup->devinf.device[i].backupFlag == 1)
			continue;
		glade_menuitem =
			gtk_radio_menu_item_new_with_label (deviceGroup,
							    cxpbackup->
							    devinf.
							    device[i].name);
		gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
				    (GtkSignalFunc) deviceRadioFunc,
				    (gpointer) NULL);
		deviceGroup =
			gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM
						   (glade_menuitem));
		gtk_menu_append (GTK_MENU (deviceMenu_menu), glade_menuitem);
		if (i == 0)
			gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
							(glade_menuitem),
							TRUE);
		gtk_widget_show (glade_menuitem);
	}

	gtk_option_menu_set_menu (GTK_OPTION_MENU (cxpbackup->deviceMenu),
				  deviceMenu_menu);
	gtk_widget_show (deviceMenu_menu);
	gtk_widget_show (cxpbackup->deviceMenu);
	gtk_box_pack_start (GTK_BOX (hbox10), cxpbackup->deviceMenu, FALSE,
			    FALSE, 0);


	label16 = gtk_label_new ("   ");
	gtk_widget_ref (label16);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "label16",
				  label16,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label16);
	gtk_box_pack_start (GTK_BOX (vbox4), label16, TRUE, FALSE, 0);

	hbox11 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox11);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "hbox11",
				  hbox11,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox11);
	gtk_box_pack_start (GTK_BOX (vbox4), hbox11, FALSE, TRUE, 0);

	cxpbackup->startBtn =
		gtk_button_new_with_label ("  Хåå׳  ");
	gtk_widget_ref (cxpbackup->startBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "startBtn",
				  cxpbackup->startBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpbackup->startBtn);
	gtk_box_pack_start (GTK_BOX (hbox11), cxpbackup->startBtn, FALSE,
			    FALSE, 0);

#if 0
	cxpbackup->endBtn = gtk_button_new_with_label ("  λ  ");
	gtk_widget_ref (cxpbackup->endBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "endBtn",
				  cxpbackup->endBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpbackup->endBtn);
	gtk_box_pack_start (GTK_BOX (hbox11), cxpbackup->endBtn, FALSE, FALSE,
			    0);
#endif

	label3 = gtk_label_new ("   ");
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (cxpbackup->window), "label3",
				  label3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_box_pack_start (GTK_BOX (vbox3), label3, FALSE, FALSE, 8);

	/* ꥹȥܥ󥳡Хå */
	gtk_signal_connect_object (GTK_OBJECT (cxpbackup->selectBtn),
				   "clicked",
				   (GtkSignalFunc) dirListSelectBtnFunc, 0);
	gtk_signal_connect_object (GTK_OBJECT (cxpbackup->unselectBtn),
				   "clicked",
				   (GtkSignalFunc) dirListUnSelectBtnFunc, 0);
	gtk_signal_connect_object (GTK_OBJECT (cxpbackup->allSelectBtn),
				   "clicked",
				   (GtkSignalFunc) dirListAllSelectBtnFunc,
				   0);
	gtk_signal_connect_object (GTK_OBJECT (cxpbackup->allClearBtn),
				   "clicked",
				   (GtkSignalFunc) dirListAllClearBtnFunc, 0);

	/* ̷׻ܥ󥳡Хå */
	gtk_signal_connect_object (GTK_OBJECT (cxpbackup->keisanBtn),
				   "clicked", (GtkSignalFunc) keisanBtnFunc,
				   0);

	/* ֳ/λܥ󥳡Хå */
	gtk_signal_connect_object (GTK_OBJECT (cxpbackup->startBtn),
				   "clicked", (GtkSignalFunc) startBtnFunc,
				   0);


	/* ǥ쥯ȥɽ */
	totalcount = 0;
	printBackupDirectory (&cxpbackup->root, -1, &totalcount);

	gtk_widget_show (cxpbackup->window);

}
