/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpbackup.h"

extern CxpBackup    *cxpbackup;

int checkDirectoryInfo( dirname )
char *dirname ;
{
    DIR     *dfd;
    struct dirent *dp ;
    char    pathname[256] ;
    int     i, k ;
    struct stat fileinfo ;

    /*-- ǥ쥯ȥΥץ --*/
    if ( (dfd = opendir(dirname)) == NULL )
	return(-1);

    /*-- ǥ쥯ȥɤ߹ --*/
    k = 0 ;
    for(i=0; (dp = readdir(dfd)) != NULL; i++)
    {
	if ( !strcmp( dp->d_name, "." ) || !strcmp( dp->d_name, "..") )
	    continue ;

	if ( strcmp( dirname,"/" ) == 0 )
	    sprintf( pathname,"%s%s", dirname, dp->d_name );
	else
	    sprintf( pathname,"%s/%s", dirname, dp->d_name );
	stat( pathname, &fileinfo );

	/* ǥ쥯ȥǤʤϽʤ */
	if ( !S_ISDIR( fileinfo.st_mode ) )
	    continue ;

	k++;
    }

    /*-- ǥ쥯ȥΥ --*/
    closedir(dfd);

    return(k);
}

static int __getDirectoryInfo( dirname, dinfo )
char *dirname ;
BDINFO   *dinfo ;
{
    DIR     *dfd;
    struct dirent *dp ;
    char    pathname[1024] ;
    char    checkname[1024] ;
    int     i, status ;
    struct stat fileinfo ;
    int     viewFlag ;

    /*-- ǥ쥯ȥΥץ --*/
    if ( (dfd = opendir(dirname)) == NULL )
    {
	fprintf(stderr,"Directory open error : [%s]\n", dirname);
	return(-1);
    }

    /*-- ǥ쥯ȥɤ߹ --*/
    dinfo->count = 0 ;
    for(i=0; (dp = readdir(dfd)) != NULL; i++)
    {
	if ( !strcmp( dp->d_name, "." ) || !strcmp( dp->d_name, "..") )
	    continue ;

	if ( strcmp( dirname,"/" ) == 0 )
	    sprintf( pathname,"%s%s", dirname, dp->d_name );
	else
	    sprintf( pathname,"%s/%s", dirname, dp->d_name );
	stat( pathname, &fileinfo );

	/* ǥ쥯ȥǤʤϽʤ */
	if ( !S_ISDIR( fileinfo.st_mode ) )
	    continue ;

	if ( dinfo->bfinfo[dinfo->count] == (BFINFO *)NULL )
	{
	    dinfo->bfinfo[dinfo->count] = (BFINFO *)malloc( sizeof(BFINFO) );
	    memset( dinfo->bfinfo[dinfo->count], 0x00, sizeof(BFINFO) );
	    dinfo->bfinfo[(dinfo->count)]->view = DIR_VIEW_NONE;
	}

	/* ǥ쥯ȥμ */
	dinfo->bfinfo[dinfo->count]->fname = g_strdup(pathname);
	(dinfo->count)++;

	status = checkDirectoryInfo( pathname );
	if ( status > 0 )
	{
	    if ( dinfo->bfinfo[(dinfo->count)-1]->view == DIR_VIEW_ON )
	    {
		/* ONä鲼γؤ */
		if ( dinfo->bfinfo[(dinfo->count)-1]->next == NULL )
		{
		    dinfo->bfinfo[(dinfo->count)-1]->next = (BDINFO *)malloc( sizeof(BDINFO) );
		    memset(dinfo->bfinfo[(dinfo->count)-1]->next, 0x00, sizeof(BDINFO) );
	        }

		__getDirectoryInfo( pathname, dinfo->bfinfo[(dinfo->count)-1]->next );

	    }else{
		if ( dinfo->bfinfo[(dinfo->count)-1]->next == NULL )
		{
		    dinfo->bfinfo[(dinfo->count)-1]->next = (BDINFO *)malloc( sizeof(BDINFO) );
		    memset(dinfo->bfinfo[(dinfo->count)-1]->next, 0x00, sizeof(BDINFO) );
		    dinfo->bfinfo[(dinfo->count)-1]->view = DIR_VIEW_OFF;
	        }
	    }

	    if (dinfo->bfinfo[(dinfo->count)-1]->view != DIR_VIEW_ON)
		dinfo->bfinfo[(dinfo->count)-1]->view = DIR_VIEW_OFF;
	}else{
	    if ( dinfo->bfinfo[(dinfo->count)-1]->next != NULL )
	    {
		free( dinfo->bfinfo[(dinfo->count)-1]->next );
	    }
	    dinfo->bfinfo[(dinfo->count)-1]->view = DIR_VIEW_NONE ;
	    dinfo->bfinfo[(dinfo->count)-1]->next = NULL ;
	}
    }

    /*-- ǥ쥯ȥΥ --*/
    closedir(dfd);

    return(0);
}

int getDirectoryInfo( dirname, dinfo )
char *dirname ;
BDINFO   *dinfo ;
{
    int     status ;
    char    pathname[1024] ;
    struct stat fileinfo ;

    if ( strcmp(dirname,"/") == 0 )
    {
	sprintf( pathname, "/" );
	stat( pathname, &fileinfo );

	/* 롼ȥǥ쥯ȥμ */
	(dinfo->count) = 0 ;

	if ( dinfo->bfinfo[dinfo->count] == (BFINFO *)NULL )
	{
	    dinfo->bfinfo[dinfo->count] = (BFINFO *)malloc( sizeof(BFINFO) );
	    memset( dinfo->bfinfo[dinfo->count], 0x00, sizeof(BFINFO) );
	}

	dinfo->bfinfo[dinfo->count]->fname = g_strdup(pathname);
	(dinfo->count)++;

	if ( dinfo->bfinfo[(dinfo->count)-1]->next == NULL )
	{
	    dinfo->bfinfo[(dinfo->count)-1]->next = (BDINFO *)malloc( sizeof(BDINFO) );
	    memset( dinfo->bfinfo[(dinfo->count)-1]->next,0x00, sizeof(BDINFO));
	}

	dinfo->bfinfo[(dinfo->count)-1]->view = DIR_VIEW_ON ;
	status = __getDirectoryInfo( pathname, dinfo->bfinfo[(dinfo->count)-1]->next );
    }else{
	status = __getDirectoryInfo( dirname, dinfo ) ;
    }
    return(status);
}

printBackupDirectory( dinfo, next, totalcount )
BDINFO		*dinfo ;
int		next ;
int		*totalcount ;
{
    GdkPixmap   *pixmap ;
    GdkBitmap   *mask;
    GtkStyle    *style;
    char        *pixname ;
    char buffname[256], setname[512] ;
    char	*dirname[2];
    char	*ptr ;
    int		i, k ;
    int		nx = next + 1;

    for(i=0;i<dinfo->count;i++)
    {
	strcpy( buffname, dinfo->bfinfo[i]->fname );
	ptr = strrchr( buffname, '/' );
	if ( strcmp( buffname, "/" ) == 0 )
	    ptr = NULL ;

	if ( ptr == NULL )
	    sprintf( setname, "%s", buffname );
	else
	    sprintf( setname, "%s", ptr+1 );

	dirname[0] = g_strdup( setname );

	gtk_clist_append( GTK_CLIST(cxpbackup->dirList), dirname );

	style = gtk_widget_get_style( cxpbackup->window );
	if ( dinfo->bfinfo[i]->select == DIR_VIEW_SELECT )
	    pixname = cxpbackup->base.selecton ;
	else
	if ( dinfo->bfinfo[i]->select == DIR_VIEW_SUBSELECT )
	    pixname = cxpbackup->base.selectsub ;
	else
	    pixname = cxpbackup->base.selectoff ;

	pixmap = gdk_pixmap_create_from_xpm_d(
			cxpbackup->window->window,
			&mask, &style->bg[GTK_STATE_NORMAL],
			(gchar **)MakeXPMdataByBackup(pixname, nx ) );

#ifdef DEBUG8
fprintf(stdout,"totalcount [%d] setname [%s]\n",(*totalcount), setname );
#endif
	gtk_clist_set_pixtext( GTK_CLIST(cxpbackup->dirList),
			(*totalcount),  /* row    */
			0,              /* collum */
			setname,        /* text   */
			2,              /* spacing size */
			pixmap,         /* pixmap */
			mask );         /* mask */

	dinfo->bfinfo[i]->row = (*totalcount) ;
	(*totalcount)++;

	if ( dinfo->bfinfo[i]->view == DIR_VIEW_ON )
	{
	    if ( dinfo->bfinfo[i]->next != NULL )
	    {
		printBackupDirectory( (BDINFO *)dinfo->bfinfo[i]->next, nx, totalcount );
	    }
	}
    }
}

BFINFO *getDirectoryInfoRow( dinfo, row )
BDINFO		*dinfo ;
int		row ;
{
    int     i, k ;

    for(i=0;i<dinfo->count;i++)
    {
	if ( dinfo->bfinfo[i]->row == row )
	    return( (BFINFO *)dinfo->bfinfo[i] ) ;

	if ( dinfo->bfinfo[i]->view == DIR_VIEW_ON )
	{
	    if ( dinfo->bfinfo[i]->next != NULL )
	    {
		BFINFO *bfinfo ;

		bfinfo = (BFINFO *)getDirectoryInfoRow(
				(BDINFO *)dinfo->bfinfo[i]->next, row);
		if ( bfinfo != (BFINFO *)NULL )
		    return(bfinfo);
	    }
	}
    }
    return( (BFINFO *)NULL );
}
