/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */   
 
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpbackup.h"

extern CxpBackup    *cxpbackup;

static GtkWidget *errorWin ;
static GtkWidget *errorList;

static char *errortitle[1] = { \
	"顼" };

static void error_destroy(GtkWidget *widget, gpointer data)
{
  /* ɥϥɤ */
  gtk_grab_remove ( errorWin );
  gtk_widget_hide( errorWin );
  errorWin = (GtkWidget *)NULL ;
}


errorView ( char *message )
{
  GtkWidget *vbox1;
  GtkWidget *swin;
  GtkWidget *hbox2;
  GtkWidget *errorLabel;
  GtkWidget *hbox3;
  GtkWidget *hbox1;
  GtkWidget *canBtn;
  int x,y,w,h ;

  w = gdk_screen_width();
  h = gdk_screen_height();
  x = w * 0.5;
  y = h * 0.5;

  if ( errorWin != (GtkWidget *)NULL )
  {
        gtk_grab_remove ( errorWin );
        gtk_widget_hide( errorWin );
  }

  errorWin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (errorWin), "errorWin", errorWin);
  gtk_widget_set_usize (errorWin, 460, 400);
  gtk_window_set_title (GTK_WINDOW (errorWin), "顼å");
  gtk_window_set_modal (GTK_WINDOW (errorWin), TRUE);
  gtk_widget_set_uposition(errorWin, (x - 460*0.5), (y - 400*0.5));
  gtk_widget_show (errorWin);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (errorWin), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (errorWin), vbox1);

  hbox2 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (errorWin), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, TRUE, 10);

  errorLabel = gtk_label_new ( message );
  gtk_widget_ref (errorLabel);
  gtk_object_set_data_full (GTK_OBJECT (errorWin), "errorLabel", errorLabel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (errorLabel);
  gtk_box_pack_start (GTK_BOX (hbox2), errorLabel, FALSE, FALSE, 0);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox3);
  gtk_object_set_data_full (GTK_OBJECT (errorWin), "hbox3", hbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox3, TRUE, TRUE, 1);

  swin = gtk_scrolled_window_new(NULL, NULL);
  
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
        GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show(swin);
  
  errorList = gtk_clist_new_with_titles(1, errortitle );
  gtk_widget_set_usize(errorList, 200, 200);
  gtk_clist_set_selection_mode( GTK_CLIST(errorList), GTK_SELECTION_BROWSE );
  
  gtk_clist_column_title_passive( GTK_CLIST(errorList), 0 );
  
  gtk_container_add(GTK_CONTAINER(swin), errorList);
  gtk_widget_show(errorList);
  
  gtk_box_pack_start (GTK_BOX (hbox3), swin,  TRUE, TRUE, 0);

  hbox1 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (errorWin), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 5);

  canBtn = gtk_button_new_with_label (" Ĥ ");
  gtk_widget_ref (canBtn);
  gtk_object_set_data_full (GTK_OBJECT (errorWin), "canBtn", canBtn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (canBtn);
  gtk_box_pack_start (GTK_BOX (hbox1), canBtn, FALSE, FALSE, 0);

  gtk_signal_connect_object (GTK_OBJECT (canBtn), "clicked",
                        (GtkSignalFunc) error_destroy,
                        GTK_OBJECT (errorWin));

  gtk_signal_connect(GTK_OBJECT(errorWin), "destroy",
                     GTK_SIGNAL_FUNC(error_destroy), NULL);

}

errorAppend ( char *message )
{
    char *messlabel[2];

    messlabel[0] = g_strdup(message);
    gtk_clist_append( GTK_CLIST(errorList), messlabel );

}
