/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpbackup.h"

extern CxpBackup    *cxpbackup;

int dirListEventFunc( GtkWidget *widget, GdkEvent *event)
{
    BFINFO              *bfinfo ;
    GdkEventButton      *bevent = (GdkEventButton *) event;
    GdkEventKey         *kevent = (GdkEventKey *) event;
    int                 row, column, totalcount ;
    char                *ptr, *ptr2 ;
    time_t              checkTime ;
    static time_t       oldTime = (time_t)0 ;
    static char         *oldName = (char *)"" ;

    if (event->type == GDK_BUTTON_PRESS)
    {
	gtk_clist_get_selection_info( GTK_CLIST(cxpbackup->dirList),
		bevent->x, bevent->y, &row, &column );
    }else
	return FALSE ;

    if ( row < 0 )
    {
	/* ٥Ȥ̲ᤵ */
	return FALSE ;
    }

    bfinfo = (BFINFO *)getDirectoryInfoRow( &cxpbackup->root, row );
    if ( bfinfo == (BFINFO *)NULL )
    {
	/* ٥Ȥ̲ᤵ */
	return FALSE ;
    }

    if (event->type == GDK_BUTTON_PRESS)
    {
	if ( bevent->button == 1 )
	{
	    /* ֤ */
	    checkTime = time(0);

	    /* ֤Ʊǥե̾ƱŸ */
	    if ( checkTime == oldTime && strcmp(bfinfo->fname, oldName) == 0 )
	    {
		if ( bfinfo->view == DIR_VIEW_ON )
		{
		    bfinfo->view = DIR_VIEW_OFF ;

		    cxpbackup->currentViewFlag = 1 ;

		    gtk_clist_freeze( GTK_CLIST(cxpbackup->dirList) );
		    gtk_clist_clear( GTK_CLIST(cxpbackup->dirList) );
		    totalcount = 0 ;
		    printBackupDirectory( &cxpbackup->root, -1, &totalcount );

		    /* ɽ֤򹹿 */
		    gtk_clist_select_row( GTK_CLIST(cxpbackup->dirList), row, 0 );
		    cxpbackup->selectrow = row ;

		    /* ɽ濴 */
		    gtk_clist_moveto( GTK_CLIST(cxpbackup->dirList),
				row, 0, (gfloat)0.5, (gfloat)0.0 );

		    gtk_clist_thaw( GTK_CLIST(cxpbackup->dirList) );

		    cxpbackup->currentViewFlag = 0 ;

		    return(TRUE);
		}else
		if ( bfinfo->view == DIR_VIEW_OFF )
		{
		    bfinfo->view = DIR_VIEW_ON ;

		    cxpbackup->currentViewFlag = 1 ;

		    gtk_clist_freeze( GTK_CLIST(cxpbackup->dirList) );
		    gtk_clist_clear( GTK_CLIST(cxpbackup->dirList) );

		    if ( strcmp( bfinfo->fname, "/" ) == 0 )
			getDirectoryInfo( bfinfo->fname, &cxpbackup->root );
		    else
			getDirectoryInfo( bfinfo->fname, bfinfo->next );

		    totalcount = 0 ;
		    printBackupDirectory( &cxpbackup->root, -1, &totalcount );

		    /* ɽ֤򹹿 */
		    gtk_clist_select_row( GTK_CLIST(cxpbackup->dirList), row, 0 );
		    cxpbackup->selectrow = row ;

		    /* ɽ濴 */
		    gtk_clist_moveto( GTK_CLIST(cxpbackup->dirList),
				row, 0, (gfloat)0.5, (gfloat)0.0 );

		    gtk_clist_thaw( GTK_CLIST(cxpbackup->dirList) );

		    cxpbackup->currentViewFlag = 0 ;

		    return(TRUE);
		}else{
		    return(FALSE);
		}
	    }

	    oldTime = checkTime ;
	    oldName = g_strdup(bfinfo->fname) ;
	}
    }

    return FALSE ;
}

int dirListSelectionFunc( clist, row, column, event, data )
GtkWidget      *clist ;
gint            row ;
gint            column ;
GdkEventButton *event ;
gpointer        data ;
{
    BFINFO	*bfinfo ;
    int		totalcount ;

    if ( row < 0 )
	return(0) ;

    if ( cxpbackup->currentViewFlag == 1 )
	return(0);

    cxpbackup->selectrow = row ;

    return(0);
}

int dirListUnSelectionFunc( clist, row, column, event, data )
GtkWidget      *clist ;
gint            row ;
gint            column ;
GdkEventButton *event ;
gpointer        data ;
{
    if ( cxpbackup->currentViewFlag == 1 )
	return(0);

    /* 򥯥ꥢ */
    cxpbackup->selectrow = -1 ;

    return(0);
}

static int nextSetSelectionFlag( BDINFO *bdinfo, int selection )
{
    int i ;

    if ( bdinfo == (BDINFO *)NULL )
	return(0) ;

    for(i=0;i<bdinfo->count;i++)
    {
	bdinfo->bfinfo[i]->select = selection ;
	nextSetSelectionFlag( (BDINFO *)bdinfo->bfinfo[i]->next, selection );
    }

    return(0);
}

int dirListSelectBtnFunc(GtkWidget *widget, gpointer data)
{
    BFINFO	*bfinfo ;
    int		totalcount ;
    int		i ;

    if ( cxpbackup->selectrow < 0 )
	return(0);

    bfinfo = (BFINFO *)getDirectoryInfoRow( &cxpbackup->root,
		cxpbackup->selectrow );
    if ( bfinfo == (BFINFO *)NULL )
	return(0);

    bfinfo->select = DIR_VIEW_SELECT ;
    nextSetSelectionFlag( (BDINFO *)bfinfo->next, bfinfo->select );

    /* Ƥ⹹ */
    ownerSelectionUpdate();

    cxpbackup->currentViewFlag = 1 ;

    gtk_clist_freeze( GTK_CLIST(cxpbackup->dirList) );
    gtk_clist_clear( GTK_CLIST(cxpbackup->dirList) );
    totalcount = 0 ;
    printBackupDirectory( &cxpbackup->root, -1, &totalcount );

    /* ɽ֤򹹿 */
    gtk_clist_select_row( GTK_CLIST(cxpbackup->dirList),
		cxpbackup->selectrow, 0 );

    /* ɽ濴 */
    gtk_clist_moveto( GTK_CLIST(cxpbackup->dirList),
	cxpbackup->selectrow, 0, (gfloat)0.5, (gfloat)0.0 );

    gtk_clist_thaw( GTK_CLIST(cxpbackup->dirList) );

    cxpbackup->currentViewFlag = 0 ;

    return(0);
}

int dirListUnSelectBtnFunc(GtkWidget *widget, gpointer data)
{
    BFINFO	*bfinfo ;
    int		totalcount ;

    if ( cxpbackup->selectrow < 0 )
	return(0);

    bfinfo = (BFINFO *)getDirectoryInfoRow( &cxpbackup->root,
		cxpbackup->selectrow );
    if ( bfinfo == (BFINFO *)NULL )
	return(0);

    bfinfo->select = DIR_VIEW_UNSELECT ;
    nextSetSelectionFlag( (BDINFO *)bfinfo->next, bfinfo->select );

    /* Ƥ⹹ */
    ownerSelectionUpdate();

    cxpbackup->currentViewFlag = 1 ;

    gtk_clist_freeze( GTK_CLIST(cxpbackup->dirList) );
    gtk_clist_clear( GTK_CLIST(cxpbackup->dirList) );
    totalcount = 0 ;
    printBackupDirectory( &cxpbackup->root, -1, &totalcount );

    /* ɽ֤򹹿 */
    gtk_clist_select_row( GTK_CLIST(cxpbackup->dirList),
		cxpbackup->selectrow, 0 );

    /* ɽ濴 */
    gtk_clist_moveto( GTK_CLIST(cxpbackup->dirList),
	cxpbackup->selectrow, 0, (gfloat)0.5, (gfloat)0.0 );

    gtk_clist_thaw( GTK_CLIST(cxpbackup->dirList) );

    cxpbackup->currentViewFlag = 0 ;


    return(0);
}

int dirListAllSelectBtnFunc(GtkWidget *widget, gpointer data)
{
    BFINFO	*bfinfo ;
    int		totalcount ;
    int		i ;

    if ( cxpbackup->selectrow < 0 )
	return(0);

    bfinfo = cxpbackup->root.bfinfo[0] ;

    bfinfo->select = DIR_VIEW_SELECT ;
    nextSetSelectionFlag( (BDINFO *)bfinfo->next, bfinfo->select );

    cxpbackup->currentViewFlag = 1 ;

    gtk_clist_freeze( GTK_CLIST(cxpbackup->dirList) );
    gtk_clist_clear( GTK_CLIST(cxpbackup->dirList) );
    totalcount = 0 ;
    printBackupDirectory( &cxpbackup->root, -1, &totalcount );

    /* ɽ֤򹹿 */
    gtk_clist_select_row( GTK_CLIST(cxpbackup->dirList),
		cxpbackup->selectrow, 0 );

    /* ɽ濴 */
    gtk_clist_moveto( GTK_CLIST(cxpbackup->dirList),
	cxpbackup->selectrow, 0, (gfloat)0.5, (gfloat)0.0 );

    gtk_clist_thaw( GTK_CLIST(cxpbackup->dirList) );

    cxpbackup->currentViewFlag = 0 ;

    return(0);
}


int dirListAllClearBtnFunc(GtkWidget *widget, gpointer data)
{
    BFINFO	*bfinfo ;
    int		totalcount ;
    int		i ;

    if ( cxpbackup->selectrow < 0 )
	return(0);

    bfinfo = cxpbackup->root.bfinfo[0] ;

    bfinfo->select = DIR_VIEW_UNSELECT ;
    nextSetSelectionFlag( (BDINFO *)bfinfo->next, bfinfo->select );

    cxpbackup->currentViewFlag = 1 ;

    gtk_clist_freeze( GTK_CLIST(cxpbackup->dirList) );
    gtk_clist_clear( GTK_CLIST(cxpbackup->dirList) );
    totalcount = 0 ;
    printBackupDirectory( &cxpbackup->root, -1, &totalcount );

    /* ɽ֤򹹿 */
    gtk_clist_select_row( GTK_CLIST(cxpbackup->dirList),
		cxpbackup->selectrow, 0 );

    /* ɽ濴 */
    gtk_clist_moveto( GTK_CLIST(cxpbackup->dirList),
	cxpbackup->selectrow, 0, (gfloat)0.5, (gfloat)0.0 );

    gtk_clist_thaw( GTK_CLIST(cxpbackup->dirList) );

    cxpbackup->currentViewFlag = 0 ;

    return(0);
}

static double directoryKeisan( char *dirname )
{
    FILE *fp ;
    double tsize ;
    int size ;
    int     i, k ;
    char workbuff[1024];
    char workname[1024];
    char backupsize[1024];
#ifdef	DISK_NATIVE_SEARCH
    DIR     *dfd;
    struct dirent *dp ;
    char    pathname[512] ;
    struct stat fileinfo ;
#endif

    tsize = 0.0 ;

#ifdef	DISK_NATIVE_SEARCH
    if ( (dfd = opendir(dirname)) == NULL )
	return(tsize);

    for(i=0; (dp = readdir(dfd)) != NULL; i++)
    {
	if ( !strcmp( dp->d_name, "." ) || !strcmp( dp->d_name, "..") )
	    continue ;

	if ( strcmp( dirname,"/" ) == 0 )
	    sprintf( pathname,"%s%s", dirname, dp->d_name );
	else
	    sprintf( pathname,"%s/%s", dirname, dp->d_name );
	stat( pathname, &fileinfo );


	if ( S_ISDIR( fileinfo.st_mode ) )
	{
	    if ( S_ISLNK( fileinfo.st_mode ) )
	    {
		size = 0 ;
	    }else{
		/* ǥ쥯ȥξˤϤβ׻ */
		size = directoryKeisan( pathname );
	    }
	}else
	if ( S_ISREG( fileinfo.st_mode ) )
	{
	    size = fileinfo.st_size ;
	}else{
	    size = 0 ;
	}
	tsize += (double)size ;
    }

    closedir(dfd);
#else
    sprintf( backupsize, "/tmp/.cxpbackupsize.%d", cxpbackup->uid );
    sprintf( workbuff, "du -sk \"%s\" > %s 2>/dev/null", dirname, backupsize );
    cxpbackup->savePid = -1 ;
    system(workbuff);

    if ( (fp = fopen(backupsize,"r")) == (FILE *)NULL )
	return(tsize);

    fgets( workbuff, sizeof(workbuff), fp);
    sscanf( workbuff, "%d %s", &size, &workname );
    tsize = (double)size * 1024.0 ;
    remove(backupsize);
#endif

    return(tsize);
}

static double nextKeisan( BDINFO *bdinfo )
{
    int    i ;
    double tsize ;
    int    size ;

    tsize = 0.0 ;

    if ( bdinfo == (BDINFO *)NULL )
	return(tsize) ;

    for(i=0;i<bdinfo->count;i++)
    {
	if ( bdinfo->bfinfo[i]->select == DIR_VIEW_SELECT )
	{
	    size = directoryKeisan( bdinfo->bfinfo[i]->fname );
	}else
	if ( bdinfo->bfinfo[i]->select == DIR_VIEW_SUBSELECT )
	{
	    size = nextKeisan( (BDINFO *)bdinfo->bfinfo[i]->next );
	}else
	    continue ;

	tsize += (double)size ;
    }

    return(tsize);
}

int keisanBtnFunc(GtkWidget *widget, gpointer data)
{
    BFINFO	*bfinfo ;
    double	totalsize ;
    double	dsize ;
    char	sizeBuffer[256];
    int		i ;

    totalsize = 0 ;
    bfinfo = cxpbackup->root.bfinfo[0] ;
    totalsize = (double)nextKeisan( (BDINFO *)bfinfo->next );

#ifdef	DEBUG8
fprintf(stdout,"size -> %lf\n", totalsize );
#endif

    dsize = totalsize / 1024 ;
    if ( dsize > 1024 )
    {
	dsize = totalsize / (1024 * 1024) ;
	sprintf( sizeBuffer,"%d Mbyte", (int)dsize );
    }else
    if ( totalsize < 1024 )
    {
	sprintf( sizeBuffer,"%d byte", (int)totalsize );
    }else{
	sprintf( sizeBuffer,"%d Kbyte", (int)dsize );
    }
    gtk_entry_set_text(GTK_ENTRY(cxpbackup->sizeEntry),  sizeBuffer );

    return(0);
}


static int __ownerSelectionUpdate( BDINFO *bdinfo )
{
    int    i ;
    int    status ;
    int    kensu, skensu ;

    /*
     * status : 0 : ̤
     *          1 : 
     *          2 : 
     *         -1 : OWNERƱ
     */

    skensu = 0 ;
    kensu = 0 ;
    status = 0 ;


    if ( bdinfo == (BDINFO *)NULL )
	return(-1) ;

    for(i=0;i<bdinfo->count;i++)
    {
	if ( bdinfo->bfinfo[i]->next != NULL )
	{
	    status = __ownerSelectionUpdate( (BDINFO *)bdinfo->bfinfo[i]->next );
	    switch( status )
	    {
		case 0 :
			bdinfo->bfinfo[i]->select = DIR_VIEW_UNSELECT ;
			break ;
		case 1 :
			bdinfo->bfinfo[i]->select = DIR_VIEW_SELECT ;
			break ;
		case 2 :
			bdinfo->bfinfo[i]->select = DIR_VIEW_SUBSELECT ;
			break ;
		case -1 :
		default :
			break;
	    }
	}

	if ( bdinfo->bfinfo[i]->select == DIR_VIEW_SELECT )
		kensu ++;
	if ( bdinfo->bfinfo[i]->select == DIR_VIEW_SUBSELECT )
		skensu ++;
    }

    if ( bdinfo->count != 0 && kensu == 0 && skensu == 0 )
    {
	status = 0 ;
    }else
    if ( kensu == 0 && skensu == 0 )
    {
	status = -1 ;
    }else
    if ( kensu == bdinfo->count )
    {
	status = 1 ;
    }else{
	status = 2 ;
    }

#ifdef	DEBUG8
fprintf(stdout,"  __owner status [%2d] count [%d] kensu [%d]\n", status, bdinfo->count, kensu );
#endif

    return(status);
}

int ownerSelectionUpdate()
{
    BFINFO *bfinfo ;
    int status ;

    bfinfo = cxpbackup->root.bfinfo[0] ;
    status = __ownerSelectionUpdate( (BDINFO *)bfinfo->next );

#ifdef	DEBUG8
fprintf(stdout,"ownerSelectionUpdate status -> %d\n", status );
#endif

    switch( status )
    {
	case 0 :
		bfinfo->select = DIR_VIEW_UNSELECT ;
		break ;
	case 1 :
		bfinfo->select = DIR_VIEW_SELECT ;
		break ;
	case 2 :
		bfinfo->select = DIR_VIEW_SUBSELECT ;
		break ;
	case -1 :
	default :
		break;
    }

    return(0);
}


static int __makeBackupList( BDINFO *bdinfo,  FILE *fp, int *totalcount )
{
    int    i ;

    if ( bdinfo == (BDINFO *)NULL )
	return(-1) ;

    for(i=0;i<bdinfo->count;i++)
    {
	if ( bdinfo->bfinfo[i]->select == DIR_VIEW_SELECT )
	{
	    if ( (*totalcount) > 0 )
		fprintf( fp, "\n" );

	    fprintf( fp, "%s", bdinfo->bfinfo[i]->fname+1 );
#ifdef	DEBUG8
fprintf( stdout, "makelist : totalcount (%d) [%s]\n",
			(*totalcount), bdinfo->bfinfo[i]->fname );
#endif
	    (*totalcount)++;
	    continue ;
	}

	if ( bdinfo->bfinfo[i]->select == DIR_VIEW_SUBSELECT )
	{
	    __makeBackupList( (BDINFO *)bdinfo->bfinfo[i]->next, fp, totalcount );
	    continue ;
	}
    }

    return(0);
}

int makeBackupList( FILE *fp )
{
    BFINFO *bfinfo ;
    int status ;
    int totalcount ;
    DIR     *dfd;
    struct dirent *dp ;
    struct stat fileinfo ;
    int     i, k ;

    totalcount = 0 ;

    bfinfo = cxpbackup->root.bfinfo[0] ;
    if ( bfinfo->select == DIR_VIEW_SELECT )
    {
	/* ե륷ƥ򥪡ץ󤷤Ƥξ */
	fprintf( fp, "%s", bfinfo->fname );
	totalcount++;

	/*-- ǥ쥯ȥΥץ --*/
	if ( (dfd = opendir("/")) == NULL )
	    return(-1);

	/*-- ǥ쥯ȥɤ߹ --*/
	k = 0 ;
	for(i=0; (dp = readdir(dfd)) != NULL; i++)
	{
	    if ( !strcmp( dp->d_name, "." ) || !strcmp( dp->d_name, "..") )
		continue ;

	    fprintf( fp, "%s", dp->d_name );

	    k++;
	}

	/*-- ǥ쥯ȥΥ --*/
	closedir(dfd);

	totalcount = k ;
    }else{
	__makeBackupList( (BDINFO *)bfinfo->next, fp, &totalcount );
    }

    return(totalcount);
}

void compressRadioFunc(GtkWidget *widget, gpointer data)
{
    GSList  *glist;
    GtkRadioMenuItem *rmi ;
    gint i;
  
    if (!GTK_WIDGET_MAPPED (widget))
	return;

    rmi = (GtkRadioMenuItem *)(((GtkOptionMenu *)cxpbackup->compressMenu)->menu_item);
    i = 0 ;
    glist = gtk_radio_menu_item_group(rmi);
    while( glist  && !((GtkCheckMenuItem *)(glist->data))->active)
    {
	glist = glist->next;
	i++;
    }

    cxpbackup->compressNo = i ;  
}

void deviceRadioFunc(GtkWidget *widget, gpointer data)
{
    GSList  *glist;
    GtkRadioMenuItem *rmi ;
    gint i;
  
    if (!GTK_WIDGET_MAPPED (widget))
	return;

    rmi = (GtkRadioMenuItem *)(((GtkOptionMenu *)cxpbackup->deviceMenu)->menu_item);
    i = 0 ;
    glist = gtk_radio_menu_item_group(rmi);
    while( glist  && !((GtkCheckMenuItem *)(glist->data))->active)
    {
	glist = glist->next;
	i++;
    }

    cxpbackup->deviceNo = i ;  
}
