/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpbackup.h"

extern CxpBackup    *cxpbackup;

extern int stopSaveFunc();
extern int cxpbackup_showWindowClose ();

static GtkWidget *stopBtn;

static char *showtitle[1] = { \
        "Хååץե" };

int startBtnFunc(GtkWidget *widget, gpointer data)
{
    FILE *backupFp ;
    char command[1024];
    char programName[256] ;
    char programCmd[1024] ;
    char localName[1024] ;
    char deviceName[256] ;
    char *cmdOption[12] ;
    int status ;

    /* Хååץץκ */
    cxpbackup->compressFlag = 0 ;
    if (GTK_TOGGLE_BUTTON(cxpbackup->compRadioBtn1)->active)
    {
	cxpbackup->compressFlag = 1 ;
    }
    if (GTK_TOGGLE_BUTTON(cxpbackup->compRadioBtn2)->active)
    {
	cxpbackup->compressFlag = 0 ;
    }

#ifdef	cxpbackup_step2
    /* ɽμ */
    cxpbackup->viewFlag = 0 ;
    if (GTK_TOGGLE_BUTTON(cxpbackup->viewRadioBtn1)->active)
    {
	cxpbackup->viewFlag = 1 ;
    }
    if (GTK_TOGGLE_BUTTON(cxpbackup->viewRadioBtn2)->active)
    {
	cxpbackup->viewFlag = 0 ;
    }
#else
    cxpbackup->viewFlag = 0 ;
#endif

    compressRadioFunc(cxpbackup->compressMenu,(gpointer)NULL);
    deviceRadioFunc  (cxpbackup->deviceMenu,  (gpointer)NULL);

    {
	int _compNo, _devNo, _k,_m, _i, _total ;

#ifdef	DEBUG9
fprintf(stdout,"cxpbackup->deviceNo => [%d]\n", cxpbackup->deviceNo );
#endif

	_total = 0 ;
	for(_i=0;_i<cxpbackup->devinf.device_kensu;_i++)
	{
	    if ( cxpbackup->devinf.device[_i].backupFlag == 1 )
		continue ;
	    _total ++;
	}

	_compNo = 1 - cxpbackup->compressNo ;
	_devNo  = (_total - 1) - cxpbackup->deviceNo ;
	cxpbackup->compressNo = _compNo;

#ifdef	DEBUG9
fprintf(stdout,"_devNo => [%d]\n", _devNo );
#endif

	_m = 0 ;
	for(_k=0;_k<cxpbackup->devinf.device_kensu;_k++)
	{
	    if ( cxpbackup->devinf.device[_k].backupFlag != 0 )
		continue ;

	    if ( _devNo == _m )
	    {
		_devNo = _k ;
		break ;
	    }
	    _m++;

	}
	cxpbackup->deviceNo = _devNo ;
    }

    /* ̾κ */
    sprintf( localName, "/tmp/.cxpbackup.%d_%d.log",
		cxpbackup->uid, cxpbackup->pid );
    sprintf(command,"touch %s", localName);
    cxpbackup->savePid = -1 ;
    system(command);
    cxpbackup->normalLog = g_strdup(localName);

    /* ٹκ */
    sprintf( localName, "/tmp/.cxpbackup.%d_%d.err",
		cxpbackup->uid, cxpbackup->pid );
    sprintf(command,"touch %s", localName);
    cxpbackup->savePid = -1 ;
    system(command);
    cxpbackup->errorLog = g_strdup(localName);

    /* ХååץꥹȤκ */
#if 0
    sprintf( localName,"/tmp/.cxpbackup.%d_%d",
		cxpbackup->uid, cxpbackup->pid );
#else
    sprintf( localName,"/tmp/.cxpbackup" );
#endif
    cxpbackup->backupList = g_strdup(localName);


    /* ǥХ̾μ */
    sprintf(deviceName,"%s",
	cxpbackup->devinf.device[cxpbackup->deviceNo].path );

    /* TARޥɺ */
    sprintf( programName, "/bin/tar" );

    if ( cxpbackup->compressFlag == 1 ) 
    {
	sprintf( programCmd, "%s%s",
		( cxpbackup->viewFlag == 1 ? "cvTf" : "cTf" ),
		( cxpbackup->compressNo == 0 ? "z" :
		 ( cxpbackup->compressNo == 1 ? "Z" : " " )) );

	cmdOption[0] = (char *)g_strdup( programCmd );
	cmdOption[1] = (char *)g_strdup( cxpbackup->backupList );
	cmdOption[2] = (char *)g_strdup( deviceName );
	cmdOption[3] = (char *)NULL ;

    }else{
	sprintf( programCmd, "cvTf" );
	cmdOption[0] = (char *)g_strdup( programCmd );
	cmdOption[1] = (char *)g_strdup( cxpbackup->backupList );
	cmdOption[2] = (char *)g_strdup( deviceName );
	cmdOption[3] = (char *)NULL ;
    }


    /* ХååѥǡꥹȤκ */
    if ( (backupFp = fopen( cxpbackup->backupList, "w" )) == (FILE *)NULL )
    {
	/* 񤭹ߥץ˼ */
	messageView( "ХååץꥹȤκ˼Ԥޤ");

	remove( cxpbackup->backupList );
	return(0);
    }
    fprintf( backupFp,"%s\n",cxpbackup->backupList+1 );
    status = makeBackupList( backupFp );
    fclose(backupFp);

    if ( status <= 0 )
    {
	messageView( "Хååפǡޤ");
	return(0);
    }

#ifdef	DEBUG8
fprintf(stdout,"compressNo  [%d]\n", cxpbackup->compressNo);
fprintf(stdout,"deviceNo    [%d]\n", cxpbackup->deviceNo);
fprintf(stdout,"programName [%s]\n", programName );
fprintf(stdout,"programCmd  [%s]\n", programCmd );
#endif

    /* Хååѻҥץ */
    if ( !(cxpbackup->savePid = fork()) )
    {

	gtk_main_quit();

	/* ǥ쥯ȥư */
	chdir("/");

#ifdef DEBUG8
fprintf(stdout,"log open ...\n");
#endif
	/* ѥե򥪡ץ */
	cxpbackup->normalFd = open(cxpbackup->normalLog, O_WRONLY|O_CREAT,0644);
	cxpbackup->errorFd  = open(cxpbackup->errorLog, O_WRONLY|O_CREAT,0644);

#ifdef DEBUG8
fprintf(stdout,"fd copy ...\n");
fflush(stdout);
#endif

	/* ƣĤ򥳥ԡ */
	if ( cxpbackup->normalFd > 0 )
	{
	    dup2(cxpbackup->normalFd,1);
	    close(cxpbackup->normalFd);
	}
	if ( cxpbackup->errorFd  > 0 ){
	    dup2(cxpbackup->errorFd, 2);
	    close(cxpbackup->errorFd);
	}

	/* exec ؿǼ¹Ԥ */
	execl( programName, programName, cmdOption[0], cmdOption[1], cmdOption[2], NULL );

	exit(0);
    }

    if ( cxpbackup->savePid <= 0 )
    {
#ifdef DEBUG8
fprintf(stdout,"Child Process error..\n");
#endif

	/* ҥץεư˼ */
	messageView( "ҥץεư˼Ԥޤ");

	remove( cxpbackup->backupList );
	remove( cxpbackup->normalLog );
	remove( cxpbackup->errorLog );
	return(0);

    }else{

	cxpbackup_showWindow ();

    }

    return(0);
}

int cxpbackup_showWindow ()
{
  GtkWidget *vbox1;
  GtkWidget *hbox2;
  GtkWidget *label1;
  GtkWidget *hbox1;
  GtkWidget *vbox2;
  GtkWidget *hbox3;
  GtkWidget *swin;
  int x,y,w,h ;
  int showx, showy ;

  w = gdk_screen_width();
  h = gdk_screen_height();
  x = w/2;
  y = h/2;

#ifdef DEBUG8
fprintf(stdout,"cxpbackup_showWindow start ...\n");
#endif

  cxpbackup->saveWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (cxpbackup->saveWindow), "saveWindow",
	cxpbackup->saveWindow);

  if ( cxpbackup->viewFlag <= 0 )
  {
	gtk_widget_set_usize (cxpbackup->saveWindow, 400, 100);
	gtk_widget_set_uposition(cxpbackup->saveWindow, (x - 400*0.5), (y - 100*0.5) );
  }else{
	gtk_widget_set_usize (cxpbackup->saveWindow, 400, 400);
	gtk_widget_set_uposition(cxpbackup->saveWindow, (x - 400*0.5), (y - 400*0.5) );
  }
  gtk_window_set_policy (GTK_WINDOW (cxpbackup->saveWindow), FALSE, FALSE, FALSE);
  gtk_window_set_title (GTK_WINDOW (cxpbackup->saveWindow), "Хåå");
#if 0
  gtk_window_set_modal (GTK_WINDOW (cxpbackup->saveWindow), TRUE);
#endif
  gtk_widget_show(cxpbackup->saveWindow);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (cxpbackup->saveWindow), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (cxpbackup->saveWindow), vbox1);

  hbox2 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (cxpbackup->saveWindow), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, TRUE, 20);

  label1 = gtk_label_new ("򤵤줿ǡ¸Ƥޤ");
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (cxpbackup->saveWindow), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (hbox2), label1, FALSE, FALSE, 0);

  hbox1 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (cxpbackup->saveWindow), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 5);

  stopBtn = gtk_button_new_with_label ("  ");
  gtk_widget_ref (stopBtn);
  gtk_object_set_data_full (GTK_OBJECT (cxpbackup->saveWindow), "stopBtn", stopBtn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (stopBtn);
  gtk_box_pack_start (GTK_BOX (hbox1), stopBtn, FALSE, FALSE, 0);


#if 0
  hbox3 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox3);
  gtk_object_set_data_full (GTK_OBJECT (cxpbackup->saveWindow), "hbox3", hbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox3, TRUE, TRUE, 5);

  swin = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
        GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show(swin);

  cxpbackup->viewList = gtk_clist_new_with_titles(1, showtitle );
  gtk_widget_set_usize(cxpbackup->viewList, 400, 300);
  gtk_clist_set_selection_mode( GTK_CLIST(cxpbackup->viewList), GTK_SELECTION_EXTENDED );
  gtk_widget_set_usize (cxpbackup->viewList, 400, 300);

  gtk_clist_column_title_passive( GTK_CLIST(cxpbackup->viewList), 0 );
 
  gtk_container_add(GTK_CONTAINER(swin), cxpbackup->viewList);
  gtk_widget_show(cxpbackup->viewList);

  gtk_box_pack_start (GTK_BOX (hbox3), swin, TRUE, TRUE, 0);
#endif

  /* ܥ󥤥٥ */
  gtk_signal_connect_object (GTK_OBJECT (stopBtn), "clicked",
                (GtkSignalFunc)stopSaveFunc, GTK_OBJECT (cxpbackup->saveWindow));

  cxpbackup->saveMode = 0 ;
  if ( cxpbackup->viewFlag > 0 )
  {
	startShowInit();
  }

#ifdef DEBUG8
fprintf(stdout,"cxpbackup_showWindow start ...\n");
#endif

  return(0);
}

int stopSaveFunc()
{

#ifdef DEBUG8
fprintf(stdout,"stopSaveFunc start ...\n");
#endif
    /* ҥץؽλΤȯԤ */
    if ( cxpbackup->savePid > 0 )
	kill( cxpbackup->savePid, SIGTERM);

    cxpbackup_showWindowClose ();
#ifdef DEBUG8
fprintf(stdout,"stopSaveFunc end ...\n");
#endif
}

int cxpbackup_showWindowClose ()
{
    struct stat fileinfo ;
    char buff[1024] ;
    FILE *fp ;

#ifdef DEBUG8
fprintf(stdout,"cxpbackup_showWindowClose start ...\n");
#endif
    gtk_widget_hide( cxpbackup->saveWindow );
    gtk_widget_destroy( cxpbackup->saveWindow );

    if ( cxpbackup->saveMode > 0 )
    {
	endShowItem();
	sleep(1);
    }
    cxpbackup->saveMode = 0 ;

    /* 򻲾Ȥƥ顼뤫ɤĴ٤ */
    stat( cxpbackup->errorLog, &fileinfo );
    if ( fileinfo.st_size > 0 )
    {
	errorView( "顼ȯƤޤ顼ƤǧƲ");
	if ((fp = fopen(cxpbackup->errorLog,"r")) != (FILE *)NULL )
	{
	    while( fgets( buff, sizeof(buff), fp ) != 0 )
	    {
		errorAppend( buff );
	    }
	    fclose(fp);
	}
    }else{
	messageView( "˥Хåå״λޤפˤʤäФƲ");
    }

    remove(cxpbackup->backupList);
    remove(cxpbackup->normalLog);
    remove(cxpbackup->errorLog);

#ifdef DEBUG8
fprintf(stdout,"cxpbackup_showWindowClose end ...\n");
#endif

}
