/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpimage.h"

CxpImage *cxpimage;

/*
 * Cxpimage Version Header
 *
 * version  date        log
 *  1.0.0   1999/09/15  first released.
 *  1.1.0   2000/02/29  search directory selection add.
 *  1.1.1   2000/04/17  main exit code is ZERO add.
 *  1.2.0   2000/06/30  program name change (cxpimage -> cxpbg)
 *  1.2.1   2000/08/01  cxpmanager start add.
 *
 */

extern int getSystemImageInfo ();

void cxpimage_init ()
{
	GtkWidget *hpaned;
	GtkWidget *vbox;
	GtkWidget *subitem;
	int row;

	cxpimage = (CxpImage *) g_malloc (sizeof (CxpImage));

	/* ưɣĤμ */
	cxpimage->uid = getuid ();
	cxpimage->gid = getgid ();

	/* ν */
	cxpimage->selectrow = -1;
	cxpimage->currentViewFlag = 0;
	cxpimage->clist_timeout_start = 0;
	cxpimage->clist_timeout_end = 0;

	/* ɹ */
	cxpimage->searchNum = getImageDirectory (cxpimage->search);

	/* ᡼ɤ߹ */
	getSystemImageInfo (&(cxpimage->image_kensu), &(cxpimage->image));

	/* ١Υɥ */
	cxpimage->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (cxpimage->window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
	gtk_window_set_title (GTK_WINDOW (cxpimage->window), "Cxpbg");
	gtk_widget_set_usize (cxpimage->window, 500, 500);


	/* VBOX */
	cxpimage->vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (cxpimage->window), cxpimage->vbox);
	gtk_widget_show (cxpimage->vbox);

	/*  */
	cxpimage_list_init ();

	/* ɥɽ */
	gtk_widget_show (cxpimage->window);

	return;
}

int main (int argc, char *argv[])
{
	CxpBasePathInit ();

	/* ޥ͡㵯ư */
	cxp_manager_start ();

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	cxpimage_init ();

	gtk_main ();
	exit (0);
}
