/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpimage.h"

extern CxpImage *cxpimage;
extern void cxpimage_message ();

static void onereadfunc ();

static GtkWidget *chkbtn[32];
static GtkWidget *dirbtn[64];

static int _pth_startFlag;
static int _pth_readFlag;

/*
 *  CXP_IMAGE_JPEG  1
 *  CXP_IMAGE_GIF   2
 *  CXP_IMAGE_TIFF  3
 *  CXP_IMAGE_XPM   4
 *  CXP_IMAGE_XWD   5
 *  CXP_IMAGE_XBM   6
 */

static char *clist_title[2] = {
	"᡼ե",
	""
};

static void CxpImageView ()
{
	int i;
	char filename[1024];
	char *ptr;
	char *imagename[4];

	gtk_clist_freeze (GTK_CLIST (cxpimage->clist));
	gtk_clist_clear (GTK_CLIST (cxpimage->clist));
	for (i = 0; i < cxpimage->image_kensu; i++)
	{
		strcpy (filename, cxpimage->image[i].file);
		ptr = (char *) strrchr (filename, '/');
		if (ptr != NULL)
			imagename[0] = g_strdup (ptr + 1);
		else
			imagename[0] = g_strdup (filename);
		imagename[1] = g_strdup (filename);
		gtk_clist_append (GTK_CLIST (cxpimage->clist), imagename);
	}
	gtk_clist_thaw (GTK_CLIST (cxpimage->clist));
}


static gint clist_timeout_startfunc (data)
     gpointer data;
{
	gtk_timeout_remove (cxpimage->clist_timeout_start);
	cxpimage->clist_timeout_start = 0;
	return (0);
}
static gint clist_timeout_endfunc (data)
     gpointer data;
{
	gtk_timeout_remove (cxpimage->clist_timeout_end);
	cxpimage->clist_timeout_end = 0;
	return (0);
}

static void clist_unselection (clist, row, column, event, data)
     GtkWidget *clist;
     gint row;
     gint column;
     GdkEventButton *event;
     gpointer data;
{
	/* 򥯥ꥢ */
	cxpimage->selectrow = -1;
}

static void clist_selection (clist, row, column, event, data)
     GtkWidget *clist;
     gint row;
     gint column;
     GdkEventButton *event;
     gpointer data;
{
	int i;

	/* ˥å */
	cxpimage->selectrow = row;

	if (cxpimage->currentViewFlag == 1)
		return;

	if (row < 0)
		return;

	/* ॢȤ */
	if (cxpimage->clist_timeout_start == 0)
	{
		cxpimage->clist_timeout_start = gtk_timeout_add (50,
								 clist_timeout_startfunc,
								 NULL);

		if (cxpimage->clist_timeout_end != 0)
		{
			gtk_timeout_remove (cxpimage->clist_timeout_end);
		}
		cxpimage->clist_timeout_end = gtk_timeout_add (200,
							       clist_timeout_endfunc,
							       NULL);

		return;
	}

	return;
}

static void setfunc (GtkWidget * widget, gpointer data)
{
	char command[2048];

	if (cxpimage->selectrow >= 0)
	{
		sprintf (command, "xloadimage -onroot %s > /dev/null",
			 cxpimage->image[cxpimage->selectrow].file);
		system (command);
	}
}

static void readfunc (GtkWidget * widget, gpointer data)
{
	int i, k;
	int dirFlag;
	char titleString[256];
	char removeFilename[256];

	if ((!GTK_TOGGLE_BUTTON (chkbtn[CXP_IMAGE_JPEG])->active)
	    && (!GTK_TOGGLE_BUTTON (chkbtn[CXP_IMAGE_GIF])->active)
	    && (!GTK_TOGGLE_BUTTON (chkbtn[CXP_IMAGE_TIFF])->active)
	    && (!GTK_TOGGLE_BUTTON (chkbtn[CXP_IMAGE_XPM])->active)
	    && (!GTK_TOGGLE_BUTTON (chkbtn[CXP_IMAGE_XWD])->active)
	    && (!GTK_TOGGLE_BUTTON (chkbtn[CXP_IMAGE_XBM])->active))
		return;

	dirFlag = 0;
	for (i = 0; i < cxpimage->searchNum; i++)
		if (GTK_TOGGLE_BUTTON (dirbtn[i])->active)
			dirFlag = 1;
	if (!dirFlag)
		return;

	_pth_readFlag = 0;
	_pth_startFlag = 0;

	for (i = CXP_IMAGE_JPEG; i <= CXP_IMAGE_XBM; i++)
	{
		if (!GTK_TOGGLE_BUTTON (chkbtn[i])->active)
			continue;

		for (k = 0; k < cxpimage->searchNum; k++)
		{
			if (!GTK_TOGGLE_BUTTON (dirbtn[k])->active)
				continue;
			_pth_readFlag = 0;

#if 1
			sprintf (titleString,
				 "Cxpbg %s%sǡ򸡺Ƥޤ",
				 cxpimage->search[k],
				 (i ==
				  CXP_IMAGE_JPEG ? "JPEG" : (i ==
							     CXP_IMAGE_GIF ?
							     "GIF" : (i ==
								      CXP_IMAGE_TIFF
								      ? "TIFF"
								      : (i ==
									 CXP_IMAGE_XPM
									 ?
									 "XPM"
									 : (i
									    ==
									    CXP_IMAGE_XWD
									    ?
									    "XWD"
									    :
									    (i
									     ==
									     CXP_IMAGE_XBM
									     ?
									     "XBM"
									     :
									     "???")))))));
			gtk_window_set_title (GTK_WINDOW (cxpimage->window),
					      titleString);

			while (gtk_events_pending ())
				gtk_main_iteration ();
#endif

			onereadfunc (i, cxpimage->search[k], &_pth_startFlag);
			_pth_readFlag = 1;

		}
	}

	strcpy (titleString, "Cxpbg");
	gtk_window_set_title (GTK_WINDOW (cxpimage->window), titleString);

	sprintf (removeFilename, "/tmp/.cxpbg.%d", cxpimage->uid);
	remove (removeFilename);

	getSystemImageInfo (&(cxpimage->image_kensu), &(cxpimage->image));
	CxpImageView ();
}

static void onereadfunc (int no, char *path, int *start)
{
	char command[1024];

	switch (no)
	{
	case CXP_IMAGE_JPEG:
		sprintf (command,
			 "find %s -name \"*.jpg\" -print %s /tmp/.cxpbg.%d",
			 path, ((*start) == 0 ? ">" : ">>"), cxpimage->uid);
		break;
	case CXP_IMAGE_GIF:
		sprintf (command,
			 "find %s -name \"*.gif\" -print %s /tmp/.cxpbg.%d",
			 path, ((*start) == 0 ? ">" : ">>"), cxpimage->uid);
		break;
	case CXP_IMAGE_TIFF:
		sprintf (command,
			 "find %s -name \"*.tif\" -print %s /tmp/.cxpbg.%d",
			 path, ((*start) == 0 ? ">" : ">>"), cxpimage->uid);
		break;
	case CXP_IMAGE_XPM:
		sprintf (command,
			 "find %s -name \"*.xpm\" -print %s /tmp/.cxpbg.%d",
			 path, ((*start) == 0 ? ">" : ">>"), cxpimage->uid);
		break;
	case CXP_IMAGE_XWD:
		sprintf (command,
			 "find %s -name \"*.xwd\" -print %s /tmp/.cxpbg.%d",
			 path, ((*start) == 0 ? ">" : ">>"), cxpimage->uid);
		break;
	case CXP_IMAGE_XBM:
		sprintf (command,
			 "find %s -name \"*.xbm\" -print %s /tmp/.cxpbg.%d",
			 path, ((*start) == 0 ? ">" : ">>"), cxpimage->uid);
		break;
	}
	system (command);
	(*start)++;


	sprintf (command, "%s/.cxp", (char *) getenv ("HOME"));
	if (access (command, F_OK))
	{
		/* ǥ쥯ȥ꤬ʤä */
		mkdir (command, 0755);
	}
	sprintf (command, "%s/.cxp/lib", (char *) getenv ("HOME"));
	if (access (command, F_OK))
	{
		/* ǥ쥯ȥ꤬ʤä */
		mkdir (command, 0755);
	}

	sprintf (command, "cp -p /tmp/.cxpbg.%d %s/.cxp/lib/cxpimage.cfg",
		 cxpimage->uid, (char *) getenv ("HOME"));
	system (command);
}

static void canfunc (GtkWidget * widget, gpointer data)
{
	gtk_main_quit ();
}


void cxpimage_list_init ()
{
	GtkWidget *hbox;
	GtkWidget *vbox;

	/* ܥ */
	GtkWidget *hbox_under;
	GtkWidget *setbtn;
	GtkWidget *cancelbtn;

	/*  */
	GtkWidget *frame_dir;
	GtkWidget *hbox_dir;
	GtkWidget *vbox_dir;

	/*  */
	GtkWidget *frame_img;
	GtkWidget *hbox_img;
	GtkWidget *vbox_img;
	GtkWidget *rbtn_img;

	/* ٥ */
	GtkWidget *label;

	char lname[256];
	int i;


	/* Clist Τ뤿Υɥɥ */
	cxpimage->swin = gtk_scrolled_window_new (NULL, NULL);

	/* ʿӿľΥСɽ褦 */
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (cxpimage->swin),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);

	label = gtk_label_new ("طʥ᡼ޥ͡");
	gtk_box_pack_start (GTK_BOX (cxpimage->vbox), label, FALSE, FALSE, 5);
	gtk_widget_show (label);

	hbox = gtk_hbox_new (FALSE, 2);
	gtk_box_pack_end (GTK_BOX (cxpimage->vbox), hbox, TRUE, TRUE, 10);
	gtk_widget_show (hbox);



  /*--- ᡼ ----*/
	frame_img = gtk_frame_new ("᡼ࡡ");
	gtk_box_pack_start (GTK_BOX (hbox), frame_img, FALSE, FALSE, 0);
	gtk_widget_show (frame_img);

	vbox_img = gtk_vbox_new (FALSE, 2);
	gtk_container_add (GTK_CONTAINER (frame_img), vbox_img);
	gtk_widget_show (vbox_img);

	for (i = CXP_IMAGE_JPEG; i <= CXP_IMAGE_XBM; i++)
	{
		switch (i)
		{
		case CXP_IMAGE_JPEG:
			strcpy (lname, "JPEGǡ");
			break;
		case CXP_IMAGE_GIF:
			strcpy (lname, "GIFǡ");
			break;
		case CXP_IMAGE_TIFF:
			strcpy (lname, "TIFFǡ");
			break;
		case CXP_IMAGE_XPM:
			strcpy (lname, "XPMǡ");
			break;
		case CXP_IMAGE_XWD:
			strcpy (lname, "XWDǡ");
			break;
		case CXP_IMAGE_XBM:
			strcpy (lname, "XBMǡ");
			break;
		}
		chkbtn[i] = gtk_check_button_new_with_label (lname);
		gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (chkbtn[i]),
					     FALSE);
		gtk_box_pack_start (GTK_BOX (vbox_img), chkbtn[i], FALSE,
				    FALSE, 0);
		gtk_widget_show (chkbtn[i]);
	}

#if 0
	hbox_img = gtk_hbox_new (FALSE, 2);
	gtk_box_pack_end (GTK_BOX (vbox_img), hbox_img, FALSE, FALSE, 3);
	gtk_widget_show (hbox_img);

	rbtn_img = gtk_button_new_with_label ("ɹ");
	gtk_box_pack_end (GTK_BOX (hbox_img), rbtn_img, FALSE, FALSE, 10);
	gtk_signal_connect_object (GTK_OBJECT (rbtn_img), "clicked",
				   (GtkSignalFunc) readfunc, NULL);
	gtk_widget_show (rbtn_img);
#endif


  /*--- ɹǥ쥯ȥ ----*/
	frame_dir = gtk_frame_new ("ꡡ");
	gtk_box_pack_start (GTK_BOX (hbox), frame_dir, FALSE, FALSE, 0);
	gtk_widget_show (frame_dir);

	vbox_dir = gtk_vbox_new (FALSE, 2);
	gtk_container_add (GTK_CONTAINER (frame_dir), vbox_dir);
	gtk_widget_show (vbox_dir);

	for (i = 0; i < cxpimage->searchNum; i++)
	{
		sprintf (lname, "%s", cxpimage->search[i]);
		dirbtn[i] = gtk_check_button_new_with_label (lname);
		gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (dirbtn[i]),
					     FALSE);
		gtk_box_pack_start (GTK_BOX (vbox_dir), dirbtn[i], FALSE,
				    FALSE, 0);
		gtk_widget_show (dirbtn[i]);
	}

	hbox_dir = gtk_hbox_new (FALSE, 2);
	gtk_box_pack_end (GTK_BOX (vbox_dir), hbox_dir, FALSE, FALSE, 3);
	gtk_widget_show (hbox_dir);



	vbox = gtk_vbox_new (FALSE, 2);
	gtk_box_pack_start (GTK_BOX (hbox), vbox, TRUE, TRUE, 10);
	gtk_widget_show (vbox);

	gtk_box_pack_start (GTK_BOX (vbox), cxpimage->swin, TRUE, TRUE, 10);
	gtk_widget_show (cxpimage->swin);


	hbox_under = gtk_hbox_new (FALSE, 2);
	gtk_box_pack_end (GTK_BOX (vbox), hbox_under, FALSE, FALSE, 3);
	gtk_widget_show (hbox_under);


	cancelbtn = gtk_button_new_with_label (" Ĥ ");
	gtk_box_pack_end (GTK_BOX (hbox_under), cancelbtn, FALSE, FALSE, 10);
	gtk_signal_connect_object (GTK_OBJECT (cancelbtn), "clicked",
				   (GtkSignalFunc) canfunc, NULL);
	gtk_widget_show (cancelbtn);

	setbtn = gtk_button_new_with_label ("ꡡ");
	gtk_box_pack_end (GTK_BOX (hbox_under), setbtn, FALSE, FALSE, 10);
	gtk_signal_connect_object (GTK_OBJECT (setbtn), "clicked",
				   (GtkSignalFunc) setfunc, NULL);
	gtk_widget_show (setbtn);

#if 1
	rbtn_img = gtk_button_new_with_label ("ɹ");
	gtk_box_pack_end (GTK_BOX (hbox_under), rbtn_img, FALSE, FALSE, 10);
	gtk_signal_connect_object (GTK_OBJECT (rbtn_img), "clicked",
				   (GtkSignalFunc) readfunc, NULL);
	gtk_widget_show (rbtn_img);
#endif


	cxpimage->clist = gtk_clist_new_with_titles (2, clist_title);

	gtk_widget_set_usize (cxpimage->clist, 440, -1);
	gtk_clist_set_selection_mode (GTK_CLIST (cxpimage->clist),
				      GTK_SELECTION_BROWSE);

	gtk_signal_connect (GTK_OBJECT (cxpimage->clist),
			    "select_row", GTK_SIGNAL_FUNC (clist_selection),
			    NULL);

	gtk_signal_connect (GTK_OBJECT (cxpimage->clist),
			    "unselect_row",
			    GTK_SIGNAL_FUNC (clist_unselection), NULL);

	/* ȥܥȤʤ褦ˤ롣 */
	gtk_clist_column_titles_passive (GTK_CLIST (cxpimage->clist));

	gtk_clist_set_column_width (GTK_CLIST (cxpimage->clist), 0, 140);
	gtk_clist_set_column_width (GTK_CLIST (cxpimage->clist), 1, 400);

	gtk_container_add (GTK_CONTAINER (cxpimage->swin), cxpimage->clist);
	gtk_widget_show (cxpimage->clist);

	CxpImageView ();

}
