/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpcalc.h"

extern CxpCalc *cxpcalc;

static gint cxpcalcbtnfunc ();
static gint cxpcalcbtnEnzn ();
static gint cxpcalcKekka ();
static gint cxpcalcbtnclear ();
static double getData ();
static char *getKekka ();
static char *make_viewdata ();
static gint getViewData ();

static char *optname_list[16] = { "CLS", "" };

static char *btnname_list[16] = { "", "", "", "",
	"", "", "", "",
	"", "", "", "",
	"", "", "", ""
};

static gint cxpcalcbtnclear ()
{
	cxpcalc->icount1 = 0;
	cxpcalc->icount2 = 0;
	cxpcalc->iset = 0;
	memset (cxpcalc->buffer1, 0x00, sizeof (cxpcalc->buffer1));
	memset (cxpcalc->buffer2, 0x00, sizeof (cxpcalc->buffer2));

	memset (cxpcalc->viewdata, 0x00, sizeof (cxpcalc->viewdata));
	sprintf (cxpcalc->viewdata, "0");

	view_data ();

}

static gint cxpcalcbtnfugo ()
{
	char buff[1024];

	if (cxpcalc->iset == 0)
	{
		if (cxpcalc->icount1 > 0)
		{
			if (cxpcalc->buffer1[0] == '-')
				cxpcalc->buffer1[0] = '+';
			else if (cxpcalc->buffer1[0] == '+')
				cxpcalc->buffer1[0] = '-';
			else
			{
				sprintf (buff, "-%s", cxpcalc->buffer1);
				strcpy (cxpcalc->buffer1, buff);
				cxpcalc->icount1 = strlen (cxpcalc->buffer1);
			}

			strcpy (cxpcalc->viewdata,
				make_viewdata (cxpcalc->buffer1, NULL, NULL,
					       NULL));
			view_data ();
		}
	}
	else
	{
		if (cxpcalc->icount2 > 0)
		{
			if (cxpcalc->buffer2[0] == '-')
				cxpcalc->buffer2[0] = '+';
			else if (cxpcalc->buffer2[0] == '+')
				cxpcalc->buffer2[0] = '-';
			else
			{
				sprintf (buff, "-%s", cxpcalc->buffer2);
				strcpy (cxpcalc->buffer2, buff);
				cxpcalc->icount2 = strlen (cxpcalc->buffer2);
			}

			strcpy (cxpcalc->viewdata,
				make_viewdata (cxpcalc->buffer1,
					       cxpcalc->buffer2,
					       &cxpcalc->enzan, NULL));
			view_data ();
		}
	}
}

static gint cxpcalcbtnfunc0 ()
{
	cxpcalcbtnfunc (0);
}
static gint cxpcalcbtnfunc1 ()
{
	cxpcalcbtnfunc (1);
}
static gint cxpcalcbtnfunc2 ()
{
	cxpcalcbtnfunc (2);
}
static gint cxpcalcbtnfunc3 ()
{
	cxpcalcbtnfunc (3);
}
static gint cxpcalcbtnfunc4 ()
{
	cxpcalcbtnfunc (4);
}
static gint cxpcalcbtnfunc5 ()
{
	cxpcalcbtnfunc (5);
}
static gint cxpcalcbtnfunc6 ()
{
	cxpcalcbtnfunc (6);
}
static gint cxpcalcbtnfunc7 ()
{
	cxpcalcbtnfunc (7);
}
static gint cxpcalcbtnfunc8 ()
{
	cxpcalcbtnfunc (8);
}
static gint cxpcalcbtnfunc9 ()
{
	cxpcalcbtnfunc (9);
}
static gint cxpcalcbtnfuncdot ()
{
	cxpcalcbtnfunc (-1);
}
static gint cxpcalcbtnfuncA ()
{
	cxpcalcbtnfunc ((int) 'A');
}
static gint cxpcalcbtnfuncB ()
{
	cxpcalcbtnfunc ((int) 'B');
}
static gint cxpcalcbtnfuncC ()
{
	cxpcalcbtnfunc ((int) 'C');
}
static gint cxpcalcbtnfuncD ()
{
	cxpcalcbtnfunc ((int) 'D');
}
static gint cxpcalcbtnfuncE ()
{
	cxpcalcbtnfunc ((int) 'E');
}
static gint cxpcalcbtnfuncF ()
{
	cxpcalcbtnfunc ((int) 'F');
}
static gint cxpcalcbtnfuncTasu ()
{
	cxpcalcbtnEnzn ((int) 1);
}
static gint cxpcalcbtnfuncHiku ()
{
	cxpcalcbtnEnzn ((int) 2);
}
static gint cxpcalcbtnfuncKake ()
{
	cxpcalcbtnEnzn ((int) 3);
}
static gint cxpcalcbtnfuncWaru ()
{
	cxpcalcbtnEnzn ((int) 4);
}
static gint cxpcalcbtnfuncEnt ()
{
	cxpcalcKekka ();
}

static gint cxpcalcKekka ()
{
#ifdef	DEBUG
	fprintf (stdout, "cxpcalc->buffer1 [%s]\n", cxpcalc->buffer1);
	fprintf (stdout, "cxpcalc->buffer2 [%s]\n", cxpcalc->buffer2);
#endif


	cxpcalc->val1 = getData (cxpcalc->icount1, cxpcalc->buffer1);
	cxpcalc->val2 = getData (cxpcalc->icount2, cxpcalc->buffer2);

	switch (cxpcalc->enzan)
	{
	case 1:
		cxpcalc->kekka = cxpcalc->val1 + cxpcalc->val2;
		break;
	case 2:
		cxpcalc->kekka = cxpcalc->val1 - cxpcalc->val2;
		break;
	case 3:
		cxpcalc->kekka = cxpcalc->val1 * cxpcalc->val2;
		break;
	case 4:
		if (cxpcalc->val1 == 0.0)
			cxpcalc->kekka = 0;
		else
			cxpcalc->kekka = cxpcalc->val1 / cxpcalc->val2;
		break;
	}

	if ((cxpcalc->icount1 != 0) && (cxpcalc->icount2 != 0))
	{
		memset (cxpcalc->viewdata, 0x00, sizeof (cxpcalc->viewdata));

		strcpy (cxpcalc->viewdata,
			make_viewdata (cxpcalc->buffer1, cxpcalc->buffer2,
				       &cxpcalc->enzan, &cxpcalc->kekka));
		view_data ();

		sprintf (cxpcalc->buffer1, "%s", getKekka (cxpcalc->kekka));
		cxpcalc->icount1 = strlen (cxpcalc->buffer1);
		cxpcalc->iset = 1;
		cxpcalc->icount2 = 0;
		memset (cxpcalc->buffer2, 0x00, sizeof (cxpcalc->buffer2));
	}
	else if ((cxpcalc->icount1 != 0) && (cxpcalc->icount2 == 0))
	{
		cxpcalc->kekka =
			(double) getData (cxpcalc->icount1, cxpcalc->buffer1);
		sprintf (cxpcalc->buffer1, "%s", getKekka (cxpcalc->kekka));
		cxpcalc->icount1 = strlen (cxpcalc->buffer1);
		cxpcalc->iset = 1;
		cxpcalc->icount2 = 0;
		memset (cxpcalc->buffer2, 0x00, sizeof (cxpcalc->buffer2));

		memset (cxpcalc->viewdata, 0x00, sizeof (cxpcalc->viewdata));
		strcpy (cxpcalc->viewdata,
			make_viewdata (cxpcalc->buffer1, NULL, NULL, NULL));
		view_data ();
	}
	else if ((cxpcalc->icount1 == 0) && (cxpcalc->icount2 != 0))
	{
		cxpcalc->kekka =
			(double) getData (cxpcalc->icount2, cxpcalc->buffer2);
		sprintf (cxpcalc->buffer1, "%s", getKekka (cxpcalc->kekka));
		cxpcalc->icount1 = strlen (cxpcalc->buffer1);
		cxpcalc->iset = 1;
		cxpcalc->icount2 = 0;
		memset (cxpcalc->buffer2, 0x00, sizeof (cxpcalc->buffer2));

		memset (cxpcalc->viewdata, 0x00, sizeof (cxpcalc->viewdata));
		strcpy (cxpcalc->viewdata,
			make_viewdata (cxpcalc->buffer1, NULL, NULL, NULL));
		view_data ();
	}
	else
	{
		cxpcalc->iset = 0;
		cxpcalc->icount1 = 0;
		cxpcalc->icount2 = 0;
		memset (cxpcalc->buffer1, 0x00, sizeof (cxpcalc->buffer1));
		memset (cxpcalc->buffer2, 0x00, sizeof (cxpcalc->buffer2));

		memset (cxpcalc->viewdata, 0x00, sizeof (cxpcalc->viewdata));
		sprintf (cxpcalc->viewdata, "0");
		view_data ();
	}

#ifdef	DEBUG
	fprintf (stdout, "val1  -> %f\n", cxpcalc->val1);
	fprintf (stdout, "enzan -> %d\n", cxpcalc->enzan);
	fprintf (stdout, "val2  -> %f\n", cxpcalc->val2);
	fprintf (stdout, "kekka -> %f\n", cxpcalc->kekka);
#endif
}

static gint cxpcalcbtnEnzn (int data)
{
	if (cxpcalc->iset == 0)
	{
		cxpcalc->iset = 1;
		cxpcalc->icount2 = 0;
		memset (cxpcalc->buffer2, 0x00, sizeof (cxpcalc->buffer2));

		memset (cxpcalc->viewdata, 0x00, sizeof (cxpcalc->viewdata));
		strcpy (cxpcalc->viewdata,
			make_viewdata (cxpcalc->buffer1, NULL, &data, NULL));
		view_data ();
	}
	else
	{
		if ((cxpcalc->icount1 == 0) && (cxpcalc->icount2 == 0))
		{
			cxpcalc->iset = 0;
			memset (cxpcalc->viewdata, 0x00,
				sizeof (cxpcalc->viewdata));
			sprintf (cxpcalc->viewdata, "0");
			view_data ();
		}
		else if ((cxpcalc->icount1 != 0) && (cxpcalc->icount2 == 0))
		{
			cxpcalc->iset = 1;
			memset (cxpcalc->viewdata, 0x00,
				sizeof (cxpcalc->viewdata));
			strcpy (cxpcalc->viewdata,
				make_viewdata (cxpcalc->buffer1, NULL, &data,
					       NULL));
			view_data ();
		}
		else if ((cxpcalc->icount1 != 0) && (cxpcalc->icount2 != 0))
		{
			/* ߤͤǷ׻Ƥ餽η̤Ȥ­롣 */
			cxpcalcKekka ();

			memset (cxpcalc->viewdata, 0x00,
				sizeof (cxpcalc->viewdata));
			strcpy (cxpcalc->viewdata,
				make_viewdata (cxpcalc->buffer1,
					       cxpcalc->buffer2,
					       &cxpcalc->enzan,
					       &cxpcalc->kekka));
			view_data ();

			sprintf (cxpcalc->buffer1, "%s",
				 getKekka (cxpcalc->kekka));
			cxpcalc->icount1 = strlen (cxpcalc->buffer1);
			cxpcalc->iset = 1;
			cxpcalc->icount2 = 0;
			memset (cxpcalc->buffer2, 0x00,
				sizeof (cxpcalc->buffer2));
		}
		else if ((cxpcalc->icount1 == 0) && (cxpcalc->icount2 != 0))
		{
			/* ˤФʤϤ */
			memset (cxpcalc->viewdata, 0x00,
				sizeof (cxpcalc->viewdata));
			sprintf (cxpcalc->viewdata, "?????");
			view_data ();
		}
	}

	switch (data)
	{
	case 1:		/* + */
		cxpcalc->enzan = data;
		break;
	case 2:		/* - */
		cxpcalc->enzan = data;
		break;
	case 3:		/* * */
		cxpcalc->enzan = data;
		break;
	case 4:		/* / */
		cxpcalc->enzan = data;
		break;
	}
}

static gint cxpcalcbtnfunc (int data)
{
	char work[1024];

	if (cxpcalc->iset == 0)
	{
		if (cxpcalc->icount1 > 16)
			return;

		if (data == -1)
			cxpcalc->buffer1[cxpcalc->icount1] = '.';
		else if (data <= 10)
			cxpcalc->buffer1[cxpcalc->icount1] = data + 0x30;
		else
			cxpcalc->buffer1[cxpcalc->icount1] = (char) data;
		cxpcalc->icount1++;
#ifdef	DEBUG
		fprintf (stdout, "cxpcalc->buffer1 [%*.*s]\n",
			 cxpcalc->icount1,
			 cxpcalc->icount1, cxpcalc->buffer1);
#endif

		strcpy (cxpcalc->viewdata, cxpcalc->buffer1);

	}
	else
	{
		if (cxpcalc->icount2 > 16)
			return;

		if (data == -1)
			cxpcalc->buffer2[cxpcalc->icount2] = '.';
		else if (data <= 10)
			cxpcalc->buffer2[cxpcalc->icount2] = data + 0x30;
		else
			cxpcalc->buffer2[cxpcalc->icount2] = (char) data;
		cxpcalc->icount2++;
#ifdef	DEBUG
		fprintf (stdout, "cxpcalc->buffer2 [%*.*s]\n",
			 cxpcalc->icount2,
			 cxpcalc->icount2, cxpcalc->buffer2);
#endif

		memset (cxpcalc->viewdata, 0x00, sizeof (cxpcalc->viewdata));
		strcpy (cxpcalc->viewdata,
			make_viewdata (cxpcalc->buffer1, cxpcalc->buffer2,
				       &cxpcalc->enzan, NULL));
	}

	view_data ();

	return (0);
}

int create_calc_btn ()
{
	GtkWidget *swin;
	GtkWidget *hbox[10];
	int x, y, i;

	for (i = 0; i < 5; i++)
	{
		hbox[i] = gtk_hbox_new (TRUE, 0);
		gtk_box_pack_start (GTK_BOX (cxpcalc->vbox), hbox[i], TRUE,
				    TRUE, 1);
		gtk_widget_show (hbox[i]);
	}

	for (i = 0; i < 2; i++)
	{
		cxpcalc->optbtn[i] =
			gtk_button_new_with_label (optname_list[i]);

		switch (i)
		{
		case 0:	/* CLS */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->optbtn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnclear, 0);
			break;
		case 1:	/* +- */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->optbtn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfugo, 0);
			break;
		}
		gtk_box_pack_start (GTK_BOX (hbox[0]), cxpcalc->optbtn[i],
				    TRUE, TRUE, 1);
		gtk_widget_show (cxpcalc->optbtn[i]);
	}

	for (i = 0; i < 16; i++)
	{
		cxpcalc->btn[i] = gtk_button_new_with_label (btnname_list[i]);

		switch (i)
		{
		case 12:	/* 0 */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->btn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfunc0, 0);
			break;
		case 8:	/* 1 */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->btn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfunc1, 0);
			break;
		case 9:	/* 2 */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->btn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfunc2, 0);
			break;
		case 10:	/* 3 */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->btn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfunc3, 0);
			break;
		case 4:	/* 4 */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->btn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfunc4, 0);
			break;
		case 5:	/* 5 */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->btn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfunc5, 0);
			break;
		case 6:	/* 6 */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->btn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfunc6, 0);
			break;
		case 0:	/* 7 */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->btn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfunc7, 0);
			break;
		case 1:	/* 8 */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->btn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfunc8, 0);
			break;
		case 2:	/* 9 */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->btn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfunc9, 0);
			break;
		case 13:	/* . */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->btn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfuncdot, 0);
			break;
		case 3:	/* / */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->btn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfuncWaru, 0);
			break;
		case 7:	/* * */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->btn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfuncKake, 0);
			break;
		case 11:	/* + */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->btn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfuncTasu, 0);
			break;
		case 14:	/* = */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->btn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfuncEnt, 0);
			break;
		case 15:	/* - */
			gtk_signal_connect_object (GTK_OBJECT
						   (cxpcalc->btn[i]),
						   "clicked",
						   (GtkSignalFunc)
						   cxpcalcbtnfuncHiku, 0);
			break;
		}
		if (i < 4 && i >= 0)
			gtk_box_pack_start (GTK_BOX (hbox[1]),
					    cxpcalc->btn[i], TRUE, TRUE, 1);
		if (i < 8 && i >= 4)
			gtk_box_pack_start (GTK_BOX (hbox[2]),
					    cxpcalc->btn[i], TRUE, TRUE, 1);
		if (i < 12 && i >= 8)
			gtk_box_pack_start (GTK_BOX (hbox[3]),
					    cxpcalc->btn[i], TRUE, TRUE, 1);
		if (i < 16 && i >= 12)
			gtk_box_pack_start (GTK_BOX (hbox[4]),
					    cxpcalc->btn[i], TRUE, TRUE, 1);
		gtk_widget_show (cxpcalc->btn[i]);
	}

}

static double getData (int count, char *data)
{
	double kekka;
	int i, status;

	status = 0;
	for (i = 0; i < count; i++)
	{
		if (data[i] == '.')
			status = 1;
	}

	if (data[0] == '-')
	{
		if (status == 1)
			kekka = 0.0 - (double) atof (data + 1);
		else
			kekka = 0.0 - (double) atoll (data + 1);
	}
	else if (data[0] == '+')
	{
		if (status == 1)
			kekka = (double) atof (data + 1);
		else
			kekka = (double) atoll (data + 1);
	}
	else
	{
		if (status == 1)
			kekka = (double) atof (data);
		else
			kekka = (double) atoll (data);
	}
	return ((double) kekka);
}

static char *getKekka (double kekka)
{
	int i, status;
	char buff[1024];
	int size;
	char *ptr;

	sprintf (buff, "%f", kekka);
	ptr = strchr (buff, '.');
	size = strlen (ptr);

	status = 0;
	for (i = 1; i < size; i++)
	{
		if (*(ptr + i) != '0')
		{
			status = 1;
			break;
		}
	}
	if (status == 0)
	{
		*ptr = 0x00;
	}

	return (strdup (buff));
}

static char *make_viewdata (char *data1, char *data2, int *enzan,
			    double *kekka)
{
	char buff[1024];
	char wk1[1024];
	char wk2[1024];

	memset (buff, 0x00, sizeof (buff));
	sprintf (buff, "0");

	if (data1 != NULL)
		getViewData (wk1, data1);
	if (data2 != NULL)
		getViewData (wk2, data2);

	if (data1 != NULL && data2 != NULL && enzan != NULL && kekka != NULL)
	{
		sprintf (buff, "%s %s %s = %s",
			 wk1,
			 (*enzan == 1 ? "+" :
			  (*enzan == 2 ? "-" :
			   (*enzan == 3 ? "*" :
			    (*enzan == 4 ? "/" : "?")))),
			 wk2, getKekka (*kekka));
	}
	else if (data1 != NULL && data2 != NULL && enzan != NULL
		 && kekka == NULL)
	{
		sprintf (buff, "%s %s %s",
			 wk1,
			 (*enzan == 1 ? "+" :
			  (*enzan == 2 ? "-" :
			   (*enzan == 3 ? "*" :
			    (*enzan == 4 ? "/" : "?")))), wk2);
	}
	else if (data1 != NULL && data2 == NULL && enzan != NULL
		 && kekka == NULL)
	{
		sprintf (buff, "%s %s",
			 wk1,
			 (*enzan == 1 ? "+" :
			  (*enzan == 2 ? "-" :
			   (*enzan == 3 ? "*" : (*enzan == 4 ? "/" : "?")))));
	}
	else if (data1 != NULL && data2 == NULL && enzan == NULL
		 && kekka == NULL)
	{
		sprintf (buff, "%s", wk1);
	}

	return (strdup (buff));
}

static gint getViewData (char *dst, char *data)
{
	if ((*data == '-') || (*data == '+'))
		sprintf (dst, "(%s)", data);
	else
		sprintf (dst, "%s", data);
}
