/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#include "cxpcommon.h"
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcalen.h"

CxpCalen *cxpcalen;

extern void cxpcalenfilefunc_close ();

static int cxpcalen_init ()
{
	char fontbuff[1024];

	cxpcalen->selectview = -1;	/* ɽ */
	cxpcalen->selectday = -1;	/* ֹ */
	cxpcalen->selecttodo = -1;	/* ToDoֹ */

	cxpcalen->notCalenSelectNotDataView = 0;
	cxpcalen->notTimeSelection = 0;
	cxpcalen->notDaySelection = 0;

	/* ܾɤ߹ */
	getBaseConfig (&cxpcalen->base);

	/* եȾɤ߹ */
	getFontConfig (&cxpcalen->fontInfo);

	/* եȤ */
	if (cxpcalen->fontInfo.kensu > 0)
	{
		cxpcalen->fontIndex = 0;
		sprintf (fontbuff, "%s,%s,%s",
			 cxpcalen->fontInfo.font[0].font_alpha,
			 cxpcalen->fontInfo.font[0].font_kanji,
			 cxpcalen->fontInfo.font[0].font_kana);
	}
	else
	{
		cxpcalen->fontIndex = -1;
		sprintf (fontbuff, "%s,%s,%s",
			 "-misc-fixed-medium-r-normal--14-*-*-*-*-*-iso8859-1",
			 "-misc-fixed-medium-r-normal--14-*-*-*-*-*-jisx0208.1983-0",
			 "-misc-fixed-medium-r-normal--14-*-*-*-*-*-jisx0201.1976-0");
	}
	cxpcalen->font = gdk_fontset_load (fontbuff);


	/* TODOɤ߹ */
	getCalenDataTodo (&cxpcalen->todo);
	if (cxpcalen->todo.kensu > 0)
		cxpcalen->selecttodo = 0;

	/* ɽ̤ɤ߹ */
	getCalenDataView (&cxpcalen->view);

	/* ꤵ줿ɽ̤ξɤ߹ */
	if (cxpcalen->view.kensu > 0)
	{
		cxpcalen->selectview = 0;

		getCalenDataSchedule (cxpcalen->s_year,
				      &cxpcalen->view.view[cxpcalen->
							   selectview],
				      &cxpcalen->data);
	}

	cxpcalen_start ();

}

int cxpcalen_getsystemdate (int *year, int *month, int *day, int *hour,
			    int *min)
{
	time_t tim;
	struct tm *stim;

	tim = time (0);
	stim = localtime (&tim);

	/* ߤǯ */
	*year = stim->tm_year + 1900;
	*month = stim->tm_mon + 1;
	*day = stim->tm_mday;
	*hour = stim->tm_hour;
	*min = stim->tm_min;

}

int main (int argc, char *argv[])
{
	int dummy_hour, dummy_min;

	CxpBasePathInit ();

	/* ޥ͡㵯ư */
	cxp_manager_start ();

	cxpcalen = (CxpCalen *) g_malloc (sizeof (CxpCalen));
	memset (cxpcalen, 0x00, sizeof (CxpCalen));

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	cxpcalen_getsystemdate (&cxpcalen->s_year, &cxpcalen->s_month,
				&cxpcalen->s_day, &dummy_hour, &dummy_min);

	cxpcalen_init ();

	viewKindData ();	/* ɽ̤ɽ */
	viewTodoData ();	/* ToDoɽ */
	viewMonthData ();	/* ɽ */
	viewDayData ();		/* ɽ */

	/* ǯɽ */
	gtk_calendar_select_month (GTK_CALENDAR (cxpcalen->calendar1),
				   cxpcalen->s_month - 1, cxpcalen->s_year);
	gtk_calendar_select_day (GTK_CALENDAR (cxpcalen->calendar1),
				 cxpcalen->s_day);


	gtk_main ();
	exit (0);
}
