/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpcalen.h"

extern CxpCalen *cxpcalen;

static GtkWidget *alarmWindow = (GtkWidget *) NULL;
static GtkWidget *alarmSetToggle;
static GtkWidget *alarmNonSetToggle;
static GtkWidget *yearSpin;
static GtkWidget *monthSpin;
static GtkWidget *daySpin;
static GtkWidget *hourSpin;
static GtkWidget *minSpin;
static GtkWidget *alarmSetBtn;
static GtkWidget *alarmCanBtn;

static AlarmInfo dialogAlarmData;

static int alarmSetFunction (GtkWidget * widget, int *func ())
{
	int year, mon, day, hour, min;

	year = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (yearSpin));
	mon = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (monthSpin));
	day = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (daySpin));
	hour = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (hourSpin));
	min = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (minSpin));

	dialogAlarmData.year = year;
	dialogAlarmData.month = mon;
	dialogAlarmData.day = day;
	dialogAlarmData.hour = hour;
	dialogAlarmData.min = min;

	*func (&dialogAlarmData);

	gtk_widget_destroy (alarmWindow);
	alarmWindow = (GtkWidget *) NULL;
}
static int alarmCanFunction (GtkWidget * widget, GtkWidget * win)
{
	gtk_widget_destroy (alarmWindow);
	alarmWindow = (GtkWidget *) NULL;
}

static int alarmToggleFunction (GtkWidget * widget, gpointer data)
{
	dialogAlarmData.mode = (int) data;
}

int create_alarmwindow (AlarmInfo alarmData, int *function ())
{
	GtkWidget *vbox1;
	GtkWidget *hbox2;
	GtkWidget *label1;
	GSList *hbox2_group = NULL;
	GtkWidget *hbox3;
	GtkWidget *label2;
	GtkWidget *hbox4;
	GtkWidget *label3;
	GtkObject *yearSpin_adj;
	GtkWidget *label4;
	GtkObject *monthSpin_adj;
	GtkWidget *label5;
	GtkObject *daySpin_adj;
	GtkWidget *label6;
	GtkObject *hourSpin_adj;
	GtkWidget *label7;
	GtkObject *minSpin_adj;
	GtkWidget *label8;
	GtkWidget *hseparator1;
	GtkWidget *hbox1;
	int x, y, w, h;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;

	if (alarmWindow != (GtkWidget *) NULL)
	{
		create_messageWin (alarmWindow,
				   "̤Υ顼ԽɥɽƤޤ");
		return (0);
	}

	dialogAlarmData.mode = alarmData.mode;
	dialogAlarmData.year = alarmData.year;
	dialogAlarmData.month = alarmData.month;
	dialogAlarmData.day = alarmData.day;
	dialogAlarmData.hour = alarmData.hour;
	dialogAlarmData.min = alarmData.min;

	alarmWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (alarmWindow), "alarmWindow",
			     alarmWindow);
	gtk_widget_set_usize (alarmWindow, 455, 160);
	gtk_window_set_title (GTK_WINDOW (alarmWindow), "顼");
	gtk_widget_set_uposition (alarmWindow, (x - 455 * 0.5),
				  (y - 160 * 0.5));
	gtk_widget_show (alarmWindow);
	gtk_signal_connect (GTK_OBJECT (alarmWindow), "destroy",
			    GTK_SIGNAL_FUNC (alarmCanFunction), alarmWindow);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "vbox1", vbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (alarmWindow), vbox1);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, TRUE, 10);

	label1 = gtk_label_new ("顼ࡡ");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "label1", label1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (hbox2), label1, FALSE, FALSE, 0);

	alarmSetToggle =
		gtk_radio_button_new_with_label (hbox2_group, "ꤹ");
	hbox2_group =
		gtk_radio_button_group (GTK_RADIO_BUTTON (alarmSetToggle));
	gtk_widget_ref (alarmSetToggle);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "alarmSetToggle",
				  alarmSetToggle,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alarmSetToggle);
	gtk_box_pack_start (GTK_BOX (hbox2), alarmSetToggle, FALSE, FALSE, 5);

	alarmNonSetToggle =
		gtk_radio_button_new_with_label (hbox2_group, "ꤷʤ");
	hbox2_group =
		gtk_radio_button_group (GTK_RADIO_BUTTON (alarmNonSetToggle));
	gtk_widget_ref (alarmNonSetToggle);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow),
				  "alarmNonSetToggle", alarmNonSetToggle,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alarmNonSetToggle);
	gtk_box_pack_start (GTK_BOX (hbox2), alarmNonSetToggle, FALSE, FALSE,
			    5);

	hbox3 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "hbox3", hbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, TRUE, 5);

	label2 = gtk_label_new ("");
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "label2", label2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (hbox3), label2, FALSE, FALSE, 0);

	hbox4 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox4);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "hbox4", hbox4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox4);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox4, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hbox4), 5);

	label3 = gtk_label_new ("");
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "label3", label3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_box_pack_start (GTK_BOX (hbox4), label3, FALSE, FALSE, 0);

	yearSpin_adj =
		gtk_adjustment_new (dialogAlarmData.year, 1980, 2030, 1, 10,
				    10);
	yearSpin = gtk_spin_button_new (GTK_ADJUSTMENT (yearSpin_adj), 1, 0);
	gtk_widget_ref (yearSpin);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "yearSpin",
				  yearSpin,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (yearSpin);
	gtk_box_pack_start (GTK_BOX (hbox4), yearSpin, TRUE, TRUE, 0);

	label4 = gtk_label_new ("ǯ");
	gtk_widget_ref (label4);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "label4", label4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_box_pack_start (GTK_BOX (hbox4), label4, FALSE, FALSE, 0);

	monthSpin_adj =
		gtk_adjustment_new (dialogAlarmData.month, 1, 12, 1, 10, 10);
	monthSpin =
		gtk_spin_button_new (GTK_ADJUSTMENT (monthSpin_adj), 1, 0);
	gtk_widget_ref (monthSpin);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "monthSpin",
				  monthSpin,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (monthSpin);
	gtk_box_pack_start (GTK_BOX (hbox4), monthSpin, TRUE, TRUE, 0);

	label5 = gtk_label_new ("");
	gtk_widget_ref (label5);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "label5", label5,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label5);
	gtk_box_pack_start (GTK_BOX (hbox4), label5, FALSE, FALSE, 0);

	daySpin_adj =
		gtk_adjustment_new (dialogAlarmData.day, 1, 31, 1, 10, 10);
	daySpin = gtk_spin_button_new (GTK_ADJUSTMENT (daySpin_adj), 1, 0);
	gtk_widget_ref (daySpin);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "daySpin",
				  daySpin,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (daySpin);
	gtk_box_pack_start (GTK_BOX (hbox4), daySpin, TRUE, TRUE, 0);

	label6 = gtk_label_new ("");
	gtk_widget_ref (label6);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "label6", label6,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label6);
	gtk_box_pack_start (GTK_BOX (hbox4), label6, FALSE, FALSE, 0);

	hourSpin_adj =
		gtk_adjustment_new (dialogAlarmData.hour, 0, 23, 1, 10, 10);
	hourSpin = gtk_spin_button_new (GTK_ADJUSTMENT (hourSpin_adj), 1, 0);
	gtk_widget_ref (hourSpin);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "hourSpin",
				  hourSpin,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hourSpin);
	gtk_box_pack_start (GTK_BOX (hbox4), hourSpin, TRUE, TRUE, 0);

	label7 = gtk_label_new ("");
	gtk_widget_ref (label7);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "label7", label7,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label7);
	gtk_box_pack_start (GTK_BOX (hbox4), label7, FALSE, FALSE, 0);

	minSpin_adj =
		gtk_adjustment_new (dialogAlarmData.min, 0, 59, 1, 10, 10);
	minSpin = gtk_spin_button_new (GTK_ADJUSTMENT (minSpin_adj), 1, 0);
	gtk_widget_ref (minSpin);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "minSpin",
				  minSpin,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (minSpin);
	gtk_box_pack_start (GTK_BOX (hbox4), minSpin, TRUE, TRUE, 0);

	label8 = gtk_label_new ("ʬ");
	gtk_widget_ref (label8);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "label8", label8,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label8);
	gtk_box_pack_start (GTK_BOX (hbox4), label8, FALSE, FALSE, 0);

	hseparator1 = gtk_hseparator_new ();
	gtk_widget_ref (hseparator1);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "hseparator1",
				  hseparator1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hseparator1);
	gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, FALSE, TRUE, 5);

	hbox1 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 5);

	alarmSetBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (alarmSetBtn);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "alarmSetBtn",
				  alarmSetBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alarmSetBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), alarmSetBtn, FALSE, FALSE, 0);

	alarmCanBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (alarmCanBtn);
	gtk_object_set_data_full (GTK_OBJECT (alarmWindow), "alarmCanBtn",
				  alarmCanBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alarmCanBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), alarmCanBtn, FALSE, FALSE, 0);

	/* ХåϿ */
	gtk_signal_connect (GTK_OBJECT (alarmSetBtn), "clicked",
			    (GtkSignalFunc) alarmSetFunction, function);

	/* Хåؿ */
	gtk_signal_connect (GTK_OBJECT (alarmCanBtn), "clicked",
			    (GtkSignalFunc) alarmCanFunction, alarmWindow);

	/* ȥܥ󥳡Хåؿ */
	gtk_signal_connect (GTK_OBJECT (alarmSetToggle), "clicked",
			    (GtkSignalFunc) alarmToggleFunction,
			    (gpointer) 1);
	gtk_signal_connect (GTK_OBJECT (alarmNonSetToggle), "clicked",
			    (GtkSignalFunc) alarmToggleFunction,
			    (gpointer) 0);


#ifdef	DEBUG9
	fprintf (stdout, "create_alarmwindow dialogAlarmData.mode => %d\n",
		 dialogAlarmData.mode);
#endif

	/* 顼Υǡ */
	if (dialogAlarmData.mode == 0)
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      (alarmNonSetToggle), TRUE);
	}
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      (alarmSetToggle), TRUE);
	}

}
