/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpcalen.h"

extern CxpCalen *cxpcalen;

extern int cxpcalenfilefunc_close ();
extern int cxpcalenkindfunc_add ();
extern int cxpcalenkindfunc_mod ();
extern int cxpcalenkindfunc_del ();
extern int cxpcalentodofunc_add ();
extern int cxpcalentodofunc_mod ();
extern int cxpcalentodofunc_del ();
extern int cxpcalenscdufunc_add ();
extern int cxpcalenscdufunc_mod ();
extern int cxpcalenscdufunc_del ();
extern int cxpcalensettfunc_sett ();
extern int cxpcalenhelpfunc_about ();
extern int viewlist_selection ();
extern int viewlist_unselection ();
extern int todolist_selection ();
extern int todolist_unselection ();
extern int daylist_selection ();
extern int daylist_unselection ();
extern int timelist_selection ();
extern int timelist_unselection ();
extern int viewAddBtnFunction ();
extern int viewModBtnFunction ();
extern int viewDelBtnFunction ();
extern int todoAddBtnFunction ();
extern int todoModBtnFunction ();
extern int todoDelBtnFunction ();
extern int YmdDownBtnFunction ();
extern int YmdUpBtnFunction ();
extern void calendar_day_selected ();


static void filemenu_response ();
static void kindmenu_response ();
static void todomenu_response ();
static void scdumenu_response ();
static void settmenu_response ();
static void helpmenu_response ();

static char *timeLabelDefine[24] = {
	"AM 00:00", "AM 01:00", "AM 02:00", "AM 03:00",
	"AM 04:00", "AM 05:00", "AM 06:00", "AM 07:00",
	"AM 08:00", "AM 09:00", "AM 10:00", "AM 11:00",
	"PM 12:00", "PM 13:00", "PM 14:00", "PM 15:00",
	"PM 16:00", "PM 17:00", "PM 18:00", "PM 19:00",
	"PM 20:00", "PM 21:00", "PM 22:00", "PM 23:00"
};

#define	FILEIACT_CLOSE	0x0101
#define	KINDIACT_ADD	0x0201
#define	KINDIACT_MOD	0x0202
#define	KINDIACT_DEL	0x0203
#define	TODOIACT_ADD	0x0301
#define	TODOIACT_MOD	0x0302
#define	TODOIACT_DEL	0x0303
#define	SCDUIACT_ADD	0x0401
#define	SCDUIACT_MOD	0x0402
#define	SCDUIACT_DEL	0x0403
#define	SETTIACT_SETT	0x0501
#define	HELPIACT_ABOUT	0x0901


#define	FILEMENU_BASE	"/ե"
#define	FILEMENU_SEP1	"/ե/sep1"
#define	FILEMENU_CLOSE	"/ե/Ĥ"

#define	KINDMENU_BASE	"/ɽ"
#define	KINDMENU_ADD	"/ɽ/ɲ"
#define	KINDMENU_MOD	"/ɽ/ѹ"
#define	KINDMENU_DEL	"/ɽ/"

#define	TODOMENU_BASE	"/ԣģ"
#define	TODOMENU_ADD	"/ԣģ/ɲ"
#define	TODOMENU_MOD	"/ԣģ/ѹ"
#define	TODOMENU_DEL	"/ԣģ/"

#define	SCDUMENU_BASE	"/塼"
#define	SCDUMENU_ADD	"/塼/ɲ"
#define	SCDUMENU_MOD	"/塼/ѹ"
#define	SCDUMENU_DEL	"/塼/"

#define	SETTMENU_BASE	"/"
#define	SETTMENU_SETT   "//ɽ֡"

#define	HELPMENU_BASE	"/إ"
#define	HELPMENU_ABOUT	"/إ/CxpcalenˤĤ"

static GtkItemFactoryEntry menu_items[] = {
	{FILEMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{FILEMENU_SEP1, NULL, NULL, 0, "<Separator>"},
	{FILEMENU_CLOSE, "<control>Q", filemenu_response, FILEIACT_CLOSE,
	 NULL},
	{KINDMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{KINDMENU_ADD, NULL, kindmenu_response, KINDIACT_ADD, NULL},
	{KINDMENU_MOD, NULL, kindmenu_response, KINDIACT_MOD, NULL},
	{KINDMENU_DEL, NULL, kindmenu_response, KINDIACT_DEL, NULL},
	{TODOMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{TODOMENU_ADD, NULL, todomenu_response, TODOIACT_ADD, NULL},
	{TODOMENU_MOD, NULL, todomenu_response, TODOIACT_MOD, NULL},
	{TODOMENU_DEL, NULL, todomenu_response, TODOIACT_DEL, NULL},
	{SCDUMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{SCDUMENU_ADD, "<control>A", scdumenu_response, SCDUIACT_ADD, NULL},
	{SCDUMENU_MOD, "<control>M", scdumenu_response, SCDUIACT_MOD, NULL},
	{SCDUMENU_DEL, "<control>D", scdumenu_response, SCDUIACT_DEL, NULL},
	{SETTMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{SETTMENU_SETT, NULL, settmenu_response, SETTIACT_SETT, NULL},
	{HELPMENU_BASE, NULL, NULL, 0, "<LastBranch>"},
	{HELPMENU_ABOUT, NULL, helpmenu_response, HELPIACT_ABOUT, NULL},
};

static void filemenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case FILEIACT_CLOSE:
		cxpcalenfilefunc_close ();
		break;
	}
}

static void kindmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case KINDIACT_ADD:
		cxpcalenkindfunc_add ();
		break;
	case KINDIACT_MOD:
		cxpcalenkindfunc_mod ();
		break;
	case KINDIACT_DEL:
		cxpcalenkindfunc_del ();
		break;
	}
}

static void todomenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case TODOIACT_ADD:
		cxpcalentodofunc_add ();
		break;
	case TODOIACT_MOD:
		cxpcalentodofunc_mod ();
		break;
	case TODOIACT_DEL:
		cxpcalentodofunc_del ();
		break;
	}
}

static void scdumenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case SCDUIACT_ADD:
		cxpcalenscdufunc_add ();
		break;
	case SCDUIACT_MOD:
		cxpcalenscdufunc_mod ();
		break;
	case SCDUIACT_DEL:
		cxpcalenscdufunc_del ();
		break;
	}
}

static void settmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case SETTIACT_SETT:
		cxpcalensettfunc_sett ();
		break;
	}
}

static void helpmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case HELPIACT_ABOUT:
		cxpcalenhelpfunc_about ();
		break;
	}
}


int cxpcalen_start ()
{
	GtkWidget *table1;
	GtkWidget *hpaned1;
	GtkWidget *vpaned1;
	GtkWidget *viewport1;
	GtkWidget *scrolledwindow1;
	GtkWidget *vbox1;
	GtkWidget *vbox2;
	GtkWidget *vbox45;
	GtkWidget *vbox46;
	GtkWidget *vbox47;
	GtkWidget *vbox48;
	GtkWidget *hbox2;
	GtkWidget *hbox3;
	GtkWidget *hbox1;
	GtkWidget *hbox4;
	GtkWidget *hbox6;
	GtkWidget *hbox31;
	GtkWidget *hbox32;
	GtkWidget *hbox33;
	GtkWidget *hbox34;
	GtkWidget *frame67;
	GtkWidget *frameMonth[50];
	GtkWidget *vboxMonth[50];
	GtkWidget *frameDay[50];
	GtkWidget *hboxDay[50];
	GtkWidget *hbox35;
	GtkWidget *vbox49;
	GtkWidget *hbox36;
	GtkWidget *frame68;
	GtkWidget *labelDay[50];
	GtkWidget *label9;
	GtkWidget *label11;
	GtkWidget *label12;
	GtkWidget *label13;
	GtkWidget *label14;
	GtkWidget *label15;
	GtkWidget *label16;
	GtkWidget *label17;
	GtkWidget *label60;
	GtkWidget *label85;
	GtkWidget *label86;
	GtkWidget *label87;
	GtkWidget *label88;
	GtkWidget *swinKind;
	GtkWidget *swinTodo;
	GtkWidget *swinHanrei;
	GtkWidget *swinMonth[50];
	GtkWidget *swinTime[50];
	GtkItemFactory *item_factory;
	GtkAccelGroup *accel_group;
	int nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);
	int i;
	int x, y, w, h;
	int xymode, whmode;

	/* μ */
	getGeometryInfo (CXPCALEN_MODE, &xymode, &whmode, &x, &y, &w, &h);

	cxpcalen->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (cxpcalen->window), "window",
			     cxpcalen->window);
	gtk_window_set_title (GTK_WINDOW (cxpcalen->window), "Cxpcalen");
	gtk_widget_set_usize (cxpcalen->window, 400, 400);
	gtk_window_set_default_size (GTK_WINDOW (cxpcalen->window), 700, 600);

	gtk_signal_connect (GTK_OBJECT (cxpcalen->window), "destroy",
			    GTK_SIGNAL_FUNC (cxpcalenfilefunc_close), NULL);

	if ((xymode == 0) || (xymode == 1))
	{
		if (x != -1 && y != -1)
		{
			/* ΰ */
			if (x >= gdk_root_parent.width)
				x = gdk_root_parent.width / 2;
			if (y >= gdk_root_parent.height)
				y = gdk_root_parent.height / 2;

			gtk_widget_set_uposition (cxpcalen->window, x, y);
		}
	}

	if ((whmode == 0) || (whmode == 1))
	{
		if (w != -1 && h != -1)
		{
			if (w >= gdk_root_parent.width)
				w = gdk_root_parent.width;
			if (h >= gdk_root_parent.height)
				h = gdk_root_parent.height;

			gtk_window_set_default_size (GTK_WINDOW
						     (cxpcalen->window), w,
						     h);
		}
	}


	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "vbox1",
				  vbox1, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (cxpcalen->window), vbox1);

	accel_group = gtk_accel_group_new ();

	item_factory =
		gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",
				      accel_group);

	gtk_item_factory_create_items (item_factory, nmenu_items, menu_items,
				       NULL);

	gtk_accel_group_attach (accel_group, GTK_OBJECT (cxpcalen->window));

	cxpcalen->menubar =
		gtk_item_factory_get_widget (item_factory, "<main>");
	gtk_widget_show (cxpcalen->menubar);
	gtk_box_pack_start (GTK_BOX (vbox1), cxpcalen->menubar, FALSE, FALSE,
			    0);

	hpaned1 = gtk_hpaned_new ();
	gtk_widget_ref (hpaned1);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "hpaned1",
				  hpaned1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hpaned1);
	gtk_box_pack_start (GTK_BOX (vbox1), hpaned1, TRUE, TRUE, 0);
	gtk_paned_set_position (GTK_PANED (hpaned1), 150);

	vbox46 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox46);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "vbox46",
				  vbox46,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox46);
	gtk_paned_pack1 (GTK_PANED (hpaned1), vbox46, FALSE, TRUE);

	hbox32 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox32);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "hbox32",
				  hbox32,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox32);
	gtk_box_pack_start (GTK_BOX (vbox46), hbox32, TRUE, TRUE, 0);

	vpaned1 = gtk_vpaned_new ();
	gtk_widget_ref (vpaned1);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "vpaned1",
				  vpaned1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vpaned1);
	gtk_box_pack_start (GTK_BOX (hbox32), vpaned1, TRUE, TRUE, 5);
	gtk_paned_set_position (GTK_PANED (vpaned1), 250);

	vbox47 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox47);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "vbox47",
				  vbox47,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox47);
	gtk_paned_pack1 (GTK_PANED (vpaned1), vbox47, FALSE, TRUE);

	label86 = gtk_label_new ("ɽ");
	gtk_widget_ref (label86);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "label86",
				  label86,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label86);
	gtk_box_pack_start (GTK_BOX (vbox47), label86, FALSE, FALSE, 0);

	hbox34 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox34);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "hbox34",
				  hbox34,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox34);
	gtk_box_pack_start (GTK_BOX (vbox47), hbox34, FALSE, TRUE, 4);

	cxpcalen->viewAddBtn = gtk_button_new_with_label (" ɲ ");
	gtk_widget_ref (cxpcalen->viewAddBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "viewAddBtn",
				  cxpcalen->viewAddBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpcalen->viewAddBtn);
	gtk_box_pack_start (GTK_BOX (hbox34), cxpcalen->viewAddBtn, FALSE,
			    FALSE, 0);

	cxpcalen->viewModBtn = gtk_button_new_with_label (" ѹ ");
	gtk_widget_ref (cxpcalen->viewModBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "viewModBtn",
				  cxpcalen->viewModBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpcalen->viewModBtn);
	gtk_box_pack_start (GTK_BOX (hbox34), cxpcalen->viewModBtn, FALSE,
			    FALSE, 0);

	cxpcalen->viewDelBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (cxpcalen->viewDelBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "viewDelBtn",
				  cxpcalen->viewDelBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpcalen->viewDelBtn);
	gtk_box_pack_start (GTK_BOX (hbox34), cxpcalen->viewDelBtn, FALSE,
			    FALSE, 0);

	swinKind = gtk_scrolled_window_new (NULL, NULL);

	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swinKind),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_box_pack_end (GTK_BOX (vbox47), swinKind, TRUE, TRUE, 5);
	gtk_widget_show (swinKind);

	cxpcalen->viewList = gtk_clist_new (1);
	gtk_clist_set_selection_mode (GTK_CLIST (cxpcalen->viewList),
				      GTK_SELECTION_BROWSE);
	gtk_signal_connect (GTK_OBJECT (cxpcalen->viewList), "select_row",
			    GTK_SIGNAL_FUNC (viewlist_selection), NULL);
	gtk_signal_connect (GTK_OBJECT (cxpcalen->viewList), "unselect_row",
			    GTK_SIGNAL_FUNC (viewlist_unselection), NULL);

	gtk_container_add (GTK_CONTAINER (swinKind), cxpcalen->viewList);
	gtk_widget_show (cxpcalen->viewList);

	vbox48 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox48);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "vbox48",
				  vbox48,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox48);
	gtk_paned_pack2 (GTK_PANED (vpaned1), vbox48, TRUE, TRUE);

	label87 = gtk_label_new ("ԣģꥹ");
	gtk_widget_ref (label87);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "label87",
				  label87,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label87);
	gtk_box_pack_start (GTK_BOX (vbox48), label87, FALSE, FALSE, 0);

	hbox33 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox33);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "hbox33",
				  hbox33,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox33);
	gtk_box_pack_start (GTK_BOX (vbox48), hbox33, FALSE, TRUE, 5);


	cxpcalen->todoAddBtn = gtk_button_new_with_label (" ɲ ");
	gtk_widget_ref (cxpcalen->todoAddBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "todoAddBtn",
				  cxpcalen->todoAddBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpcalen->todoAddBtn);
	gtk_box_pack_start (GTK_BOX (hbox33), cxpcalen->todoAddBtn, FALSE,
			    FALSE, 0);

	cxpcalen->todoModBtn = gtk_button_new_with_label (" ѹ ");
	gtk_widget_ref (cxpcalen->todoModBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "todoModBtn",
				  cxpcalen->todoModBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpcalen->todoModBtn);
	gtk_box_pack_start (GTK_BOX (hbox33), cxpcalen->todoModBtn, FALSE,
			    FALSE, 0);

	cxpcalen->todoDelBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (cxpcalen->todoDelBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "todoDelBtn",
				  cxpcalen->todoDelBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpcalen->todoDelBtn);
	gtk_box_pack_start (GTK_BOX (hbox33), cxpcalen->todoDelBtn, FALSE,
			    FALSE, 0);

	swinTodo = gtk_scrolled_window_new (NULL, NULL);

	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swinTodo),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_box_pack_end (GTK_BOX (vbox48), swinTodo, TRUE, TRUE, 5);
	gtk_widget_show (swinTodo);

	cxpcalen->todoList = gtk_clist_new (1);
	gtk_clist_set_selection_mode (GTK_CLIST (cxpcalen->todoList),
				      GTK_SELECTION_BROWSE);
	gtk_signal_connect (GTK_OBJECT (cxpcalen->todoList), "select_row",
			    GTK_SIGNAL_FUNC (todolist_selection), NULL);
	gtk_signal_connect (GTK_OBJECT (cxpcalen->todoList), "unselect_row",
			    GTK_SIGNAL_FUNC (todolist_unselection), NULL);

	gtk_container_add (GTK_CONTAINER (swinTodo), cxpcalen->todoList);
	gtk_widget_show (cxpcalen->todoList);


	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "vbox2",
				  vbox2, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_paned_pack2 (GTK_PANED (hpaned1), vbox2, TRUE, TRUE);

	hbox35 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox35);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "hbox35",
				  hbox35,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox35);
	gtk_box_pack_start (GTK_BOX (vbox2), hbox35, FALSE, TRUE, 5);

	vbox49 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox49);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "vbox49",
				  vbox49,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox49);
	gtk_box_pack_start (GTK_BOX (hbox35), vbox49, FALSE, TRUE, 0);

	hbox36 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox36);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "hbox36",
				  hbox36,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox36);
	gtk_box_pack_start (GTK_BOX (vbox49), hbox36, FALSE, TRUE, 6);



	cxpcalen->YmdDownBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (cxpcalen->YmdDownBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "YmdDownBtn",
				  cxpcalen->YmdDownBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpcalen->YmdDownBtn);
	gtk_box_pack_start (GTK_BOX (hbox36), cxpcalen->YmdDownBtn, FALSE,
			    FALSE, 0);

	cxpcalen->viewYmdLabel = gtk_label_new ("XXXXǯXX");
	gtk_widget_ref (cxpcalen->viewYmdLabel);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window),
				  "viewYmdLabel", cxpcalen->viewYmdLabel,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpcalen->viewYmdLabel);
	gtk_box_pack_start (GTK_BOX (hbox36), cxpcalen->viewYmdLabel, FALSE,
			    FALSE, 0);

	cxpcalen->YmdUpBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (cxpcalen->YmdUpBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "YmdUpBtn",
				  cxpcalen->YmdUpBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpcalen->YmdUpBtn);
	gtk_box_pack_start (GTK_BOX (hbox36), cxpcalen->YmdUpBtn, FALSE,
			    FALSE, 0);

	cxpcalen->calendar1 = gtk_calendar_new ();
	gtk_widget_ref (cxpcalen->calendar1);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "calendar1",
				  cxpcalen->calendar1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpcalen->calendar1);
	gtk_box_pack_start (GTK_BOX (vbox49), cxpcalen->calendar1, FALSE,
			    TRUE, 0);
	gtk_calendar_display_options (GTK_CALENDAR (cxpcalen->calendar1),
				      GTK_CALENDAR_SHOW_DAY_NAMES);

	frame68 = gtk_frame_new (NULL);
	gtk_widget_ref (frame68);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "frame68",
				  frame68,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame68);
	gtk_box_pack_start (GTK_BOX (hbox35), frame68, TRUE, TRUE, 10);

	swinHanrei = gtk_scrolled_window_new (NULL, NULL);

	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swinHanrei),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_container_add (GTK_CONTAINER (frame68), swinHanrei);
	gtk_widget_show (swinHanrei);

	cxpcalen->HanreiList = gtk_clist_new (1);
	gtk_clist_set_selection_mode (GTK_CLIST (cxpcalen->HanreiList),
				      GTK_SELECTION_SINGLE);

	gtk_container_add (GTK_CONTAINER (swinHanrei), cxpcalen->HanreiList);
	gtk_widget_show (cxpcalen->HanreiList);


	cxpcalen->notebook1 = gtk_notebook_new ();
	gtk_widget_ref (cxpcalen->notebook1);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "notebook1",
				  cxpcalen->notebook1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpcalen->notebook1);
	gtk_box_pack_start (GTK_BOX (vbox2), cxpcalen->notebook1, TRUE, TRUE,
			    0);

	hbox4 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox4);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "hbox4",
				  hbox4, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox4);
	gtk_container_add (GTK_CONTAINER (cxpcalen->notebook1), hbox4);

	table1 = gtk_table_new (7, 7, FALSE);
	gtk_widget_ref (table1);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "table1",
				  table1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table1);
	gtk_box_pack_start (GTK_BOX (hbox4), table1, TRUE, TRUE, 0);

	label11 = gtk_label_new ("");
	gtk_widget_ref (label11);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "label11",
				  label11,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label11);
	gtk_table_attach (GTK_TABLE (table1), label11, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND),
			  (GtkAttachOptions) (0), 0, 0);

	label12 = gtk_label_new ("");
	gtk_widget_ref (label12);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "label12",
				  label12,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label12);
	gtk_table_attach (GTK_TABLE (table1), label12, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND),
			  (GtkAttachOptions) (0), 0, 0);

	label13 = gtk_label_new ("");
	gtk_widget_ref (label13);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "label13",
				  label13,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label13);
	gtk_table_attach (GTK_TABLE (table1), label13, 2, 3, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND),
			  (GtkAttachOptions) (0), 0, 0);

	label14 = gtk_label_new ("");
	gtk_widget_ref (label14);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "label14",
				  label14,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label14);
	gtk_table_attach (GTK_TABLE (table1), label14, 3, 4, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND),
			  (GtkAttachOptions) (0), 0, 0);

	label15 = gtk_label_new ("");
	gtk_widget_ref (label15);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "label15",
				  label15,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label15);
	gtk_table_attach (GTK_TABLE (table1), label15, 4, 5, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND),
			  (GtkAttachOptions) (0), 0, 0);

	label16 = gtk_label_new ("");
	gtk_widget_ref (label16);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "label16",
				  label16,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label16);
	gtk_table_attach (GTK_TABLE (table1), label16, 5, 6, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND),
			  (GtkAttachOptions) (0), 0, 0);

	label17 = gtk_label_new ("");
	gtk_widget_ref (label17);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "label17",
				  label17,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label17);
	gtk_table_attach (GTK_TABLE (table1), label17, 6, 7, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND),
			  (GtkAttachOptions) (0), 0, 0);

	for (i = 0; i < 42; i++)
	{
		frameMonth[i] = gtk_frame_new (NULL);
#if 0
		gtk_widget_ref (frameMonth[i]);
		gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window),
					  "frame", frameMonth[i],
					  (GtkDestroyNotify)
					  gtk_widget_unref);
#endif
		gtk_widget_show (frameMonth[i]);
		gtk_table_attach (GTK_TABLE (table1), frameMonth[i],
				  (int) ((i + 7) % 7),
				  (int) ((i + 7) % 7 + 1),
				  (int) ((i + 7) / 7),
				  (int) ((i + 7) / 7 + 1),
				  (GtkAttachOptions) (GTK_FILL),
				  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
				  0, 0);

		vboxMonth[i] = gtk_vbox_new (FALSE, 0);
		gtk_widget_show (vboxMonth[i]);
		gtk_container_add (GTK_CONTAINER (frameMonth[i]),
				   vboxMonth[i]);

		cxpcalen->dayLabel[i] = gtk_label_new ("XX");
		gtk_widget_show (cxpcalen->dayLabel[i]);
		gtk_box_pack_start (GTK_BOX (vboxMonth[i]),
				    cxpcalen->dayLabel[i], FALSE, FALSE, 0);

		swinMonth[i] = gtk_scrolled_window_new (NULL, NULL);

#if 0
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW
						(swinMonth[i]),
						GTK_POLICY_AUTOMATIC,
						GTK_POLICY_AUTOMATIC);
#else
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW
						(swinMonth[i]),
						GTK_POLICY_NEVER,
						GTK_POLICY_NEVER);
#endif
		gtk_box_pack_end (GTK_BOX (vboxMonth[i]), swinMonth[i], TRUE,
				  TRUE, 0);
		gtk_widget_show (swinMonth[i]);

		cxpcalen->dayList[i] = gtk_clist_new (1);
		gtk_clist_set_selection_mode (GTK_CLIST
					      (cxpcalen->dayList[i]),
					      GTK_SELECTION_SINGLE);
		gtk_signal_connect (GTK_OBJECT (cxpcalen->dayList[i]),
				    "select_row",
				    GTK_SIGNAL_FUNC (daylist_selection),
				    (gpointer) i);
		gtk_signal_connect (GTK_OBJECT (cxpcalen->dayList[i]),
				    "unselect_row",
				    GTK_SIGNAL_FUNC (daylist_unselection),
				    (gpointer) i);

		gtk_container_add (GTK_CONTAINER (swinMonth[i]),
				   cxpcalen->dayList[i]);
		gtk_widget_show (cxpcalen->dayList[i]);
	}



	label9 = gtk_label_new ("Υ塼");
	gtk_widget_ref (label9);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "label9",
				  label9,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label9);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (cxpcalen->notebook1),
				    gtk_notebook_get_nth_page (GTK_NOTEBOOK
							       (cxpcalen->
								notebook1),
							       0), label9);

	hbox6 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox6);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "hbox6",
				  hbox6, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox6);
	gtk_container_add (GTK_CONTAINER (cxpcalen->notebook1), hbox6);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow1);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window),
				  "scrolledwindow1", scrolledwindow1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (hbox6), scrolledwindow1, FALSE, TRUE, 0);

	viewport1 = gtk_viewport_new (NULL, NULL);
	gtk_widget_ref (viewport1);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "viewport1",
				  viewport1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (viewport1);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), viewport1);

	vbox45 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox45);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "vbox45",
				  vbox45,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox45);
	gtk_container_add (GTK_CONTAINER (viewport1), vbox45);

	frame67 = gtk_frame_new (NULL);
	gtk_widget_ref (frame67);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "frame67",
				  frame67,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame67);
	gtk_box_pack_start (GTK_BOX (vbox45), frame67, FALSE, TRUE, 0);

	hbox31 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox31);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "hbox31",
				  hbox31,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox31);
	gtk_container_add (GTK_CONTAINER (frame67), hbox31);

	label85 = gtk_label_new ("");
	gtk_widget_ref (label85);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "label85",
				  label85,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label85);
	gtk_box_pack_start (GTK_BOX (hbox31), label85, FALSE, FALSE, 0);
	gtk_widget_set_usize (label85, 60, -2);

	label88 = gtk_label_new ("塼");
	gtk_widget_ref (label88);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "label88",
				  label88,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label88);
	gtk_box_pack_start (GTK_BOX (hbox31), label88, TRUE, FALSE, 0);


	for (i = 0; i < 24; i++)
	{
		frameDay[i] = gtk_frame_new (NULL);
		gtk_widget_show (frameDay[i]);
		gtk_box_pack_start (GTK_BOX (vbox45), frameDay[i], FALSE,
				    TRUE, 0);

		hboxDay[i] = gtk_hbox_new (FALSE, 0);
		gtk_widget_show (hboxDay[i]);
		gtk_container_add (GTK_CONTAINER (frameDay[i]), hboxDay[i]);

		labelDay[i] = gtk_label_new (timeLabelDefine[i]);

		gtk_widget_show (labelDay[i]);
		gtk_box_pack_start (GTK_BOX (hboxDay[i]), labelDay[i], FALSE,
				    FALSE, 0);
		gtk_widget_set_usize (labelDay[i], 60, -2);

		swinTime[i] = gtk_scrolled_window_new (NULL, NULL);

#if 0
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW
						(swinTime[i]),
						GTK_POLICY_AUTOMATIC,
						GTK_POLICY_AUTOMATIC);
#else
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW
						(swinTime[i]),
						GTK_POLICY_NEVER,
						GTK_POLICY_NEVER);
#endif
		gtk_box_pack_end (GTK_BOX (hboxDay[i]), swinTime[i], TRUE,
				  TRUE, 0);
		gtk_widget_show (swinTime[i]);

		cxpcalen->timeList[i] = gtk_clist_new (1);
		gtk_clist_set_selection_mode (GTK_CLIST
					      (cxpcalen->timeList[i]),
					      GTK_SELECTION_SINGLE);
		gtk_signal_connect (GTK_OBJECT (cxpcalen->timeList[i]),
				    "select_row",
				    GTK_SIGNAL_FUNC (timelist_selection),
				    (gpointer) i);
		gtk_signal_connect (GTK_OBJECT (cxpcalen->timeList[i]),
				    "unselect_row",
				    GTK_SIGNAL_FUNC (timelist_unselection),
				    (gpointer) i);

		gtk_container_add (GTK_CONTAINER (swinTime[i]),
				   cxpcalen->timeList[i]);
		gtk_widget_show (cxpcalen->timeList[i]);
	}


	label60 = gtk_label_new ("Υ塼");
	gtk_widget_ref (label60);
	gtk_object_set_data_full (GTK_OBJECT (cxpcalen->window), "label60",
				  label60,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label60);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (cxpcalen->notebook1),
				    gtk_notebook_get_nth_page (GTK_NOTEBOOK
							       (cxpcalen->
								notebook1),
							       1), label60);

	/* Хå */
	gtk_signal_connect (GTK_OBJECT (cxpcalen->calendar1), "day_selected",
			    GTK_SIGNAL_FUNC (calendar_day_selected),
			    cxpcalen->calendar1);

	/* ܥ󥳡Хå */
	gtk_signal_connect (GTK_OBJECT (cxpcalen->viewAddBtn), "clicked",	/* ɲ */
			    (GtkSignalFunc) viewAddBtnFunction,
			    cxpcalen->window);
	gtk_signal_connect (GTK_OBJECT (cxpcalen->viewModBtn), "clicked",	/* ѹ */
			    (GtkSignalFunc) viewModBtnFunction,
			    cxpcalen->window);
	gtk_signal_connect (GTK_OBJECT (cxpcalen->viewDelBtn), "clicked",	/*  */
			    (GtkSignalFunc) viewDelBtnFunction,
			    cxpcalen->window);
	gtk_signal_connect (GTK_OBJECT (cxpcalen->todoAddBtn), "clicked",	/* ɲ */
			    (GtkSignalFunc) todoAddBtnFunction,
			    cxpcalen->window);
	gtk_signal_connect (GTK_OBJECT (cxpcalen->todoModBtn), "clicked",	/* ѹ */
			    (GtkSignalFunc) todoModBtnFunction,
			    cxpcalen->window);
	gtk_signal_connect (GTK_OBJECT (cxpcalen->todoDelBtn), "clicked",	/*  */
			    (GtkSignalFunc) todoDelBtnFunction,
			    cxpcalen->window);
	gtk_signal_connect (GTK_OBJECT (cxpcalen->YmdDownBtn), "clicked",	/*  */
			    (GtkSignalFunc) YmdDownBtnFunction,
			    cxpcalen->window);
	gtk_signal_connect (GTK_OBJECT (cxpcalen->YmdUpBtn), "clicked",	/*  */
			    (GtkSignalFunc) YmdUpBtnFunction,
			    cxpcalen->window);

	gtk_widget_show (cxpcalen->window);

}
