/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpcalen.h"

extern CxpCalen *cxpcalen;

/* λ */
int cxpcalenfilefunc_close ()
{
	int x, y, w, h;
	int xymode, whmode;

	getGeometryInfo (CXPCALEN_MODE, &xymode, &whmode, &x, &y, &w, &h);
	if (xymode == 0)	/* ΰ */
	{
		x = cxpcalen->window->allocation.x;
		y = cxpcalen->window->allocation.y;
	}
	if (whmode == 0)	/* Υ */
	{
		w = cxpcalen->window->allocation.width;
		h = cxpcalen->window->allocation.height;
	}
	setGeometryInfo (CXPCALEN_MODE, xymode, whmode, x, y, w, h);

	gtk_main_quit ();
}

/* ɽ֡ */
int cxpcalensettfunc_sett ()
{
	create_sizeSettingWindow (CXPCALEN_MODE);
}

/* إ׽ */
int cxpcalenhelpfunc_about ()
{
	cxpcalen_help_about ();
}

/* ɲåܥ */
int viewAddBtnFunction (GtkWidget * widget, GtkWidget * win)
{
	cxpcalenkindfunc_add ();
}

/* ѹܥ */
int viewModBtnFunction (GtkWidget * widget, GtkWidget * win)
{
	cxpcalenkindfunc_mod ();
}

/* ̺ܥ */
int viewDelBtnFunction (GtkWidget * widget, GtkWidget * win)
{
	cxpcalenkindfunc_del ();
}

/* ToDoɲåܥ */
int todoAddBtnFunction (GtkWidget * widget, GtkWidget * win)
{
	cxpcalentodofunc_add ();
}

/* ToDoѹܥ */
int todoModBtnFunction (GtkWidget * widget, GtkWidget * win)
{
	cxpcalentodofunc_mod ();
}

/* ToDoܥ */
int todoDelBtnFunction (GtkWidget * widget, GtkWidget * win)
{
	cxpcalentodofunc_del ();
}

/* ܥ */
int YmdDownBtnFunction (GtkWidget * widget, GtkWidget * win)
{
	int s_year;
	int s_month;
	int s_day;
	int max_day;

	s_year = cxpcalen->s_year;
	s_month = cxpcalen->s_month;
	s_day = cxpcalen->s_day;

	if (s_month - 1 > 0)
	{
		s_month--;
	}
	else
	{
		if (s_year - 1 > MIN_YEAR_VALUE)
		{
			s_year--;
			s_month = 12;
		}
		else
		{
			return (0);
		}
	}

	/* ǯå */
	max_day = getMonthDay (s_year, s_month);
	if (max_day < s_day)
		s_day = max_day;


	cxpcalen->s_year = s_year;
	cxpcalen->s_month = s_month;
	cxpcalen->s_day = s_day;

	/* ǡɽ */
	viewMonthData ();

	/* ǡɽ */
	viewDayData ();

	/* ǯɽ */
	gtk_calendar_select_month (GTK_CALENDAR (cxpcalen->calendar1),
				   cxpcalen->s_month - 1, cxpcalen->s_year);
	gtk_calendar_select_day (GTK_CALENDAR (cxpcalen->calendar1),
				 cxpcalen->s_day);

	return (0);
}

/* ܥ */
int YmdUpBtnFunction (GtkWidget * widget, GtkWidget * win)
{
	int s_year;
	int s_month;
	int s_day;
	int max_day;

	s_year = cxpcalen->s_year;
	s_month = cxpcalen->s_month;
	s_day = cxpcalen->s_day;

	if (s_month + 1 <= MAX_CALEN_MONTH)
	{
		s_month++;
	}
	else
	{
		if (s_year + 1 <= MAX_YEAR_VALUE)
		{
			s_year++;
			s_month = 1;
		}
		else
		{
			return (0);
		}
	}

	/* ǯå */
	max_day = getMonthDay (s_year, s_month);
	if (max_day < s_day)
		s_day = max_day;


	cxpcalen->s_year = s_year;
	cxpcalen->s_month = s_month;
	cxpcalen->s_day = s_day;

	/* ǡɽ */
	viewMonthData ();

	/* ǡɽ */
	viewDayData ();

	/* ǯɽ */
	gtk_calendar_select_month (GTK_CALENDAR (cxpcalen->calendar1),
				   cxpcalen->s_month - 1, cxpcalen->s_year);
	gtk_calendar_select_day (GTK_CALENDAR (cxpcalen->calendar1),
				 cxpcalen->s_day);

	return (0);
}
