/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpcalen.h"

extern CxpCalen *cxpcalen;

/* ɲå˥塼 */
int cxpcalenkindfunc_add ()
{
	ViewDataItem *viewitem;

	if (cxpcalen->view.kensu + 1 >= MAX_VIEWDATA_NUM)
	{
		create_messageWin (cxpcalen->window,
				   "̤Ϻ128ޤǤǤ");
		return (0);
	}

	viewitem = (ViewDataItem *) NULL;

	/* ɲ */
	create_kindwindow (viewitem, -1);
}

/* Խ˥塼 */
int cxpcalenkindfunc_mod ()
{
	ViewDataItem *viewitem;

	if (cxpcalen->view.kensu <= 0)
	{
		create_messageWin (cxpcalen->window, "̤ޤ");
		return (0);
	}

	if (cxpcalen->selectview < 0)
	{
		create_messageWin (cxpcalen->window,
				   "̤򤵤Ƥޤ");
		return (0);
	}

	if (cxpcalen->selectview >= cxpcalen->view.kensu)
	{
		create_messageWin (cxpcalen->window,
				   "̤ɽǡȰפޤ");
		return (0);
	}

	viewitem =
		(ViewDataItem *) & cxpcalen->view.view[cxpcalen->selectview];

	/* ѹ */
	create_kindwindow (viewitem, cxpcalen->selectview);
}

int kindDeleteOkfunc (GtkWidget * widget, GtkWidget * win)
{
	DIR *dfd;
	struct dirent *dp;
	char dirname[1024];
	char filename[1024];
	int i;

	if (cxpcalen->view.kensu <= 0)
	{
		create_messageWin (cxpcalen->window, "̤ޤ");
		return (0);
	}

	if (cxpcalen->selectview >= cxpcalen->view.kensu)
	{
		create_messageWin (cxpcalen->window,
				   "̤ɽǡפޤ");
		return (0);
	}

	/* ̤Υǡƺ */
	switch (cxpcalen->view.view[cxpcalen->selectview].kind)
	{
	case 0:		/* Ŀ */
		sprintf (dirname, "%s/.cxp/schedule/mine/%s",
			 getenv ("HOME"),
			 cxpcalen->view.view[cxpcalen->selectview].title);
		break;
	case 1:		/* Ż */
		sprintf (dirname, "%s/.cxp/schedule/work/%s",
			 getenv ("HOME"),
			 cxpcalen->view.view[cxpcalen->selectview].title);
		break;
	case 2:		/* ̣ */
		sprintf (dirname, "%s/.cxp/schedule/state/%s",
			 getenv ("HOME"),
			 cxpcalen->view.view[cxpcalen->selectview].title);
		break;
	case 3:		/*  */
		sprintf (dirname, "%s/.cxp/schedule/play/%s",
			 getenv ("HOME"),
			 cxpcalen->view.view[cxpcalen->selectview].title);
		break;
	case 4:		/* ¾ */
		sprintf (dirname, "%s/.cxp/schedule/other/%s",
			 getenv ("HOME"),
			 cxpcalen->view.view[cxpcalen->selectview].title);
		break;
	default:
		create_messageWin (cxpcalen->window, "̤ξǤ");
		return (0);
	}

	/* ǥ쥯ȥ꤬¸ߤΤ */
	if (!access (dirname, F_OK))
	{
		/* ǥ쥯ȥΥեƺ */
		if ((dfd = opendir (dirname)) == NULL)
		{
#ifdef	DEBUG9
			fprintf (stdout, "kindDeleteOkfunc opendir [%s]\n",
				 dirname);
#endif
			create_messageWin (cxpcalen->window,
					   "ǥ쥯ȥ򥪡ץǤޤ");
			return (-1);
		}

		for (i = 0; (dp = readdir (dfd)) != NULL; i++)
		{
			if (!strcmp (dp->d_name, ".")
			    || !strcmp (dp->d_name, ".."))
				continue;

			sprintf (filename, "%s/%s", dirname, dp->d_name);
			remove (filename);
		}

		closedir (dfd);

		/* ǥ쥯ȥ */
		rmdir (dirname);
	}

	/* ̤ */
	for (i = cxpcalen->selectview; i < cxpcalen->view.kensu - 1; i++)
	{
		cxpcalen->view.view[i].kind = cxpcalen->view.view[i + 1].kind;
		cxpcalen->view.view[i].title =
			g_strdup (cxpcalen->view.view[i + 1].title);
		cxpcalen->view.view[i].kensu =
			cxpcalen->view.view[i + 1].kensu;

		cxpcalen->view.view[i + 1].kind = 0;
		cxpcalen->view.view[i + 1].title = (char *) NULL;
		cxpcalen->view.view[i + 1].kensu = 0;
	}

	cxpcalen->view.kensu--;

	/* ǡ¸ */
	setCalenDataView (&cxpcalen->view);

	/* ǡɹ */
	getCalenDataView (&cxpcalen->view);

	/* ǡɽ */
	viewKindData ();

	/* ǡ */
	if (cxpcalen->view.kensu > 0)
	{
		gtk_clist_select_row (GTK_CLIST (cxpcalen->viewList), 0, 0);
		cxpcalen->selectview = 0;
		cxpcalen->selectday = -1;
		cxpcalen->selecttime = -1;

		/* ¾Υǡɽʤ */
		viewMonthData ();
		viewDayData ();
	}
	else
	{
		cxpcalen->selectview = -1;
		cxpcalen->selectday = -1;
		cxpcalen->selecttime = -1;

		/* ¾Υǡɽʤ */
		viewMonthData ();
		viewDayData ();
	}

	gtk_widget_destroy (win);

	return (0);
}

/* ̺˥塼 */
int cxpcalenkindfunc_del ()
{
	if (cxpcalen->view.kensu <= 0)
	{
		create_messageWin (cxpcalen->window, "̤ޤ");
		return (0);
	}

	if (cxpcalen->selectview < 0)
	{
		create_messageWin (cxpcalen->window,
				   "̤򤵤Ƥޤ");
		return (0);
	}

	if (cxpcalen->selectview >= cxpcalen->view.kensu)
	{
		create_messageWin (cxpcalen->window,
				   "̤ɽǡפޤ");
		return (0);
	}

	create_messageWin2 (cxpcalen->window,
			    "򤷤Ƥ̤ޤ",
			    kindDeleteOkfunc, NULL);
}
