/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpcalen.h"

extern CxpCalen *cxpcalen;

static GtkWidget *selectWindow = (GtkWidget *) NULL;
static GtkWidget *selectList;
static GtkWidget *selectSetBtn;
static GtkWidget *selectCanBtn;

static int selectionNo;

static int viewKindData ();

static int selectSetFunction (GtkWidget * widget, int *func ())
{
	if (selectionNo < 0)
	{
		return (0);
	}

	*func (selectionNo);

	gtk_widget_destroy (selectWindow);
	selectWindow = (GtkWidget *) NULL;
}

static int selectCanFunction (GtkWidget * widget, GtkWidget * win)
{
	gtk_widget_destroy (selectWindow);
	selectWindow = (GtkWidget *) NULL;
}

static int kindlist_selection (GtkWidget * clist, gint row, gint column,
			       GdkEventButton * event, gpointer data)
{
	if (row < 0)
		return (0);

	selectionNo = row;

	return (0);
}

static int kindlist_unselection (GtkWidget * clist, gint row, gint column,
				 GdkEventButton * event, gpointer data)
{
	if (row < 0)
		return (0);

	selectionNo = -1;

	return (0);
}

int create_selectwindow (int selectdata, int *function ())
{
	GtkWidget *vbox1;
	GtkWidget *hbox2;
	GtkWidget *hbox1;
	GtkWidget *swin;
	int x, y, w, h;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;

	if (selectWindow != (GtkWidget *) NULL)
	{
		create_messageWin (selectWindow,
				   "̤μ򥦥ɥɽƤޤ");
		return (0);
	}

	selectWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (selectWindow), "selectWindow",
			     selectWindow);
	gtk_widget_set_usize (selectWindow, 180, 240);
	gtk_window_set_title (GTK_WINDOW (selectWindow), "");
	gtk_widget_set_uposition (selectWindow, (x - 180 * 0.5),
				  (y - 240 * 0.5));
	gtk_signal_connect (GTK_OBJECT (selectWindow), "destroy",
			    GTK_SIGNAL_FUNC (selectCanFunction),
			    selectWindow);
	gtk_widget_show (selectWindow);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (selectWindow), "vbox1", vbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (selectWindow), vbox1);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (selectWindow), "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, TRUE, TRUE, 10);

	swin = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (hbox2), swin, TRUE, TRUE, 10);
	gtk_widget_show (swin);

	selectList = gtk_clist_new (1);
	gtk_clist_set_selection_mode (GTK_CLIST (selectList),
				      GTK_SELECTION_BROWSE);
	gtk_signal_connect (GTK_OBJECT (selectList), "select_row",
			    GTK_SIGNAL_FUNC (kindlist_selection), NULL);
	gtk_signal_connect (GTK_OBJECT (selectList), "unselect_row",
			    GTK_SIGNAL_FUNC (kindlist_unselection), NULL);
	gtk_container_add (GTK_CONTAINER (swin), selectList);
	gtk_widget_show (selectList);

	hbox1 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (selectWindow), "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 10);

	selectSetBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (selectSetBtn);
	gtk_object_set_data_full (GTK_OBJECT (selectWindow), "selectSetBtn",
				  selectSetBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (selectSetBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), selectSetBtn, FALSE, FALSE, 0);

	selectCanBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (selectCanBtn);
	gtk_object_set_data_full (GTK_OBJECT (selectWindow), "selectCanBtn",
				  selectCanBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (selectCanBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), selectCanBtn, FALSE, FALSE, 0);


	/* ХåϿ */
	gtk_signal_connect (GTK_OBJECT (selectSetBtn), "clicked",
			    (GtkSignalFunc) selectSetFunction, function);

	/* Хåؿ */
	gtk_signal_connect (GTK_OBJECT (selectCanBtn), "clicked",
			    (GtkSignalFunc) selectCanFunction, selectWindow);

	/* ǡɽ */
	viewKindData ();

	/* ǡ */
	gtk_clist_select_row (GTK_CLIST (selectList), selectdata, 0);

}

static int viewKindData ()
{
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	char *viewitem[2];
	char *pixname;

	/* ɽ */
	gtk_clist_freeze (GTK_CLIST (selectList));

	/* ꥹȤΥꥢ */
	gtk_clist_clear (GTK_CLIST (selectList));

	style = gtk_widget_get_style (cxpcalen->window);

	viewitem[0] = "Ŀ";
	gtk_clist_append (GTK_CLIST (selectList), viewitem);
	pixname = cxpcalen->base.kindmine.none;
	pixmap = gdk_pixmap_create_from_xpm_d (cxpcalen->window->window,
					       &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       (gchar **)
					       MakeCalenXPMdata (pixname, 0));
	gtk_clist_set_pixtext (GTK_CLIST (selectList), 0, 0, "Ŀ", 2,
			       pixmap, mask);

	viewitem[0] = "Ż";
	gtk_clist_append (GTK_CLIST (selectList), viewitem);
	pixname = cxpcalen->base.kindwork.none;
	pixmap = gdk_pixmap_create_from_xpm_d (cxpcalen->window->window,
					       &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       (gchar **)
					       MakeCalenXPMdata (pixname, 0));
	gtk_clist_set_pixtext (GTK_CLIST (selectList), 1, 0, "Ż", 2,
			       pixmap, mask);

	viewitem[0] = "̣";
	gtk_clist_append (GTK_CLIST (selectList), viewitem);
	pixname = cxpcalen->base.kindtaste.none;
	pixmap = gdk_pixmap_create_from_xpm_d (cxpcalen->window->window,
					       &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       (gchar **)
					       MakeCalenXPMdata (pixname, 0));
	gtk_clist_set_pixtext (GTK_CLIST (selectList), 2, 0, "̣", 2,
			       pixmap, mask);

	viewitem[0] = "";
	gtk_clist_append (GTK_CLIST (selectList), viewitem);
	pixname = cxpcalen->base.kindplay.none;
	pixmap = gdk_pixmap_create_from_xpm_d (cxpcalen->window->window,
					       &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       (gchar **)
					       MakeCalenXPMdata (pixname, 0));
	gtk_clist_set_pixtext (GTK_CLIST (selectList), 3, 0, "", 2,
			       pixmap, mask);

	viewitem[0] = "¾";
	gtk_clist_append (GTK_CLIST (selectList), viewitem);
	pixname = cxpcalen->base.kindother.none;
	pixmap = gdk_pixmap_create_from_xpm_d (cxpcalen->window->window,
					       &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       (gchar **)
					       MakeCalenXPMdata (pixname, 0));
	gtk_clist_set_pixtext (GTK_CLIST (selectList), 4, 0, "¾", 2,
			       pixmap, mask);


	/* ɽ */
	gtk_clist_thaw (GTK_CLIST (selectList));

}
