/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpcalen.h"

extern CxpCalen *cxpcalen;

extern char *getKindLabel ();

static GtkWidget *kindWindow = (GtkWidget *) NULL;
static GtkWidget *kindNameEntry;
static GtkWidget *kindKindEntry;
static GtkWidget *kindSelectBtn;
static GtkWidget *kindSetBtn;
static GtkWidget *kindCanBtn;

static ViewDataItem kindEditViewItem;
static int kindEditSelectNo;

static int kindSetFunction (GtkWidget * widget, GtkWidget * win)
{
	char newbuff[1024];
	char oldbuff[1024];
	char *data;
	int i;

	data = gtk_entry_get_text (GTK_ENTRY (kindNameEntry));
	if (data == (char *) NULL)
	{
		create_messageWin (kindWindow, "ǡޤ");
		return (0);
	}

	if (strlen (data) <= 0)
	{
		create_messageWin (kindWindow, "ǡޤ");
		return (0);
	}

	kindEditViewItem.title = g_strdup (data);

	/* Ʊ̾Τ뤫å */
	if (kindEditSelectNo < 0)
	{
		for (i = 0; i < cxpcalen->view.kensu; i++)
		{
			if (strcmp (data, cxpcalen->view.view[i].title) == 0)
			{
				create_messageWin (kindWindow,
						   "ˤ̾ΤϻȤƤޤ");
				return (0);
			}
		}
	}
	else
	{
		for (i = 0; i < cxpcalen->view.kensu; i++)
		{
			if (i == kindEditSelectNo)
				continue;
			if (strcmp (data, cxpcalen->view.view[i].title) == 0)
			{
				create_messageWin (kindWindow,
						   "ˤ̾ΤϻȤƤޤ");
				return (0);
			}
		}
	}

	if (kindEditSelectNo < 0)
	{
		/* ɲ */
		cxpcalen->view.view[cxpcalen->view.kensu].kind =
			kindEditViewItem.kind;
		cxpcalen->view.view[cxpcalen->view.kensu].title =
			g_strdup (kindEditViewItem.title);
		cxpcalen->view.view[cxpcalen->view.kensu].kensu =
			kindEditViewItem.kensu;
		cxpcalen->view.kensu++;
	}
	else
	{
		/* ѹ */
#if 0
		if (cxpcalen->view.view[kindEditSelectNo].kind !=
		    kindEditViewItem.kind)
		{
#endif
			switch (cxpcalen->view.view[kindEditSelectNo].kind)
			{
			case 0:
				sprintf (oldbuff, "%s/.cxp/schedule/mine/%s",
					 getenv ("HOME"),
					 cxpcalen->view.
					 view[kindEditSelectNo].title);
				break;
			case 1:
				sprintf (oldbuff, "%s/.cxp/schedule/work/%s",
					 getenv ("HOME"),
					 cxpcalen->view.
					 view[kindEditSelectNo].title);
				break;
			case 2:
				sprintf (oldbuff, "%s/.cxp/schedule/taste/%s",
					 getenv ("HOME"),
					 cxpcalen->view.
					 view[kindEditSelectNo].title);
				break;
			case 3:
				sprintf (oldbuff, "%s/.cxp/schedule/play/%s",
					 getenv ("HOME"),
					 cxpcalen->view.
					 view[kindEditSelectNo].title);
				break;
			case 4:
				sprintf (oldbuff, "%s/.cxp/schedule/other/%s",
					 getenv ("HOME"),
					 cxpcalen->view.
					 view[kindEditSelectNo].title);
				break;
			default:
				return (0);
			}

			switch (kindEditViewItem.kind)
			{
			case 0:
				sprintf (newbuff, "%s/.cxp/schedule/mine/%s",
					 getenv ("HOME"),
					 kindEditViewItem.title);
				break;
			case 1:
				sprintf (newbuff, "%s/.cxp/schedule/work/%s",
					 getenv ("HOME"),
					 kindEditViewItem.title);
				break;
			case 2:
				sprintf (newbuff, "%s/.cxp/schedule/taste/%s",
					 getenv ("HOME"),
					 kindEditViewItem.title);
				break;
			case 3:
				sprintf (newbuff, "%s/.cxp/schedule/play/%s",
					 getenv ("HOME"),
					 kindEditViewItem.title);
				break;
			case 4:
				sprintf (newbuff, "%s/.cxp/schedule/other/%s",
					 getenv ("HOME"),
					 kindEditViewItem.title);
				break;
			default:
				return (0);
			}

			rename (oldbuff, newbuff);

#if 0
		}
#endif

		cxpcalen->view.view[kindEditSelectNo].kind =
			kindEditViewItem.kind;
		cxpcalen->view.view[kindEditSelectNo].title =
			g_strdup (kindEditViewItem.title);
		cxpcalen->view.view[kindEditSelectNo].kensu =
			kindEditViewItem.kensu;
	}

	/* ǡ¸ */
	setCalenDataView (&cxpcalen->view);

	/* ǡɹ */
	getCalenDataView (&cxpcalen->view);

	/* ǡɽ */
	viewKindData ();

	/* ǡ */
	if (kindEditSelectNo < 0)
	{
		/* ɲäξˤɲäս */

		for (i = 0; i < cxpcalen->view.kensu; i++)
		{
			if (strcmp
			    (cxpcalen->view.view[i].title,
			     kindEditViewItem.title) == 0)
			{
				gtk_clist_select_row (GTK_CLIST
						      (cxpcalen->viewList), i,
						      0);
				cxpcalen->selectview = i;
				break;
			}
		}
		cxpcalen->selectday = -1;
		cxpcalen->selecttime = -1;

		/* ¾Υǡɽʤ */
		viewMonthData ();
		viewDayData ();

	}
	else
	{
		/* ѹξˤѹս */
		gtk_clist_select_row (GTK_CLIST (cxpcalen->viewList),
				      kindEditSelectNo, 0);
		cxpcalen->selectview = kindEditSelectNo;
	}

	gtk_widget_destroy (kindWindow);
	kindWindow = (GtkWidget *) NULL;
}

static int kindCanFunction (GtkWidget * widget, GtkWidget * win)
{
	gtk_widget_destroy (kindWindow);
	kindWindow = (GtkWidget *) NULL;
}

static int kindSelOkFunc (int selno)
{
	kindEditViewItem.kind = selno;

	/* ̤ɽ */
	gtk_entry_set_text (GTK_ENTRY (kindKindEntry),
			    getKindLabel (kindEditViewItem.kind));

	return (0);
}

static int kindSelFunction (GtkWidget * widget, GtkWidget * win)
{
	create_selectwindow (kindEditViewItem.kind, kindSelOkFunc);
}


int create_kindwindow (ViewDataItem * viewitem, int selno)
{
	GtkWidget *vbox1;
	GtkWidget *hbox2;
	GtkWidget *label1;
	GtkWidget *hbox3;
	GtkWidget *label2;
	GtkWidget *hseparator1;
	GtkWidget *hbox1;
	int x, y, w, h;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;

	if (kindWindow != (GtkWidget *) NULL)
	{
		create_messageWin (kindWindow,
				   "̤μԽɥɽƤޤ");
		return (0);
	}

	if (selno < 0 || viewitem == (ViewDataItem *) NULL)
	{
		/* ɲ */
		memset (&kindEditViewItem, 0x00, sizeof (ViewDataItem));
		kindEditViewItem.kind = 0;
		kindEditViewItem.title = "";
		kindEditViewItem.kensu = 0;
		kindEditSelectNo = -1;
	}
	else
	{
		/* ѹ */
		memset (&kindEditViewItem, 0x00, sizeof (ViewDataItem));
		kindEditViewItem.kind = viewitem->kind;
		kindEditViewItem.title = g_strdup (viewitem->title);
		kindEditViewItem.kensu = 0;
		kindEditSelectNo = selno;
	}

	kindWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (kindWindow), "kindWindow",
			     kindWindow);
	gtk_widget_set_usize (kindWindow, 300, 170);
	gtk_window_set_title (GTK_WINDOW (kindWindow), "ɽԽ");
	gtk_widget_set_uposition (kindWindow, (x - 600 * 0.5),
				  (y - 140 * 0.5));
	gtk_signal_connect (GTK_OBJECT (kindWindow), "destroy",
			    GTK_SIGNAL_FUNC (kindCanFunction), kindWindow);
	gtk_widget_show (kindWindow);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (kindWindow), "vbox1", vbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (kindWindow), vbox1);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (kindWindow), "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, TRUE, 15);

	label1 = gtk_label_new ("ɽ̾Ρ");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (kindWindow), "label1", label1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (hbox2), label1, FALSE, FALSE, 0);

	kindNameEntry = gtk_entry_new ();
	gtk_widget_ref (kindNameEntry);
	gtk_object_set_data_full (GTK_OBJECT (kindWindow), "kindNameEntry",
				  kindNameEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (kindNameEntry);
	gtk_box_pack_start (GTK_BOX (hbox2), kindNameEntry, TRUE, TRUE, 5);

	hbox3 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (kindWindow), "hbox3", hbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, TRUE, 15);

	label2 = gtk_label_new ("");
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (kindWindow), "label2", label2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (hbox3), label2, FALSE, FALSE, 0);

	kindKindEntry = gtk_entry_new ();
	gtk_widget_ref (kindKindEntry);
	gtk_object_set_data_full (GTK_OBJECT (kindWindow), "kindKindEntry",
				  kindKindEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (kindKindEntry);
	gtk_box_pack_start (GTK_BOX (hbox3), kindKindEntry, TRUE, TRUE, 5);

	kindSelectBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (kindSelectBtn);
	gtk_object_set_data_full (GTK_OBJECT (kindWindow), "kindSelectBtn",
				  kindSelectBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (kindSelectBtn);
	gtk_box_pack_start (GTK_BOX (hbox3), kindSelectBtn, FALSE, FALSE, 5);

	hseparator1 = gtk_hseparator_new ();
	gtk_widget_ref (hseparator1);
	gtk_object_set_data_full (GTK_OBJECT (kindWindow), "hseparator1",
				  hseparator1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hseparator1);
	gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, FALSE, TRUE, 10);

	hbox1 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (kindWindow), "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 5);

	kindSetBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (kindSetBtn);
	gtk_object_set_data_full (GTK_OBJECT (kindWindow), "kindSetBtn",
				  kindSetBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (kindSetBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), kindSetBtn, FALSE, FALSE, 0);

	kindCanBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (kindCanBtn);
	gtk_object_set_data_full (GTK_OBJECT (kindWindow), "kindCanBtn",
				  kindCanBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (kindCanBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), kindCanBtn, FALSE, FALSE, 0);

	/* ̤ԽǤʤ褦ˤ */
	gtk_entry_set_editable (GTK_ENTRY (kindKindEntry), FALSE);

	/* ХåϿ */
	gtk_signal_connect (GTK_OBJECT (kindSetBtn), "clicked",
			    (GtkSignalFunc) kindSetFunction, kindWindow);

	/* Хåؿ */
	gtk_signal_connect (GTK_OBJECT (kindCanBtn), "clicked",
			    (GtkSignalFunc) kindCanFunction, kindWindow);

	/* Хåؿ */
	gtk_signal_connect (GTK_OBJECT (kindSelectBtn), "clicked",
			    (GtkSignalFunc) kindSelFunction, kindWindow);

	/* ǡɽ */
	gtk_entry_set_text (GTK_ENTRY (kindNameEntry),
			    kindEditViewItem.title);
	gtk_entry_set_text (GTK_ENTRY (kindKindEntry),
			    getKindLabel (kindEditViewItem.kind));

}
