/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpcalen.h"

extern CxpCalen *cxpcalen;

static GtkWidget *levelWindow = (GtkWidget *) NULL;
static GtkWidget *levelList;
static GtkWidget *levelSetBtn;
static GtkWidget *levelCanBtn;
static int selectionNo;

static int viewLevelData ();

int levellist_selection (GtkWidget * clist, gint row, gint column,
			 GdkEventButton * event, gpointer data)
{
	if (row < 0)
		return (0);

	selectionNo = row;

	return (0);
}

int levellist_unselection (GtkWidget * clist, gint row, gint column,
			   GdkEventButton * event, gpointer data)
{
	if (row < 0)
		return (0);

	selectionNo = -1;

	return (0);
}

static int levelSetFunction (GtkWidget * widget, int *func ())
{
	int i;

	if (selectionNo < 0)
	{
		return (0);
	}

#ifdef	DEBUG9
	fprintf (stdout, "levelSetFunction selno => %d\n", selectionNo);
#endif

	*func (selectionNo);

	gtk_widget_destroy (levelWindow);
	levelWindow = (GtkWidget *) NULL;
}

static int levelCanFunction (GtkWidget * widget, GtkWidget * win)
{
	gtk_widget_destroy (levelWindow);
	levelWindow = (GtkWidget *) NULL;
}

int create_levelwindow (int levelData, int *function ())
{
	GtkWidget *vbox1;
	GtkWidget *hbox2;
	GtkWidget *hbox1;
	GtkWidget *swin;
	int x, y, w, h;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;

	if (levelWindow != (GtkWidget *) NULL)
	{
		create_messageWin (levelWindow,
				   "̤Υ٥򥦥ɥɽƤޤ");
		return (0);
	}

	levelWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (levelWindow), "levelWindow",
			     levelWindow);
	gtk_widget_set_usize (levelWindow, 180, 180);
	gtk_window_set_title (GTK_WINDOW (levelWindow), "٥ ");
	gtk_widget_set_uposition (levelWindow, (x - 180 * 0.5),
				  (y - 180 * 0.5));
	gtk_widget_show (levelWindow);
	gtk_signal_connect (GTK_OBJECT (levelWindow), "destroy",
			    GTK_SIGNAL_FUNC (levelCanFunction), levelWindow);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (levelWindow), "vbox1", vbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (levelWindow), vbox1);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (levelWindow), "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, TRUE, TRUE, 5);

	swin = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (hbox2), swin, TRUE, TRUE, 10);
	gtk_widget_show (swin);

	levelList = gtk_clist_new (1);
	gtk_clist_set_selection_mode (GTK_CLIST (levelList),
				      GTK_SELECTION_SINGLE);
	gtk_signal_connect (GTK_OBJECT (levelList), "select_row",
			    GTK_SIGNAL_FUNC (levellist_selection), NULL);
	gtk_signal_connect (GTK_OBJECT (levelList), "unselect_row",
			    GTK_SIGNAL_FUNC (levellist_unselection), NULL);
	gtk_container_add (GTK_CONTAINER (swin), levelList);
	gtk_widget_show (levelList);

	hbox1 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (levelWindow), "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 9);

	levelSetBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (levelSetBtn);
	gtk_object_set_data_full (GTK_OBJECT (levelWindow), "levelSetBtn",
				  levelSetBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (levelSetBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), levelSetBtn, FALSE, FALSE, 0);

	levelCanBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (levelCanBtn);
	gtk_object_set_data_full (GTK_OBJECT (levelWindow), "levelCanBtn",
				  levelCanBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (levelCanBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), levelCanBtn, FALSE, FALSE, 0);

	/* ХåϿ */
	gtk_signal_connect (GTK_OBJECT (levelSetBtn), "clicked",
			    (GtkSignalFunc) levelSetFunction, function);

	/* Хåؿ */
	gtk_signal_connect (GTK_OBJECT (levelCanBtn), "clicked",
			    (GtkSignalFunc) levelCanFunction, levelWindow);


	/* ǡɽ */
	viewLevelData ();

}

static int viewLevelData ()
{
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	char *viewitem[2];
	char *pixname;

	/* ɽ */
	gtk_clist_freeze (GTK_CLIST (levelList));

	/* ꥹȤΥꥢ */
	gtk_clist_clear (GTK_CLIST (levelList));

	style = gtk_widget_get_style (cxpcalen->window);

	viewitem[0] = "̾";
	gtk_clist_append (GTK_CLIST (levelList), viewitem);
	pixname = cxpcalen->base.levelnormal.none;
	pixmap = gdk_pixmap_create_from_xpm_d (cxpcalen->window->window,
					       &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       (gchar **)
					       MakeCalenXPMdata (pixname, 0));
	gtk_clist_set_pixtext (GTK_CLIST (levelList), 0, 0, "̾", 2, pixmap,
			       mask);

	viewitem[0] = "";
	gtk_clist_append (GTK_CLIST (levelList), viewitem);
	pixname = cxpcalen->base.leveljyuyou.none;
	pixmap = gdk_pixmap_create_from_xpm_d (cxpcalen->window->window,
					       &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       (gchar **)
					       MakeCalenXPMdata (pixname, 0));
	gtk_clist_set_pixtext (GTK_CLIST (levelList), 1, 0, "", 2, pixmap,
			       mask);

	viewitem[0] = "۵";
	gtk_clist_append (GTK_CLIST (levelList), viewitem);
	pixname = cxpcalen->base.levelkinkyu.none;
	pixmap = gdk_pixmap_create_from_xpm_d (cxpcalen->window->window,
					       &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       (gchar **)
					       MakeCalenXPMdata (pixname, 0));
	gtk_clist_set_pixtext (GTK_CLIST (levelList), 2, 0, "۵", 2, pixmap,
			       mask);

	viewitem[0] = "¾";
	gtk_clist_append (GTK_CLIST (levelList), viewitem);
	pixname = cxpcalen->base.levelother.none;
	pixmap = gdk_pixmap_create_from_xpm_d (cxpcalen->window->window,
					       &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       (gchar **)
					       MakeCalenXPMdata (pixname, 0));
	gtk_clist_set_pixtext (GTK_CLIST (levelList), 3, 0, "¾", 2,
			       pixmap, mask);


	/* ɽ */
	gtk_clist_thaw (GTK_CLIST (levelList));

}
