/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpcalen.h"

extern CxpCalen *cxpcalen;

static int monthListAllUnselect ();
static int dayListAllUnselect ();
static int monthListOneSelect ();
static int dayListOneSelect ();
static int selectDataViewhanrei ();

/* ɽ */
int viewlist_selection (GtkWidget * clist, gint row, gint column,
			GdkEventButton * event, gpointer data)
{
	if (row < 0)
		return (0);

#ifdef  DEBUG9
	fprintf (stdout, "viewlist_selection row -> [%d]\n", row);
#endif

	if (cxpcalen->view.kensu > row)
		cxpcalen->selectview = row;
	else
		cxpcalen->selectview = 0;

	/* Υǡɽ */
	viewMonthData ();

	/* Υǡɽ */
	viewDayData ();

	return (0);
}

/* ɽ */
int viewlist_unselection (GtkWidget * clist, gint row, gint column,
			  GdkEventButton * event, gpointer data)
{
#ifdef  DEBUG9
	fprintf (stdout, "viewlist_unselection\n");
#endif

	cxpcalen->selectview = -1;

	/* Υǡɽ */
	viewMonthData ();

	/* Υǡɽ */
	viewDayData ();

	return (0);
}

/* ToDo */
int todolist_selection (GtkWidget * clist, gint row, gint column,
			GdkEventButton * event, gpointer data)
{
	if (row < 0)
		return (0);

#ifdef  DEBUG9
	fprintf (stdout, "todolist_selection row -> [%d]\n", row);
#endif

	if (cxpcalen->todo.kensu > row)
		cxpcalen->selecttodo = row;
	else
		cxpcalen->selecttodo = 0;

	return (0);
}

/* ToDo */
int todolist_unselection (GtkWidget * clist, gint row, gint column,
			  GdkEventButton * event, gpointer data)
{
#ifdef  DEBUG9
	fprintf (stdout, "todolist_unselection\n");
#endif

	cxpcalen->selecttodo = -1;
}

/* ɽꥹ */
int daylist_selection (GtkWidget * clist, gint row, gint column,
		       GdkEventButton * event, gpointer data)
{
	int startweek;

	/* ̵ξˤϽʤ */
	if (cxpcalen->notDaySelection == 1)
		return (0);

#ifdef	DEBUG9
	fprintf (stdout, "daylist_selection data -> %d\n", (int) data);
#endif

	/* 򤷤򥫥ꤹ */
	cxpcalen->notCalenSelectNotDataView = 1;	/* ǡɽʤ */

	startweek =
		getStartMonthPosition (cxpcalen->s_year, cxpcalen->s_month);
	cxpcalen->s_day = ((int) data - startweek) + 1;
	gtk_calendar_select_day (GTK_CALENDAR (cxpcalen->calendar1),
				 cxpcalen->s_day);

	/* 򤷤ܤꤹ */
	cxpcalen->selectday = (int) data;

	/* 򤷤ܤꤹ */
	cxpcalen->selecttime = row;

	/* 򤵤Ƥܤ */
	monthListAllUnselect (cxpcalen->selectday);

	/* 򤵤Ƥܤ */
	dayListAllUnselect (-1);

	/* 򤷤ܤɽιܤ֤ꤹ */
	dayListOneSelect ();

	/* 򤷤ܤƤˤϲ̾¦ɽ */
	selectDataViewhanrei (cxpcalen->selectday, cxpcalen->selecttime);

#ifdef	DEBUG9
	fprintf (stdout, "daylist_selection selectday  -> %d\n",
		 cxpcalen->selectday);
	fprintf (stdout, "daylist_selection selecttime -> %d\n",
		 cxpcalen->selecttime);
#endif

	return (0);
}

/* ɽꥹ */
int daylist_unselection (GtkWidget * clist, gint row, gint column,
			 GdkEventButton * event, gpointer data)
{
#ifdef	DEBUG9
	fprintf (stdout, "daylist_unselection data -> %d\n", (int) data);
#endif

	/* ⤷ʤ */
	return (0);
}

/* ɽλꥹ */
int timelist_selection (GtkWidget * clist, gint row, gint column,
			GdkEventButton * event, gpointer data)
{
	Day *dayInfo;
	int timecount[32];
	int i, k, z;
	int cmax;
	int maxday, startweek;

	/* ̵ξˤϽʤ */
	if (cxpcalen->notTimeSelection == 1)
		return (0);

	/* ηκǽ */
	maxday = getMonthDay (cxpcalen->s_year, cxpcalen->s_month);

	/* ηκǽ */
	startweek =
		getStartMonthPosition (cxpcalen->s_year, cxpcalen->s_month);

#ifdef	DEBUG9
	fprintf (stdout, "timelist_selection data -> %d\n", (int) data);
#endif

	dayInfo =
		&cxpcalen->data.month[cxpcalen->s_month -
				      1].day[cxpcalen->s_day - 1];

	memset (timecount, 0x00, sizeof (timecount));
	for (z = 0; z < 24; z++)
	{
		for (i = 0; i < dayInfo->kensu; i++)
		{
			if (dayInfo->info[i].hour == z)
			{
				timecount[z]++;
			}
		}
	}

#ifdef	DEBUG9
	fprintf (stdout, "timelist_selection timecount[%d] => %d\n",
		 (int) data, timecount[(int) data]);
#endif

	cmax = 0;
	for (z = 0; z < (int) data; z++)
		cmax += timecount[z];
	cxpcalen->selecttime = cmax + row;

#ifdef	DEBUG9
	fprintf (stdout, "timelist_selection selecttime => %d\n",
		 cxpcalen->selecttime);
#endif


	/* 򤵤Ƥܤ */
	monthListAllUnselect (-1);

	/* 򤵤Ƥܤ */
	dayListAllUnselect (cxpcalen->selecttime);

	cxpcalen->selectday = (cxpcalen->s_day - 1) + startweek;

	/* 򤷤ܤηɽιܤ֤ꤹ */
	monthListOneSelect ();

	/* 򤷤ܤƤˤϲ̾¦ɽ */
	selectDataViewhanrei (cxpcalen->selectday, cxpcalen->selecttime);

#ifdef	DEBUG9
	fprintf (stdout, "timelist_selection selectday  -> %d\n",
		 cxpcalen->selectday);
	fprintf (stdout, "timelist_selection selecttime -> %d\n",
		 cxpcalen->selecttime);
#endif



	return (0);
}

/* ɽλꥹ */
int timelist_unselection (GtkWidget * clist, gint row, gint column,
			  GdkEventButton * event, gpointer data)
{
#ifdef	DEBUG9
	fprintf (stdout, "timelist_unselection data -> %d\n", (int) data);
#endif

	/* ⤷ʤ */
	return (0);
}

/* ɽιܤ */
static int monthListAllUnselect (int selectday)
{
	Day *dayInfo;
	int maxday, startweek;
	int x, y, cnt;

	/* ηκǽ */
	maxday = getMonthDay (cxpcalen->s_year, cxpcalen->s_month);

	/* ηκǽ */
	startweek =
		getStartMonthPosition (cxpcalen->s_year, cxpcalen->s_month);


	/* Υ塼ƥꥢ */
	for (x = 0; x < maxday; x++)
	{
		dayInfo = &cxpcalen->data.month[cxpcalen->s_month - 1].day[x];
		for (y = 0; y < dayInfo->kensu; y++)
		{
			cnt = x + startweek;

			if (selectday == cnt)
				break;
#ifdef	DEBUG9
			fprintf (stdout, "clear cnt => [%d]\n", cnt);
#endif
			gtk_clist_unselect_row (GTK_CLIST
						(cxpcalen->dayList[cnt]), y,
						0);
		}
	}

	return (0);
}

/* ɽιܤ */
static int dayListAllUnselect (int selecttime)
{
	Day *dayInfo;
	int timecount[32];
	int i, z, k;

	dayInfo =
		&cxpcalen->data.month[cxpcalen->s_month -
				      1].day[cxpcalen->s_day - 1];

	memset (timecount, 0x00, sizeof (timecount));
	for (z = 0; z < 24; z++)
	{
		for (i = 0; i < dayInfo->kensu; i++)
		{
			if (dayInfo->info[i].hour == z)
			{
				timecount[z]++;
			}
		}
	}

	k = 0;
	for (z = 0; z < 24; z++)
	{
		for (i = 0; i < timecount[z]; i++)
		{
			if (selecttime >= 0)
			{
				if (k != selecttime)
				{
					gtk_clist_unselect_row (GTK_CLIST
								(cxpcalen->
								 timeList[z]),
								i, 0);
				}
			}
			else
			{
				gtk_clist_unselect_row (GTK_CLIST
							(cxpcalen->
							 timeList[z]), i, 0);
			}
			k++;
		}
	}

	return (0);
}

/* ɽλꤵ줿ܤ֤Ȥ */
static int dayListOneSelect ()
{
	Day *dayInfo;
	int timecount[32];
	int i, k, z;

#ifdef	DEBUG9
	fprintf (stdout, "dayListOneSelect \n");
	fprintf (stdout, "dayListOneSelect cxpcalen->selecttime => %d\n",
		 cxpcalen->selecttime);
#endif

	dayInfo =
		&cxpcalen->data.month[cxpcalen->s_month -
				      1].day[cxpcalen->s_day - 1];

	memset (timecount, 0x00, sizeof (timecount));
	for (z = 0; z < 24; z++)
	{
		for (i = 0; i < dayInfo->kensu; i++)
		{
			if (dayInfo->info[i].hour == z)
			{
				timecount[z]++;
			}
		}

#ifdef	DEBUG9
		if (timecount[z] > 0)
			fprintf (stdout,
				 "dayListOneSelect timecount[%d] => %d\n", z,
				 timecount[z]);
#endif
	}

	/* ɽλ̵ */
	cxpcalen->notTimeSelection = 1;

	k = 0;
	for (z = 0; z < 24; z++)
	{
		for (i = 0; i < timecount[z]; i++)
		{
#ifdef	DEBUG9
			fprintf (stdout,
				 "dayListOneSelect k (%d) cxpcalen->selecttime (%d)\n",
				 k, cxpcalen->selecttime);
#endif
			if (k == cxpcalen->selecttime)
			{
#ifdef	DEBUG9
				fprintf (stdout,
					 "dayListOneSelect cxpcalen->selecttime => %d z [%d] i [%d]\n",
					 cxpcalen->selecttime, z, i);
#endif
				gtk_clist_select_row (GTK_CLIST
						      (cxpcalen->timeList[z]),
						      i, 0);
				k++;
				break;
			}
			k++;
		}
	}

	cxpcalen->notTimeSelection = 0;

	return (0);
}

/* ɽλꤵ줿ܤ֤Ȥ */
static int monthListOneSelect ()
{
	Day *dayInfo;
	int maxday, startweek;
	int x, y, z, k, cnt;

	cxpcalen->notDaySelection = 1;

	/* ηκǽ */
	maxday = getMonthDay (cxpcalen->s_year, cxpcalen->s_month);

	/* ηκǽ */
	startweek =
		getStartMonthPosition (cxpcalen->s_year, cxpcalen->s_month);

#ifdef	DEBUG9
	fprintf (stdout, "monthListOneSelect maxday => %d\n", maxday);
	fprintf (stdout, "monthListOneSelect startweek => %d\n", startweek);
	fprintf (stdout, "monthListOneSelect selectday => %d\n",
		 cxpcalen->selectday);
#endif

	/* ꤵ줿ս֤Ȥ */
	gtk_clist_select_row (GTK_CLIST
			      (cxpcalen->dayList[cxpcalen->selectday]),
			      cxpcalen->selecttime, 0);

	cxpcalen->notDaySelection = 0;

	return (0);
}

/* 򤷤ܤ㥨ꥢɽ */
static int selectDataViewhanrei (int selectday, int selecttime)
{
	Day *dayInfo;
	int maxday, startweek;
	int x, y, cnt;

	/* ηκǽ */
	maxday = getMonthDay (cxpcalen->s_year, cxpcalen->s_month);

	/* ηκǽ */
	startweek =
		getStartMonthPosition (cxpcalen->s_year, cxpcalen->s_month);


	/* Υ塼ƥꥢ */
	for (x = 0; x < maxday; x++)
	{
		dayInfo = &cxpcalen->data.month[cxpcalen->s_month - 1].day[x];
		for (y = 0; y < dayInfo->kensu; y++)
		{
			cnt = x + startweek;

			if (selectday == cnt)
			{
				viewHanreiData (&dayInfo->info[selecttime]);
				break;
			}
		}
	}

	return (0);
}
