/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpcalen.h"

extern CxpCalen *cxpcalen;

extern char *getKindLabel ();
extern char *getLebelLabel ();
extern char *getAlarmLabel ();

static GtkWidget *schWindow = (GtkWidget *) NULL;
static GtkWidget *kindEntry;
static GtkWidget *yearSpin;
static GtkWidget *monthSpin;
static GtkWidget *daySpin;
static GtkWidget *hourSpin;
static GtkWidget *minSpin;
static GtkWidget *levelEntry;
static GtkWidget *levelSelectBtn;
static GtkWidget *titleEntry;
static GtkWidget *schNaiyoText;
static GtkWidget *alarmSettingBtn;
static GtkWidget *alarmSettingLabel;
static GtkWidget *schSetBtn;
static GtkWidget *schCanBtn;

static ScduInfo schEditInfo;
static int schEditKind;
static int schEditYear;
static int schEditSelno;

static int schSetFunction (GtkWidget * widget, GtkWidget * win)
{
	Year wyear;
	Day *dayInfo;
	int year, mon, day, hour, min;
	int backYear, backMonth, backDay, backHour, backMin;
	char *backTitle;
	char *title, *dataptr;
	int i;

	/* ǯʬμФ */
	year = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (yearSpin));
	mon = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (monthSpin));
	day = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (daySpin));
	hour = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (hourSpin));
	min = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (minSpin));

	/* ȥμ */
	title = gtk_entry_get_text (GTK_ENTRY (titleEntry));
	if (title == (char *) NULL || strlen (title) <= 0)
	{
		create_messageWin (schWindow, "ȥ뤬ϤƤޤ");
		return (0);
	}

	/* Ƥμ */
	dataptr = gtk_editable_get_chars (GTK_EDITABLE (schNaiyoText), 0, -1);

	/* ѹξˤǯ¸Ƥ */
	backYear = schEditYear;
	backMonth = schEditInfo.month;
	backDay = schEditInfo.day;
	backHour = schEditInfo.hour;
	backMin = schEditInfo.min;
	backTitle = g_strdup (schEditInfo.title);


	schEditYear = year;
	schEditInfo.month = mon;
	schEditInfo.day = day;
	schEditInfo.hour = hour;
	schEditInfo.min = min;
	schEditInfo.title = g_strdup (title);
	if (strlen (dataptr) <= 0)
	{
		schEditInfo.length = 0;
		schEditInfo.data = (char *) NULL;
	}
	else
	{
		schEditInfo.length = strlen (dataptr);
		schEditInfo.data = g_strdup (dataptr);
	}

	/* ѹˤΥǡ */
	if (schEditSelno >= 0)
	{
		/* Υǡ */
		dayInfo =
			&cxpcalen->data.month[backMonth - 1].day[backDay - 1];

		for (i = schEditSelno; i < dayInfo->kensu - 1; i++)
		{
			dayInfo->info[i].month = dayInfo->info[i + 1].month;
			dayInfo->info[i].day = dayInfo->info[i + 1].day;
			dayInfo->info[i].hour = dayInfo->info[i + 1].hour;
			dayInfo->info[i].min = dayInfo->info[i + 1].min;
			dayInfo->info[i].level = dayInfo->info[i + 1].level;
			dayInfo->info[i].title =
				g_strdup (dayInfo->info[i + 1].title);
			dayInfo->info[i].alarm.mode =
				dayInfo->info[i + 1].alarm.mode;
			dayInfo->info[i].alarm.year =
				dayInfo->info[i + 1].alarm.year;
			dayInfo->info[i].alarm.month =
				dayInfo->info[i + 1].alarm.month;
			dayInfo->info[i].alarm.day =
				dayInfo->info[i + 1].alarm.day;
			dayInfo->info[i].alarm.hour =
				dayInfo->info[i + 1].alarm.hour;
			dayInfo->info[i].alarm.min =
				dayInfo->info[i + 1].alarm.min;
			dayInfo->info[i].length = dayInfo->info[i + 1].length;
			if (dayInfo->info[i + 1].length > 0)
			{
				dayInfo->info[i].data =
					g_strdup (dayInfo->info[i + 1].data);
			}
			else
			{
				dayInfo->info[i].data = (char *) NULL;
			}

			dayInfo->info[i + 1].month = 0;
			dayInfo->info[i + 1].day = 0;
			dayInfo->info[i + 1].hour = 0;
			dayInfo->info[i + 1].min = 0;
			dayInfo->info[i + 1].level = 0;
			dayInfo->info[i + 1].title = (char *) NULL;
			dayInfo->info[i + 1].alarm.mode = 0;
			dayInfo->info[i + 1].alarm.year = 0;
			dayInfo->info[i + 1].alarm.month = 0;
			dayInfo->info[i + 1].alarm.day = 0;
			dayInfo->info[i + 1].alarm.hour = 0;
			dayInfo->info[i + 1].alarm.min = 0;
			dayInfo->info[i + 1].length = 0;
			dayInfo->info[i + 1].data = (char *) NULL;
		}
		dayInfo->kensu--;

		/* ǡ¸ */
		setCalenDataSchedule (backYear,
				      &cxpcalen->view.view[schEditKind],
				      &cxpcalen->data);
	}


    /*- Υǡ򿷤ɲä --*/

	/* ǡɤ߹ */
	memset (&wyear, 0x00, sizeof (Year));
	getCalenDataSchedule (schEditYear,
			      &cxpcalen->view.view[schEditKind], &wyear);

	/* ǡꤹ */
	dayInfo =
		&wyear.month[schEditInfo.month - 1].day[schEditInfo.day - 1];
	dayInfo->info[dayInfo->kensu].month = schEditInfo.month;
	dayInfo->info[dayInfo->kensu].day = schEditInfo.day;
	dayInfo->info[dayInfo->kensu].hour = schEditInfo.hour;
	dayInfo->info[dayInfo->kensu].min = schEditInfo.min;
	dayInfo->info[dayInfo->kensu].level = schEditInfo.level;
	dayInfo->info[dayInfo->kensu].title = g_strdup (schEditInfo.title);
	dayInfo->info[dayInfo->kensu].alarm.mode = schEditInfo.alarm.mode;
	dayInfo->info[dayInfo->kensu].alarm.year = schEditInfo.alarm.year;
	dayInfo->info[dayInfo->kensu].alarm.month = schEditInfo.alarm.month;
	dayInfo->info[dayInfo->kensu].alarm.day = schEditInfo.alarm.day;
	dayInfo->info[dayInfo->kensu].alarm.hour = schEditInfo.alarm.hour;
	dayInfo->info[dayInfo->kensu].alarm.min = schEditInfo.alarm.min;
	dayInfo->info[dayInfo->kensu].length = schEditInfo.length;
	if (schEditInfo.length > 0)
		dayInfo->info[dayInfo->kensu].data =
			strdup (schEditInfo.data);
	else
		dayInfo->info[dayInfo->kensu].data = (char *) NULL;

	dayInfo->kensu++;

	/* ǡ¸ */
	setCalenDataSchedule (schEditYear,
			      &cxpcalen->view.view[schEditKind], &wyear);


	/* ǡκɤ߹ */
	getCalenDataSchedule (cxpcalen->s_year,
			      &cxpcalen->view.view[cxpcalen->selectview],
			      &cxpcalen->data);

	/* ǡɽ */
	viewMonthData ();	/* ɽ */
	viewDayData ();		/* ɽ */

	gtk_widget_destroy (schWindow);
	schWindow = (GtkWidget *) NULL;
}

static int schCanFunction (GtkWidget * widget, GtkWidget * win)
{
	gtk_widget_destroy (schWindow);
	schWindow = (GtkWidget *) NULL;
}

static int schlevelsetOkfunc (int level)
{
	schEditInfo.level = level;

	gtk_entry_set_text (GTK_ENTRY (levelEntry), getLebelLabel (level));

	return (0);
}

static int levelSelFunction (GtkWidget * widget, GtkWidget * win)
{
	create_levelwindow (schEditInfo.level, schlevelsetOkfunc);
}

static int schalarmsetOkfunc (AlarmInfo * alarminfo)
{
	schEditInfo.alarm.mode = alarminfo->mode;
	schEditInfo.alarm.year = alarminfo->year;
	schEditInfo.alarm.month = alarminfo->month;
	schEditInfo.alarm.day = alarminfo->day;
	schEditInfo.alarm.hour = alarminfo->hour;
	schEditInfo.alarm.min = alarminfo->min;

	gtk_label_set_text (GTK_LABEL (alarmSettingLabel),
			    getAlarmLabel (schEditInfo.alarm.mode));

	return (0);
}

static int alarmSelFunction (GtkWidget * widget, GtkWidget * win)
{
	create_alarmwindow (schEditInfo.alarm, schalarmsetOkfunc);
}


int create_schwindow (int kind, int year, ScduInfo * schinfo, int selno)
{
	GtkWidget *vbox1;
	GtkWidget *hbox1;
	GtkWidget *label1;
	GtkWidget *hbox2;
	GtkWidget *label2;
	GtkObject *yearSpin_adj;
	GtkWidget *label3;
	GtkObject *monthSpin_adj;
	GtkWidget *label4;
	GtkObject *daySpin_adj;
	GtkWidget *label5;
	GtkObject *hourSpin_adj;
	GtkWidget *label6;
	GtkObject *minSpin_adj;
	GtkWidget *label7;
	GtkWidget *hbox3;
	GtkWidget *label8;
	GtkWidget *hbox4;
	GtkWidget *label9;
	GtkWidget *hbox6;
	GtkWidget *label10;
	GtkWidget *hbox7;
	GtkWidget *scrolledwindow1;
	GtkWidget *hbox8;
	GtkWidget *hseparator1;
	GtkWidget *hbox9;
	int x, y, w, h;
	int length;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;

	if (schWindow != (GtkWidget *) NULL)
	{
		create_messageWin (schWindow,
				   "̤Υ塼ԽɥɽƤޤ");
		return (0);
	}

	if (selno < 0)
	{
		/* ɲ */
		schEditInfo.month = schinfo->month;
		schEditInfo.day = schinfo->day;
		schEditInfo.hour = schinfo->hour;
		schEditInfo.min = schinfo->min;
		schEditInfo.level = schinfo->level;
		schEditInfo.title = "";
		schEditInfo.alarm.mode = schinfo->alarm.mode;
		schEditInfo.alarm.year = schinfo->alarm.year;
		schEditInfo.alarm.month = schinfo->alarm.month;
		schEditInfo.alarm.day = schinfo->alarm.day;
		schEditInfo.alarm.hour = schinfo->alarm.hour;
		schEditInfo.alarm.min = schinfo->alarm.min;
		schEditInfo.length = 0;
		schEditInfo.data = (char *) NULL;
		schEditKind = kind;
		schEditYear = year;
		schEditSelno = -1;
	}
	else
	{
		/* ѹ */
		schEditInfo.month = schinfo->month;
		schEditInfo.day = schinfo->day;
		schEditInfo.hour = schinfo->hour;
		schEditInfo.min = schinfo->min;
		schEditInfo.level = schinfo->level;
		schEditInfo.title = g_strdup (schinfo->title);
		schEditInfo.alarm.mode = schinfo->alarm.mode;
		schEditInfo.alarm.year = schinfo->alarm.year;
		schEditInfo.alarm.month = schinfo->alarm.month;
		schEditInfo.alarm.day = schinfo->alarm.day;
		schEditInfo.alarm.hour = schinfo->alarm.hour;
		schEditInfo.alarm.min = schinfo->alarm.min;
		schEditInfo.length = schinfo->length;
		if (schinfo->length > 0)
		{
			if (schinfo->data == (char *) NULL)
				schEditInfo.data = (char *) NULL;
			else
				schEditInfo.data = g_strdup (schinfo->data);
		}
		else
		{
			schEditInfo.data = (char *) NULL;
		}
		schEditKind = kind;
		schEditYear = year;
		schEditSelno = selno;
	}

	schWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (schWindow), "schWindow", schWindow);
	gtk_widget_set_usize (schWindow, 450, 350);
	gtk_window_set_title (GTK_WINDOW (schWindow), "塼Խ");
	gtk_widget_set_uposition (schWindow, (x - 450 * 0.5),
				  (y - 350 * 0.5));
	gtk_signal_connect (GTK_OBJECT (schWindow), "destroy",
			    GTK_SIGNAL_FUNC (schCanFunction), schWindow);
	gtk_widget_show (schWindow);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "vbox1", vbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (schWindow), vbox1);

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 5);

	label1 = gtk_label_new ("̡");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "label1", label1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE, FALSE, 10);

	kindEntry = gtk_entry_new ();
	gtk_widget_ref (kindEntry);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "kindEntry",
				  kindEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (kindEntry);
	gtk_box_pack_start (GTK_BOX (hbox1), kindEntry, FALSE, TRUE, 0);
	gtk_entry_set_editable (GTK_ENTRY (kindEntry), FALSE);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, TRUE, 5);

	label2 = gtk_label_new ("");
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "label2", label2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (hbox2), label2, FALSE, FALSE, 10);

	yearSpin_adj =
		gtk_adjustment_new (schEditYear, 1980, 2030, 1, 10, 10);
	yearSpin = gtk_spin_button_new (GTK_ADJUSTMENT (yearSpin_adj), 1, 0);
	gtk_widget_ref (yearSpin);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "yearSpin",
				  yearSpin,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (yearSpin);
	gtk_box_pack_start (GTK_BOX (hbox2), yearSpin, FALSE, TRUE, 0);
	gtk_widget_set_usize (yearSpin, 60, -2);

	label3 = gtk_label_new ("ǯ");
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "label3", label3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_box_pack_start (GTK_BOX (hbox2), label3, FALSE, FALSE, 0);

	monthSpin_adj =
		gtk_adjustment_new (schEditInfo.month, 1, 12, 1, 10, 10);
	monthSpin =
		gtk_spin_button_new (GTK_ADJUSTMENT (monthSpin_adj), 1, 0);
	gtk_widget_ref (monthSpin);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "monthSpin",
				  monthSpin,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (monthSpin);
	gtk_box_pack_start (GTK_BOX (hbox2), monthSpin, FALSE, TRUE, 0);
	gtk_widget_set_usize (monthSpin, 50, -2);

	label4 = gtk_label_new ("");
	gtk_widget_ref (label4);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "label4", label4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_box_pack_start (GTK_BOX (hbox2), label4, FALSE, FALSE, 0);

	daySpin_adj = gtk_adjustment_new (schEditInfo.day, 1, 31, 1, 10, 10);
	daySpin = gtk_spin_button_new (GTK_ADJUSTMENT (daySpin_adj), 1, 0);
	gtk_widget_ref (daySpin);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "daySpin", daySpin,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (daySpin);
	gtk_box_pack_start (GTK_BOX (hbox2), daySpin, FALSE, TRUE, 0);
	gtk_widget_set_usize (daySpin, 50, -2);

	label5 = gtk_label_new ("");
	gtk_widget_ref (label5);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "label5", label5,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label5);
	gtk_box_pack_start (GTK_BOX (hbox2), label5, FALSE, FALSE, 0);

	hourSpin_adj =
		gtk_adjustment_new (schEditInfo.hour, 0, 29, 1, 10, 10);
	hourSpin = gtk_spin_button_new (GTK_ADJUSTMENT (hourSpin_adj), 1, 0);
	gtk_widget_ref (hourSpin);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "hourSpin",
				  hourSpin,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hourSpin);
	gtk_box_pack_start (GTK_BOX (hbox2), hourSpin, FALSE, TRUE, 0);
	gtk_widget_set_usize (hourSpin, 50, -2);

	label6 = gtk_label_new ("");
	gtk_widget_ref (label6);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "label6", label6,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label6);
	gtk_box_pack_start (GTK_BOX (hbox2), label6, FALSE, FALSE, 0);

	minSpin_adj = gtk_adjustment_new (schEditInfo.min, 0, 59, 1, 10, 10);
	minSpin = gtk_spin_button_new (GTK_ADJUSTMENT (minSpin_adj), 1, 0);
	gtk_widget_ref (minSpin);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "minSpin", minSpin,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (minSpin);
	gtk_box_pack_start (GTK_BOX (hbox2), minSpin, FALSE, TRUE, 0);
	gtk_widget_set_usize (minSpin, 50, -2);

	label7 = gtk_label_new ("ʬ");
	gtk_widget_ref (label7);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "label7", label7,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label7);
	gtk_box_pack_start (GTK_BOX (hbox2), label7, FALSE, FALSE, 0);

	hbox3 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "hbox3", hbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, TRUE, 5);

	label8 = gtk_label_new ("٥롧");
	gtk_widget_ref (label8);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "label8", label8,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label8);
	gtk_box_pack_start (GTK_BOX (hbox3), label8, FALSE, FALSE, 10);

	levelEntry = gtk_entry_new_with_max_length (20);
	gtk_widget_ref (levelEntry);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "levelEntry",
				  levelEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (levelEntry);
	gtk_box_pack_start (GTK_BOX (hbox3), levelEntry, FALSE, TRUE, 10);
	gtk_entry_set_editable (GTK_ENTRY (levelEntry), FALSE);

	levelSelectBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (levelSelectBtn);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "levelSelectBtn",
				  levelSelectBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (levelSelectBtn);
	gtk_box_pack_start (GTK_BOX (hbox3), levelSelectBtn, FALSE, FALSE, 0);

	hbox4 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox4);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "hbox4", hbox4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox4);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox4, FALSE, TRUE, 5);

	label9 = gtk_label_new ("ȥ롧");
	gtk_widget_ref (label9);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "label9", label9,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label9);
	gtk_box_pack_start (GTK_BOX (hbox4), label9, FALSE, FALSE, 10);

	titleEntry = gtk_entry_new ();
	gtk_widget_ref (titleEntry);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "titleEntry",
				  titleEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (titleEntry);
	gtk_box_pack_start (GTK_BOX (hbox4), titleEntry, TRUE, TRUE, 10);

	hbox6 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox6);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "hbox6", hbox6,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox6);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox6, FALSE, TRUE, 5);

	label10 = gtk_label_new ("");
	gtk_widget_ref (label10);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "label10", label10,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label10);
	gtk_box_pack_start (GTK_BOX (hbox6), label10, FALSE, FALSE, 10);

	hbox7 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox7);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "hbox7", hbox7,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox7);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox7, TRUE, TRUE, 5);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow1);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "scrolledwindow1",
				  scrolledwindow1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (hbox7), scrolledwindow1, TRUE, TRUE, 10);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
					GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	schNaiyoText = gtk_text_new (NULL, NULL);
	gtk_widget_ref (schNaiyoText);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "schNaiyoText",
				  schNaiyoText,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (schNaiyoText);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), schNaiyoText);
	gtk_text_set_editable (GTK_TEXT (schNaiyoText), TRUE);

	hbox8 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox8);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "hbox8", hbox8,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox8);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox8, FALSE, TRUE, 5);

	alarmSettingBtn = gtk_button_new_with_label (" 顼 ");
	gtk_widget_ref (alarmSettingBtn);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "alarmSettingBtn",
				  alarmSettingBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alarmSettingBtn);
	gtk_box_pack_start (GTK_BOX (hbox8), alarmSettingBtn, FALSE, FALSE,
			    10);

	alarmSettingLabel = gtk_label_new ("ߥ顼ꤵƤޤ");
	gtk_widget_ref (alarmSettingLabel);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "alarmSettingLabel",
				  alarmSettingLabel,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alarmSettingLabel);
	gtk_box_pack_start (GTK_BOX (hbox8), alarmSettingLabel, FALSE, FALSE,
			    0);

	hseparator1 = gtk_hseparator_new ();
	gtk_widget_ref (hseparator1);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "hseparator1",
				  hseparator1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hseparator1);
	gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, FALSE, TRUE, 5);

	hbox9 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox9);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "hbox9", hbox9,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox9);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox9, FALSE, TRUE, 5);

	schSetBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (schSetBtn);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "schSetBtn",
				  schSetBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (schSetBtn);
	gtk_box_pack_start (GTK_BOX (hbox9), schSetBtn, FALSE, FALSE, 0);

	schCanBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (schCanBtn);
	gtk_object_set_data_full (GTK_OBJECT (schWindow), "schCanBtn",
				  schCanBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (schCanBtn);
	gtk_box_pack_start (GTK_BOX (hbox9), schCanBtn, FALSE, FALSE, 0);

	/* ХåϿ */
	gtk_signal_connect (GTK_OBJECT (schSetBtn), "clicked",
			    (GtkSignalFunc) schSetFunction, schWindow);

	/* Хåؿ */
	gtk_signal_connect (GTK_OBJECT (schCanBtn), "clicked",
			    (GtkSignalFunc) schCanFunction, schWindow);

	/* Хåؿ */
	gtk_signal_connect (GTK_OBJECT (levelSelectBtn), "clicked",
			    (GtkSignalFunc) levelSelFunction, schWindow);

	/* Хåؿ */
	gtk_signal_connect (GTK_OBJECT (alarmSettingBtn), "clicked",
			    (GtkSignalFunc) alarmSelFunction, schWindow);


	/* ̤ԽǤʤ褦ˤ */
	gtk_entry_set_editable (GTK_ENTRY (kindEntry), FALSE);

	/* ٥ԽǤʤ褦ˤ */
	gtk_entry_set_editable (GTK_ENTRY (levelEntry), FALSE);

	/* ǡɽ */
	gtk_entry_set_text (GTK_ENTRY (kindEntry),
			    getKindLabel (cxpcalen->view.view[schEditKind].
					  kind));
	gtk_entry_set_text (GTK_ENTRY (levelEntry),
			    getLebelLabel (schEditInfo.level));
	gtk_entry_set_text (GTK_ENTRY (titleEntry), schEditInfo.title);

	/* ƥȤɽ */
	if (schEditInfo.length > 0 && schEditInfo.data != (char *) NULL)
	{
		/* ɽ */
		gtk_text_freeze (GTK_TEXT (schNaiyoText));

		/* ǡ */
		gtk_text_insert (GTK_TEXT (schNaiyoText),
				 cxpcalen->font, NULL, NULL,
				 schEditInfo.data, strlen (schEditInfo.data));

		/* ɽ */
		gtk_text_thaw (GTK_TEXT (schNaiyoText));
	}

	/* 顼å */
	gtk_label_set_text (GTK_LABEL (alarmSettingLabel),
			    getAlarmLabel (schEditInfo.alarm.mode));

}
