/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpcalen.h"

extern CxpCalen *cxpcalen;

/* 塼ɲå˥塼 */
int cxpcalenscdufunc_add ()
{
	ScduInfo schinfo;
	int schyear;
	int schkind;
	int year, month, day, hour, min;

#ifdef	DEBUG9
	fprintf (stdout, "cxpcalenscdufunc_add selectview => %d\n",
		 cxpcalen->selectview);
	fprintf (stdout, "cxpcalenscdufunc_add selectday  => %d\n",
		 cxpcalen->selectday);
	fprintf (stdout, "cxpcalenscdufunc_add selecttime => %d\n",
		 cxpcalen->selecttime);
#endif

	if (cxpcalen->view.kensu <= 0)
	{
		create_messageWin (cxpcalen->window, "̤ޤ");
		return (0);
	}

	if (cxpcalen->selectview < 0)
	{
		create_messageWin (cxpcalen->window,
				   "̤򤵤Ƥޤ");
		return (0);
	}

	memset (&schinfo, 0x00, sizeof (ScduInfo));

	/* ߤǯФ */
	cxpcalen_getsystemdate (&year, &month, &day, &hour, &min);

	if (cxpcalen->selectday >= 0)
	{
		/* 򤵤Ƥ˥ǡɲä */
		schyear = cxpcalen->s_year;
		schinfo.month = cxpcalen->s_month;
		schinfo.day = cxpcalen->s_day;
		schinfo.hour = hour;
		schinfo.min = min;
		schinfo.level = 0;
		schinfo.title = "";
		schinfo.alarm.mode = 0;
		schinfo.alarm.year = cxpcalen->s_year;
		schinfo.alarm.month = cxpcalen->s_month;
		schinfo.alarm.day = cxpcalen->s_day;
		schinfo.alarm.hour = hour;
		schinfo.alarm.min = min;
		schinfo.length = 0;
		schinfo.data = (char *) NULL;

	}
	else
	{
		/* ߤ˥ǡɲä */
		schyear = year;
		schinfo.month = month;
		schinfo.day = day;
		schinfo.hour = hour;
		schinfo.min = min;
		schinfo.level = 0;
		schinfo.title = "";
		schinfo.alarm.mode = 0;
		schinfo.alarm.year = year;
		schinfo.alarm.month = month;
		schinfo.alarm.day = day;
		schinfo.alarm.hour = hour;
		schinfo.alarm.min = min;
		schinfo.length = 0;
		schinfo.data = (char *) NULL;

	}

	/* ɲ */
	create_schwindow (cxpcalen->selectview, schyear, &schinfo, -1);
}

/* 塼Խ˥塼 */
int cxpcalenscdufunc_mod ()
{
	ScduInfo schinfo;
	int schyear;
	int year, month, day, hour, min;
	int daynumber, timenumber;

#ifdef	DEBUG9
	fprintf (stdout, "cxpcalenscdufunc_mod selectview => %d\n",
		 cxpcalen->selectview);
	fprintf (stdout, "cxpcalenscdufunc_mod selectday  => %d\n",
		 cxpcalen->selectday);
	fprintf (stdout, "cxpcalenscdufunc_mod selecttime => %d\n",
		 cxpcalen->selecttime);
#endif

	if (cxpcalen->view.kensu <= 0)
	{
		create_messageWin (cxpcalen->window, "̤ޤ");
		return (0);
	}

	if (cxpcalen->selectview < 0)
	{
		create_messageWin (cxpcalen->window,
				   "̤򤵤Ƥޤ");
		return (0);
	}

	if (cxpcalen->selectday < 0 || cxpcalen->selecttime < 0)
	{
		create_messageWin (cxpcalen->window,
				   "ѹ륹塼뤬򤵤Ƥޤ");
		return (0);
	}

	memset (&schinfo, 0x00, sizeof (ScduInfo));

	/* ߤǯФ */
	cxpcalen_getsystemdate (&year, &month, &day, &hour, &min);

	/* 򤵤Ƥܤꤹ */
	getEditScheduleItem (&schinfo, &daynumber, &timenumber);
	schyear = cxpcalen->s_year;

	/* ѹ */
	create_schwindow (cxpcalen->selectview, schyear, &schinfo,
			  timenumber);
}

/* 塼˥塼 */
int cxpcalenscdufunc_del ()
{
	Day *dayInfo;
	int i;

#ifdef	DEBUG9
	fprintf (stdout, "cxpcalenscdufunc_del selectview => %d\n",
		 cxpcalen->selectview);
	fprintf (stdout, "cxpcalenscdufunc_del selectday  => %d\n",
		 cxpcalen->selectday);
	fprintf (stdout, "cxpcalenscdufunc_del selecttime => %d\n",
		 cxpcalen->selecttime);
#endif

	if (cxpcalen->view.kensu <= 0)
	{
		create_messageWin (cxpcalen->window, "̤ޤ");
		return (0);
	}

	if (cxpcalen->selectview < 0)
	{
		create_messageWin (cxpcalen->window,
				   "̤򤵤Ƥޤ");
		return (0);
	}

	if (cxpcalen->selectday < 0 || cxpcalen->selecttime < 0)
	{
		create_messageWin (cxpcalen->window,
				   "륹塼뤬򤵤Ƥޤ");
		return (0);
	}

	/* Υǡ */
	dayInfo =
		&cxpcalen->data.month[cxpcalen->s_month -
				      1].day[cxpcalen->s_day - 1];

	for (i = cxpcalen->selecttime; i < dayInfo->kensu - 1; i++)
	{
		dayInfo->info[i].month = dayInfo->info[i + 1].month;
		dayInfo->info[i].day = dayInfo->info[i + 1].day;
		dayInfo->info[i].hour = dayInfo->info[i + 1].hour;
		dayInfo->info[i].min = dayInfo->info[i + 1].min;
		dayInfo->info[i].level = dayInfo->info[i + 1].level;
		dayInfo->info[i].title =
			g_strdup (dayInfo->info[i + 1].title);
		dayInfo->info[i].alarm.mode = dayInfo->info[i + 1].alarm.mode;
		dayInfo->info[i].alarm.year = dayInfo->info[i + 1].alarm.year;
		dayInfo->info[i].alarm.month =
			dayInfo->info[i + 1].alarm.month;
		dayInfo->info[i].alarm.day = dayInfo->info[i + 1].alarm.day;
		dayInfo->info[i].alarm.hour = dayInfo->info[i + 1].alarm.hour;
		dayInfo->info[i].alarm.min = dayInfo->info[i + 1].alarm.min;
		dayInfo->info[i].length = dayInfo->info[i + 1].length;
		if (dayInfo->info[i + 1].length > 0)
		{
			dayInfo->info[i].data =
				g_strdup (dayInfo->info[i + 1].data);
		}
		else
		{
			dayInfo->info[i].data = (char *) NULL;
		}

		dayInfo->info[i + 1].month = 0;
		dayInfo->info[i + 1].day = 0;
		dayInfo->info[i + 1].hour = 0;
		dayInfo->info[i + 1].min = 0;
		dayInfo->info[i + 1].level = 0;
		dayInfo->info[i + 1].title = (char *) NULL;
		dayInfo->info[i + 1].alarm.mode = 0;
		dayInfo->info[i + 1].alarm.year = 0;
		dayInfo->info[i + 1].alarm.month = 0;
		dayInfo->info[i + 1].alarm.day = 0;
		dayInfo->info[i + 1].alarm.hour = 0;
		dayInfo->info[i + 1].alarm.min = 0;
		dayInfo->info[i + 1].length = 0;
		dayInfo->info[i + 1].data = (char *) NULL;
	}
	dayInfo->kensu--;

	/* ǡ¸ */
	setCalenDataSchedule (cxpcalen->s_year,
			      &cxpcalen->view.view[cxpcalen->selectview],
			      &cxpcalen->data);

	/* ǡκɤ߹ */
	getCalenDataSchedule (cxpcalen->s_year,
			      &cxpcalen->view.view[cxpcalen->selectview],
			      &cxpcalen->data);

	/* ǡɽ */
	viewMonthData ();	/* ɽ */
	viewDayData ();		/* ɽ */

}

int getEditScheduleItem (ScduInfo * schinfo, int *daynumber, int *timenumber)
{
	Day *dayInfo;
	int maxday, startweek;
	int z;

	/* ηκǽ */
	maxday = getMonthDay (cxpcalen->s_year, cxpcalen->s_month);

	/* ηκǽ */
	startweek =
		getStartMonthPosition (cxpcalen->s_year, cxpcalen->s_month);

	dayInfo =
		&cxpcalen->data.month[cxpcalen->s_month -
				      1].day[cxpcalen->s_day - 1];
	z = cxpcalen->selecttime;

	/* 塼ꤹ */
	schinfo->month = dayInfo->info[z].month;
	schinfo->day = dayInfo->info[z].day;
	schinfo->hour = dayInfo->info[z].hour;
	schinfo->min = dayInfo->info[z].min;
	schinfo->level = dayInfo->info[z].level;
	schinfo->title = g_strdup (dayInfo->info[z].title);
	schinfo->alarm.mode = dayInfo->info[z].alarm.mode;
	schinfo->alarm.year = dayInfo->info[z].alarm.year;
	schinfo->alarm.month = dayInfo->info[z].alarm.month;
	schinfo->alarm.day = dayInfo->info[z].alarm.day;
	schinfo->alarm.hour = dayInfo->info[z].alarm.hour;
	schinfo->alarm.min = dayInfo->info[z].alarm.min;
	schinfo->length = dayInfo->info[z].length;

	if (dayInfo->info[z].length > 0)
	{
		if (dayInfo->info[z].data != (char *) NULL)
		{
			schinfo->data = g_strdup (dayInfo->info[z].data);
		}
		else
		{
			schinfo->data = (char *) NULL;
		}
	}
	else
	{
		schinfo->data = (char *) NULL;
	}

	*daynumber = cxpcalen->s_day - 1;
	*timenumber = cxpcalen->selecttime;

	return (0);
}
