/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpcalen.h"

extern CxpCalen *cxpcalen;

static GtkWidget *todoWindow = (GtkWidget *) NULL;
static GtkWidget *todoEntry;
static GtkWidget *todoLevelLabel;
static GtkWidget *todoLevelSelBtn;
static GtkWidget *todoAlarmBtn;
static GtkWidget *todoAlarmLabel;
static GtkWidget *todoSetBtn;
static GtkWidget *todoCanBtn;

static TodoItem todoitemwin;
static int todoSelectNo;

extern char *getAlarmLabel ();
extern char *getLebelLabel ();

static int todoSetFunction (GtkWidget * widget, GtkWidget * win)
{
	char *data;

	data = gtk_entry_get_text (GTK_ENTRY (todoEntry));
	if (data == (char *) NULL)
	{
		create_messageWin (todoWindow, "ǡޤ");
		return (0);
	}
	else if (strlen (data) <= 0)
	{
		create_messageWin (todoWindow, "ǡޤ");
		return (0);
	}

	if (todoSelectNo < 0)
	{
		/* ɲ */
		cxpcalen->todo.item[cxpcalen->todo.kensu].level =
			todoitemwin.level;
		cxpcalen->todo.item[cxpcalen->todo.kensu].alarm.mode =
			todoitemwin.alarm.mode;
		cxpcalen->todo.item[cxpcalen->todo.kensu].alarm.year =
			todoitemwin.alarm.year;
		cxpcalen->todo.item[cxpcalen->todo.kensu].alarm.month =
			todoitemwin.alarm.month;
		cxpcalen->todo.item[cxpcalen->todo.kensu].alarm.day =
			todoitemwin.alarm.day;
		cxpcalen->todo.item[cxpcalen->todo.kensu].alarm.hour =
			todoitemwin.alarm.hour;
		cxpcalen->todo.item[cxpcalen->todo.kensu].alarm.min =
			todoitemwin.alarm.min;
		cxpcalen->todo.item[cxpcalen->todo.kensu].data =
			strdup (data);
		cxpcalen->todo.kensu++;
	}
	else
	{
		/* ѹ */
		cxpcalen->todo.item[todoSelectNo].level = todoitemwin.level;
		cxpcalen->todo.item[todoSelectNo].alarm.mode =
			todoitemwin.alarm.mode;
		cxpcalen->todo.item[todoSelectNo].alarm.year =
			todoitemwin.alarm.year;
		cxpcalen->todo.item[todoSelectNo].alarm.month =
			todoitemwin.alarm.month;
		cxpcalen->todo.item[todoSelectNo].alarm.day =
			todoitemwin.alarm.day;
		cxpcalen->todo.item[todoSelectNo].alarm.hour =
			todoitemwin.alarm.hour;
		cxpcalen->todo.item[todoSelectNo].alarm.min =
			todoitemwin.alarm.min;
		cxpcalen->todo.item[todoSelectNo].data = strdup (data);
	}

	/* ǡ¸ */
	setCalenDataTodo (&cxpcalen->todo);

	/* ǡɽ */
	viewTodoData ();

	/* ǡ */
	if (todoSelectNo < 0)
		gtk_clist_select_row (GTK_CLIST (cxpcalen->todoList),
				      cxpcalen->todo.kensu - 1, 0);
	else
		gtk_clist_select_row (GTK_CLIST (cxpcalen->todoList),
				      todoSelectNo, 0);

	gtk_widget_destroy (win);
	todoWindow = (GtkWidget *) NULL;
}
static int todoCanFunction (GtkWidget * widget, GtkWidget * win)
{
	gtk_widget_destroy (win);
	todoWindow = (GtkWidget *) NULL;
}

static int alarmsetOkfunc (AlarmInfo * alarminfo)
{
	todoitemwin.alarm.mode = alarminfo->mode;
	todoitemwin.alarm.year = alarminfo->year;
	todoitemwin.alarm.month = alarminfo->month;
	todoitemwin.alarm.day = alarminfo->day;
	todoitemwin.alarm.hour = alarminfo->hour;
	todoitemwin.alarm.min = alarminfo->min;

	gtk_label_set_text (GTK_LABEL (todoAlarmLabel),
			    getAlarmLabel (todoitemwin.alarm.mode));

	return (0);
}

static int alarmSetFunction (GtkWidget * widget, GtkWidget * win)
{
	create_alarmwindow (todoitemwin.alarm, alarmsetOkfunc);
}

static int levelsetOkfunc (int level)
{
	todoitemwin.level = level;

	gtk_label_set_text (GTK_LABEL (todoLevelLabel),
			    getLebelLabel (level));

	return (0);
}

static int levelSetFunction (GtkWidget * widget, GtkWidget * win)
{
	create_levelwindow (todoitemwin.level, levelsetOkfunc);
}

int create_todowindow (TodoItem * todoitem, int selno)
{
	GtkWidget *vbox1;
	GtkWidget *hbox2;
	GtkWidget *label1;
	GtkWidget *hbox3;
	GtkWidget *hseparator1;
	GtkWidget *hbox1;
	int x, y, w, h;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;

	if (todoWindow != (GtkWidget *) NULL)
	{
		create_messageWin (todoWindow,
				   "̤ΣԣԽɥɽƤޤ");
		return (0);
	}

	if (selno < 0 || todoitem == (TodoItem *) NULL)
	{
		/* ɲ */
		memset (&todoitemwin, 0x00, sizeof (TodoItem));
		todoitemwin.level = 0;
		todoitemwin.alarm.mode = 0;

		/*  */
		cxpcalen_getsystemdate (&todoitemwin.alarm.year,
					&todoitemwin.alarm.month,
					&todoitemwin.alarm.day,
					&todoitemwin.alarm.hour,
					&todoitemwin.alarm.min);

		todoitemwin.data = (char *) NULL;

		todoSelectNo = -1;

	}
	else
	{

		/* ѹ */
		memset (&todoitemwin, 0x00, sizeof (TodoItem));
		todoitemwin.level = todoitem->level;
		todoitemwin.alarm.mode = todoitem->alarm.mode;
		todoitemwin.alarm.year = todoitem->alarm.year;
		todoitemwin.alarm.month = todoitem->alarm.month;
		todoitemwin.alarm.day = todoitem->alarm.day;
		todoitemwin.alarm.hour = todoitem->alarm.hour;
		todoitemwin.alarm.min = todoitem->alarm.min;
		todoitemwin.data = strdup (todoitem->data);

		todoSelectNo = selno;
	}

	todoWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (todoWindow), "todoWindow",
			     todoWindow);
	gtk_widget_set_usize (todoWindow, 450, 140);
	gtk_window_set_title (GTK_WINDOW (todoWindow), "ԣԽ");
	gtk_widget_set_uposition (todoWindow, (x - 450 * 0.5),
				  (y - 140 * 0.5));
	gtk_widget_show (todoWindow);
	gtk_signal_connect (GTK_OBJECT (todoWindow), "destroy",
			    GTK_SIGNAL_FUNC (todoCanFunction), todoWindow);


	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (todoWindow), "vbox1", vbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (todoWindow), vbox1);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (todoWindow), "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, TRUE, 10);

	label1 = gtk_label_new ("ơ");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (todoWindow), "label1", label1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (hbox2), label1, FALSE, FALSE, 0);

	todoEntry = gtk_entry_new ();
	gtk_widget_ref (todoEntry);
	gtk_object_set_data_full (GTK_OBJECT (todoWindow), "todoEntry",
				  todoEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (todoEntry);
	gtk_box_pack_start (GTK_BOX (hbox2), todoEntry, TRUE, TRUE, 5);

	todoLevelLabel = gtk_label_new ("XXXX");
	gtk_widget_ref (todoLevelLabel);
	gtk_object_set_data_full (GTK_OBJECT (todoWindow), "todoLevelLabel",
				  todoLevelLabel,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (todoLevelLabel);
	gtk_box_pack_start (GTK_BOX (hbox2), todoLevelLabel, FALSE, FALSE, 5);

	todoLevelSelBtn = gtk_button_new_with_label ("  ٥ ");
	gtk_widget_ref (todoLevelSelBtn);
	gtk_object_set_data_full (GTK_OBJECT (todoWindow), "todoLevelSelBtn",
				  todoLevelSelBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (todoLevelSelBtn);
	gtk_box_pack_start (GTK_BOX (hbox2), todoLevelSelBtn, FALSE, FALSE,
			    5);

	hbox3 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (todoWindow), "hbox3", hbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, TRUE, 10);

	todoAlarmBtn = gtk_button_new_with_label (" 顼 ");
	gtk_widget_ref (todoAlarmBtn);
	gtk_object_set_data_full (GTK_OBJECT (todoWindow), "todoAlarmBtn",
				  todoAlarmBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (todoAlarmBtn);
	gtk_box_pack_start (GTK_BOX (hbox3), todoAlarmBtn, FALSE, FALSE, 20);

	todoAlarmLabel = gtk_label_new ("ߥ顼ꤵƤޤ");
	gtk_widget_ref (todoAlarmLabel);
	gtk_object_set_data_full (GTK_OBJECT (todoWindow), "todoAlarmLabel",
				  todoAlarmLabel,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (todoAlarmLabel);
	gtk_box_pack_start (GTK_BOX (hbox3), todoAlarmLabel, FALSE, FALSE, 0);

	hseparator1 = gtk_hseparator_new ();
	gtk_widget_ref (hseparator1);
	gtk_object_set_data_full (GTK_OBJECT (todoWindow), "hseparator1",
				  hseparator1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hseparator1);
	gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, FALSE, TRUE, 5);

	hbox1 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (todoWindow), "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 5);

	todoSetBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (todoSetBtn);
	gtk_object_set_data_full (GTK_OBJECT (todoWindow), "todoSetBtn",
				  todoSetBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (todoSetBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), todoSetBtn, FALSE, FALSE, 0);

	todoCanBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (todoCanBtn);
	gtk_object_set_data_full (GTK_OBJECT (todoWindow), "todoCanBtn",
				  todoCanBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (todoCanBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), todoCanBtn, FALSE, FALSE, 0);


	/* ХåϿ */
	gtk_signal_connect (GTK_OBJECT (todoSetBtn), "clicked",
			    (GtkSignalFunc) todoSetFunction, todoWindow);

	/* ХåϿ */
	gtk_signal_connect (GTK_OBJECT (todoLevelSelBtn), "clicked",
			    (GtkSignalFunc) levelSetFunction, todoWindow);

	/* Хåؿ */
	gtk_signal_connect (GTK_OBJECT (todoCanBtn), "clicked",
			    (GtkSignalFunc) todoCanFunction, todoWindow);

	/* Хåؿ */
	gtk_signal_connect (GTK_OBJECT (todoAlarmBtn), "clicked",
			    (GtkSignalFunc) alarmSetFunction, todoWindow);


	/* ǡ */
	if (todoitemwin.data != (char *) NULL)
	{
		gtk_entry_set_text (GTK_ENTRY (todoEntry), todoitemwin.data);
	}
	else
	{
		gtk_entry_set_text (GTK_ENTRY (todoEntry), "");
	}

	/* 顼å */
	gtk_label_set_text (GTK_LABEL (todoAlarmLabel),
			    getAlarmLabel (todoitemwin.alarm.mode));

	/* ٥ */
	gtk_label_set_text (GTK_LABEL (todoLevelLabel),
			    getLebelLabel (todoitemwin.level));

}
