/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpcalen.h"

extern CxpCalen *cxpcalen;

int viewKindData ()
{
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	char *viewitem[2];
	char *pixname;
	int i, kensu;
	int maxBoxNum[32];
	int nowBoxNum[32];

	cxpcalen->selectview = -1;
	memset (maxBoxNum, 0x00, sizeof (maxBoxNum));
	memset (nowBoxNum, 0x00, sizeof (nowBoxNum));

	/* ɽ */
	gtk_clist_freeze (GTK_CLIST (cxpcalen->viewList));

	/* ꥹȤΥꥢ */
	gtk_clist_clear (GTK_CLIST (cxpcalen->viewList));


	/* TODOɤ߹ */
	memset (&cxpcalen->view, 0x00, sizeof (ViewData));
	getCalenDataView (&cxpcalen->view);

	if (cxpcalen->view.kensu > 0)
	{
		for (i = 0; i < cxpcalen->view.kensu; i++)
		{
			switch (cxpcalen->view.view[i].kind)
			{
			default:
			case 0:
				maxBoxNum[0]++;
				break;
			case 1:
				maxBoxNum[1]++;
				break;
			case 2:
				maxBoxNum[2]++;
				break;
			case 3:
				maxBoxNum[3]++;
				break;
			case 4:
				maxBoxNum[4]++;
				break;
			}
		}
	}

	kensu = 0;
	/* Ŀ */
	if (cxpcalen->view.kensu > 0)
	{
		for (i = 0; i < cxpcalen->view.kensu; i++)
		{
			if (cxpcalen->view.view[i].kind == 0)
			{
				viewitem[0] =
					g_strdup (cxpcalen->view.view[i].
						  title);
				gtk_clist_append (GTK_CLIST
						  (cxpcalen->viewList),
						  viewitem);

				nowBoxNum[0]++;

				if (maxBoxNum[0] == 1)
					pixname =
						cxpcalen->base.kindmine.none;
				else if (maxBoxNum[0] == nowBoxNum[0])
					pixname =
						cxpcalen->base.kindcomm.none;
				else if (maxBoxNum[0] > nowBoxNum[0]
					 && nowBoxNum[0] == 1)
					pixname =
						cxpcalen->base.kindmine.next;
				else
					pixname =
						cxpcalen->base.kindcomm.next;

				style = gtk_widget_get_style (cxpcalen->
							      window);
				pixmap = gdk_pixmap_create_from_xpm_d
					(cxpcalen->window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL],
					 (gchar **) MakeCalenXPMdata (pixname,
								      0));

				gtk_clist_set_pixtext (GTK_CLIST
						       (cxpcalen->viewList),
						       kensu, 0,
						       cxpcalen->view.view[i].
						       title, 2, pixmap,
						       mask);
				kensu++;
			}
		}
	}

	/* Ż */
	if (cxpcalen->view.kensu > 0)
	{
		for (i = 0; i < cxpcalen->view.kensu; i++)
		{
			if (cxpcalen->view.view[i].kind == 1)
			{
				viewitem[0] =
					g_strdup (cxpcalen->view.view[i].
						  title);
				gtk_clist_append (GTK_CLIST
						  (cxpcalen->viewList),
						  viewitem);

				nowBoxNum[1]++;

				if (maxBoxNum[1] == 1)
					pixname =
						cxpcalen->base.kindwork.none;
				else if (maxBoxNum[1] == nowBoxNum[1])
					pixname =
						cxpcalen->base.kindcomm.none;
				else if (maxBoxNum[1] > nowBoxNum[1]
					 && nowBoxNum[1] == 1)
					pixname =
						cxpcalen->base.kindwork.next;
				else
					pixname =
						cxpcalen->base.kindcomm.next;

				style = gtk_widget_get_style (cxpcalen->
							      window);
				pixmap = gdk_pixmap_create_from_xpm_d
					(cxpcalen->window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL],
					 (gchar **) MakeCalenXPMdata (pixname,
								      0));

				gtk_clist_set_pixtext (GTK_CLIST
						       (cxpcalen->viewList),
						       kensu, 0,
						       cxpcalen->view.view[i].
						       title, 2, pixmap,
						       mask);
				kensu++;
			}
		}
	}

	/* ̣ */
	if (cxpcalen->view.kensu > 0)
	{
		for (i = 0; i < cxpcalen->view.kensu; i++)
		{
			if (cxpcalen->view.view[i].kind == 2)
			{
				viewitem[0] =
					g_strdup (cxpcalen->view.view[i].
						  title);
				gtk_clist_append (GTK_CLIST
						  (cxpcalen->viewList),
						  viewitem);

				nowBoxNum[2]++;

				if (maxBoxNum[2] == 1)
					pixname =
						cxpcalen->base.kindtaste.none;
				else if (maxBoxNum[0] == nowBoxNum[2])
					pixname =
						cxpcalen->base.kindcomm.none;
				else if (maxBoxNum[2] > nowBoxNum[2]
					 && nowBoxNum[2] == 1)
					pixname =
						cxpcalen->base.kindtaste.next;
				else
					pixname =
						cxpcalen->base.kindcomm.next;

				style = gtk_widget_get_style (cxpcalen->
							      window);
				pixmap = gdk_pixmap_create_from_xpm_d
					(cxpcalen->window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL],
					 (gchar **) MakeCalenXPMdata (pixname,
								      0));

				gtk_clist_set_pixtext (GTK_CLIST
						       (cxpcalen->viewList),
						       kensu, 0,
						       cxpcalen->view.view[i].
						       title, 2, pixmap,
						       mask);
				kensu++;
			}
		}
	}

	/*  */
	if (cxpcalen->view.kensu > 0)
	{
		for (i = 0; i < cxpcalen->view.kensu; i++)
		{
			if (cxpcalen->view.view[i].kind == 3)
			{
				viewitem[0] =
					g_strdup (cxpcalen->view.view[i].
						  title);
				gtk_clist_append (GTK_CLIST
						  (cxpcalen->viewList),
						  viewitem);

				nowBoxNum[3]++;

				if (maxBoxNum[3] == 1)
					pixname =
						cxpcalen->base.kindplay.none;
				else if (maxBoxNum[3] == nowBoxNum[3])
					pixname =
						cxpcalen->base.kindcomm.none;
				else if (maxBoxNum[3] > nowBoxNum[3]
					 && nowBoxNum[3] == 1)
					pixname =
						cxpcalen->base.kindplay.next;
				else
					pixname =
						cxpcalen->base.kindcomm.next;

				style = gtk_widget_get_style (cxpcalen->
							      window);
				pixmap = gdk_pixmap_create_from_xpm_d
					(cxpcalen->window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL],
					 (gchar **) MakeCalenXPMdata (pixname,
								      0));

				gtk_clist_set_pixtext (GTK_CLIST
						       (cxpcalen->viewList),
						       kensu, 0,
						       cxpcalen->view.view[i].
						       title, 2, pixmap,
						       mask);
				kensu++;
			}
		}
	}

	/* ¾ */
	if (cxpcalen->view.kensu > 0)
	{
		for (i = 0; i < cxpcalen->view.kensu; i++)
		{
			if (cxpcalen->view.view[i].kind == 4)
			{
				viewitem[0] =
					g_strdup (cxpcalen->view.view[i].
						  title);
				gtk_clist_append (GTK_CLIST
						  (cxpcalen->viewList),
						  viewitem);

				nowBoxNum[4]++;

				if (maxBoxNum[4] == 1)
					pixname =
						cxpcalen->base.kindother.none;
				else if (maxBoxNum[4] == nowBoxNum[4])
					pixname =
						cxpcalen->base.kindcomm.none;
				else if (maxBoxNum[4] > nowBoxNum[4]
					 && nowBoxNum[4] == 1)
					pixname =
						cxpcalen->base.kindother.next;
				else
					pixname =
						cxpcalen->base.kindcomm.next;

				style = gtk_widget_get_style (cxpcalen->
							      window);
				pixmap = gdk_pixmap_create_from_xpm_d
					(cxpcalen->window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL],
					 (gchar **) MakeCalenXPMdata (pixname,
								      0));

				gtk_clist_set_pixtext (GTK_CLIST
						       (cxpcalen->viewList),
						       kensu, 0,
						       cxpcalen->view.view[i].
						       title, 2, pixmap,
						       mask);
				kensu++;
			}
		}
	}

	/* ɽ */
	gtk_clist_thaw (GTK_CLIST (cxpcalen->viewList));
}

int viewTodoData ()
{
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	char *viewitem[2];
	char *pixname;
	int i;

	cxpcalen->selecttodo = -1;

	/* ɽ */
	gtk_clist_freeze (GTK_CLIST (cxpcalen->todoList));

	/* ꥹȤΥꥢ */
	gtk_clist_clear (GTK_CLIST (cxpcalen->todoList));

	/* TODOɤ߹ */
	memset (&cxpcalen->todo, 0x00, sizeof (Todo));
	getCalenDataTodo (&cxpcalen->todo);
	if (cxpcalen->todo.kensu > 0)
	{
		for (i = 0; i < cxpcalen->todo.kensu; i++)
		{
#ifdef	DEBUG9
			fprintf (stdout,
				 "cxpcalen->todo.item[%d].data => [%s]\n", i,
				 cxpcalen->todo.item[i].data);
#endif
			viewitem[0] = g_strdup (cxpcalen->todo.item[i].data);
			gtk_clist_append (GTK_CLIST (cxpcalen->todoList),
					  viewitem);

			switch (cxpcalen->todo.item[i].level)
			{
			default:
			case 0:	/* ̾ */
				if (cxpcalen->todo.item[i].alarm.mode == 0)
					pixname =
						cxpcalen->base.levelnormal.
						none;
				else
					pixname =
						cxpcalen->base.levelnormal.
						next;
				break;
			case 1:	/*  */
				if (cxpcalen->todo.item[i].alarm.mode == 0)
					pixname =
						cxpcalen->base.leveljyuyou.
						none;
				else
					pixname =
						cxpcalen->base.leveljyuyou.
						next;
				break;
			case 2:	/* ۵ */
				if (cxpcalen->todo.item[i].alarm.mode == 0)
					pixname =
						cxpcalen->base.levelkinkyu.
						none;
				else
					pixname =
						cxpcalen->base.levelkinkyu.
						next;
				break;
			case 3:	/* ¾ */
				if (cxpcalen->todo.item[i].alarm.mode == 0)
					pixname =
						cxpcalen->base.levelother.
						none;
				else
					pixname =
						cxpcalen->base.levelother.
						next;
				break;
			}

			style = gtk_widget_get_style (cxpcalen->window);
			pixmap = gdk_pixmap_create_from_xpm_d (cxpcalen->
							       window->window,
							       &mask,
							       &style->
							       bg
							       [GTK_STATE_NORMAL],
							       (gchar **)
							       MakeCalenXPMdata
							       (pixname, 0));

			gtk_clist_set_pixtext (GTK_CLIST (cxpcalen->todoList),
					       i, 0,
					       cxpcalen->todo.item[i].data, 2,
					       pixmap, mask);
		}
	}

	/* ɽ */
	gtk_clist_thaw (GTK_CLIST (cxpcalen->todoList));
}

int viewMonthData ()
{
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	Day *dayInfo;
	int maxday;
	int startweek;
	int x, y, z, i, j;
	int cnt;
	char buff[1024];
	char *viewitem[2];
	char *pixname;

#ifdef	DEBUG9
	fprintf (stdout, "viewMonthData start ...\n");
	fprintf (stdout, "cxpcalen->s_year  => %d\n", cxpcalen->s_year);
	fprintf (stdout, "cxpcalen->s_month => %d\n", cxpcalen->s_month);
	fprintf (stdout, "cxpcalen->s_day   => %d\n", cxpcalen->s_day);
#endif

	cxpcalen->selectday = -1;

	/* ηκǽ */
	maxday = getMonthDay (cxpcalen->s_year, cxpcalen->s_month);

	/* ηκǽ */
	startweek =
		getStartMonthPosition (cxpcalen->s_year, cxpcalen->s_month);

	/* եȥǯɽ */
	sprintf (buff, "%04dǯ%2d", cxpcalen->s_year, cxpcalen->s_month);
	gtk_label_set_text (GTK_LABEL (cxpcalen->viewYmdLabel), buff);

	/*----- ꥢ ---------------------------------------------*/
	/* Υ塼ƥꥢ */
	for (y = 0; y < 6; y++)
	{
		for (x = 0; x < 7; x++)
		{
			/* ٥ */
			if (y * 7 + x < startweek)
			{
				memset (buff, 0x00, sizeof (buff));
				gtk_label_set_text (GTK_LABEL
						    (cxpcalen->
						     dayLabel[y * 7 + x]),
						    buff);
			}
			else if (y * 7 + x - startweek < maxday)
			{
				sprintf (buff, "%d",
					 y * 7 + x - startweek + 1);
				gtk_label_set_text (GTK_LABEL
						    (cxpcalen->
						     dayLabel[y * 7 + x]),
						    buff);
			}
			else
			{
				memset (buff, 0x00, sizeof (buff));
				gtk_label_set_text (GTK_LABEL
						    (cxpcalen->
						     dayLabel[y * 7 + x]),
						    buff);
			}

			/* ꥹȤΥꥢ */
			gtk_clist_clear (GTK_CLIST
					 (cxpcalen->dayList[y * 7 + x]));
		}
	}


	/* Υ塼ƥꥢ */
	gtk_clist_clear (GTK_CLIST (cxpcalen->HanreiList));

	/*--- ǡ ----------------------------------------------*/
	/* 򤵤ƤʤϽʤ */
	if (cxpcalen->selectview < 0)
	{

#ifdef	DEBUG9
		fprintf (stdout, "viewMonthData ǡ򤵤Ƥʤ\n");
#endif
		return (0);
	}
	else
	{
#ifdef	DEBUG9
		fprintf (stdout, "viewMonthData ǡ򤵤Ƥ[%d]\n",
			 cxpcalen->selectview);
#endif
	}

	/* ǯΥ塼 */
	getCalenDataSchedule (cxpcalen->s_year,
			      &cxpcalen->view.view[cxpcalen->selectview],
			      &cxpcalen->data);


	/* Υ塼򥻥åȤ */
	for (y = 0; y < 6; y++)
	{
		for (x = 0; x < 7; x++)
		{

			/* ɽ */
			gtk_clist_freeze (GTK_CLIST
					  (cxpcalen->dayList[y * 7 + x]));

			/* ǡ */
			if ((y * 7 + x >= startweek)
			    && (y * 7 + x - startweek < maxday))
			{
				cnt = y * 7 + x - startweek;

				dayInfo =
					&cxpcalen->data.month[cxpcalen->
							      s_month -
							      1].day[cnt];

#ifdef	DEBUG9
				fprintf (stdout,
					 "viewMonthData y[%2d] x[%2d] starweek [%d] cnt [%d] kensu [%d]\n",
					 y, x, startweek, cnt,
					 dayInfo->kensu);
#endif

				for (i = 0; i < dayInfo->kensu; i++)
				{
#ifdef	DEBUG9
					fprintf (stdout,
						 "viewMonthData ǡ (%s)\n",
						 dayInfo->info[i].title);
#endif

					viewitem[0] =
						g_strdup (dayInfo->info[i].
							  title);
					gtk_clist_append (GTK_CLIST
							  (cxpcalen->
							   dayList[y * 7 +
								   x]),
							  viewitem);

					switch (dayInfo->info[i].level)
					{
					default:
					case 0:	/* ̾ */
						if (dayInfo->info[i].alarm.
						    mode == 0)
							pixname =
								cxpcalen->
								base.
								levelnormal.
								none;
						else
							pixname =
								cxpcalen->
								base.
								levelnormal.
								next;
						break;
					case 1:	/*  */
						if (dayInfo->info[i].alarm.
						    mode == 0)
							pixname =
								cxpcalen->
								base.
								leveljyuyou.
								none;
						else
							pixname =
								cxpcalen->
								base.
								leveljyuyou.
								next;
						break;
					case 2:	/* ۵ */
						if (dayInfo->info[i].alarm.
						    mode == 0)
							pixname =
								cxpcalen->
								base.
								levelkinkyu.
								none;
						else
							pixname =
								cxpcalen->
								base.
								levelkinkyu.
								next;
						break;
					case 3:	/* ¾ */
						if (dayInfo->info[i].alarm.
						    mode == 0)
							pixname =
								cxpcalen->
								base.
								levelother.
								none;
						else
							pixname =
								cxpcalen->
								base.
								levelother.
								next;
						break;
					}

					style = gtk_widget_get_style
						(cxpcalen->window);
					pixmap = gdk_pixmap_create_from_xpm_d
						(cxpcalen->window->window,
						 &mask,
						 &style->bg[GTK_STATE_NORMAL],
						 (gchar **)
						 MakeCalenXPMdata (pixname,
								   0));

					gtk_clist_set_pixtext (GTK_CLIST
							       (cxpcalen->
								dayList[y *
									7 +
									x]),
							       i, 0,
							       dayInfo->
							       info[i].title,
							       2, pixmap,
							       mask);
				}
			}

			/* ɽ */
			gtk_clist_thaw (GTK_CLIST
					(cxpcalen->dayList[y * 7 + x]));
		}
	}

	return (0);

}

int viewDayData ()
{
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	Day *dayInfo;
	int maxday;
	int startweek;
	int x, y, z, i, j;
	int cnt;
	char buff[1024];
	char *viewitem[2];
	char *pixname;

#ifdef	DEBUG9
	fprintf (stdout, "viewDayData start ...\n");
	fprintf (stdout, "cxpcalen->s_year  => %d\n", cxpcalen->s_year);
	fprintf (stdout, "cxpcalen->s_month => %d\n", cxpcalen->s_month);
	fprintf (stdout, "cxpcalen->s_day   => %d\n", cxpcalen->s_day);
#endif

	cxpcalen->selecttime = -1;

	/* ηκǽ */
	maxday = getMonthDay (cxpcalen->s_year, cxpcalen->s_month);

	/* ηκǽ */
	startweek =
		getStartMonthPosition (cxpcalen->s_year, cxpcalen->s_month);


	/*--- ꥢ ----*/
	/* Υ塼ƥꥢ */
	for (z = 0; z < 24; z++)
	{
		/* ꥹȤΥꥢ */
		gtk_clist_clear (GTK_CLIST (cxpcalen->timeList[z]));
	}


	/* Υ塼򥻥åȤ */
	dayInfo =
		&cxpcalen->data.month[cxpcalen->s_month -
				      1].day[cxpcalen->s_day - 1];
	for (z = 0; z < 24; z++)
	{
		/* ɽ */
		gtk_clist_freeze (GTK_CLIST (cxpcalen->timeList[z]));

		j = 0;
		for (i = 0; i < dayInfo->kensu; i++)
		{
			if (dayInfo->info[i].hour == z)
			{
				sprintf (buff, "%02d:%02d %s",
					 dayInfo->info[i].hour,
					 dayInfo->info[i].min,
					 dayInfo->info[i].title);
				viewitem[0] = g_strdup (buff);
				gtk_clist_append (GTK_CLIST
						  (cxpcalen->timeList[z]),
						  viewitem);

#ifdef	DEBUG9
				fprintf (stdout, "TIME SET [%s] LEVEL [%d]\n",
					 dayInfo->info[i].title,
					 dayInfo->info[i].level);
#endif

				switch (dayInfo->info[i].level)
				{
				default:
				case 0:	/* ̾ */
					if (dayInfo->info[i].alarm.mode == 0)
						pixname =
							cxpcalen->base.
							levelnormal.none;
					else
						pixname =
							cxpcalen->base.
							levelnormal.next;
					break;
				case 1:	/*  */
					if (dayInfo->info[i].alarm.mode == 0)
						pixname =
							cxpcalen->base.
							leveljyuyou.none;
					else
						pixname =
							cxpcalen->base.
							leveljyuyou.next;
					break;
				case 2:	/* ۵ */
					if (dayInfo->info[i].alarm.mode == 0)
						pixname =
							cxpcalen->base.
							levelkinkyu.none;
					else
						pixname =
							cxpcalen->base.
							levelkinkyu.next;
					break;
				case 3:	/* ¾ */
					if (dayInfo->info[i].alarm.mode == 0)
						pixname =
							cxpcalen->base.
							levelother.none;
					else
						pixname =
							cxpcalen->base.
							levelother.next;
					break;
				}

				style = gtk_widget_get_style (cxpcalen->
							      window);
				pixmap = gdk_pixmap_create_from_xpm_d
					(cxpcalen->window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL],
					 (gchar **) MakeCalenXPMdata (pixname,
								      0));

				gtk_clist_set_pixtext (GTK_CLIST
						       (cxpcalen->
							timeList[z]), j, 0,
						       buff, 2, pixmap, mask);
				j++;
			}
		}

		/* ɽ */
		gtk_clist_thaw (GTK_CLIST (cxpcalen->timeList[z]));
	}

	return (0);
}


int viewHanreiData (ScduInfo * sch)
{
	char *viewitem[2];
	char *viewnaiyo[256];
	char buff[1024];
	int len, count;

	/* ɽ */
	gtk_clist_freeze (GTK_CLIST (cxpcalen->HanreiList));

	/* ƥꥢ */
	gtk_clist_clear (GTK_CLIST (cxpcalen->HanreiList));

	/* դ */
	sprintf (buff, "%04dǯ%02d%02d %02d%02dʬΥ塼",
		 cxpcalen->s_year, sch->month, sch->day, sch->hour, sch->min);
	viewitem[0] = g_strdup (buff);
	gtk_clist_append (GTK_CLIST (cxpcalen->HanreiList), viewitem);

	/* ȥ */
	sprintf (buff, "ȥ롧%s", sch->title);
	viewitem[0] = g_strdup (buff);
	gtk_clist_append (GTK_CLIST (cxpcalen->HanreiList), viewitem);

	/* ٥ */
	sprintf (buff, "٥롧%s", getLebelLabel (sch->level));
	viewitem[0] = g_strdup (buff);
	gtk_clist_append (GTK_CLIST (cxpcalen->HanreiList), viewitem);

	/* 顼 */
	if (sch->alarm.mode == 0)
		sprintf (buff, "顼ࡧꤵƤޤ");
	else
		sprintf (buff,
			 "顼ࡧ%04dǯ%02d%02d %02d%02dʬꤵƤޤ",
			 sch->alarm.year, sch->alarm.month, sch->alarm.day,
			 sch->alarm.hour, sch->alarm.min);
	viewitem[0] = g_strdup (buff);
	gtk_clist_append (GTK_CLIST (cxpcalen->HanreiList), viewitem);

	/* Ƥ */
	sprintf (buff, "ơ");
	viewitem[0] = g_strdup (buff);
	gtk_clist_append (GTK_CLIST (cxpcalen->HanreiList), viewitem);

	if (sch->length <= 0)
	{
		sprintf (buff, "ޤ");
		viewitem[0] = g_strdup (buff);
		gtk_clist_append (GTK_CLIST (cxpcalen->HanreiList), viewitem);
	}
	else
	{

#ifdef	DEBUG9
		fprintf (stdout, "DATA [%*.*s]\n", sch->length, sch->length,
			 sch->data);
#endif

		count = 0;
		len = 0;
		memset (buff, 0x00, sizeof (buff));
		while (1)
		{
			if (*(sch->data + count) == '\n')
			{
				viewitem[0] = g_strdup (buff);
				gtk_clist_append (GTK_CLIST
						  (cxpcalen->HanreiList),
						  viewitem);
				len = 0;
				memset (buff, 0x00, sizeof (buff));
			}
			else
			{
				buff[len] = *(sch->data + count);
				len++;
			}
			count++;

			if (count >= sch->length)
				break;

		}
		if (len > 0)
		{
			viewitem[0] = g_strdup (buff);
			gtk_clist_append (GTK_CLIST (cxpcalen->HanreiList),
					  viewitem);
		}
	}

	/* ɽ */
	gtk_clist_thaw (GTK_CLIST (cxpcalen->HanreiList));
}
