/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpdevice.h"

extern CxpDevice *cxpdevice;

extern int devListSelectionFunc ();
extern int devListUnSelectionFunc ();

extern int selectBtnFunc ();
extern int addBtnFunc ();
extern int modBtnFunc ();
extern int delBtnFunc ();
extern int setBtnFunc ();
extern int canBtnFunc ();

GtkWidget *window;
GtkWidget *devList;
GtkWidget *addBtn;
GtkWidget *modBtn;
GtkWidget *delBtn;
GtkWidget *mediaTypeMenu;
GtkWidget *mediaTypeMenu_menu;
GtkWidget *mediaEntry;
GtkWidget *deviceEntry;
GtkWidget *selectBtn;
GtkWidget *backupCheckBtn;
GtkWidget *setBtn;
GtkWidget *canBtn;

static char *devtitle[1] = { "ϿǥХ"
};

static void filemenu_response ();
static void helpmenu_response ();

#define FILEIACT_SAVE		0x0101
#define FILEIACT_CLOSE		0x0102
#define HELPIACT_HELP		0x0901

#define FILEMENU_BASE           "/ե"
#define FILEMENU_SAVE           "/ե/Ͽ"
#define FILEMENU_CLOSE          "/ե/λ"
#define HELPMENU_BASE           "/إ"
#define HELPMENU_HELP           "/إ/CxpdeviceˤĤ"

static GtkItemFactoryEntry menu_items[] = {
	{FILEMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{FILEMENU_SAVE, "<control>S", filemenu_response, FILEIACT_SAVE, NULL},
	{FILEMENU_CLOSE, "<control>Q", filemenu_response, FILEIACT_CLOSE,
	 NULL},
	{HELPMENU_BASE, NULL, NULL, 0, "<LastBranch>"},
	{HELPMENU_HELP, NULL, helpmenu_response, HELPIACT_HELP, NULL},
};


int cxpdevicefunc_close ()
{
	gtk_main_quit ();
}

static void filemenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case FILEIACT_SAVE:
		setBtnFunc ();
		break;
	case FILEIACT_CLOSE:
		canBtnFunc ();
		break;
	}
}

static void helpmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case HELPIACT_HELP:
		cxpdevicehelpfunc_help ();
		break;
	}
}

int cxpdevice_start (void)
{
	GtkWidget *vbox1;
	GtkWidget *hbox1;
	GtkWidget *label1;
	GtkWidget *hseparator1;
	GtkWidget *hbox3;
	GtkWidget *vbox2;
	GtkWidget *vbox3;
	GtkWidget *vbox4;
	GtkWidget *frame1;
	GtkWidget *vbox6;
	GtkWidget *hbox5;
	GtkWidget *label2;
	GtkWidget *hbox6;
	GtkWidget *label3;
	GtkWidget *hbox7;
	GtkWidget *label4;
	GtkWidget *hbox8;
	GtkWidget *label5;
	GtkWidget *hseparator2;
	GtkWidget *hbox4;
	GtkWidget *swin;
	GSList *mediaTypeGroup;
	GtkItemFactory *item_factory;
	GtkAccelGroup *accel_group;
	int nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);


	cxpdevice->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (cxpdevice->window), "window",
			     cxpdevice->window);
	gtk_widget_set_usize (cxpdevice->window, 700, 300);
	gtk_window_set_title (GTK_WINDOW (cxpdevice->window), "Cxpdevice");
	gtk_signal_connect (GTK_OBJECT (cxpdevice->window), "destroy",
			    GTK_SIGNAL_FUNC (cxpdevicefunc_close), NULL);


	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "vbox1",
				  vbox1, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (cxpdevice->window), vbox1);

#if 0
	hbox1 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "hbox1",
				  hbox1, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 5);

	label1 = gtk_label_new ("ǥХ");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "label1",
				  label1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE, FALSE, 0);

	hseparator1 = gtk_hseparator_new ();
	gtk_widget_ref (hseparator1);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window),
				  "hseparator1", hseparator1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hseparator1);
	gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, FALSE, TRUE, 4);
#else

	accel_group = gtk_accel_group_new ();

	item_factory =
		gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",
				      accel_group);

	gtk_item_factory_create_items (item_factory, nmenu_items, menu_items,
				       NULL);

	gtk_accel_group_attach (accel_group, GTK_OBJECT (cxpdevice->window));

	cxpdevice->menubar =
		gtk_item_factory_get_widget (item_factory, "<main>");
	gtk_box_pack_start (GTK_BOX (vbox1), cxpdevice->menubar, FALSE, FALSE,
			    0);
	gtk_widget_show (cxpdevice->menubar);

#endif

	hbox3 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "hbox3",
				  hbox3, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox3, TRUE, TRUE, 0);

	swin = gtk_scrolled_window_new (NULL, NULL);

	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_widget_show (swin);

	cxpdevice->devList = gtk_clist_new_with_titles (1, devtitle);
	gtk_clist_set_selection_mode (GTK_CLIST (cxpdevice->devList),
				      GTK_SELECTION_SINGLE);

	/* ꥹȥХå */
#if 0
	gtk_signal_connect (GTK_OBJECT (cxpdevice->devList), "event",
			    GTK_SIGNAL_FUNC (devListEventFunc), NULL);
#endif
	gtk_signal_connect (GTK_OBJECT (cxpdevice->devList), "select_row",
			    GTK_SIGNAL_FUNC (devListSelectionFunc), NULL);
	gtk_signal_connect (GTK_OBJECT (cxpdevice->devList), "unselect_row",
			    GTK_SIGNAL_FUNC (devListUnSelectionFunc), NULL);

	gtk_clist_column_title_passive (GTK_CLIST (cxpdevice->devList), 0);

	gtk_container_add (GTK_CONTAINER (swin), cxpdevice->devList);
	gtk_widget_show (cxpdevice->devList);

	gtk_box_pack_start (GTK_BOX (hbox3), swin, TRUE, TRUE, 6);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "vbox2",
				  vbox2, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (hbox3), vbox2, FALSE, TRUE, 6);

	vbox3 = gtk_vbox_new (TRUE, 0);
	gtk_widget_ref (vbox3);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "vbox3",
				  vbox3, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox3);
	gtk_box_pack_start (GTK_BOX (vbox2), vbox3, TRUE, TRUE, 10);

	cxpdevice->addBtn = gtk_button_new_with_label (" ɲ ");
	gtk_widget_ref (cxpdevice->addBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "addBtn",
				  cxpdevice->addBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpdevice->addBtn);
	gtk_box_pack_start (GTK_BOX (vbox3), cxpdevice->addBtn, FALSE, FALSE,
			    0);

	cxpdevice->modBtn = gtk_button_new_with_label (" ѹ ");
	gtk_widget_ref (cxpdevice->modBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "modBtn",
				  cxpdevice->modBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpdevice->modBtn);
	gtk_box_pack_start (GTK_BOX (vbox3), cxpdevice->modBtn, FALSE, FALSE,
			    0);

	cxpdevice->delBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (cxpdevice->delBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "delBtn",
				  cxpdevice->delBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpdevice->delBtn);
	gtk_box_pack_start (GTK_BOX (vbox3), cxpdevice->delBtn, FALSE, FALSE,
			    0);

	vbox4 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox4);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "vbox4",
				  vbox4, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox4);
	gtk_box_pack_start (GTK_BOX (hbox3), vbox4, FALSE, TRUE, 5);

	frame1 = gtk_frame_new (" ǥХ ");
	gtk_widget_ref (frame1);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "frame1",
				  frame1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame1);
	gtk_box_pack_start (GTK_BOX (vbox4), frame1, TRUE, TRUE, 0);

	vbox6 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox6);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "vbox6",
				  vbox6, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox6);
	gtk_container_add (GTK_CONTAINER (frame1), vbox6);

	hbox5 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox5);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "hbox5",
				  hbox5, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox5);
	gtk_box_pack_start (GTK_BOX (vbox6), hbox5, FALSE, TRUE, 8);

	label2 = gtk_label_new ("ǥס");
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "label2",
				  label2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (hbox5), label2, FALSE, FALSE, 10);

	mediaTypeGroup = NULL;

	cxpdevice->itemTypeFDD =
		gtk_radio_button_new_with_label (mediaTypeGroup,
						 "եåԡ");
	mediaTypeGroup =
		gtk_radio_button_group (GTK_RADIO_BUTTON
					(cxpdevice->itemTypeFDD));
	gtk_widget_ref (cxpdevice->itemTypeFDD);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window),
				  "itemTypeFDD", cxpdevice->itemTypeFDD,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpdevice->itemTypeFDD);
	gtk_box_pack_start (GTK_BOX (hbox5), cxpdevice->itemTypeFDD, FALSE,
			    FALSE, 0);

	cxpdevice->itemTypeTAPE =
		gtk_radio_button_new_with_label (mediaTypeGroup,
						 "ơ");
	mediaTypeGroup =
		gtk_radio_button_group (GTK_RADIO_BUTTON
					(cxpdevice->itemTypeTAPE));
	gtk_widget_ref (cxpdevice->itemTypeTAPE);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window),
				  "itemTypeTAPE", cxpdevice->itemTypeTAPE,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpdevice->itemTypeTAPE);
	gtk_box_pack_start (GTK_BOX (hbox5), cxpdevice->itemTypeTAPE, FALSE,
			    FALSE, 0);

	cxpdevice->itemTypeOTHER =
		gtk_radio_button_new_with_label (mediaTypeGroup,
						 "¾");
	mediaTypeGroup =
		gtk_radio_button_group (GTK_RADIO_BUTTON
					(cxpdevice->itemTypeOTHER));
	gtk_widget_ref (cxpdevice->itemTypeOTHER);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window),
				  "itemTypeOTHER", cxpdevice->itemTypeOTHER,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpdevice->itemTypeOTHER);
	gtk_box_pack_start (GTK_BOX (hbox5), cxpdevice->itemTypeOTHER, FALSE,
			    FALSE, 0);


	hbox6 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox6);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "hbox6",
				  hbox6, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox6);
	gtk_box_pack_start (GTK_BOX (vbox6), hbox6, FALSE, TRUE, 5);

	label3 = gtk_label_new ("ǥ̾");
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "label3",
				  label3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_box_pack_start (GTK_BOX (hbox6), label3, FALSE, FALSE, 10);

	cxpdevice->mediaEntry = gtk_entry_new ();
	gtk_widget_ref (cxpdevice->mediaEntry);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window),
				  "mediaEntry", cxpdevice->mediaEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpdevice->mediaEntry);
	gtk_box_pack_start (GTK_BOX (hbox6), cxpdevice->mediaEntry, TRUE,
			    TRUE, 5);

	hbox7 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox7);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "hbox7",
				  hbox7, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox7);
	gtk_box_pack_start (GTK_BOX (vbox6), hbox7, FALSE, TRUE, 5);

	label4 = gtk_label_new ("ǥХ̾");
	gtk_widget_ref (label4);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "label4",
				  label4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_box_pack_start (GTK_BOX (hbox7), label4, FALSE, FALSE, 10);

	cxpdevice->deviceEntry = gtk_entry_new ();
	gtk_widget_ref (cxpdevice->deviceEntry);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window),
				  "deviceEntry", cxpdevice->deviceEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpdevice->deviceEntry);
	gtk_box_pack_start (GTK_BOX (hbox7), cxpdevice->deviceEntry, TRUE,
			    TRUE, 5);

	cxpdevice->selectBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (cxpdevice->selectBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "selectBtn",
				  cxpdevice->selectBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpdevice->selectBtn);
	gtk_box_pack_start (GTK_BOX (hbox7), cxpdevice->selectBtn, FALSE,
			    FALSE, 5);

	hbox8 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox8);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "hbox8",
				  hbox8, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox8);
	gtk_box_pack_start (GTK_BOX (vbox6), hbox8, FALSE, TRUE, 5);

	label5 = gtk_label_new ("ץ");
	gtk_widget_ref (label5);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "label5",
				  label5,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label5);
	gtk_box_pack_start (GTK_BOX (hbox8), label5, FALSE, FALSE, 10);

	cxpdevice->backupCheckBtn =
		gtk_check_button_new_with_label
		("Хåå֤ȤѤ");
	gtk_widget_ref (cxpdevice->backupCheckBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window),
				  "backupCheckBtn", cxpdevice->backupCheckBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpdevice->backupCheckBtn);
	gtk_box_pack_start (GTK_BOX (hbox8), cxpdevice->backupCheckBtn, FALSE,
			    FALSE, 3);

#if 0
	hseparator2 = gtk_hseparator_new ();
	gtk_widget_ref (hseparator2);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window),
				  "hseparator2", hseparator2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hseparator2);
	gtk_box_pack_start (GTK_BOX (vbox1), hseparator2, FALSE, TRUE, 7);

	hbox4 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox4);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "hbox4",
				  hbox4, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox4);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox4, FALSE, TRUE, 5);

	cxpdevice->setBtn = gtk_button_new_with_label ("  ¸ ");
	gtk_widget_ref (cxpdevice->setBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "setBtn",
				  cxpdevice->setBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpdevice->setBtn);
	gtk_box_pack_start (GTK_BOX (hbox4), cxpdevice->setBtn, FALSE, FALSE,
			    0);

	cxpdevice->canBtn = gtk_button_new_with_label (" λ ");
	gtk_widget_ref (cxpdevice->canBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxpdevice->window), "canBtn",
				  cxpdevice->canBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxpdevice->canBtn);
	gtk_box_pack_start (GTK_BOX (hbox4), cxpdevice->canBtn, FALSE, FALSE,
			    0);
#endif


	/* ɲáפ򲡤褦ˡѹסֺפ򲡤ʤ褦 */
	gtk_widget_set_sensitive (cxpdevice->addBtn, TRUE);
	gtk_widget_set_sensitive (cxpdevice->modBtn, FALSE);
	gtk_widget_set_sensitive (cxpdevice->delBtn, FALSE);


	/* ǥХܥ󥳡Хå */
	gtk_signal_connect_object (GTK_OBJECT (cxpdevice->selectBtn),
				   "clicked", (GtkSignalFunc) selectBtnFunc,
				   0);

	/* ɲåܥ󥳡Хå */
	gtk_signal_connect_object (GTK_OBJECT (cxpdevice->addBtn),
				   "clicked", (GtkSignalFunc) addBtnFunc, 0);

	/* ѹܥ󥳡Хå */
	gtk_signal_connect_object (GTK_OBJECT (cxpdevice->modBtn),
				   "clicked", (GtkSignalFunc) modBtnFunc, 0);

	/* ܥ󥳡Хå */
	gtk_signal_connect_object (GTK_OBJECT (cxpdevice->delBtn),
				   "clicked", (GtkSignalFunc) delBtnFunc, 0);

#if 0
	/* Ͽܥ󥳡Хå */
	gtk_signal_connect_object (GTK_OBJECT (cxpdevice->setBtn),
				   "clicked", (GtkSignalFunc) setBtnFunc, 0);

	/* λܥ󥳡Хå */
	gtk_signal_connect_object (GTK_OBJECT (cxpdevice->canBtn),
				   "clicked", (GtkSignalFunc) canBtnFunc, 0);
#endif

	/* ǥХɽ */
	cxpdevice_view ();

	gtk_widget_show (cxpdevice->window);
}
