/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpdevice.h"

extern CxpDevice *cxpdevice;

static int checkData ()
{
	int status;
	char *checkMedia;
	char *checkPath;

	status = 0;

	if ((checkMedia =
	     gtk_entry_get_text (GTK_ENTRY (cxpdevice->mediaEntry))) == NULL)
	{
#ifdef	DEBUG8
		fprintf (stdout, "checkMedia get error ...\n");
#endif
		status = 1;
		return (status);
	}

	if ((checkPath =
	     gtk_entry_get_text (GTK_ENTRY (cxpdevice->deviceEntry))) == NULL)
	{
#ifdef	DEBUG8
		fprintf (stdout, "checkPath get error ...\n");
#endif
		status = 1;
		return (status);
	}

	if (strlen (checkMedia) <= 0)
	{
#ifdef	DEBUG8
		fprintf (stdout, "checkMedia length is ZERO ...\n");
#endif
		status = 1;
	}

	if (strlen (checkPath) <= 0)
	{
#ifdef	DEBUG8
		fprintf (stdout, "checkPath length is ZERO ...\n");
#endif
		status = 1;
	}

	return (status);
}

int addBtnFunc (GtkWidget * widget, gpointer data)
{
	int status;
	char *type;
	int backup;
	char *media;
	char *path;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	char *pixname;
	char *viewname[2];


	if (cxpdevice->devinf.device_kensu + 1 > MAX_DEVICE_NUM)
	{
		create_messageWin (cxpdevice->window,
				   "ϿǤǥХϣޤǤǤ");
		return (0);
	}

	status = checkData ();
	if (status != 0)
	{
		create_messageWin (cxpdevice->window,
				   "ϤƤʤս꤬١ɲäǤޤ");
		return (0);
	}

	if (GTK_TOGGLE_BUTTON (cxpdevice->itemTypeFDD)->active)
		type = g_strdup ("FDD");
	else if (GTK_TOGGLE_BUTTON (cxpdevice->itemTypeTAPE)->active)
		type = g_strdup ("TAPE");
	else
		type = g_strdup ("OTHER");


	if (GTK_TOGGLE_BUTTON (cxpdevice->backupCheckBtn)->active)
		backup = 0;
	else
		backup = 1;


	if ((media =
	     gtk_entry_get_text (GTK_ENTRY (cxpdevice->mediaEntry))) == NULL)
	{
		create_messageWin (cxpdevice->window,
				   "ϤƤʤս꤬١ɲäǤޤ");
		return (0);
	}

	if ((path =
	     gtk_entry_get_text (GTK_ENTRY (cxpdevice->deviceEntry))) == NULL)
	{
		create_messageWin (cxpdevice->window,
				   "ϤƤʤս꤬١ɲäǤޤ");
		return (0);
	}

	cxpdevice->devinf.device[cxpdevice->devinf.device_kensu].type =
		g_strdup (type);
	cxpdevice->devinf.device[cxpdevice->devinf.device_kensu].name =
		g_strdup (media);
	cxpdevice->devinf.device[cxpdevice->devinf.device_kensu].path =
		g_strdup (path);
	cxpdevice->devinf.device[cxpdevice->devinf.device_kensu].backupFlag =
		backup;
	cxpdevice->devinf.device_kensu++;

	/* ǡꥹȤɲä */
#if 0
	/* ꥹȤɲ */
	listname[0] = g_strdup (cinfo[i].login);
	gtk_clist_append (GTK_CLIST (userList), listname);
#endif

	viewname[0] = g_strdup (media);
	gtk_clist_append (GTK_CLIST (cxpdevice->devList), viewname);

	if (strncmp (type, "FDD", 3) == 0)
		pixname = cxpdevice->base.devicefdd;
	else if (strncmp (type, "TAPE", 3) == 0)
		pixname = cxpdevice->base.devicetape;
	else if (strncmp (type, "CD", 2) == 0)
		pixname = cxpdevice->base.devicecd;
	else
		pixname = cxpdevice->base.deviceunknown;

	style = gtk_widget_get_style (cxpdevice->window);
	pixmap = gdk_pixmap_create_from_xpm_d (cxpdevice->window->window,
					       &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       (gchar **)
					       MakeDeviceXPMdata (pixname,
								  0));

	gtk_clist_set_pixtext (GTK_CLIST (cxpdevice->devList),
			       cxpdevice->devinf.device_kensu - 1, 0,
			       cxpdevice->devinf.device[cxpdevice->devinf.
							device_kensu -
							1].name, 2, pixmap,
			       mask);

	/* ե饰ON */
	cxpdevice->saveFlag = 1;

	return (0);
}

int modBtnFunc (GtkWidget * widget, gpointer data)
{
	int status;
	char *type;
	int backup;
	char *media;
	char *path;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	char *pixname;

	status = checkData ();
	if (status != 0)
	{
		create_messageWin (cxpdevice->window,
				   "ϤƤʤս꤬١ɲäǤޤ");
		return (0);
	}

	if (GTK_TOGGLE_BUTTON (cxpdevice->itemTypeFDD)->active)
		type = g_strdup ("FDD");
	else if (GTK_TOGGLE_BUTTON (cxpdevice->itemTypeTAPE)->active)
		type = g_strdup ("TAPE");
	else
		type = g_strdup ("OTHER");


	if (GTK_TOGGLE_BUTTON (cxpdevice->backupCheckBtn)->active)
		backup = 0;
	else
		backup = 1;


	if ((media =
	     gtk_entry_get_text (GTK_ENTRY (cxpdevice->mediaEntry))) == NULL)
	{
		create_messageWin (cxpdevice->window,
				   "ϤƤʤս꤬١ɲäǤޤ");
		return (0);
	}

	if ((path =
	     gtk_entry_get_text (GTK_ENTRY (cxpdevice->deviceEntry))) == NULL)
	{
		create_messageWin (cxpdevice->window,
				   "ϤƤʤս꤬١ɲäǤޤ");
		return (0);
	}

	cxpdevice->devinf.device[cxpdevice->selectrow].type = g_strdup (type);
	cxpdevice->devinf.device[cxpdevice->selectrow].name =
		g_strdup (media);
	cxpdevice->devinf.device[cxpdevice->selectrow].path = g_strdup (path);
	cxpdevice->devinf.device[cxpdevice->selectrow].backupFlag = backup;

	/* ꥹȤѹ */
	if (strncmp (type, "FDD", 3) == 0)
		pixname = cxpdevice->base.devicefdd;
	else if (strncmp (type, "TAPE", 3) == 0)
		pixname = cxpdevice->base.devicetape;
	else if (strncmp (type, "CD", 2) == 0)
		pixname = cxpdevice->base.devicecd;
	else
		pixname = cxpdevice->base.deviceunknown;

	style = gtk_widget_get_style (cxpdevice->window);
	pixmap = gdk_pixmap_create_from_xpm_d (cxpdevice->window->window,
					       &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       (gchar **)
					       MakeDeviceXPMdata (pixname,
								  0));

	gtk_clist_set_pixtext (GTK_CLIST (cxpdevice->devList),
			       cxpdevice->selectrow, 0,
			       cxpdevice->devinf.device[cxpdevice->selectrow].
			       name, 2, pixmap, mask);

	/* ե饰ON */
	cxpdevice->saveFlag = 1;

	return (0);
}

int delBtnFunc (GtkWidget * widget, gpointer data)
{
	int i, k;

	i = cxpdevice->selectrow;

	if (cxpdevice->selectrow < 0)
	{
		create_messageWin (cxpdevice->window,
				   "٤ˤϥǥХ򤷤Ʋ");
		return (0);
	}


	for (k = i; k < cxpdevice->devinf.device_kensu - 1; k++)
	{
		cxpdevice->devinf.device[k].type =
			g_strdup (cxpdevice->devinf.device[k + 1].type);
		cxpdevice->devinf.device[k].name =
			g_strdup (cxpdevice->devinf.device[k + 1].name);
		cxpdevice->devinf.device[k].path =
			g_strdup (cxpdevice->devinf.device[k + 1].path);
		cxpdevice->devinf.device[k].backupFlag =
			cxpdevice->devinf.device[k + 1].backupFlag;
	}
	cxpdevice->devinf.device[k].type = (char *) NULL;
	cxpdevice->devinf.device[k].name = (char *) NULL;
	cxpdevice->devinf.device[k].path = (char *) NULL;
	cxpdevice->devinf.device[k].backupFlag = 0;

	cxpdevice->devinf.device_kensu--;

	if (cxpdevice->devinf.device_kensu < 0)
		cxpdevice->devinf.device_kensu = 0;

	gtk_clist_remove (GTK_CLIST (cxpdevice->devList),
			  cxpdevice->selectrow);

	/* ե饰ON */
	cxpdevice->saveFlag = 1;

	return (0);
}
