/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpdevice.h"

extern CxpDevice *cxpdevice;

int devListSelectionFunc (GtkWidget * clist, gint row, gint column,
			  GdkEventButton * event, gpointer data)
{
	GSList *mediaTypeGroup;
	DeviceItem *devptr;
	int type;

	if (row < 0)
		return (0);

	cxpdevice->selectrow = row;

	devptr = &cxpdevice->devinf.device[row];

	/* 򤷤ǡɽ */
	gtk_entry_set_text (GTK_ENTRY (cxpdevice->deviceEntry), devptr->path);
	gtk_entry_set_text (GTK_ENTRY (cxpdevice->mediaEntry), devptr->name);

	if (devptr->backupFlag == 1)
	{
		/* Хåå֤ȤѤʤ */
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      (cxpdevice->backupCheckBtn), 0);
	}
	else
	{
		/* Хåå֤ȤѤ */
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      (cxpdevice->backupCheckBtn), 1);
	}

	/* ˥塼ꤹ */
#ifdef	DEBUG8
	fprintf (stdout, "devptr->type => [%s]\n", devptr->type);
#endif

	if (strcmp (devptr->type, "FDD") == 0)
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      (cxpdevice->itemTypeFDD), 1);
	}
	else if (strcmp (devptr->type, "TAPE") == 0)
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      (cxpdevice->itemTypeTAPE), 1);
	}
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					      (cxpdevice->itemTypeOTHER), 1);
	}

	/* 򤷤ѹסֺפ򲡤褦 */
	/* ɲáפ򲡤ʤ褦ꤹ롣 */
	gtk_widget_set_sensitive (cxpdevice->addBtn, FALSE);
	gtk_widget_set_sensitive (cxpdevice->modBtn, TRUE);
	gtk_widget_set_sensitive (cxpdevice->delBtn, TRUE);

}

int devListUnSelectionFunc (GtkWidget * clist, gint row, gint column,
			    GdkEventButton * event, gpointer data)
{

	if (row < 0)
		return (0);

	cxpdevice->selectrow = -1;

	/* ˤ */
	gtk_entry_set_text (GTK_ENTRY (cxpdevice->deviceEntry), "");
	gtk_entry_set_text (GTK_ENTRY (cxpdevice->mediaEntry), "");

	/* 줿ɲáפ򲡤褦 */
	/* ѹסֺפ򲡤ʤ褦ꤹ롣 */
	gtk_widget_set_sensitive (cxpdevice->addBtn, TRUE);
	gtk_widget_set_sensitive (cxpdevice->modBtn, FALSE);
	gtk_widget_set_sensitive (cxpdevice->delBtn, FALSE);

}
