/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpdevice.h"

extern CxpDevice *cxpdevice;

int cxpdevice_view ()
{
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	int i;
	char *pixname;
	char *viewname[2];

	gtk_clist_freeze (GTK_CLIST (cxpdevice->devList));
	gtk_clist_clear (GTK_CLIST (cxpdevice->devList));

	for (i = 0; i < cxpdevice->devinf.device_kensu; i++)
	{
		viewname[0] = g_strdup (cxpdevice->devinf.device[i].name);
		gtk_clist_append (GTK_CLIST (cxpdevice->devList), viewname);

#ifdef	DEBUG8
		fprintf (stdout, "type  :[%s]\n",
			 cxpdevice->devinf.device[i].type);
		fprintf (stdout, "name  :[%s]\n",
			 cxpdevice->devinf.device[i].name);
		fprintf (stdout, "path  :[%s]\n",
			 cxpdevice->devinf.device[i].path);
#endif

		if (strncmp (cxpdevice->devinf.device[i].type, "FDD", 3) == 0)
			pixname = cxpdevice->base.devicefdd;
		else if (strncmp (cxpdevice->devinf.device[i].type, "TAPE", 3)
			 == 0)
			pixname = cxpdevice->base.devicetape;
		else if (strncmp (cxpdevice->devinf.device[i].type, "CD", 2)
			 == 0)
			pixname = cxpdevice->base.devicecd;
		else
			pixname = cxpdevice->base.deviceunknown;

		style = gtk_widget_get_style (cxpdevice->window);
		pixmap = gdk_pixmap_create_from_xpm_d (cxpdevice->window->
						       window, &mask,
						       &style->
						       bg[GTK_STATE_NORMAL],
						       (gchar **)
						       MakeDeviceXPMdata
						       (pixname, 0));

		gtk_clist_set_pixtext (GTK_CLIST (cxpdevice->devList),
				       i, 0, cxpdevice->devinf.device[i].name,
				       2, pixmap, mask);
	}

	gtk_clist_thaw (GTK_CLIST (cxpdevice->devList));

}
