/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "common_image.h"
#include "cxpimageview.h"

CxpImageView *cxpimageview;

ImageCache image_cache = { NULL, 0, 0 };

int main (int argc, char *argv[])
{
	int i, kensu;
	int w, h, type;

	CxpBasePathInit ();

	/* ޥ͡㵯ư */
	cxp_manager_start ();

	cxpimageview = (CxpImageView *) g_malloc (sizeof (CxpImageView));

	/* ꥢ */
	memset (cxpimageview, 0x00, sizeof (CxpImageView));

	if (!getcwd (cxpimageview->path, MAX_DIR_LENGTH))
		strcpy (cxpimageview->path, "/");

	cxpimageview->selectrow = -1;

	/* ưɣĤμ */
	cxpimageview->uid = getuid ();
	cxpimageview->gid = getgid ();

	getBaseConfig (&cxpimageview->base);

	kensu = 0;
	for (i = 1; i < argc; i++)
	{
		if (access (argv[i], F_OK))
			continue;

		type = common_image_check (argv[i], &w, &h);
		if (type == CXP_IMAGE_NONE)
			continue;

		if (cxpimageview->selectrow == -1)
			cxpimageview->selectrow = 0;

		cxpimageview->image[kensu].name = g_strdup (argv[i]);
		cxpimageview->image_kensu++;
		kensu++;
	}

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	cxpimage_start ();

	gtk_entry_set_text (GTK_ENTRY (cxpimageview->pathEntry),
			    cxpimageview->path);

	cxpimage_filelistview ();
	if (cxpimageview->selectrow >= 0)
	{
		while (gtk_events_pending ())
			gtk_main_iteration ();
		cxpimage_imageview ();
		while (gtk_events_pending ())
			gtk_main_iteration ();
	}

	gtk_main ();
	exit (0);
}
